<?php
session_start();
require_once("classconexion.php");
// AGREGAR LOS PUNTOS Y LA BARRA (../) PARA SUBIR UN DIRECTORIO

// SOLUCIÓN DEFINITIVA: UTILIZAR __DIR__ PARA ASEGURAR LA RUTA ABSOLUTA
include_once(__DIR__ . '/funciones_basicas.php');


include "class.phpmailer.php";
include "class.smtp.php";

// Motrar todos los errores de PHP
error_reporting(E_ALL);//muestro errores
//error_reporting(0);//desactivo errores
// Motrar todos los errores de PHP
ini_set('display_errors', '1');

//evita el error Fatal error: Allowed memory size of X bytes exhausted (tried to allocate Y bytes)...
ini_set('memory_limit', '-1'); 
// es lo mismo que set_time_limit(300) ;
ini_set('max_execution_time', 3800); 

// ***************************************************************
// BLOQUE DE FUNCIONES DE UTILIDAD (AGREGADO PARA CORREGIR EL ERROR)
// ***************************************************************

// La clave debe ser consistente con su sistema, esta es una clave de ejemplo
// Si su sistema usa otra clave para el cifrado, debe reemplazarla aquí
if (!defined('CUSTOM_KEY_CRYPTO')) {
    define('CUSTOM_KEY_CRYPTO', 'SANIGNACIO_KEY_CHOPCHOP'); 
}


// FUNCION PARA LIMPIAR CADENAS
if (!function_exists('limpiar')) {
    function limpiar($cadena) {
        $cadena = htmlspecialchars(trim($cadena));
        $cadena = str_ireplace("<script>", "", $cadena);
        $cadena = str_ireplace("</script>", "", $cadena);
        $cadena = str_ireplace("SELECT * FROM", "", $cadena);
        $cadena = str_ireplace("DELETE FROM", "", $cadena);
        $cadena = str_ireplace("INSERT INTO", "", $cadena);
        $cadena = str_ireplace("--", "", $cadena);
        $cadena = str_ireplace("^", "", $cadena);
        return $cadena;
    }
}

// FUNCION PARA DESENCRIPTAR CADENAS
if (!function_exists('decode')) {
    function decode($string, $key = CUSTOM_KEY_CRYPTO) {
        // La decodificación requiere que el string no esté vacío
        if (empty($string)) { return ""; }
        
        $result = '';
        $string = base64_decode($string);
        for($i=0; $i<strlen($string); $i++) {
            $char = substr($string, $i, 1);
            $keychar = substr($key, ($i % strlen($key))-1, 1);
            $char = chr(ord($char)-ord($keychar));
            $result.=$char;
        }
        return $result;
    }
}
// ***************************************************************

################################## CLASE LOGIN ###################################
class Login extends Db
{

public function __construct()
{
	parent::__construct();
} 	

###################### FUNCION PARA EXPIRAR SESSION POR INACTIVIDAD ####################
public function ExpiraSession()
{
	/*if(!isset($_SESSION['usuario'])){// Esta logeado?.
		header("Location: logout.php"); 
	}

	//Verifico el tiempo si esta seteado, caso contrario lo seteo.
	if(isset($_SESSION['time'])){
		$tiempo = limpiar($_SESSION['time']);
	} else {
		$tiempo = strtotime(date("Y-m-d H:i:s"));
	}

	$inactividad =7200; //(1 hora de cierre sesion )600 equivale a 10 minutos

	$actual =  strtotime(date("Y-m-d H:i:s"));

	if(($actual-$tiempo) >= $inactividad){
		?>					
		<script type='text/javascript' language='javascript'>
			alert('SU SESSION A EXPIRADO \nPOR FAVOR LOGUEESE DE NUEVO PARA ACCEDER AL SISTEMA') 
			document.location.href='logout'	 
		</script> 
		<?php
	} else {
		$_SESSION['time'] = $actual;
	} */
}
###################### FUNCION PARA EXPIRAR SESSION POR INACTIVIDAD ####################
###################### NUEVA FUNCION PARA OBTENER EL TIPO DE CAMBIO ####################
/*
public function ObtenerTipoCambio() {
    try {
        $sql = "SELECT montocambio, simbolocambio FROM tipocambio ORDER BY fechacambio DESC LIMIT 1";
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute();
        $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Cierra el statement
        $stmt = null;
        
        return $resultado;
    } catch (PDOException $e) {
        // Manejo de errores en caso de fallo en la base de datos
        error_log("Error al obtener el tipo de cambio: " . $e->getMessage());
        return null;
    }
}

*/



// MÉTODO PARA LISTAR PROPINAS POR FECHAS
// MÉTODO PARA LISTAR PROPINAS POR FECHAS (CON CORRECCIONES DEFINITIVAS)
public function ListarPropinasxFechas()
{
    self::SetNames();
    
    // Decodificación y limpieza de variables
    $tipopago = limpiar(decode($_GET["tipopago"])); 
    $desde = limpiar(date("Y-m-d", strtotime($_GET["desde"])));
    $hasta = limpiar(date("Y-m-d", strtotime($_GET["hasta"])));
    $codsucursal = limpiar(decode($_GET["codsucursal"]));
    
    // Condición para filtrar por Tipo de Pago (1=GENERAL, 2=CONTADO, 3=CRÉDITO)
    if ($tipopago == "1") {
        $query_tipopago = "";
    } else {
        $query_tipopago = " AND v.tipopago = '" . $tipopago . "'";
    }

    $sql = "SELECT 
                v.idventa,
                v.codfactura,
                v.montopropina,
                v.fechaventa,  /* Usamos 'fechaventa' (Asumiendo que es el nombre real de la columna) */
                v.codcliente,
                c.nomcliente,
                u.nombres AS nomcajero,
                v.totalpago
            FROM 
                ventas v
            INNER JOIN 
                usuarios u ON v.mesero = u.codigo  /* <<--- CORRECCIÓN DEFINITIVA: u.codigo es la clave primaria en la tabla usuarios */
            LEFT JOIN
                clientes c ON v.codcliente = c.codcliente
            WHERE
                v.codsucursal = '".$codsucursal."'
                AND DATE_FORMAT(v.fechaventa,'%Y-%m-%d') BETWEEN '".$desde."' AND '".$hasta."'
                AND v.montopropina > 0 
                ".$query_tipopago."
            ORDER BY 
                v.idventa DESC";

    foreach ($this->dbh->query($sql) as $row) {
        $this->p[] = $row;
    }
    return $this->p;
}











public function ObtenerTipoCambio() {
    try {
        // CAMBIE simbolocambio POR descripcioncambio
        $sql = "SELECT montocambio, descripcioncambio FROM tiposcambio ORDER BY fechacambio DESC, codcambio DESC LIMIT 1";
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute();
        $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

        // Cierra el statement
        $stmt = null;

        return $resultado;
    } catch (PDOException $e) {
        // Manejo de errores en caso de fallo en la base de datos
        error_log("Error al obtener el tipo de cambio: " . $e->getMessage());
        return null;
    }
}




#################### FUNCION PARA sumar vueltos por caja ####################

public function SumarVueltosPorCaja($codcaja, $fechaapertura, $fechacierre) {
    try {
        $sql = "SELECT SUM(montodevuelto) AS total_vueltos FROM ventas WHERE codcaja = :codcaja AND fecha_venta BETWEEN :fechaapertura AND :fechacierre";

        $stmt = $this->dbh->prepare($sql);
        $stmt->bindParam(':codcaja', $codcaja, PDO::PARAM_INT);
        $stmt->bindParam(':fechaapertura', $fechaapertura, PDO::PARAM_STR);
        $stmt->bindParam(':fechacierre', $fechacierre, PDO::PARAM_STR);
        $stmt->execute();
        
        $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $stmt = null;
        
        return $resultado['total_vueltos'] ?? 0;
    } catch (PDOException $e) {
        error_log("Error al sumar vueltos por caja: " . $e->getMessage());
        return 0;
    }
}


#################### funcion sumar vueltos por caja ####################

#################### FUNCION PARA ACCEDER AL SISTEMA ####################
public function Logueo()
{
	self::SetNames();
	if(empty($_POST["usuario"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT
	usuarios.codigo, 
	usuarios.dni,
	usuarios.nombres,
	usuarios.sexo,
	usuarios.direccion,
	usuarios.telefono,
	usuarios.email,
	usuarios.usuario,
	usuarios.password,
	usuarios.nivel,
	usuarios.status,
	usuarios.comision,
	usuarios.codsucursal,
	sucursales.nrosucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.nroactividadsucursal,
	sucursales.fechaautorsucursal,
	sucursales.llevacontabilidad,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.descsucursal,
	tiposmoneda.moneda,
	tiposmoneda.simbolo,
	documentos.documento,
	documentos2.documento AS documento2,
	provincias.provincia,
	departamentos.departamento
	FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento 
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	WHERE usuarios.usuario = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST["usuario"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		echo "2";
		exit;

	} else {
			
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[]=$row;
		}

		if (limpiar($row['status'])==0)
		{  
			echo "3";
			exit;
		} 
		elseif (password_verify($_POST["password"], $row['password'])) {

		######### DATOS DEL USUARIO ###########
		$_SESSION["codigo"] = $p[0]["codigo"];
		$_SESSION["dni"] = $p[0]["dni"];
		$_SESSION["nombres"] = $p[0]["nombres"];
		$_SESSION["sexo"] = $p[0]["sexo"];
		$_SESSION["direccion"] = $p[0]["direccion"];
		$_SESSION["telefono"] = $p[0]["telefono"];
		$_SESSION["email"] = $p[0]["email"];
		$_SESSION["usuario"] = $p[0]["usuario"];
		$_SESSION["password"] = $p[0]["password"];
		$_SESSION["nivel"] = $p[0]["nivel"];
		$_SESSION["status"] = $p[0]["status"];
		$_SESSION["ingreso"] = limpiar(date("Y-m-d H:i:s"));

		################## DATOS DE LA SUCURSAL ##################
		$_SESSION["codsucursal"] = $p[0]["codsucursal"];
		$_SESSION["documsucursal"] = $p[0]["documsucursal"];
		$_SESSION["cuitsucursal"] = $p[0]["cuitsucursal"];
		$_SESSION["nomsucursal"] = $p[0]["nomsucursal"];
		$_SESSION["tlfsucursal"] = $p[0]["tlfsucursal"];
		$_SESSION["id_provincia"] = $p[0]["id_provincia"];
		$_SESSION["provincia"] = $p[0]["provincia"];
		$_SESSION["id_departamento"] = $p[0]["id_departamento"];
		$_SESSION["departamento"] = $p[0]["departamento"];
		$_SESSION["direcsucursal"] = $p[0]["direcsucursal"];
		$_SESSION["correosucursal"] = $p[0]["correosucursal"];
		$_SESSION["nomencargado"] = $p[0]["nomencargado"];
		$_SESSION["descsucursal"] = $p[0]["descsucursal"];
		$_SESSION["simbolo"] = $p[0]["simbolo"];
		$_SESSION["documento"] = $p[0]["documento"];
		$_SESSION["documento2"] = $p[0]["documento2"];

		$query = "INSERT INTO log VALUES (null, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$a);
		$stmt->bindParam(2,$b);
		$stmt->bindParam(3,$c);
		$stmt->bindParam(4,$d);
		$stmt->bindParam(5,$e);

		$a = limpiar($_SERVER['REMOTE_ADDR']);
		$b = limpiar(date("Y-m-d H:i:s"));
		$c = limpiar($_SERVER['HTTP_USER_AGENT']);
		$d = limpiar($_SERVER['PHP_SELF']);
		$e = limpiar($_POST["usuario"]);
		$stmt->execute();

		switch($_SESSION["nivel"])
		{
			case 'ADMINISTRADOR(A) GENERAL':
			$_SESSION["acceso"]="administradorG";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'ADMINISTRADOR(A) SUCURSAL':
			$_SESSION["acceso"]="administradorS";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'SECRETARIA':
			$_SESSION["acceso"]="secretaria";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'CAJERO(A)':
			$_SESSION["acceso"]="cajero";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'MESERO(A)':
			$_SESSION["acceso"]="mesero";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'COCINERO(A)':
			$_SESSION["acceso"]="cocinero";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'BARTENDER':
			$_SESSION["acceso"]="bar";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'REPOSTERIA':
			$_SESSION["acceso"]="reposteria";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>

			<?php
			break;
			case 'REPARTIDOR':
			$_SESSION["acceso"]="repartidor";
			?>

			<script type="text/javascript">
				window.location="panel";
			</script>
			
			<?php
			break;
		}//end switch	

	} else {

  	echo "4";
  
	}
  } 
}
#################### FUNCION PARA ACCEDER AL SISTEMA ####################



















######################## FUNCION RECUPERAR Y ACTUALIZAR PASSWORD #######################

########################### FUNCION PARA RECUPERAR CLAVE #############################
public function RecuperarPassword()
{
	self::SetNames();
	if(empty($_POST["email"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT * FROM usuarios WHERE email = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST["email"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "2";
		exit;
	}
	else
	{
			
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$pa[] = $row;
		}
		$id = $pa[0]["codigo"];
		$nombres = $pa[0]["nombres"];
		$email = $pa[0]["email"];
		$pass = strtoupper(generar_clave(10));
	}

	################## DATOS DE CONFIGURACION #####################
	$sql = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
    $rucemisor = $row['cuitsucursal'];
    $nomsucursal = $row['nomsucursal'];
    $correo = $row['correosucursal'];
    ################## DATOS DE CONFIGURACION #####################

	#################### VALIDACION DE ENVIO DE CORREO CON PHPMAILER ####################
	$smtp=new PHPMailer();
	$smtp->SMTPOptions = array(
		'ssl' => array(
			'verify_peer' => false,
			'verify_peer_name' => false,
			'allow_self_signed' => true
		)
	);

	# Indicamos que vamos a utilizar un servidor SMTP
	$smtp->IsSMTP();

    # Definimos el formato del correo con UTF-8
	$smtp->CharSet="UTF-8";

    # autenticación contra nuestro servidor smtp
	$smtp->Port = 465;
	$smtp->IsSMTP(); // use SMTP
	$smtp->SMTPAuth   = true;
	$smtp->SMTPSecure = 'ssl';						// enable SMTP authentication
	$smtp->Host       = "smtp.gmail.com";			// sets MAIL as the SMTP server
	//$smtp->Username   = "empresa@gmail.com";	// MAIL username
	//$smtp->Password   = "passworemailempresa";			// MAIL password
	$smtp->Username   = "abrahamveliz.jt@gmail.com";	// MAIL username
	$smtp->Password   = "wmeeivbgailahpis";			// MAIL password
	//$smtp->Password   = "rlvp qpbx mndj bcli";			// MAIL password

	# datos de quien realiza el envio
	$smtp->From       = $correo; // from mail
	$smtp->FromName   = $nomsucursal; // from mail name

	# Indicamos las direcciones donde enviar el mensaje con el formato
	#   "correo"=>"nombre usuario"
	# Se pueden poner tantos correos como se deseen

	# establecemos un limite de caracteres de anchura
	$smtp->WordWrap   = 50; // set word wrap

	# NOTA: Los correos es conveniente enviarlos en formato HTML y Texto para que
	# cualquier programa de correo pueda leerlo.

	# Definimos el contenido HTML del correo
	$contenidoHTML="<head>";
	$contenidoHTML.="<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
	$contenidoHTML.="</head><body>";
	$contenidoHTML.="<b>Recuperación de Contraseña</b>";
	$contenidoHTML.="<p>Nueva Contraseña de Acceso: $pass</p>";
	$contenidoHTML.="</body>\n";

	# Definimos el contenido en formato Texto del correo
	$contenidoTexto= " Recuperación de Contraseña";
	$contenidoTexto.="\n\n";

	# Definimos el subject
	$smtp->Subject= " Recuperación de Contraseña";

	# Adjuntamos el archivo al correo.
    $smtp->AddAttachment("fotos/logo_principal.png", "logo.png");
	//$smtp->AddAttachment("");

	# Indicamos el contenido
	$smtp->AltBody=$contenidoTexto; //Text Body
	$smtp->MsgHTML($contenidoHTML); //Text body HTML

	$smtp->ClearAllRecipients();
	$smtp->AddAddress($email,str_replace(" ", "_",$nombres));

	//$smtp->Send();
	//Enviamos email
	if(!$smtp->Send()) {

	    //Mensaje no pudo ser enviado
	    echo "3";
		exit;

	} else {

	$sql = " UPDATE usuarios set "
	." password = ? "
	." WHERE "
	." codigo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $password);
	$stmt->bindParam(2, $codigo);

	$codigo = $id;
	$password = password_hash($pass, PASSWORD_DEFAULT);
	$stmt->execute();

	echo "<span class='fa fa-check-square-o'></span> SU NUEVA CLAVE DE ACCESO LE FUE ENVIADA A SU CORREO ELECTRONICO EXITOSAMENTE";
	exit;

   }
	#################### VALIDACION DE ENVIO DE CORREO CON PHPMAILER ####################
}	
############################# FUNCION PARA RECUPERAR CLAVE ############################

########################## FUNCION PARA ACTUALIZAR PASSWORD ############################
public function ActualizarPassword()
{
	self::SetNames();
	if(empty($_POST["dni"]))
	{
		echo "1";
		exit;
	}

	if(password_hash($_POST["password"], PASSWORD_DEFAULT) == limpiar($_POST["clave"])){
		echo "2";
		exit;

	} else {
		
		$sql = " UPDATE usuarios set "
		." usuario = ?, "
		." password = ? "
		." WHERE "
		." codigo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $usuario);
		$stmt->bindParam(2, $password);
		$stmt->bindParam(3, $codigo);	

		$usuario = limpiar($_POST["usuario"]);
		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$codigo = limpiar($_POST["codigo"]);
		$stmt->execute();
		
		echo "<span class='fa fa-check-square-o'></span> SU CLAVE DE ACCESO FUE ACTUALIZADA EXITOSAMENTE, SER&Aacute; EXPULSADO DE SU SESI&Oacute;N Y DEBER&Aacute; DE ACCEDER NUEVAMENTE CON SU NUEVA CLAVE";
		?>
		<script>
			function redireccionar(){location.href="logout";}
			setTimeout ("redireccionar()", 3000);
		</script>
		<?php
		exit;
	}
}
########################## FUNCION PARA ACTUALIZAR PASSWORD  ############################

####################### FUNCION RECUPERAR Y ACTUALIZAR PASSWORD ########################


























###################### FUNCION CONFIGURACION GENERAL DEL SISTEMA #######################

######################## FUNCION ID CONFIGURACION DEL SISTEMA #########################
public function ConfiguracionPorId()
{
	self::SetNames();
	$sql = "SELECT 
	configuracion.id,
	configuracion.documsucursal,
	configuracion.cuitsucursal,
	configuracion.nomsucursal,
	configuracion.codgiro,
	configuracion.girosucursal,
	configuracion.tlfsucursal,
	configuracion.correosucursal,
	configuracion.id_provincia,
	configuracion.id_departamento,
	configuracion.direcsucursal,
	configuracion.documencargado,
	configuracion.dniencargado,
	configuracion.nomencargado,
	configuracion.tlfencargado,
	documentos.documento,
	documentos2.documento AS documento2,
	provincias.provincia,
	departamentos.departamento
	FROM configuracion 
	LEFT JOIN documentos ON configuracion.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON configuracion.documencargado = documentos2.coddocumento 
	LEFT JOIN provincias ON configuracion.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON configuracion.id_departamento = departamentos.id_departamento
	WHERE configuracion.id = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array('1'));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION ID CONFIGURACION DEL SISTEMA #########################

######################## FUNCION  ACTUALIZAR CONFIGURACION ##########################
public function ActualizarConfiguracion()
{

	self::SetNames();
	if(empty($_POST["cuitsucursal"]) or empty($_POST["nomsucursal"]) or empty($_POST["codgiro"]) or empty($_POST["girosucursal"]) or empty($_POST["tlfsucursal"]) or empty($_POST["correosucursal"]) or empty($_POST["direcsucursal"]) or empty($_POST["dniencargado"]) or empty($_POST["nomencargado"]) or empty($_POST["tlfencargado"]))
	{
		echo "1";
		exit;
	}

	$sql = " UPDATE configuracion set "
	." documsucursal = ?, "
	." cuitsucursal = ?, "
	." nomsucursal = ?, "
	." codgiro = ?, "
	." girosucursal = ?, "
	." tlfsucursal = ?, "
	." correosucursal = ?, "
	." id_provincia = ?, "
	." id_departamento = ?, "
	." direcsucursal = ?, "
	." documencargado = ?, "
	." dniencargado = ?, "
	." nomencargado = ?, "
	." tlfencargado = ? "
	." WHERE "
	." id = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $documsucursal);
	$stmt->bindParam(2, $cuitsucursal);
	$stmt->bindParam(3, $nomsucursal);
	$stmt->bindParam(4, $codgiro);
	$stmt->bindParam(5, $girosucursal);
	$stmt->bindParam(6, $tlfsucursal);
	$stmt->bindParam(7, $correosucursal);
	$stmt->bindParam(8, $id_provincia);
	$stmt->bindParam(9, $id_departamento);
	$stmt->bindParam(10, $direcsucursal);
	$stmt->bindParam(11, $documencargado);
	$stmt->bindParam(12, $dniencargado);
	$stmt->bindParam(13, $nomencargado);
	$stmt->bindParam(14, $tlfencargado);
	$stmt->bindParam(15, $id);

	$documsucursal = limpiar($_POST['documsucursal'] == '' ? "0" : $_POST['documsucursal']);
	$cuitsucursal = limpiar($_POST["cuitsucursal"]);
	$nomsucursal = limpiar($_POST["nomsucursal"]);
	$codgiro = limpiar($_POST['codgiro'] == '' ? "0" : $_POST['codgiro']);
	$girosucursal = limpiar($_POST['girosucursal'] == '' ? "0" : $_POST['girosucursal']);
	$tlfsucursal = limpiar($_POST["tlfsucursal"]);
	$correosucursal = limpiar($_POST["correosucursal"]);
	$id_provincia = limpiar($_POST['id_provincia'] == '' ? "0" : $_POST['id_provincia']);
	$id_departamento = limpiar($_POST['id_departamento'] == '' ? "0" : $_POST['id_departamento']);
	$direcsucursal = limpiar($_POST["direcsucursal"]);
	$documencargado = limpiar($_POST['documencargado'] == '' ? "0" : $_POST['documencargado']);
	$dniencargado = limpiar($_POST["dniencargado"]);
	$nomencargado = limpiar($_POST["nomencargado"]);
	$tlfencargado = limpiar($_POST["tlfencargado"]);
	$id = limpiar($_POST["id"]);
	$stmt->execute();

	################## SUBIR LOGO PRINCIPAL #1 ######################################
    //datos del arhivo  
    if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
    if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
    if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; }  
         //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<200000) {  
		if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/logo_principal.png"))
		{ 
		## se puede dar un aviso
	    } 
		## se puede dar otro aviso 
	}
	################## FINALIZA SUBIR LOGO PRINCIPAL #1 ##################

    ################## SUBIR LOGO PDF #1 ######################################
    //datos del arhivo  
    if (isset($_FILES['imagen2']['name'])) { $nombre_archivo = $_FILES['imagen2']['name']; } else { $nombre_archivo =''; }
    if (isset($_FILES['imagen2']['type'])) { $tipo_archivo = $_FILES['imagen2']['type']; } else { $tipo_archivo =''; }
    if (isset($_FILES['imagen2']['size'])) { $tamano_archivo = $_FILES['imagen2']['size']; } else { $tamano_archivo =''; }  
         //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<200000) {  
		if (move_uploaded_file($_FILES['imagen2']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/logo_pdf.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	################## FINALIZA SUBIR LOGO PDF #1 ######################################

	echo "<span class='fa fa-check-square-o'></span> LOS DATOS DE CONFIGURACI&Oacute;N FUERON ACTUALIZADOS EXITOSAMENTE";
	exit;
}
######################## FUNCION  ACTUALIZAR CONFIGURACION #######################

#################### FIN DE FUNCION CONFIGURACION GENERAL DEL SISTEMA ##################


























################################## CLASE USUARIOS #####################################

############################## FUNCION REGISTRAR USUARIOS ##############################
public function RegistrarUsuarios()
{
	self::SetNames();
	if(empty($_POST["nombres"]) or empty($_POST["usuario"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	}

	if($_POST["nivel"]=="ADMINISTRADOR(A) GENERAL" && $_POST["codsucursal"]!="0")
	{
		
		echo "2";
		exit;
	}

	elseif($_POST["nivel"]!="ADMINISTRADOR(A) GENERAL" && $_POST["codsucursal"]=="0")
	{
		
		echo "3";
		exit;
	}

	$sql = "SELECT dni FROM usuarios WHERE dni = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["dni"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		
		echo "4";
		exit;
	}
	else
	{
	$sql = "SELECT email FROM usuarios WHERE email = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["email"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{

		echo "5";
		exit;
	}
	else
	{
	$sql = "SELECT usuario FROM usuarios WHERE usuario = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["usuario"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO usuarios values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $dni);
		$stmt->bindParam(2, $nombres);
		$stmt->bindParam(3, $sexo);
		$stmt->bindParam(4, $direccion);
		$stmt->bindParam(5, $telefono);
		$stmt->bindParam(6, $email);
		$stmt->bindParam(7, $usuario);
		$stmt->bindParam(8, $password);
		$stmt->bindParam(9, $nivel);
		$stmt->bindParam(10, $status);
		$stmt->bindParam(11, $comision);
		$stmt->bindParam(12, $codsucursal);

		$dni = limpiar($_POST["dni"]);
		$nombres = limpiar($_POST["nombres"]);
		$sexo = limpiar($_POST["sexo"]);
		$direccion = limpiar($_POST["direccion"]);
		$telefono = limpiar($_POST["telefono"]);
		$email = limpiar($_POST["email"]);
		$usuario = limpiar($_POST["usuario"]);
		//$password = hash("sha512", $password);	
		//$hashed_password = password_hash($password, PASSWORD_DEFAULT);
		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$nivel = limpiar($_POST["nivel"]);
		$status = limpiar($_POST["status"]);
		$comision = limpiar($_POST["comision"]);
	    $codsucursal = limpiar($_POST['codsucursal'] == "0" ? "0" : decrypt($_POST["codsucursal"]));
		$stmt->execute();

		################## SUBIR FOTO DE USUARIOS ######################################
         //datos del arhivo  
				if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
				if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
				if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; }  
         //compruebo si las características del archivo son las que deseo  
				if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<50000) 
				{  
					if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/".$_POST["dni"].".jpg"))
					{ 
		 ## se puede dar un aviso
					} 
		 ## se puede dar otro aviso 
				}
		################## FINALIZA SUBIR FOTO DE USUARIOS ##################

				echo "<span class='fa fa-check-square-o'></span> EL USUARIO HA SIDO REGISTRADO EXITOSAMENTE";
				exit;
			}
			else
			{
				echo "6";
				exit;
			}
		}
	}
}
############################# FUNCION REGISTRAR USUARIOS ###############################

############################# FUNCION LISTAR USUARIOS ################################
public function ListarUsuarios()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT * FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

	$sql = "SELECT * FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal
	WHERE usuarios.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
############################## FUNCION LISTAR USUARIOS ################################

###################### FUNCION LISTAR USUARIOS RESPONSABLES ######################
public function ListarResponsables()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT * FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal 
	WHERE usuarios.nivel = 'ADMINISTRADOR(A) SUCURSAL' OR usuarios.nivel = 'SECRETARIA' OR usuarios.nivel = 'CAJERO(A)'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

	$sql = "SELECT * FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal 
	WHERE usuarios.codsucursal = '".limpiar($_SESSION["codsucursal"])."' AND usuarios.nivel = 'ADMINISTRADOR(A) SUCURSAL' OR usuarios.nivel = 'SECRETARIA' OR usuarios.nivel = 'CAJERO(A)'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
##################### FUNCION LISTAR USUARIOS RESPONSABLES #########################

###################### FUNCION LISTAR USUARIOS REPARTIDORES ######################
public function ListarRepartidores()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT * FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal
	WHERE usuarios.nivel = 'REPARTIDOR'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

	$sql = "SELECT * FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal
	WHERE usuarios.codsucursal = '".limpiar($_SESSION["codsucursal"])."' AND usuarios.nivel = 'REPARTIDOR'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
##################### FUNCION LISTAR USUARIOS REPARTIDORES #########################

########################## FUNCION BUSQUEDA DE LOGS DE USUARIOS ###############################
public function BusquedaLogs()
	{
	self::SetNames();
	
	$buscar = limpiar($_POST['b']);

	if(empty($buscar)) {
            echo "";
            exit;
    }

    $sql = "SELECT * FROM log WHERE CONCAT(ip, ' ',tiempo, ' ',detalles, ' ',usuario) LIKE '%".$buscar."%' LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0) {

	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON REGISTROS PARA TU BUSQUEDA</div></center>";
	exit;
		
	} else {
			
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################## FUNCION BUSQUEDA DE LOGS DE USUARIOS ###############################

########################### FUNCION LISTAR LOGS DE USUARIOS ###########################
public function ListarLogs()
{
	self::SetNames();
	$sql = "SELECT * FROM log";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

   }
########################### FUNCION LISTAR LOGS DE USUARIOS ###########################

############################ FUNCION ID USUARIOS #################################
public function UsuariosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM usuarios LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal 
	WHERE usuarios.codigo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID USUARIOS #################################

############################ FUNCION ACTUALIZAR USUARIOS ############################
public function ActualizarUsuarios()
{

	self::SetNames();
	if(empty($_POST["dni"]) or empty($_POST["nombres"]) or empty($_POST["usuario"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	}

	if($_POST["nivel"]=="ADMINISTRADOR(A) GENERAL" && $_POST["codsucursal"]!="0")
	{
		
		echo "2";
		exit;
	}

	elseif($_POST["nivel"]!="ADMINISTRADOR(A) GENERAL" && $_POST["codsucursal"]=="0")
	{
		
		echo "3";
		exit;
	}

	$sql = "SELECT * FROM usuarios WHERE codigo != ? AND dni = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codigo"],$_POST["dni"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "4";
		exit;
	}
	else
	{
	$sql = "SELECT email FROM usuarios WHERE codigo != ? AND email = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codigo"],$_POST["email"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "5";
		exit;
	}
	else
	{
		$sql = "SELECT usuario FROM usuarios WHERE codigo != ? AND usuario = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codigo"],$_POST["usuario"]));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$sql = " UPDATE usuarios set "
			." dni = ?, "
			." nombres = ?, "
			." sexo = ?, "
			." direccion = ?, "
			." telefono = ?, "
			." email = ?, "
			." usuario = ?, "
			." password = ?, "
			." nivel = ?, "
			." status = ?, "
			." comision = ?, "
			." codsucursal = ? "
			." WHERE "
			." codigo = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $dni);
			$stmt->bindParam(2, $nombres);
			$stmt->bindParam(3, $sexo);
			$stmt->bindParam(4, $direccion);
			$stmt->bindParam(5, $telefono);
			$stmt->bindParam(6, $email);
			$stmt->bindParam(7, $usuario);
			$stmt->bindParam(8, $password);
			$stmt->bindParam(9, $nivel);
			$stmt->bindParam(10, $status);
			$stmt->bindParam(11, $comision);
			$stmt->bindParam(12, $codsucursal);
			$stmt->bindParam(13, $codigo);

			$dni = limpiar($_POST["dni"]);
			$nombres = limpiar($_POST["nombres"]);
			$sexo = limpiar($_POST["sexo"]);
			$direccion = limpiar($_POST["direccion"]);
			$telefono = limpiar($_POST["telefono"]);
			$email = limpiar($_POST["email"]);
			$usuario = limpiar($_POST["usuario"]);
			$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
			$nivel = limpiar($_POST["nivel"]);
			$status = limpiar($_POST["status"]);
			$comision = limpiar($_POST["comision"]);
	        $codsucursal = limpiar($_POST['codsucursal'] == "0" ? "0" : decrypt($_POST["codsucursal"]));
			//$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$codigo = limpiar($_POST["codigo"]);
			$stmt->execute();

		################## SUBIR FOTO DE USUARIOS ######################################
         //datos del arhivo  
				if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
				if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
				if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; }  
         //compruebo si las características del archivo son las que deseo  
				if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<50000) 
				{  
					if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/".$_POST["dni"].".jpg"))
					{ 
		 ## se puede dar un aviso
					} 
		 ## se puede dar otro aviso 
				}
		################## FINALIZA SUBIR FOTO DE USUARIOS ######################################

				echo "<span class='fa fa-check-square-o'></span> EL USUARIO HA SIDO ACTUALIZADO EXITOSAMENTE";
				exit;

			}
			else
			{
				echo "6";
				exit;
			}
		}
	}
}
############################ FUNCION ACTUALIZAR USUARIOS ############################

############################# FUNCION ELIMINAR USUARIOS ################################
public function EliminarUsuarios()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codigo FROM cajas WHERE codigo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codigo"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM usuarios WHERE codigo = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codigo);
		$codigo = decrypt($_GET["codigo"]);
		$stmt->execute();

		$dni = decrypt($_GET["dni"]);
		if (file_exists("fotos/".$dni.".jpg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/".$dni.".jpg";		
		unlink($archivos);
		}

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################## FUNCION ELIMINAR USUARIOS ##############################

######################## FUNCION BUSCAR USUARIOS POR SUCURSAL ##########################
public function BuscarUsuariosxSucursal() 
{
	self::SetNames();
	$sql = " SELECT * FROM usuarios 
	INNER JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal 
	WHERE usuarios.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION BUSCAR USUARIOS POR SUCURSAL ##########################

################### FUNCION SELECCIONA USUARIO POR CODIGO Y SUCURSAL ###################
public function BuscarUsuariosxCodigo() 
{
	self::SetNames();
	$sql = " SELECT * FROM usuarios WHERE codigo = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codigo"],decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################### FUNCION SELECCIONA USUARIO POR CODIGO Y SUCURSAL ##################

############################ FIN DE CLASE USUARIOS ################################


























################################ CLASE PROVINCIAS ##################################

########################## FUNCION REGISTRAR PROVINCIAS ###############################
public function RegistrarProvincias()
{
	self::SetNames();
	if(empty($_POST["provincia"]))
	{
		echo "1";
		exit;
	}

			$sql = "SELECT provincia FROM provincias WHERE provincia = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($_POST["provincia"]));
			$num = $stmt->rowCount();
			if($num == 0)
			{
				$query = "INSERT INTO provincias values (null, ?);";
				$stmt = $this->dbh->prepare($query);
				$stmt->bindParam(1, $provincia);

				$provincia = limpiar($_POST["provincia"]);
				$stmt->execute();

			echo "<span class='fa fa-check-square-o'></span> LA PROVINCIA HA SIDO REGISTRADA EXITOSAMENTE";
			exit;

			} else {

			echo "2";
			exit;
	    }
}
############################ FUNCION REGISTRAR PROVINCIAS ############################

############################ FUNCION LISTAR PROVINCIAS ################################
public function ListarProvincias()
{
	self::SetNames();
	$sql = "SELECT * FROM provincias";

	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
########################### FUNCION LISTAR PROVINCIAS ################################

########################### FUNCION ID PROVINCIAS #################################
public function ProvinciasPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM provincias WHERE id_provincia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_provincia"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID PROVINCIAS #################################

############################ FUNCION ACTUALIZAR PROVINCIAS ############################
public function ActualizarProvincias()
{

	self::SetNames();
	if(empty($_POST["id_provincia"]) or empty($_POST["provincia"]))
	{
		echo "1";
		exit;
	}

		$sql = "SELECT provincia FROM provincias WHERE id_provincia != ? AND provincia = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["id_provincia"],$_POST["provincia"]));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$sql = " UPDATE provincias set "
			." provincia = ? "
			." WHERE "
			." id_provincia = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $provincia);
			$stmt->bindParam(2, $id_provincia);

			$provincia = limpiar($_POST["provincia"]);
            $id_provincia = limpiar($_POST['id_provincia']);
			$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA PROVINCIA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

		} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR PROVINCIAS ############################

############################ FUNCION ELIMINAR PROVINCIAS ############################
public function EliminarProvincias()
{
	self::SetNames();
	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT id_provincia FROM departamentos WHERE id_provincia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_provincia"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM provincias WHERE id_provincia = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$id_provincia);
		$id_provincia = decrypt($_GET["id_provincia"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################ FUNCION ELIMINAR PROVINCIAS ##############################

############################## FIN DE CLASE PROVINCIAS ################################


























############################### CLASE DEPARTAMENTOS ################################

############################# FUNCION REGISTRAR DEPARTAMENTOS ###########################
public function RegistrarDepartamentos()
{
	self::SetNames();
	if(empty($_POST["departamento"]) or empty($_POST["id_provincia"]))
	{
		echo "1";
		exit;
	}

		$sql = "SELECT departamento FROM departamentos WHERE departamento = ? AND id_provincia = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["departamento"],$_POST["id_provincia"]));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$query = "INSERT INTO departamentos values (null, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $departamento);
			$stmt->bindParam(2, $id_provincia);

			$departamento = limpiar($_POST["departamento"]);
			$id_provincia = limpiar($_POST['id_provincia']);
			$stmt->execute();

	echo "<span class='fa fa-check-square-o'></span> EL DEPARTAMENTO HA SIDO REGISTRADO EXITOSAMENTE";
	exit;

		} else {

		echo "2";
		exit;
    }
}
########################### FUNCION REGISTRAR DEPARTAMENTOS ########################

########################## FUNCION PARA LISTAR DEPARTAMENTOS ##########################
public function ListarDepartamentos()
{
	self::SetNames();
	$sql = "SELECT * FROM departamentos LEFT JOIN provincias ON departamentos.id_provincia = provincias.id_provincia";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
######################### FUNCION PARA LISTAR DEPARTAMENTOS ##########################

###################### FUNCION LISTAR DEPARTAMENTOS POR PROVINCIAS #####################
public function ListarDepartamentoXProvincias() 
       {
	self::SetNames();
	$sql = "SELECT * FROM departamentos WHERE id_provincia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["id_provincia"]));
	$num = $stmt->rowCount();
	    if($num==0)
	{
		echo "<option value='0' selected> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
##################### FUNCION LISTAR DEPARTAMENTOS POR PROVINCIAS ######################

################# FUNCION PARA SELECCIONAR DEPARTAMENTOS POR PROVINCIA #################
public function SeleccionaDepartamento()
{
	self::SetNames();
	$sql = "SELECT * FROM departamentos WHERE id_provincia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["id_provincia"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value='0'> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
		while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################# FUNCION PARA SELECCIONAR DEPARTAMENTOS POR PROVINCIA ################

############################ FUNCION ID DEPARTAMENTOS #################################
public function DepartamentosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM departamentos LEFT JOIN provincias ON departamentos.id_provincia = provincias.id_provincia WHERE departamentos.id_provincia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_provincia"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID DEPARTAMENTOS #################################

######################## FUNCION ACTUALIZAR DEPARTAMENTOS ############################
public function ActualizarDepartamentos()
{
	self::SetNames();
	if(empty($_POST["id_departamento"]) or empty($_POST["departamento"]) or empty($_POST["id_provincia"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT departamento FROM departamentos WHERE id_departamento != ? AND departamento = ? AND id_provincia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["id_departamento"],$_POST["departamento"],$_POST["id_provincia"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE departamentos set "
		." departamento = ?, "
		." id_provincia = ? "
		." WHERE "
		." id_departamento = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $departamento);
		$stmt->bindParam(2, $id_provincia);
		$stmt->bindParam(3, $id_departamento);

		$departamento = limpiar($_POST["departamento"]);
        $id_provincia = limpiar($_POST['id_provincia']);
        $id_departamento = limpiar($_POST['id_departamento']);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL DEPARTAMENTO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR DEPARTAMENTOS #######################

############################ FUNCION ELIMINAR DEPARTAMENTOS ###########################
public function EliminarDepartamentos()
{
	self::SetNames();
	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT id_departamento FROM configuracion WHERE id_departamento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_departamento"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM departamentos WHERE id_departamento = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$id_departamento);
		$id_departamento = decrypt($_GET["id_departamento"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR DEPARTAMENTOS ############################

############################## FIN DE CLASE DEPARTAMENTOS ##############################


























################################ CLASE TIPOS DE DOCUMENTOS ##############################

########################### FUNCION REGISTRAR TIPO DE DOCUMENTOS ########################
public function RegistrarDocumentos()
{
	self::SetNames();
	if(empty($_POST["documento"]) or empty($_POST["descripcion"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT * FROM documentos WHERE documento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["documento"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO documentos values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $documento);
		$stmt->bindParam(2, $descripcion);

		$documento = limpiar($_POST["documento"]);
		$descripcion = limpiar($_POST["descripcion"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE DOCUMENTO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION REGISTRAR TIPO DE MONEDA ########################

########################## FUNCION LISTAR TIPO DE MONEDA ################################
public function ListarDocumentos()
{
	self::SetNames();
	$sql = "SELECT * FROM documentos ORDER BY documento ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
######################### FUNCION LISTAR TIPO DE DOCUMENTOS ##########################

######################### FUNCION ID TIPO DE DOCUMENTOS ###############################
public function DocumentoPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM documentos WHERE coddocumento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["coddocumento"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################## FUNCION ID TIPO DE DOCUMENTOS #########################

######################### FUNCION ACTUALIZAR TIPO DE DOCUMENTOS ########################
public function ActualizarDocumentos()
{

	self::SetNames();
	if(empty($_POST["coddocumento"]) or empty($_POST["documento"]) or empty($_POST["descripcion"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT documento FROM documentos WHERE coddocumento != ? AND documento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["coddocumento"],$_POST["documento"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE documentos set "
		." documento = ?, "
		." descripcion = ? "
		." WHERE "
		." coddocumento = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $documento);
		$stmt->bindParam(2, $descripcion);
		$stmt->bindParam(3, $coddocumento);

		$documento = limpiar($_POST["documento"]);
		$descripcion = limpiar($_POST["descripcion"]);
		$coddocumento = limpiar($_POST["coddocumento"]);
		$stmt->execute();

	    echo "<span class='fa fa-check-square-o'></span> EL TIPO DE DOCUMENTO HA SIDO ACTUALIZADO EXITOSAMENTE";
	    exit;

	} else {

	    echo "2";
	    exit;
    }
}
####################### FUNCION ACTUALIZAR TIPO DE DOCUMENTOS #######################

######################### FUNCION ELIMINAR TIPO DE DOCUMENTOS #########################
public function EliminarDocumentos()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT documsucursal FROM configuracion WHERE documsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["coddocumento"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM documentos WHERE coddocumento = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddocumento);
		$coddocumento = decrypt($_GET["coddocumento"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
######################## FUNCION ELIMINAR TIPOS DE DOCUMENTOS ###########################

########################### FIN DE CLASE TIPOS DE DOCUMENTOS ###########################



























############################### CLASE TIPOS DE MONEDAS ##############################

############################ FUNCION REGISTRAR TIPO DE MONEDA ##########################
public function RegistrarTipoMoneda()
{
	self::SetNames();
	if(empty($_POST["moneda"]) or empty($_POST["moneda"]) or empty($_POST["simbolo"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT * FROM tiposmoneda WHERE moneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["moneda"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO tiposmoneda values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $moneda);
		$stmt->bindParam(2, $siglas);
		$stmt->bindParam(3, $simbolo);

		$moneda = limpiar($_POST["moneda"]);
		$siglas = limpiar($_POST["siglas"]);
		$simbolo = limpiar($_POST["simbolo"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE MONEDA HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

    } else {

		echo "2";
		exit;
	}
}
######################### FUNCION REGISTRAR TIPO DE MONEDA #######################

########################## FUNCION LISTAR TIPO DE MONEDA ################################
public function ListarTipoMoneda()
{
	self::SetNames();
	$sql = "SELECT * FROM tiposmoneda";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
########################### FUNCION LISTAR TIPO DE MONEDA #########################

############################ FUNCION ID TIPO DE MONEDA #################################
public function TipoMonedaPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM tiposmoneda WHERE codmoneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmoneda"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID TIPO DE MONEDA #################################

####################### FUNCION ACTUALIZAR TIPO DE MONEDA ###########################
public function ActualizarTipoMoneda()
{

	self::SetNames();
	if(empty($_POST["codmoneda"]) or empty($_POST["moneda"]) or empty($_POST["siglas"]) or empty($_POST["simbolo"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT moneda FROM tiposmoneda WHERE codmoneda != ? AND moneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codmoneda"],$_POST["moneda"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE tiposmoneda set "
		." moneda = ?, "
		." siglas = ?, "
		." simbolo = ? "
		." WHERE "
		." codmoneda = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $moneda);
		$stmt->bindParam(2, $siglas);
		$stmt->bindParam(3, $simbolo);
		$stmt->bindParam(4, $codmoneda);

		$moneda = limpiar($_POST["moneda"]);
		$siglas = limpiar($_POST["siglas"]);
		$simbolo = limpiar($_POST["simbolo"]);
		$codmoneda = limpiar($_POST["codmoneda"]);
		$stmt->execute();

	    echo "<span class='fa fa-check-square-o'></span> EL TIPO DE MONEDA HA SIDO ACTUALIZADO EXITOSAMENTE";
	    exit;

	} else {

	   echo "2";
	   exit;
    }
}
######################## FUNCION ACTUALIZAR TIPO DE MONEDA ############################

######################### FUNCION ELIMINAR TIPO DE MONEDA ###########################
public function EliminarTipoMoneda()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codmoneda FROM tiposcambio WHERE codmoneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmoneda"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM tiposmoneda WHERE codmoneda = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmoneda);
		$codmoneda = decrypt($_GET["codmoneda"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR TIPOS DE MONEDAS ########################

##################### FUNCION BUSCAR TIPOS DE CAMBIOS POR MONEDA #######################
public function BuscarTiposCambios()
{
	self::SetNames();
	$sql = "SELECT * FROM tiposmoneda INNER JOIN tiposcambio ON tiposmoneda.codmoneda = tiposcambio.codmoneda WHERE tiposcambio.codmoneda = ? ORDER BY tiposcambio.codcambio DESC LIMIT 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmoneda"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<center><div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON TIPOS DE CAMBIO PARA LA MONEDA SELECCIONADA</div></center>";
		exit;
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
##################### FUNCION BUSCAR TIPOS DE CAMBIOS POR MONEDA #####################

############################# FIN DE CLASE TIPOS DE MONEDAS #############################
























############################## CLASE TIPOS DE CAMBIOS ################################

########################## FUNCION REGISTRAR TIPO DE CAMBIO #########################

/*
public function RegistrarTipoCambio()
{
	self::SetNames();
	if(empty($_POST["descripcioncambio"]) or empty($_POST["montocambio"]) or empty($_POST["codmoneda"]) or empty($_POST["fechacambio"]))
	{
		echo "1";
		exit;
	}
			
		$sql = "SELECT codmoneda, fechacambio FROM tiposcambio WHERE codmoneda = ? AND fechacambio = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codmoneda"],date("Y-m-d",strtotime($_POST['fechacambio']))));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$query = "INSERT INTO tiposcambio values (null, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $descripcioncambio);
			$stmt->bindParam(2, $montocambio);
			$stmt->bindParam(3, $codmoneda);
			$stmt->bindParam(4, $fechacambio);

			$descripcioncambio = limpiar($_POST["descripcioncambio"]);
			$montocambio = number_format($_POST["montocambio"], 3, '.', '');
			$codmoneda = limpiar($_POST["codmoneda"]);
			$fechacambio = limpiar(date("Y-m-d",strtotime($_POST['fechacambio'])));
			$stmt->execute();

			echo "<span class='fa fa-check-square-o'></span> EL TIPO DE CAMBIO HA SIDO REGISTRADO EXITOSAMENTE";
			exit;

			} else {

			echo "2";
			exit;
	    }
}

*/


######################### FUNCION REGISTRAR TIPO DE CAMBIO ########################
public function RegistrarTipoCambio() {
    try {
        // Primero, se eliminan todos los registros existentes en la tabla
        $deleteSql = "DELETE FROM tiposcambio";
        $this->dbh->exec($deleteSql);

        // Luego, se inserta el nuevo tipo de cambio
        $sql = "INSERT INTO tiposcambio (descripcioncambio, montocambio, codmoneda, fechacambio) VALUES (:descripcion, :monto, :moneda, NOW())";
        $stmt = $this->dbh->prepare($sql);
        $stmt->bindParam(':descripcion', $_POST['descripcioncambio']);
        $stmt->bindParam(':monto', $_POST['montocambio']);
        $stmt->bindParam(':moneda', $_POST['codmoneda']);
        $stmt->execute();
        
        return "success";
    } catch (PDOException $e) {
        // En caso de error, se registra y se devuelve un estado de fallo
        error_log("Error al registrar tipo de cambio: " . $e->getMessage());
        return "error";
    }
}
######################### FUNCION REGISTRAR TIPO DE CAMBIO ########################



########################### FUNCION LISTAR TIPO DE CAMBIO ########################
public function ListarTipoCambio() {
    self::SetNames();
    
    // Inicializar el array de resultados
    $this->p = array();

    try {
        $sql = "SELECT * FROM tiposcambio INNER JOIN tiposmoneda ON tiposcambio.codmoneda = tiposmoneda.codmoneda";
        
        foreach ($this->dbh->query($sql) as $row) {
            $this->p[] = $row;
        }

        // Devolver el array de resultados si todo es correcto
        return $this->p;
        
    } catch (PDOException $e) {
        // En caso de error, registrarlo y retornar false
        error_log("Error en ListarTipoCambio: " . $e->getMessage());
        return false;
    } finally {
        // Asegurarse de cerrar la conexión de la base de datos
        $this->dbh = null;
    }
}
######################### FUNCION LISTAR TIPO DE CAMBIO ################################

######################## FUNCION ID TIPO DE CAMBIO #################################
public function TipoCambioPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM tiposcambio INNER JOIN tiposmoneda ON tiposcambio.codmoneda = tiposmoneda.codmoneda WHERE tiposcambio.codcambio = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcambio"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID TIPO DE CAMBIO #################################

####################### FUNCION ACTUALIZAR TIPO DE CAMBIO ############################
public function ActualizarTipoCambio()
{
	self::SetNames();
	if(empty($_POST["codcambio"])or empty($_POST["descripcioncambio"]) or empty($_POST["montocambio"]) or empty($_POST["codmoneda"]) or empty($_POST["fechacambio"]))
	{
		echo "1";
		exit;
	}
			
		$sql = "SELECT codmoneda, fechacambio FROM tiposcambio WHERE codcambio != ? AND codmoneda = ? AND fechacambio = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codcambio"],$_POST["codmoneda"],date("Y-m-d",strtotime($_POST['fechacambio']))));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$sql = "UPDATE tiposcambio set "
			." descripcioncambio = ?, "
			." montocambio = ?, "
			." codmoneda = ?, "
			." fechacambio = ? "
			." WHERE "
			." codcambio = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $descripcioncambio);
			$stmt->bindParam(2, $montocambio);
			$stmt->bindParam(3, $codmoneda);
			$stmt->bindParam(4, $fechacambio);
			$stmt->bindParam(5, $codcambio);

			$descripcioncambio = limpiar($_POST["descripcioncambio"]);
			$montocambio = number_format($_POST["montocambio"], 3, '.', '');
			$codmoneda = limpiar($_POST["codmoneda"]);
			$fechacambio = limpiar(date("Y-m-d",strtotime($_POST['fechacambio'])));
			$codcambio = limpiar($_POST["codcambio"]);
			$stmt->execute();

			echo "<span class='fa fa-check-square-o'></span> EL TIPO DE CAMBIO HA SIDO ACTUALIZADO EXITOSAMENTE";
			exit;

			} else {

			echo "2";
			exit;
	    }
}
###################### FUNCION ACTUALIZAR TIPO DE CAMBIO ############################

########################## FUNCION ELIMINAR TIPO DE CAMBIO ###########################
public function EliminarTipoCambio()
{
	self::SetNames();
		if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

		    $sql = "DELETE FROM tiposcambio WHERE codcambio = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1,$codcambio);
			$codcambio = decrypt($_GET["codcambio"]);
			$stmt->execute();

			echo "1";
			exit;

		} else {
		   
			echo "2";
			exit;
		} 
}
########################### FUNCION ELIMINAR TIPO DE CAMBIO ###########################

######################## FUNCION BUSCAR PRODUCTOS POR MONEDA ###########################
public function MonedaProductoId()
{
	self::SetNames();
	if($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT 
	sucursales.codmoneda, 
	tiposmoneda.moneda, 
	tiposmoneda.siglas, 
	tiposmoneda.simbolo, 
	tiposcambio.montocambio 
	FROM tiposmoneda 
	INNER JOIN sucursales ON tiposmoneda.codmoneda = sucursales.codmoneda
	INNER JOIN tiposcambio ON tiposmoneda.codmoneda = tiposcambio.codmoneda 
	WHERE sucursales.codsucursal = ? ORDER BY tiposcambio.codcambio DESC LIMIT 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	   }

	} else {

	$sql = "SELECT 
	sucursales.codmoneda, 
	tiposmoneda.moneda, 
	tiposmoneda.siglas, 
	tiposmoneda.simbolo, 
	tiposcambio.montocambio 
	FROM sucursales 
	INNER JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	INNER JOIN tiposcambio ON tiposmoneda.codmoneda = tiposcambio.codmoneda 
	WHERE sucursales.codsucursal = ? 
	ORDER BY tiposcambio.codcambio 
	DESC LIMIT 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codsucursal"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	   }
	}
}
###################### FUNCION BUSCAR PRODUCTOS POR MONEDA ##########################

############################ FIN DE CLASE TIPOS DE CAMBIOS #############################


























############################### CLASE IMPUESTOS ####################################

############################ FUNCION REGISTRAR IMPUESTOS ###############################
public function RegistrarImpuestos()
{
	self::SetNames();
	if(empty($_POST["nomimpuesto"]) or empty($_POST["valorimpuesto"]) or empty($_POST["statusimpuesto"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT statusimpuesto FROM impuestos WHERE nomimpuesto != ? 
	AND statusimpuesto = ? 
	AND statusimpuesto = 'ACTIVO'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomimpuesto"],$_POST["statusimpuesto"]));
	$num = $stmt->rowCount();
	if($num>0)
	{
		echo "2";
		exit;
	}
	else
	{

	$sql = "SELECT nomimpuesto FROM impuestos WHERE nomimpuesto = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomimpuesto"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO impuestos values (null, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomimpuesto);
		$stmt->bindParam(2, $valorimpuesto);
		$stmt->bindParam(3, $statusimpuesto);
		$stmt->bindParam(4, $fechaimpuesto);

		$nomimpuesto = limpiar($_POST["nomimpuesto"]);
		$valorimpuesto = limpiar($_POST["valorimpuesto"]);
		$statusimpuesto = limpiar($_POST["statusimpuesto"]);
		$fechaimpuesto = limpiar(date("Y-m-d",strtotime($_POST['fechaimpuesto'])));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL IMPUESTO HA SIDO REGISTRADO  EXITOSAMENTE";
			exit;

			} else {

			echo "3";
			exit;
	    }
	}
}
############################ FUNCION REGISTRAR IMPUESTOS ###############################

############################# FUNCION LISTAR IMPUESTOS ################################
public function ListarImpuestos()
{
	self::SetNames();
	$sql = "SELECT * FROM impuestos";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
############################# FUNCION LISTAR IMPUESTOS ################################

############################ FUNCION ID IMPUESTOS #################################
public function ImpuestosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM impuestos WHERE statusimpuesto = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array("ACTIVO"));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
}
############################ FUNCION ID IMPUESTOS #################################

############################ FUNCION ID IMPUESTOS #################################
public function BusquedaImpuestosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM impuestos WHERE codimpuesto = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["impuesto"])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
}
############################ FUNCION ID IMPUESTOS #################################

############################ FUNCION ACTUALIZAR IMPUESTOS ############################
public function ActualizarImpuestos()
{
	self::SetNames();
	if(empty($_POST["codimpuesto"]) or empty($_POST["nomimpuesto"]) or empty($_POST["valorimpuesto"]) or empty($_POST["statusimpuesto"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT statusimpuesto FROM impuestos WHERE codimpuesto != ? AND statusimpuesto = ? AND statusimpuesto = 'ACTIVO'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codimpuesto"],$_POST["statusimpuesto"]));
	$num = $stmt->rowCount();
	if($num>0)
	{
		echo "2";
		exit;
	}
	else
	{

	$sql = "SELECT nomimpuesto FROM impuestos WHERE codimpuesto != ? AND nomimpuesto = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codimpuesto"],$_POST["nomimpuesto"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE impuestos set "
		." nomimpuesto = ?, "
		." valorimpuesto = ?, "
		." statusimpuesto = ? "
		." WHERE "
		." codimpuesto = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomimpuesto);
		$stmt->bindParam(2, $valorimpuesto);
		$stmt->bindParam(3, $statusimpuesto);
		$stmt->bindParam(4, $codimpuesto);

		$nomimpuesto = limpiar($_POST["nomimpuesto"]);
		$valorimpuesto = limpiar($_POST["valorimpuesto"]);
		$statusimpuesto = limpiar($_POST["statusimpuesto"]);
		$codimpuesto = limpiar($_POST["codimpuesto"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL IMPUESTO HA SIDO ACTUALIZADO EXITOSAMENTE";
			exit;

			} else {

			echo "3";
			exit;
		}
	}
}
############################ FUNCION ACTUALIZAR IMPUESTOS ############################

######################### FUNCION ELIMINAR IMPUESTOS #########################
public function EliminarImpuestos()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT * FROM impuestos WHERE codimpuesto = ? AND statusimpuesto = 'ACTIVO'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codimpuesto"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM impuestos WHERE codimpuesto = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codimpuesto);
		$codimpuesto = decrypt($_GET["codimpuesto"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
######################## FUNCION ELIMINAR IMPUESTOS ###########################

############################ FIN DE CLASE IMPUESTOS ################################






















############################# CLASE SUCURSALES ##################################

############################ FUNCION REGISTRAR SUCURSALES ##########################
public function RegistrarSucursales()
{
	self::SetNames();
	if(empty($_POST["nrosucursal"]) or empty($_POST["cuitsucursal"]) or empty($_POST["nomsucursal"]) or empty($_POST["direcsucursal"]) or empty($_POST["correosucursal"]) or empty($_POST["nroactividadsucursal"]) or empty($_POST["inicioticket"]) or empty($_POST["inicioboleta"]) or empty($_POST["iniciofactura"]) or empty($_POST["inicionotacredito"]) or empty($_POST["dniencargado"]) or empty($_POST["nomencargado"]) or empty($_POST["codmoneda"]))
	{
		echo "1";
		exit;
	}

	$sql = " SELECT correosucursal FROM sucursales WHERE correosucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["correosucursal"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{

		echo "2";
		exit;
	}
	else
	{
	$sql = " SELECT cuitsucursal FROM sucursales WHERE cuitsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["cuitsucursal"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	$query = " INSERT INTO sucursales values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $nrosucursal);
	$stmt->bindParam(2, $documsucursal);
	$stmt->bindParam(3, $cuitsucursal);
	$stmt->bindParam(4, $nomsucursal);
    $stmt->bindParam(5, $codgiro);
    $stmt->bindParam(6, $girosucursal);
	$stmt->bindParam(7, $id_provincia);
	$stmt->bindParam(8, $id_departamento);
	$stmt->bindParam(9, $direcsucursal);
	$stmt->bindParam(10, $correosucursal);
	$stmt->bindParam(11, $tlfsucursal);
	$stmt->bindParam(12, $nroactividadsucursal);
	$stmt->bindParam(13, $inicioticket);
	$stmt->bindParam(14, $inicioboleta);
	$stmt->bindParam(15, $iniciofactura);
	$stmt->bindParam(16, $inicionotacredito);
	$stmt->bindParam(17, $fechaautorsucursal);
	$stmt->bindParam(18, $llevacontabilidad);
	$stmt->bindParam(19, $documencargado);
	$stmt->bindParam(20, $dniencargado);
	$stmt->bindParam(21, $nomencargado);
	$stmt->bindParam(22, $tlfencargado);
	$stmt->bindParam(23, $descsucursal);
	$stmt->bindParam(24, $codmoneda);
	$stmt->bindParam(25, $codmoneda2);

	$nrosucursal = limpiar($_POST["nrosucursal"]);
	$documsucursal = limpiar($_POST['documsucursal'] == '' ? "0" : $_POST['documsucursal']);
	$cuitsucursal = limpiar($_POST["cuitsucursal"]);
	$nomsucursal = limpiar($_POST["nomsucursal"]);
	$codgiro = limpiar($_POST['codgiro'] == '' ? "0" : $_POST['codgiro']);
	$girosucursal = limpiar($_POST['girosucursal'] == '' ? "0" : $_POST['girosucursal']);
	$id_provincia = limpiar($_POST['id_provincia']);
	$id_departamento = limpiar($_POST['id_departamento']);
	$direcsucursal = limpiar($_POST["direcsucursal"]);
	$correosucursal = limpiar($_POST["correosucursal"]);
	$tlfsucursal = limpiar($_POST["tlfsucursal"]);
	$nroactividadsucursal = limpiar($_POST["nroactividadsucursal"]);
	$inicioticket = limpiar($_POST["inicioticket"]);
	$inicioboleta = limpiar($_POST["inicioboleta"]);
	$iniciofactura = limpiar($_POST["iniciofactura"]);
	$inicionotacredito = limpiar($_POST["inicionotacredito"]);
	$fechaautorsucursal = limpiar($_POST['fechaautorsucursal'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaautorsucursal'])));
	$llevacontabilidad = limpiar($_POST['llevacontabilidad'] == '' ? "NO" : $_POST['llevacontabilidad']);
	$documencargado = limpiar($_POST['documencargado'] == '' ? "0" : $_POST['documencargado']);
	$dniencargado = limpiar($_POST["dniencargado"]);
	$nomencargado = limpiar($_POST["nomencargado"]);
	$tlfencargado = limpiar($_POST["tlfencargado"]);
	$descsucursal = limpiar($_POST["descsucursal"]);
	$codmoneda = limpiar($_POST["codmoneda"]);
	$codmoneda2 = limpiar($_POST["codmoneda2"]);
	$stmt->execute();

	##################  SUBIR LOGO DE SUCURSAL ######################################
	//datos del arhivo  
	if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo = ''; }
    if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo = ''; }
	if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo = ''; }  
	//compruebo si las características del archivo son las que deseo  
    if ((strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<200000) {  
		if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/sucursales/".$nombre_archivo) && rename("fotos/sucursales/".$nombre_archivo,"fotos/sucursales/".$_POST["cuitsucursal"].".png"))
		{ 
	## se puede dar un aviso
		} 
	## se puede dar otro aviso 
	}
	##################  FINALIZA SUBIR LOGO DE SUCURSAL ##################

			echo "<span class='fa fa-check-square-o'></span> LA SUCURSAL HA SIDO REGISTRADA EXITOSAMENTE";
			exit;
		}
		else
		{
			echo "3";
			exit;
	    }
	}
}
######################### FUNCION REGISTRAR SUCURSALES ###############################

######################## FUNCION LISTAR SUCURSALES ###############################
public function ListarSucursales()
{
	self::SetNames();
	$sql = "SELECT 
	sucursales.codsucursal,
	sucursales.nrosucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.nroactividadsucursal,
	sucursales.inicioticket,
	sucursales.inicioboleta,
	sucursales.iniciofactura,
	sucursales.inicionotacredito,
	sucursales.fechaautorsucursal,
	sucursales.llevacontabilidad,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.descsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda2.moneda AS moneda2,
	provincias.provincia,
	departamentos.departamento 
	FROM sucursales 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;	
 }
########################## FUNCION LISTAR SUCURSALES ##########################

######################## FUNCION LISTAR SUCURSALES DIFERENTES A SESSION ###############################
public function ListarSucursalesDiferentes()
{
	self::SetNames();
	$sql = "SELECT 
	sucursales.codsucursal,
	sucursales.nrosucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.nroactividadsucursal,
	sucursales.inicioticket,
	sucursales.inicioboleta,
	sucursales.iniciofactura,
	sucursales.inicionotacredito,
	sucursales.fechaautorsucursal,
	sucursales.llevacontabilidad,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.descsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda2.moneda AS moneda2,
	provincias.provincia,
	departamentos.departamento
	FROM sucursales 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	WHERE sucursales.codsucursal != '".limpiar($_SESSION["codsucursal"])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
########################## FUNCION LISTAR SUCURSALES DIFERENTES A SESSION ########################## 

############################ FUNCION ID SUCURSALES #################################
public function SucursalesPorId()
{
	self::SetNames();
	$sql = "SELECT 
	sucursales.codsucursal,
	sucursales.nrosucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.nroactividadsucursal,
	sucursales.inicioticket,
	sucursales.inicioboleta,
	sucursales.iniciofactura,
	sucursales.inicionotacredito,
	sucursales.fechaautorsucursal,
	sucursales.llevacontabilidad,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.descsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	provincias.provincia,
	departamentos.departamento
	FROM sucursales 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento 
	WHERE sucursales.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID SUCURSALES #################################

############################ FUNCION ACTUALIZAR SUCURSALES ############################
public function ActualizarSucursales()
{
	self::SetNames();
	if(empty($_POST["codsucursal"]) or empty($_POST["nrosucursal"]) or empty($_POST["cuitsucursal"]) or empty($_POST["nomsucursal"]) or empty($_POST["direcsucursal"]) or empty($_POST["correosucursal"]) or empty($_POST["nroactividadsucursal"]) or empty($_POST["inicioticket"]) or empty($_POST["inicioboleta"]) or empty($_POST["iniciofactura"]) or empty($_POST["inicionotacredito"]) or empty($_POST["dniencargado"]) or empty($_POST["nomencargado"]) or empty($_POST["codmoneda"]))
	{
		echo "1";
		exit;
	}

	$sql = " SELECT correosucursal FROM sucursales WHERE codsucursal != ? AND correosucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codsucursal"],$_POST["correosucursal"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "2";
		exit;
	}
	else
	{
	$sql = " SELECT cuitsucursal FROM sucursales WHERE codsucursal != ? AND cuitsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codsucursal"],$_POST["cuitsucursal"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE sucursales set "
		." nrosucursal = ?, "
		." documsucursal = ?, "
		." cuitsucursal = ?, "
		." nomsucursal = ?, "
	    ." codgiro = ?, "
	    ." girosucursal = ?, "
		." id_provincia = ?, "
		." id_departamento = ?, "
		." direcsucursal = ?, "
		." correosucursal = ?, "
		." tlfsucursal = ?, "
		." nroactividadsucursal = ?, "
		." inicioticket = ?, "
		." inicioboleta = ?, "
		." iniciofactura = ?, "
		." inicionotacredito = ?, "
		." fechaautorsucursal = ?, "
		." llevacontabilidad = ?, "
		." documencargado = ?, "
		." dniencargado = ?, "
		." nomencargado = ?, "
		." tlfencargado = ?, "
		." descsucursal = ?, "
		." codmoneda = ?, "
		." codmoneda2 = ? "
		." where "
		." codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nrosucursal);
		$stmt->bindParam(2, $documsucursal);
		$stmt->bindParam(3, $cuitsucursal);
		$stmt->bindParam(4, $nomsucursal);
	    $stmt->bindParam(5, $codgiro);
	    $stmt->bindParam(6, $girosucursal);
		$stmt->bindParam(7, $id_provincia);
		$stmt->bindParam(8, $id_departamento);
		$stmt->bindParam(9, $direcsucursal);
		$stmt->bindParam(10, $correosucursal);
		$stmt->bindParam(11, $tlfsucursal);
		$stmt->bindParam(12, $nroactividadsucursal);
		$stmt->bindParam(13, $inicioticket);
		$stmt->bindParam(14, $inicioboleta);
		$stmt->bindParam(15, $iniciofactura);
		$stmt->bindParam(16, $inicionotacredito);
		$stmt->bindParam(17, $fechaautorsucursal);
		$stmt->bindParam(18, $llevacontabilidad);
		$stmt->bindParam(19, $documencargado);
		$stmt->bindParam(20, $dniencargado);
		$stmt->bindParam(21, $nomencargado);
		$stmt->bindParam(22, $tlfencargado);
		$stmt->bindParam(23, $descsucursal);
		$stmt->bindParam(24, $codmoneda);
		$stmt->bindParam(25, $codmoneda2);
		$stmt->bindParam(26, $codsucursal);

		$nrosucursal = limpiar($_POST["nrosucursal"]);
		$documsucursal = limpiar($_POST['documsucursal'] == '' ? "0" : $_POST['documsucursal']);
		$cuitsucursal = limpiar($_POST["cuitsucursal"]);
		$nomsucursal = limpiar($_POST["nomsucursal"]);
	    $codgiro = limpiar($_POST['codgiro'] == '' ? "0" : $_POST['codgiro']);
	    $girosucursal = limpiar($_POST['girosucursal'] == '' ? "0" : $_POST['girosucursal']);
		$id_departamento = limpiar($_POST['id_departamento']);
		$id_provincia = limpiar($_POST['id_provincia']);
		$direcsucursal = limpiar($_POST["direcsucursal"]);
		$correosucursal = limpiar($_POST["correosucursal"]);
		$tlfsucursal = limpiar($_POST["tlfsucursal"]);
		$nroactividadsucursal = limpiar($_POST["nroactividadsucursal"]);
	    $inicioticket = limpiar($_POST["inicioticket"]);
		$inicioboleta = limpiar($_POST["inicioboleta"]);
		$iniciofactura = limpiar($_POST["iniciofactura"]);
		$inicionotacredito = limpiar($_POST["inicionotacredito"]);
		$fechaautorsucursal = limpiar($_POST['fechaautorsucursal'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaautorsucursal'])));
	    $llevacontabilidad = limpiar($_POST['llevacontabilidad'] == '' ? "NO" : $_POST['llevacontabilidad']);
		$documencargado = limpiar($_POST['documencargado'] == '' ? "0" : $_POST['documencargado']);
		$dniencargado = limpiar($_POST["dniencargado"]);
		$nomencargado = limpiar($_POST["nomencargado"]);
		$tlfencargado = limpiar($_POST["tlfencargado"]);
		$descsucursal = limpiar($_POST["descsucursal"]);
		$codmoneda = limpiar($_POST["codmoneda"]);
		$codmoneda2 = limpiar($_POST["codmoneda2"]);
		$codsucursal = limpiar($_POST["codsucursal"]);
		$stmt->execute();

		##################  SUBIR LOGO DE SUCURSAL ######################################
		//datos del arhivo  
		if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo = ''; }
	    if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo = ''; }
		if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo = ''; }  
		//compruebo si las características del archivo son las que deseo  
	    if ((strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<200000) {  
			if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/sucursales/".$nombre_archivo) && rename("fotos/sucursales/".$nombre_archivo,"fotos/sucursales/".$_POST["cuitsucursal"].".png"))
			{ 
		## se puede dar un aviso
			} 
		## se puede dar otro aviso 
		}
		##################  FINALIZA SUBIR LOGO DE SUCURSAL ##################

			echo "<span class='fa fa-check-square-o'></span> LA SUCURSAL HA SIDO ACTUALIZADA EXITOSAMENTE";
			exit;

		}
		else
		{
			echo "3";
			exit;
		}
	}
}
############################ FUNCION ACTUALIZAR SUCURSALES ############################

########################## FUNCION ELIMINAR SUCURSALES ########################
public function EliminarSucursales()
{
	self::SetNames();
	if($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT codsucursal FROM productos WHERE codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM sucursales WHERE codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codsucursal);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################ FUNCION ELIMINAR SUCURSALES #######################

####################### FUNCION LISTAR SUCURSALES DIFERENTES ######################
public function BuscarSucursalesDiferentes() 
{
	self::SetNames();
	$sql = "SELECT * FROM sucursales WHERE codsucursal != ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	    if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
####################### FUNCION LISTAR SUCURSALES DIFERENTES #########################

############################# FIN DE CLASE SUCURSALES ################################




















#################################### CLASE SALAS ##################################

############################# FUNCION REGISTRAR SALAS ############################
public function RegistrarSalas()
{
	self::SetNames();
	if(empty($_POST["nomsala"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT nomsala FROM salas WHERE nomsala = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomsala"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO salas values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomsala);
		$stmt->bindParam(2, $fecha);
		$stmt->bindParam(3, $codsucursal);

		$nomsala = limpiar($_POST["nomsala"]);
        $fecha = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA SALA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
    }
}
############################# FUNCION REGISTRAR SALAS ##############################

############################# FUNCION LISTAR SALAS #############################
public function ListarSalas()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT * FROM salas LEFT JOIN sucursales ON salas.codsucursal = sucursales.codsucursal";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

	$sql = "SELECT * FROM salas LEFT JOIN sucursales ON salas.codsucursal = sucursales.codsucursal
	WHERE salas.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
 }
############################## FUNCION LISTAR SALAS #############################

############################ FUNCION ID SALAS #################################
public function SalasPorId()
{
	self::SetNames();
	$sql = "SELECT 
	salas.codsala, 
	salas.nomsala, 
	salas.fecha, 
	mesas.codmesa, 
	mesas.nommesa, 
	mesas.fecha, 
	mesas.statusmesa 
	FROM salas 
	LEFT JOIN sucursales ON salas.codsucursal = sucursales.codsucursal
	LEFT JOIN mesas ON salas.codsala = mesas.codsala
	WHERE salas.codsala = ? AND salas.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsala"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID SALAS #################################

############################ FUNCION ACTUALIZAR SALAS ############################
public function ActualizarSalas()
{

	self::SetNames();
	if(empty($_POST["codsala"]) or empty($_POST["nomsala"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

		$sql = "SELECT nomsala FROM salas WHERE codsala != ? AND nomsala = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codsala"],$_POST["nomsala"],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$sql = " UPDATE salas set "
			." nomsala = ?, "
			." codsucursal = ? "
			." WHERE "
			." codsala = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $nomsala);
			$stmt->bindParam(2, $codsucursal);
			$stmt->bindParam(3, $codsala);

			$nomsala = limpiar($_POST["nomsala"]);
			$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$codsala = limpiar($_POST["codsala"]);
			$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA SALA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR SALAS ############################

############################ FUNCION ELIMINAR SALAS ############################
public function EliminarSalas()
{
	self::SetNames();

	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

		$sql = "SELECT * FROM mesas WHERE codsala = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["codsala"])));
		$num = $stmt->rowCount();
		if($num == 0)
		{

			$sql = "DELETE FROM salas WHERE codsala = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1,$codsala);
			$stmt->bindParam(2,$codsucursal);
			$codsala = decrypt($_GET["codsala"]);
			$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			$stmt->execute();

			echo "1";
			exit;

		} else {
		   
			echo "2";
			exit;
		  } 
			
		} else {
		
		echo "3";
		exit;
	 }	
}
############################# FUNCION ELIMINAR SALAS #############################

####################### FUNCION LISTAR SALAS POR SUCURSALES ######################
public function BuscarSalasxSucursales() 
{
	self::SetNames();
	$sql = "SELECT * FROM salas WHERE codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	    if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
####################### FUNCION LISTAR SALAS POR SUCURSALES #########################

################################ FIN DE CLASE SALAS ###############################






















#################################### CLASE MESAS ##################################

############################# FUNCION REGISTRAR MESAS ############################
public function RegistrarMesas()
{
	self::SetNames();
	if(empty($_POST["codsala"]) or empty($_POST["nommesa"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT codsala, nommesa FROM mesas WHERE codsala = ? and nommesa = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codsala"]), $_POST["nommesa"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO mesas values (null, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codsala);
		$stmt->bindParam(2, $nommesa);
		$stmt->bindParam(3, $puestos);
		$stmt->bindParam(4, $fecha);
        $stmt->bindParam(5, $statusmesa);

		$codsala = limpiar(decrypt($_POST["codsala"]));
		$nommesa = limpiar($_POST["nommesa"]);
		$puestos = limpiar($_POST["puestos"]);
        $fecha = limpiar(date("Y-m-d"));
        $statusmesa = limpiar("0");
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA MESA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

		} else {

		echo "2";
		exit;
    }
}
############################# FUNCION REGISTRAR MESAS ##############################

############################# FUNCION LISTAR MESAS #############################
public function ListarMesas()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT 
	salas.codsala, 
	salas.nomsala, 
	salas.fecha,
	salas.codsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal, 
	mesas.codmesa, 
	mesas.nommesa, 
	mesas.puestos, 
	mesas.fecha, 
	mesas.statusmesa,
	SUM(pag.totalpago) as total_deudas 
	FROM mesas 
	LEFT JOIN salas ON mesas.codsala = salas.codsala 
	LEFT JOIN sucursales ON salas.codsucursal = sucursales.codsucursal

	LEFT JOIN
        (SELECT
        codmesa, totalpago     
        FROM pedidos WHERE statuspedido = 1) pag ON pag.codmesa = mesas.codmesa

	GROUP BY mesas.codmesa
	ORDER BY mesas.nommesa ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

	$sql = "SELECT 
	salas.codsala, 
	salas.nomsala, 
	salas.fecha,
	salas.codsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal, 
	mesas.codmesa, 
	mesas.nommesa, 
	mesas.puestos, 
	mesas.fecha, 
	mesas.statusmesa,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	SUM(pag.totalpago) as total_deudas 
	FROM mesas 
	LEFT JOIN salas ON mesas.codsala = salas.codsala 
	LEFT JOIN sucursales ON salas.codsucursal = sucursales.codsucursal
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda

	LEFT JOIN
    (SELECT
    codmesa, totalpago     
    FROM pedidos WHERE codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
    AND statuspedido = 1) pag ON pag.codmesa = mesas.codmesa

	WHERE salas.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	GROUP BY mesas.codmesa
	ORDER BY mesas.nommesa ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
############################## FUNCION LISTAR MESAS #############################

############################ FUNCION ID MESAS #################################
public function MesasPorId()
{
	self::SetNames();
	$sql = "SELECT 
	salas.codsala, 
	salas.nomsala, 
	salas.fecha, 
	mesas.codmesa, 
	mesas.nommesa, 
	mesas.puestos, 
	mesas.fecha, 
	mesas.statusmesa 
	FROM mesas 
	LEFT JOIN salas ON mesas.codsala = salas.codsala
	LEFT JOIN sucursales ON salas.codsucursal = sucursales.codsucursal 
	WHERE mesas.codmesa = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmesa"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID MESAS #################################

############################ FUNCION ACTUALIZAR MESAS ############################
public function ActualizarMesas()
{

	self::SetNames();
	if(empty($_POST["codmesa"]) or empty($_POST["codsala"]) or empty($_POST["nommesa"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT codsala, nommesa FROM mesas WHERE codmesa != ? AND codsala = ? AND nommesa = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codmesa"],decrypt($_POST["codsala"]),$_POST["nommesa"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE mesas set "
		." codsala = ?, "
		." nommesa = ?, "
		." puestos = ? "
		." WHERE "
		." codmesa = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codsala);
		$stmt->bindParam(2, $nommesa);
		$stmt->bindParam(3, $puestos);
		$stmt->bindParam(4, $codmesa);

		$codsala = limpiar(decrypt($_POST["codsala"]));
		$nommesa = limpiar($_POST["nommesa"]);
		$puestos = limpiar($_POST["puestos"]);
		$codmesa = limpiar($_POST["codmesa"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA MESA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

		} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR MESAS ############################

############################ FUNCION ELIMINAR MESAS ############################
public function EliminarMesas()
{
	self::SetNames();

	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codmesa FROM ventas WHERE codmesa = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmesa"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM mesas WHERE codmesa = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmesa);
		$codmesa = decrypt($_GET["codmesa"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################# FUNCION ELIMINAR MESAS #############################

####################### FUNCION BUSCAR MESAS POR SALAS ######################
public function BuscarMesas() 
{
	self::SetNames();
	$sql = "SELECT * FROM mesas WHERE codsala = ? AND statusmesa != 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsala"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
####################### FUNCION BUSCAR MESAS POR SALAS #########################

############################ FUNCION CAMBIAR MESAS ############################
public function CambiarMesas()
{
	self::SetNames();
	if(empty($_POST["codpedido"]) or empty($_POST["nuevasala"]) or empty($_POST["nuevamesa"]))
	{
		echo "1";
		exit;
	}

	############### ACTUALIZO MESA EN PEDIDOS ###############
	$sql = " UPDATE pedidos set "
	." codmesa = ? "
	." WHERE "
	." codpedido = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $nuevamesa);
	$stmt->bindParam(2, $codpedido);

	$nuevamesa = limpiar(decrypt($_POST["nuevamesa"]));
	$codpedido = limpiar(decrypt($_POST["codpedido"]));
	$stmt->execute();
    ############### ACTUALIZO MESA EN PEDIDOS ###############

    ############### ACTUALIZO MESA EN DETALLES PEDIDOS ###############
	$sql = " UPDATE detallepedidos set "
	." codmesa = ? "
	." WHERE "
	." codpedido = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $nuevamesa);
	$stmt->bindParam(2, $codpedido);

	$nuevamesa = limpiar(decrypt($_POST["nuevamesa"]));
	$codpedido = limpiar(decrypt($_POST["codpedido"]));
	$stmt->execute();
    ############### ACTUALIZO MESA EN DETALLES PEDIDOS ###############

    ############### ACTUALIZO STATUS A RESERVADA DE MESA ###############
	$sql = " UPDATE mesas set "
	." statusmesa = ? "
	." WHERE "
	." codmesa = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statusmesa);
	$stmt->bindParam(2, $nuevamesa);

	$statusmesa = limpiar("1");
	$nuevamesa = limpiar(decrypt($_POST["nuevamesa"]));
	$stmt->execute();
    ############### ACTUALIZO STATUS A RESERVADA DE MESA ###############

    ############### ACTUALIZO STATUS A DISPONIBLE DE MESA ###############
	$sql = " UPDATE mesas set "
	." statusmesa = ? "
	." WHERE "
	." codmesa = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statusmesa);
	$stmt->bindParam(2, $mesa_actual);

	$statusmesa = limpiar("0");
	$mesa_actual = limpiar(decrypt($_POST["mesa_actual"]));
	$stmt->execute();
    ############### ACTUALIZO STATUS A DISPONIBLE DE MESA ###############

	echo "<span class='fa fa-check-square-o'></span> LA MESA HA SIDO CAMBIADA EXITOSAMENTE";
	exit;
}
############################ FUNCION CAMBIAR MESAS ############################

################################ FIN DE CLASE MESAS ###############################























#################################### CLASE CATEGORIAS ##################################

############################# FUNCION REGISTRAR CATEGORIAS ############################
public function RegistrarCategorias()
{
	self::SetNames();
	if(empty($_POST["nomcategoria"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT nomcategoria FROM categorias WHERE nomcategoria = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomcategoria"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO categorias values (null, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomcategoria);

		$nomcategoria = limpiar($_POST["nomcategoria"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA CATEGORIA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
    }
}
############################# FUNCION REGISTRAR CATEGORIAS ##############################

############################# FUNCION LISTAR CATEGORIAS #############################
public function ListarCategorias()
{
	self::SetNames();
	$sql = "SELECT * FROM categorias ORDER BY nomcategoria ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
############################## FUNCION LISTAR CATEGORIAS #############################

############################ FUNCION ID CATEGORIAS #################################
public function CategoriasPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM categorias WHERE codcategoria = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcategoria"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID CATEGORIAS #################################

############################ FUNCION ACTUALIZAR CATEGORIAS ############################
public function ActualizarCategorias()
{
	self::SetNames();
	if(empty($_POST["codcategoria"]) or empty($_POST["nomcategoria"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT nomcategoria FROM categorias WHERE codcategoria != ? AND nomcategoria = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcategoria"],$_POST["nomcategoria"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE categorias set "
		." nomcategoria = ? "
		." WHERE "
		." codcategoria = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomcategoria);
		$stmt->bindParam(2, $codcategoria);

		$nomcategoria = limpiar($_POST["nomcategoria"]);
		$codcategoria = limpiar($_POST["codcategoria"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA CATEGORIA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
    }
}
############################ FUNCION ACTUALIZAR CATEGORIAS ############################

############################ FUNCION ELIMINAR CATEGORIAS ############################
public function EliminarCategorias()
{
	self::SetNames();

	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codcategoria FROM productos WHERE codcategoria = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcategoria"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM categorias WHERE codcategoria = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcategoria);
		$codcategoria = decrypt($_GET["codcategoria"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################# FUNCION ELIMINAR CATEGORIAS #############################

################################ FIN DE CLASE CATEGORIAS ###############################

























#################################### CLASE MEDIDAS ##################################

############################# FUNCION REGISTRAR MEDIDAS ############################
public function RegistrarMedidas()
{
	self::SetNames();
	if(empty($_POST["nommedida"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT nommedida FROM medidas WHERE nommedida = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nommedida"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO medidas values (null, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nommedida);

		$nommedida = limpiar($_POST["nommedida"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA MEDIDA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################# FUNCION REGISTRAR MEDIDAS ##############################

############################# FUNCION LISTAR MEDIDAS #############################
public function ListarMedidas()
{
	self::SetNames();
	$sql = "SELECT * FROM medidas";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
############################## FUNCION LISTAR MEDIDAS #############################

############################ FUNCION ID MEDIDAS #################################
public function MedidasPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM medidas WHERE codmedida = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmedida"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID MEDIDAS #################################

############################ FUNCION ACTUALIZAR MEDIDAS ############################
public function ActualizarMedidas()
{
	self::SetNames();
	if(empty($_POST["codmedida"]) or empty($_POST["nommedida"]))
	{
		echo "1";
		exit;
	}

		$sql = "SELECT nommedida FROM medidas WHERE codmedida != ? AND nommedida = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codmedida"],$_POST["nommedida"]));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$sql = " UPDATE medidas set "
			." nommedida = ? "
			." WHERE "
			." codmedida = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $nommedida);
			$stmt->bindParam(2, $codmedida);

			$nommedida = limpiar($_POST["nommedida"]);
			$codmedida = limpiar($_POST["codmedida"]);
			$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA MEDIDA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

		} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR MEDIDAS ############################

############################ FUNCION ELIMINAR MEDIDAS ############################
public function EliminarMedidas()
{
	self::SetNames();

	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codmedida FROM ingredientes WHERE codmedida = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmedida"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM medidas WHERE codmedida = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmedida);
		$codmedida = decrypt($_GET["codmedida"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################# FUNCION ELIMINAR MEDIDAS #############################

################################ FIN DE CLASE MEDIDAS ###############################























#################################### CLASE SALSAS ##################################

############################# FUNCION REGISTRAR SALSAS ############################
public function RegistrarSalsas()
{
	self::SetNames();
	if(empty($_POST["nomsalsa"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT codsalsa FROM salsas ORDER BY idsalsa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$id=$row["codsalsa"];

	}
	if(empty($id))
	{
		$codsalsa = "01";

	} else {

		$resto = substr($id, 0, 1);
		$coun = strlen($resto);
		$num     = substr($id, $coun);
		$codigo     = $num + 1;
		$codsalsa = "0".$codigo;
	}

	$sql = "SELECT nomsalsa FROM salsas WHERE nomsalsa = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomsalsa"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO salsas values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codsalsa);
		$stmt->bindParam(2, $nomsalsa);

		$nomsalsa = limpiar($_POST["nomsalsa"]);
		$stmt->execute();

		################## SUBIR FOTO DE SALSAS ########################
         //datos del arhivo  
		if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
		if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
		if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; }  
         //compruebo si las características del archivo son las que deseo  
		if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<50000) 
			{  
				if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/salsas/".$nombre_archivo) && rename("fotos/salsas/".$nombre_archivo,"fotos/salsas/".$codsalsa.".jpg"))
				{ 
		 ## se puede dar un aviso
				} 
		 ## se puede dar otro aviso 
		}
		################## FINALIZA SUBIR FOTO DE SALSAS ##################

		echo "<span class='fa fa-check-square-o'></span> LA SALSA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
    }
}
############################# FUNCION REGISTRAR SALSAS ##############################

############################# FUNCION LISTAR SALSAS #############################
public function ListarSalsas()
{
	self::SetNames();
	$sql = "SELECT * FROM salsas ORDER BY nomsalsa ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
 }
############################## FUNCION LISTAR SALSAS #############################

############################ FUNCION ID SALSAS #################################
public function SalsasPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM salsas WHERE codsalsa = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsalsa"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID SALSAS #################################

############################ FUNCION ACTUALIZAR SALSAS ############################
public function ActualizarSalsas()
{
	self::SetNames();
	if(empty($_POST["codsalsa"]) or empty($_POST["nomsalsa"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT nomsalsa FROM salsas WHERE codsalsa != ? AND nomsalsa = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codsalsa"],$_POST["nomsalsa"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE salsas set "
		." nomsalsa = ? "
		." WHERE "
		." codsalsa = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomsalsa);
		$stmt->bindParam(2, $codsalsa);

		$nomsalsa = limpiar($_POST["nomsalsa"]);
		$codsalsa = limpiar($_POST["codsalsa"]);
		$stmt->execute();

		################## SUBIR FOTO DE SALSAS ########################
         //datos del arhivo  
		if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
		if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
		if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; }  
         //compruebo si las características del archivo son las que deseo  
		if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<50000) 
			{  
				if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/salsas/".$nombre_archivo) && rename("fotos/salsas/".$nombre_archivo,"fotos/salsas/".$codsalsa.".jpg"))
				{ 
		 ## se puede dar un aviso
				} 
		 ## se puede dar otro aviso 
		}
		################## FINALIZA SUBIR FOTO DE SALSAS ##################

		echo "<span class='fa fa-check-square-o'></span> LA SALSA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
    }
}
############################ FUNCION ACTUALIZAR SALSAS ############################

############################ FUNCION ELIMINAR SALSAS ############################
public function EliminarSalsas()
{
	self::SetNames();

	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

		$sql = "DELETE FROM salsas WHERE codsalsa = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codsalsa);
		$codsalsa = decrypt($_GET["codsalsa"]);
		$stmt->execute();

		$codsalsa = decrypt($_GET["codsalsa"]);
		if (file_exists("fotos/salsas/".$codsalsa.".jpg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/salsas/".$codsalsa.".jpg";		
		unlink($archivos);
		}

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 	
}
############################# FUNCION ELIMINAR SALSAS #############################

################################ FIN DE CLASE SALSAS ###############################























################################## CLASE CLIENTES ##################################

############################### FUNCION CARGAR CLIENTES ##############################
public function CargarClientes()
{
	self::SetNames();
	if(empty($_FILES["sel_file"]))
	{
		echo "1";
		exit;
	}
    //Aquí es donde seleccionamos nuestro csv
     $fname = $_FILES['sel_file']['name'];
     //echo 'Cargando nombre del archivo: '.$fname.' ';
     $chk_ext = explode(".",$fname);
     
    if(strtolower(end($chk_ext)) == "csv")
    {
    //si es correcto, entonces damos permisos de lectura para subir
    $filename = $_FILES['sel_file']['tmp_name'];
    $handle = fopen($filename, "r");
    $this->dbh->beginTransaction();
    
    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {

    //Insertamos los datos con los valores...
		   
	$query = "INSERT INTO clientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcliente);
	$stmt->bindParam(2, $tipocliente);
	$stmt->bindParam(3, $documcliente);
	$stmt->bindParam(4, $dnicliente);
	$stmt->bindParam(5, $nomcliente);
	$stmt->bindParam(6, $razoncliente);
	$stmt->bindParam(7, $girocliente);
	$stmt->bindParam(8, $tlfcliente);
	$stmt->bindParam(9, $id_provincia);
	$stmt->bindParam(10, $id_departamento);
	$stmt->bindParam(11, $direccliente);
	$stmt->bindParam(12, $emailcliente);
	$stmt->bindParam(13, $limitecredito);
	$stmt->bindParam(14, $fechaingreso);
	
	$codcliente = limpiar($data[0]);
	$tipocliente = limpiar($data[1]);
	$documcliente = limpiar($data[2]);
	$dnicliente = limpiar($data[3]);
	$nomcliente = limpiar($data[4]);
	$razoncliente = limpiar($data[5]);
	$girocliente = limpiar($data[6]);
	$tlfcliente = limpiar($data[7]);
	$id_provincia = limpiar($data[8]);
	$id_departamento = limpiar($data[9]);
	$direccliente = limpiar($data[10]);
	$emailcliente = limpiar($data[11]);
	$limitecredito = limpiar($data[12]);
	$fechaingreso = limpiar(date("Y-m-d"));
	$stmt->execute();
				
    }
    $this->dbh->commit();
    //cerramos la lectura del archivo "abrir archivo" con un "cerrar archivo"
    fclose($handle);
	        
	   echo "<span class='fa fa-check-square-o'></span> LA CARGA MASIVA DE CLIENTES FUE REALIZADA EXITOSAMENTE";
	   exit;
             
    } else {
    //si aparece esto es posible que el archivo no tenga el formato adecuado, inclusive cuando es cvs, revisarlo para ver si esta separado por " , "
        echo "2";
		exit;
    }  
}
################################# FUNCION CARGAR CLIENTES ###############################

############################ FUNCION REGISTRAR CLIENTES ###############################
public function RegistrarClientes()
{
	self::SetNames();
	if(empty($_POST["tipocliente"]) or empty($_POST["dnicliente"]) or empty($_POST["direccliente"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT codcliente FROM clientes ORDER BY idcliente DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$id=$row["codcliente"];

	}
	if(empty($id))
	{
		$codcliente = "C1";

	} else {

		$resto = substr($id, 0, 1);
		$coun = strlen($resto);
		$num     = substr($id, $coun);
		$codigo     = $num + 1;
		$codcliente = "C".$codigo;
	}

	$sql = "SELECT dnicliente FROM clientes WHERE dnicliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["dnicliente"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO clientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $tipocliente);
	    $stmt->bindParam(3, $documcliente);
		$stmt->bindParam(4, $dnicliente);
		$stmt->bindParam(5, $nomcliente);
		$stmt->bindParam(6, $razoncliente);
		$stmt->bindParam(7, $girocliente);
		$stmt->bindParam(8, $tlfcliente);
		$stmt->bindParam(9, $id_provincia);
		$stmt->bindParam(10, $id_departamento);
		$stmt->bindParam(11, $direccliente);
		$stmt->bindParam(12, $emailcliente);
	    $stmt->bindParam(13, $limitecredito);
		$stmt->bindParam(14, $fechaingreso);
		
		$tipocliente = limpiar($_POST["tipocliente"]);
		$documcliente = limpiar($_POST["documcliente"]);
		$dnicliente = limpiar($_POST["dnicliente"]);
		$nomcliente = limpiar($_POST['tipocliente'] == 'JURIDICO' ? "" : $_POST["nomcliente"]);
		$razoncliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["razoncliente"]);
		$girocliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["girocliente"]);
		$tlfcliente = limpiar($_POST["tlfcliente"]);
		$id_provincia = limpiar($_POST['id_departamento'] == '' ? "0" : $_POST["id_provincia"]);
		$id_departamento = limpiar($_POST['id_departamento'] == '' ? "0" : $_POST["id_departamento"]);
		$direccliente = limpiar($_POST["direccliente"]);
		$emailcliente = limpiar($_POST["emailcliente"]);
		$limitecredito = limpiar($_POST["limitecredito"]);
	    $fechaingreso = limpiar(date("Y-m-d"));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL CLIENTE HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
######################## FUNCION REGISTRAR CLIENTES ###############################

########################## FUNCION BUSQUEDA DE CLIENTES ###############################
public function BusquedaClientes()
	{
	self::SetNames();
	 $sql = "SELECT
	clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	clientes.nomcliente,
	clientes.razoncliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	clientes.fechaingreso,
    documentos.documento,
	provincias.provincia,
	departamentos.departamento
	FROM clientes 
	LEFT JOIN documentos ON clientes.documcliente = documentos.coddocumento
	LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento WHERE CONCAT(dnicliente, ' ',nomcliente, ' ',razoncliente, ' ',direccliente, ' ',emailcliente) LIKE '%".limpiar($_GET['bclientes'])."%' LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0) {

	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON REGISTROS PARA TU BUSQUEDA</div></center>";
	exit;
		
	} else {
			
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################## FUNCION BUSQUEDA DE CLIENTES ###############################

############################ FUNCION LISTAR CLIENTES ################################
public function ListarClientes()
	{
	self::SetNames();
	$sql = "SELECT
	clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	clientes.fechaingreso,
    documentos.documento,
	provincias.provincia,
	departamentos.departamento
	FROM clientes 
	LEFT JOIN documentos ON clientes.documcliente = documentos.coddocumento
	LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
######################### FUNCION LISTAR CLIENTES ################################

######################### FUNCION ID CLIENTES #################################
public function ClientesPorId()
{
	self::SetNames();
	$sql = "SELECT
	clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	clientes.fechaingreso,
    documentos.documento,
	provincias.provincia,
	departamentos.departamento,
	COUNT(ventas.codcliente) as cantidad,
	SUM(ventas.totalpago) as totalcompras
	FROM clientes
	LEFT JOIN ventas ON clientes.codcliente = ventas.codcliente 
	LEFT JOIN documentos ON clientes.documcliente = documentos.coddocumento
	LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento WHERE clientes.codcliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcliente"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID CLIENTES #################################
	
############################ FUNCION ACTUALIZAR CLIENTES ############################
public function ActualizarClientes()
{
	
    self::SetNames();
	if(empty($_POST["codcliente"]) or empty($_POST["tipocliente"]) or empty($_POST["dnicliente"]) or empty($_POST["direccliente"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT dnicliente FROM clientes WHERE codcliente != ? AND dnicliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcliente"],$_POST["dnicliente"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE clientes set "
		." tipocliente = ?, "
		." documcliente = ?, "
		." dnicliente = ?, "
		." nomcliente = ?, "
		." razoncliente = ?, "
		." girocliente = ?, "
		." tlfcliente = ?, "
		." id_provincia = ?, "
		." id_departamento = ?, "
		." direccliente = ?, "
		." emailcliente = ?, "
		." limitecredito = ? "
		." WHERE "
		." codcliente = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $tipocliente);
	    $stmt->bindParam(2, $documcliente);
		$stmt->bindParam(3, $dnicliente);
		$stmt->bindParam(4, $nomcliente);
		$stmt->bindParam(5, $razoncliente);
		$stmt->bindParam(6, $girocliente);
		$stmt->bindParam(7, $tlfcliente);
		$stmt->bindParam(8, $id_provincia);
		$stmt->bindParam(9, $id_departamento);
		$stmt->bindParam(10, $direccliente);
		$stmt->bindParam(11, $emailcliente);
		$stmt->bindParam(12, $limitecredito);
		$stmt->bindParam(13, $codcliente);
		
		$tipocliente = limpiar($_POST["tipocliente"]);
		$documcliente = limpiar($_POST["documcliente"]);
		$dnicliente = limpiar($_POST["dnicliente"]);
		$nomcliente = limpiar($_POST['tipocliente'] == 'JURIDICO' ? "" : $_POST["nomcliente"]);
		$razoncliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["razoncliente"]);
		$girocliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["girocliente"]);
		$tlfcliente = limpiar($_POST["tlfcliente"]);
		$id_provincia = limpiar($_POST['id_departamento'] == '' ? "0" : $_POST["id_provincia"]);
		$id_departamento = limpiar($_POST['id_departamento'] == '' ? "0" : $_POST["id_departamento"]);
		$direccliente = limpiar($_POST["direccliente"]);
		$emailcliente = limpiar($_POST["emailcliente"]);
		$limitecredito = limpiar($_POST["limitecredito"]);
		$codcliente = limpiar($_POST["codcliente"]);
		$stmt->execute();
    
	echo "<span class='fa fa-check-square-o'></span> EL CLIENTE HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR CLIENTES ############################

########################### FUNCION ELIMINAR CLIENTES #################################
public function EliminarClientes()
	{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codcliente FROM ventas WHERE codcliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcliente"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM clientes where codcliente = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcliente);
		$codcliente = decrypt($_GET["codcliente"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR CLIENTES #################################

############################## FIN DE CLASE CLIENTES #################################


























################################## CLASE PROVEEDORES ###################################

########################## FUNCION CARGAR PROVEEDORES ###############################
public function CargarProveedores()
{
	self::SetNames();
	if(empty($_FILES["sel_file"]))
	{
		echo "1";
		exit;
	}
    //Aquí es donde seleccionamos nuestro csv
     $fname = $_FILES['sel_file']['name'];
     //echo 'Cargando nombre del archivo: '.$fname.' ';
     $chk_ext = explode(".",$fname);
     
    if(strtolower(end($chk_ext)) == "csv")
    {
    //si es correcto, entonces damos permisos de lectura para subir
    $filename = $_FILES['sel_file']['tmp_name'];
    $handle = fopen($filename, "r");
    $this->dbh->beginTransaction();
    
    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {

           //Insertamos los datos con los valores...
		   
	$query = "INSERT INTO proveedores values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproveedor);
	$stmt->bindParam(2, $documproveedor);
	$stmt->bindParam(3, $dniproveedor);
	$stmt->bindParam(4, $nomproveedor);
	$stmt->bindParam(5, $tlfproveedor);
	$stmt->bindParam(6, $id_provincia);
	$stmt->bindParam(7, $id_departamento);
	$stmt->bindParam(8, $direcproveedor);
	$stmt->bindParam(9, $emailproveedor);
	$stmt->bindParam(10, $vendedor);
	$stmt->bindParam(11, $tlfvendedor);
	$stmt->bindParam(12, $fechaingreso);

	$codproveedor = limpiar($data[0]);
	$documproveedor = limpiar($data[1]);
	$dniproveedor = limpiar($data[2]);
	$nomproveedor = limpiar($data[3]);
	$tlfproveedor = limpiar($data[4]);
	$id_provincia = limpiar($data[5]);
	$id_departamento = limpiar($data[6]);
	$direcproveedor = limpiar($data[7]);
	$emailproveedor = limpiar($data[8]);
	$vendedor = limpiar($data[9]);
	$tlfvendedor = limpiar($data[10]);
	$fechaingreso = limpiar(date("Y-m-d"));
	$stmt->execute();
			
    }
    $this->dbh->commit();
    //cerramos la lectura del archivo "abrir archivo" con un "cerrar archivo"
    fclose($handle);
	        
	    echo "<span class='fa fa-check-square-o'></span> LA CARGA MASIVA DE PROVEEDORES FUE REALIZADA EXITOSAMENTE";
	    exit;
             
    }
    else
    {
    //si aparece esto es posible que el archivo no tenga el formato adecuado, inclusive cuando es cvs, revisarlo para ver si esta separado por " , "
        echo "2";
		exit;
    }  
}
############################# FUNCION CARGAR PROVEEDORES ##############################

############################ FUNCION REGISTRAR PROVEEDORES ##########################
public function RegistrarProveedores()
{
	self::SetNames();
	if(empty($_POST["cuitproveedor"]) or empty($_POST["nomproveedor"]) or empty($_POST["direcproveedor"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT codproveedor FROM proveedores ORDER BY idproveedor DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$id=$row["codproveedor"];

	}
	if(empty($id))
	{
		$codproveedor = "P1";

	} else {

		$resto = substr($id, 0, 1);
		$coun = strlen($resto);
		$num     = substr($id, $coun);
		$codigo     = $num + 1;
		$codproveedor = "P".$codigo;
	}

	$sql = "SELECT cuitproveedor FROM proveedores WHERE cuitproveedor = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["cuitproveedor"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO proveedores values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproveedor);
	    $stmt->bindParam(2, $documproveedor);
		$stmt->bindParam(3, $cuitproveedor);
		$stmt->bindParam(4, $nomproveedor);
		$stmt->bindParam(5, $tlfproveedor);
		$stmt->bindParam(6, $id_provincia);
		$stmt->bindParam(7, $id_departamento);
		$stmt->bindParam(8, $direcproveedor);
		$stmt->bindParam(9, $emailproveedor);
		$stmt->bindParam(10, $vendedor);
		$stmt->bindParam(11, $tlfvendedor);
		$stmt->bindParam(12, $fechaingreso);
		
		$documproveedor = limpiar($_POST['documproveedor'] == '' ? "0" : $_POST['documproveedor']);
		$cuitproveedor = limpiar($_POST["cuitproveedor"]);
		$nomproveedor = limpiar($_POST["nomproveedor"]);
		$tlfproveedor = limpiar($_POST["tlfproveedor"]);
		$id_provincia = limpiar($_POST['id_provincia'] == '' ? "0" : $_POST['id_provincia']);
		$id_departamento = limpiar($_POST['id_departamento'] == '' ? "0" : $_POST['id_departamento']);
		$direcproveedor = limpiar($_POST["direcproveedor"]);
		$emailproveedor = limpiar($_POST["emailproveedor"]);
		$vendedor = limpiar($_POST["vendedor"]);
		$tlfvendedor = limpiar($_POST["tlfvendedor"]);
	    $fechaingreso = limpiar(date("Y-m-d"));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL PROVEEDOR HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
########################### FUNCION REGISTRAR PROVEEDORES ########################

########################### FUNCION LISTAR PROVEEDORES ################################
public function ListarProveedores()
{
	self::SetNames();
    $sql = "SELECT
	proveedores.codproveedor,
	proveedores.documproveedor,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	proveedores.tlfproveedor,
	proveedores.id_provincia,
	proveedores.id_departamento,
	proveedores.direcproveedor,
	proveedores.emailproveedor,
	proveedores.vendedor,
	proveedores.tlfvendedor,
	proveedores.fechaingreso,
    documentos.documento,
	provincias.provincia,
	departamentos.departamento
	FROM proveedores 
	LEFT JOIN documentos ON proveedores.documproveedor = documentos.coddocumento
	LEFT JOIN provincias ON proveedores.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON proveedores.id_departamento = departamentos.id_departamento";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################### FUNCION LISTAR PROVEEDORES ################################

########################### FUNCION ID PROVEEDORES #################################
public function ProveedoresPorId()
{
	self::SetNames();
	$sql = "SELECT
	proveedores.codproveedor,
	proveedores.documproveedor,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	proveedores.tlfproveedor,
	proveedores.id_provincia,
	proveedores.id_departamento,
	proveedores.direcproveedor,
	proveedores.emailproveedor,
	proveedores.vendedor,
	proveedores.tlfvendedor,
	proveedores.fechaingreso,
    documentos.documento,
	provincias.provincia,
	departamentos.departamento
	FROM proveedores 
	LEFT JOIN documentos ON proveedores.documproveedor = documentos.coddocumento
	LEFT JOIN provincias ON proveedores.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON proveedores.id_departamento = departamentos.id_departamento 
	WHERE proveedores.codproveedor = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproveedor"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID PROVEEDORES #################################
	
############################ FUNCION ACTUALIZAR PROVEEDORES ############################
public function ActualizarProveedores()
{
self::SetNames();
	if(empty($_POST["codproveedor"]) or empty($_POST["cuitproveedor"]) or empty($_POST["nomproveedor"]) or empty($_POST["direcproveedor"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT cuitproveedor FROM proveedores WHERE codproveedor != ? AND cuitproveedor = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codproveedor"],$_POST["cuitproveedor"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE proveedores set "
		." documproveedor = ?, "
		." cuitproveedor = ?, "
		." nomproveedor = ?, "
		." tlfproveedor = ?, "
		." id_provincia = ?, "
		." id_departamento = ?, "
		." direcproveedor = ?, "
		." emailproveedor = ?, "
		." vendedor = ?, "
		." tlfvendedor = ? "
		." WHERE "
		." codproveedor = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $documproveedor);
		$stmt->bindParam(2, $cuitproveedor);
		$stmt->bindParam(3, $nomproveedor);
		$stmt->bindParam(4, $tlfproveedor);
		$stmt->bindParam(5, $id_provincia);
		$stmt->bindParam(6, $id_departamento);
		$stmt->bindParam(7, $direcproveedor);
		$stmt->bindParam(8, $emailproveedor);
		$stmt->bindParam(9, $vendedor);
		$stmt->bindParam(10, $tlfvendedor);
		$stmt->bindParam(11, $codproveedor);
		
		$documproveedor = limpiar($_POST['documproveedor'] == '' ? "0" : $_POST['documproveedor']);
		$cuitproveedor = limpiar($_POST["cuitproveedor"]);
		$nomproveedor = limpiar($_POST["nomproveedor"]);
		$tlfproveedor = limpiar($_POST["tlfproveedor"]);
		$id_provincia = limpiar($_POST['id_provincia'] == '' ? "0" : $_POST['id_provincia']);
		$id_departamento = limpiar($_POST['id_departamento'] == '' ? "0" : $_POST['id_departamento']);
		$direcproveedor = limpiar($_POST["direcproveedor"]);
		$emailproveedor = limpiar($_POST["emailproveedor"]);
		$vendedor = limpiar($_POST["vendedor"]);
		$tlfvendedor = limpiar($_POST["tlfvendedor"]);
		$codproveedor = limpiar($_POST["codproveedor"]);
		$stmt->execute();
    
	echo "<span class='fa fa-check-square-o'></span> EL PROVEEDOR HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR PROVEEDORES ############################

########################## FUNCION ELIMINAR PROVEEDORES #################################
public function EliminarProveedores()
{
    self::SetNames();
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codproveedor FROM productos WHERE codproveedor = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproveedor"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM proveedores where codproveedor = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproveedor);
		$codproveedor = decrypt($_GET["codproveedor"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR PROVEEDORES #########################

############################## FIN DE CLASE PROVEEDORES #################################




























################################# CLASE INGREDIENTES ######################################

############################### FUNCION CARGAR INGREDIENTES ##############################
public function CargarIngredientes()
	{
	self::SetNames();
	if(empty($_FILES["sel_file"]))
	{
		echo "1";
		exit;
	}

	############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

        //Aquí es donde seleccionamos nuestro csv
         $fname = $_FILES['sel_file']['name'];
         //echo 'Cargando nombre del archivo: '.$fname.' ';
         $chk_ext = explode(".",$fname);
         
        if(strtolower(end($chk_ext)) == "csv")
        {
        //si es correcto, entonces damos permisos de lectura para subir
        $filename = $_FILES['sel_file']['tmp_name'];
        $handle = fopen($filename, "r");
        $this->dbh->beginTransaction();
        
        while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {

        //Insertamos los datos con los valores...
        $query = "INSERT INTO ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    	$stmt = $this->dbh->prepare($query);
    	$stmt->bindParam(1, $codingrediente);
    	$stmt->bindParam(2, $nomingrediente);
    	$stmt->bindParam(3, $codmedida);
    	$stmt->bindParam(4, $preciocompra);
    	$stmt->bindParam(5, $precioventa);
    	$stmt->bindParam(6, $cantingrediente);
    	$stmt->bindParam(7, $stockminimo);
    	$stmt->bindParam(8, $stockmaximo);
    	$stmt->bindParam(9, $ivaingrediente);
    	$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $lote);
    	$stmt->bindParam(12, $fechaexpiracion);
    	$stmt->bindParam(13, $codproveedor);
    	$stmt->bindParam(14, $preparado);
    	$stmt->bindParam(15, $favorito);
    	$stmt->bindParam(16, $controlstocki);
    	$stmt->bindParam(17, $codsucursal);

    	$codingrediente = limpiar($data[0]);
    	$nomingrediente = limpiar($data[1]);
    	$codmedida = limpiar($data[2]);
    	$preciocompra = limpiar($data[3]);
    	$precioventa = limpiar($data[4]);
    	$cantingrediente = limpiar($data[5]);
    	$stockminimo = limpiar($data[6]);
    	$stockmaximo = limpiar($data[7]);
    	$ivaingrediente = limpiar($data[8]);
    	$descingrediente = limpiar($data[9]);
    	$lote = limpiar($data[10]);
    	$fechaexpiracion = limpiar($data[11]);
    	$codproveedor = limpiar($data[12]);
    	$preparado = limpiar($data[13]);
    	$favorito = limpiar($data[14]);
    	$controlstocki = limpiar($data[15]);
    	$codsucursal = limpiar($_SESSION["codsucursal"]);
    	$stmt->execute();

        ##################### REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX #####################
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproceso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codingrediente);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
    	$stmt->bindParam(14, $codsucursal);
		
		$codproceso = limpiar($data[0]);
		$codresponsable = limpiar("0");
		$codproducto = limpiar($data[0]);
		$movimiento = limpiar("ENTRADAS");
		$entradas = limpiar($data[5]);
		$salidas = limpiar("0.00");
		$devolucion = limpiar("0.00");
		$stockactual = limpiar($data[5]);
		$ivaingrediente = limpiar($data[8] == 'SI' ? $valor : "0.00");
		$descingrediente = limpiar($data[9]);
    	$precio = limpiar($data[4]);
		$documento = limpiar("INVENTARIO INICIAL");
		$fechakardex = limpiar(date("Y-m-d"));
    	$codsucursal = limpiar($_SESSION["codsucursal"]);
		$stmt->execute();
		##################### REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX #####################
	
        }
           
        $this->dbh->commit();
        //cerramos la lectura del archivo "abrir archivo" con un "cerrar archivo"
        fclose($handle);
	        
	    echo "<span class='fa fa-check-square-o'></span> LA CARGA MASIVA DE INGREDIENTES FUE REALIZADA EXITOSAMENTE";
	    exit;
             
    } else {
    //si aparece esto es posible que el archivo no tenga el formato adecuado, inclusive cuando es cvs, revisarlo para ver si esta separado por " , "
        echo "2";
		exit;
    }  
}
############################## FUNCION CARGAR INGREDIENTES ##############################

########################### FUNCION REGISTRAR INGREDIENTES ###############################
public function RegistrarIngredientes()
{
	self::SetNames();
	if(empty($_POST["codingrediente"]) or empty($_POST["nomingrediente"]) or empty($_POST["codmedida"]))
	{
		echo "1";
		exit;
	}

	############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

	$sql = "SELECT codingrediente FROM ingredientes WHERE codingrediente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codingrediente"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
    $query = "INSERT INTO ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codingrediente);
		$stmt->bindParam(2, $nomingrediente);
		$stmt->bindParam(3, $codmedida);
		$stmt->bindParam(4, $preciocompra);
		$stmt->bindParam(5, $precioventa);
		$stmt->bindParam(6, $cantingrediente);
		$stmt->bindParam(7, $stockminimo);
		$stmt->bindParam(8, $stockmaximo);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $lote);
		$stmt->bindParam(12, $fechaexpiracion);
		$stmt->bindParam(13, $codproveedor);
		$stmt->bindParam(14, $preparado);
		$stmt->bindParam(15, $favorito);
		$stmt->bindParam(16, $controlstocki);
    	$stmt->bindParam(17, $codsucursal);

		$codingrediente = limpiar($_POST["codingrediente"]);
		$nomingrediente = limpiar($_POST["nomingrediente"]);
		$codmedida = limpiar($_POST["codmedida"]);
		$preciocompra = limpiar($_POST["preciocompra"]);
		$precioventa = limpiar($_POST["precioventa"]);
		$cantingrediente = limpiar($_POST["cantingrediente"]);
		$stockminimo = limpiar($_POST["stockminimo"]);
		$stockmaximo = limpiar($_POST["stockmaximo"]);
		$ivaingrediente = limpiar($_POST["ivaingrediente"]);
		$descingrediente = limpiar($_POST["descingrediente"]);
		$lote = limpiar($_POST['lote'] == '' ? "0" : $_POST['lote']);
		$fechaexpiracion = limpiar($_POST['fechaexpiracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaexpiracion'])));
		$codproveedor = limpiar($_POST['codproveedor'] == '' ? "0" : $_POST['codproveedor']);
	    $preparado = limpiar($_POST["preparado"]);
	    $favorito = limpiar($_POST["favorito"]);
		$controlstocki = limpiar($_POST["controlstocki"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

        ##################### REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX #####################
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproceso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codingrediente);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
    	$stmt->bindParam(14, $codsucursal);

		$codproceso = limpiar($_POST['codingrediente']);
		$codresponsable = limpiar("0");
		$codingrediente = limpiar($_POST['codingrediente']);
		$movimiento = limpiar("ENTRADAS");
		$entradas = limpiar($_POST['cantingrediente']);
		$salidas = limpiar("0.00");
		$devolucion = limpiar("0.00");
		$stockactual = limpiar($_POST['cantingrediente']);
		$ivaingrediente = limpiar($_POST["ivaingrediente"] == 'SI' ? $valor : "0.00");
		$descingrediente = limpiar($_POST["descingrediente"]);
		$precio = limpiar($_POST['precioventa']);
		$documento = limpiar("INVENTARIO INICIAL");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
        ##################### REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX #####################


		echo "<span class='fa fa-check-square-o'></span> EL INGREDIENTE HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
########################## FUNCION REGISTRAR INGREDIENTES ###############################

########################### FUNCION LISTAR INGREDIENTES ################################
public function ListarIngredientes()
	{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida  
	LEFT JOIN proveedores ON ingredientes.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ingredientes.codsucursal = ? 
	ORDER BY ingredientes.nomingrediente ASC";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
	    exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}

	} else { 

    $sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida  
	LEFT JOIN proveedores ON ingredientes.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE ingredientes.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	ORDER BY ingredientes.nomingrediente ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
########################## FUNCION LISTAR INGREDIENTES ################################

########################### FUNCION LISTAR INGREDIENTES EN STOCK MINIMO ################################
public function ListarIngredientesMinimo()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida  
	LEFT JOIN proveedores ON ingredientes.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE CAST(ingredientes.cantingrediente AS DECIMAL(10,2)) <= CAST(ingredientes.stockminimo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

    $sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida  
	LEFT JOIN proveedores ON ingredientes.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE ingredientes.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND CAST(ingredientes.cantingrediente AS DECIMAL(10,2)) <= CAST(ingredientes.stockminimo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
########################## FUNCION LISTAR INGREDIENTES EN STOCK MINIMO ################################

########################### FUNCION LISTAR INGREDIENTES FAVORITOS ################################
public function ListarIngredientesFavoritos()
{
	self::SetNames();
    $sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.fechaexpiracion,
	ingredientes.preparado,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida
	FROM ingredientes LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida
	WHERE ingredientes.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	AND ingredientes.cantingrediente > 0
	AND ingredientes.favorito = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR INGREDIENTES FAVORITOS ################################

########################### FUNCION LISTAR INGREDIENTES EN STOCK MAXIMO ################################
public function ListarIngredientesMaximo()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida 
	LEFT JOIN proveedores ON ingredientes.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE CAST(ingredientes.cantingrediente AS DECIMAL(10,2)) >= CAST(ingredientes.stockmaximo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

    $sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida  
	LEFT JOIN proveedores ON ingredientes.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE ingredientes.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND CAST(ingredientes.cantingrediente AS DECIMAL(10,2)) >= CAST(ingredientes.stockmaximo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
   }
}
########################## FUNCION LISTAR INGREDIENTES EN STOCK MAXIMO ################################

############################# FUNCION LISTAR INGREDIENTES EN EXTRAS ################################
public function ListarIngredientesModal()
{
	self::SetNames();
	$sql = "SELECT 
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.codsucursal,
	medidas.nommedida,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
    LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2  
    WHERE ingredientes.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
    AND ingredientes.cantingrediente != '0.00'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR INGREDIENTES EN EXTRAS ################################

############################# FUNCION LISTAR INGREDIENTES PARA MENU ################################
public function ListarIngredientesMenu()
	{
	self::SetNames();
    $sql = "
	SELECT
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	medidas.nommedida, 
	GROUP_CONCAT(nomingrediente, '|', precioventa, '|', cantingrediente SEPARATOR '<br>') AS menu_extras
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento  
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
    WHERE ingredientes.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
    GROUP BY ingredientes.codmedida";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR INGREDIENTES PARA MENU ################################

############################ FUNCION ID INGREDIENTES #################################
public function IngredientesPorId()
{
	self::SetNames();
	$sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	INNER JOIN medidas ON ingredientes.codmedida=medidas.codmedida
	LEFT JOIN proveedores ON ingredientes.codproveedor=proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ingredientes.codingrediente = ? AND ingredientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codingrediente"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID INGREDIENTES #################################

############################ FUNCION VER INGREDIENTES EN PRODUCTOS ############################
public function VerDetallesIngredientes()
{
	self::SetNames();
	$sql ="SELECT 
	productosxingredientes.codproducto, 
	productosxingredientes.codingrediente, 
	productosxingredientes.cantracion,
	productosxingredientes.codsucursal,
	ingredientes.nomingrediente,
	ingredientes.preciocompra,   
	ingredientes.precioventa, 
	ingredientes.cantingrediente,
	ingredientes.descingrediente, 
	ingredientes.codmedida, 
	medidas.nommedida 
	FROM (productosxingredientes INNER JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente)
	INNER JOIN medidas ON ingredientes.codmedida = medidas.codmedida 
	WHERE productosxingredientes.codproducto = ? AND productosxingredientes.codsucursal = ?
	GROUP BY productosxingredientes.codproducto,productosxingredientes.codingrediente,productosxingredientes.codsucursal";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproducto"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "";		
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION VER INGREDIENTES EN PRODUCTOS ############################

############################ FUNCION VER MODAL INGREDIENTES EN PRODUCTOS ############################
public function VerDetallesIngredientesModal()
{
	self::SetNames();
	$sql ="SELECT 
	productosxingredientes.codproducto, 
	productosxingredientes.codingrediente, 
	productosxingredientes.cantracion,
	productosxingredientes.codsucursal,
	ingredientes.nomingrediente,
	ingredientes.preciocompra,   
	ingredientes.precioventa, 
	ingredientes.cantingrediente,
	ingredientes.descingrediente, 
	ingredientes.codmedida, 
	medidas.nommedida 
	FROM (productosxingredientes INNER JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente)
	INNER JOIN medidas ON ingredientes.codmedida = medidas.codmedida 
	WHERE productosxingredientes.codproducto = ? AND productosxingredientes.codsucursal = ?
	GROUP BY productosxingredientes.codproducto,productosxingredientes.codingrediente,productosxingredientes.codsucursal";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["d_codigo"]),limpiar($_SESSION["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "";		
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION VER MODAL INGREDIENTES EN PRODUCTOS ############################

############################ FUNCION DETALLES INGREDIENTES ID #################################
public function DetallesIngredientesPorId()
{
	self::SetNames();
	$sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.codsucursal,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor
	FROM (ingredientes LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida)
	LEFT JOIN proveedores ON ingredientes.codproveedor = proveedores.codproveedor 
	WHERE ingredientes.codingrediente = ? AND ingredientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["d_codigo"]),limpiar($_SESSION["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION DETALLES INGREDIENTES ID #################################

############################ FUNCION ACTUALIZAR INGREDIENTES ############################
public function ActualizarIngredientes()
{   
	self::SetNames();
	if(empty($_POST["codingrediente"]) or empty($_POST["nomingrediente"]) or empty($_POST["codmedida"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT codingrediente FROM ingredientes WHERE idingrediente != ? AND codingrediente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["idingrediente"],$_POST["codingrediente"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE ingredientes set"
		." nomingrediente = ?, "
		." codmedida = ?, "
		." preciocompra = ?, "
		." precioventa = ?, "
		." cantingrediente = ?, "
		." stockminimo = ?, "
		." stockmaximo = ?, "
		." ivaingrediente = ?, "
		." descingrediente = ?, "
		." lote = ?, "
		." fechaexpiracion = ?, "
		." codproveedor = ?, "
		." preparado = ?, "
		." favorito = ?, "
		." controlstocki = ? "
		." WHERE "
		." idingrediente = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomingrediente);
		$stmt->bindParam(2, $codmedida);
		$stmt->bindParam(3, $preciocompra);
		$stmt->bindParam(4, $precioventa);
		$stmt->bindParam(5, $cantingrediente);
		$stmt->bindParam(6, $stockminimo);
		$stmt->bindParam(7, $stockmaximo);
		$stmt->bindParam(8, $ivaingrediente);
		$stmt->bindParam(9, $descingrediente);
		$stmt->bindParam(10, $lote);
		$stmt->bindParam(11, $fechaexpiracion);
		$stmt->bindParam(12, $codproveedor);
		$stmt->bindParam(13, $preparado);
		$stmt->bindParam(14, $favorito);
		$stmt->bindParam(15, $controlstocki);
		$stmt->bindParam(16, $idingrediente);

		$nomingrediente = limpiar($_POST["nomingrediente"]);
		$codmedida = limpiar($_POST["codmedida"]);
		$preciocompra = limpiar($_POST["preciocompra"]);
		$precioventa = limpiar($_POST["precioventa"]);
		$cantingrediente = limpiar($_POST["cantingrediente"]);
		$stockminimo = limpiar($_POST["stockminimo"]);
		$stockmaximo = limpiar($_POST["stockmaximo"]);
		$ivaingrediente = limpiar($_POST["ivaingrediente"]);
		$descingrediente = limpiar($_POST["descingrediente"]);
		$lote = limpiar($_POST['lote'] == '' ? "0" : $_POST['lote']);
		$fechaexpiracion = limpiar($_POST['fechaexpiracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaexpiracion'])));
		$codproveedor = limpiar($_POST['codproveedor'] == '' ? "0" : $_POST['codproveedor']);
		$preparado = limpiar($_POST["preparado"]);
	    $favorito = limpiar($_POST["favorito"]);
		$controlstocki = limpiar($_POST["controlstocki"]);
		$codingrediente = limpiar($_POST["codingrediente"]);
		$idingrediente = limpiar($_POST["idingrediente"]);
		$stmt->execute();
    
	echo "<span class='fa fa-check-square-o'></span> EL INGREDIENTE HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR INGREDIENTES ############################

########################## FUNCION AJUSTAR STOCK DE INGREDIENTES ###########################
public function SumarStockIngrediente()
{
	self::SetNames();
	if(empty($_POST["idingrediente"]) or empty($_POST["cantidad"]))
	{
		echo "1";
	    exit;
	}
	elseif($_POST["cantidad"] == 0 || $_POST["cantidad"] == 0.00){

		echo "2";
		exit;
	}

	################ OBTENGO EXISTENCIA DE INGREDIENTE ################
	$sql = "SELECT
	codingrediente,
	nomingrediente,
	cantingrediente,
	precioventa,
	ivaingrediente, 
	descingrediente 
	FROM ingredientes 
	WHERE idingrediente = '".limpiar($_POST['idingrediente'])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codingredientebd = $row['codingrediente'];
	$nomingredientebd = $row['nomingrediente'];
	$cantingredientebd = $row['cantingrediente'];
	$precioventabd = $row['precioventa'];
	$ivaingredientebd = $row['ivaingrediente'];
	$descingredientebd = $row['descingrediente'];
    ################ OBTENGO EXISTENCIA DE INGREDIENTE ################

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
    $valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################
	
	################ ACTUALIZO EXISTENCIA DE INGREDIENTE ################
	$sql = "UPDATE ingredientes set"
		  ." cantingrediente = ? "
		  ." where "
		  ." idingrediente = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $cantingrediente);
	$stmt->bindParam(2, $idingrediente);
	
	$cantingrediente = number_format($_POST["cantidad"] + $cantingredientebd, 2, '.', '');
	$idingrediente= limpiar($_POST["idingrediente"]);
	$stmt->execute();
	################ ACTUALIZO EXISTENCIA DE INGREDIENTE ################

	##################### REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX #####################
	$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproceso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codingrediente);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaingrediente);
	$stmt->bindParam(10, $descingrediente);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14, $codsucursal);

	$codproceso = limpiar($codingredientebd);
	$codresponsable = limpiar("0");
	$codingrediente = limpiar($codingredientebd);
	$movimiento = limpiar("ENTRADAS");
	$entradas = limpiar($_POST['cantidad']);
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = number_format($_POST["cantidad"] + $cantingredientebd, 2, '.', '');
	$ivaingrediente = limpiar($ivaingredientebd == "SI" ? $valor : "0.00");
	$descingrediente = limpiar($descingredientebd);
	$precio = limpiar($precioventabd);
	$documento = limpiar("SUMA DE STOCK");
	$fechakardex = limpiar(date("Y-m-d"));
	$codsucursal = limpiar($_SESSION["codsucursal"]);
	$stmt->execute();
    ##################### REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX #####################

	echo "<span class='fa fa-check-square-o'></span> LA CANTIDAD FUE SUMADA AL STOCK DEL INGREDIENTE EXITOSAMENTE";
	exit;
}
###################### FUNCION AJUSTAR STOCK DE INGREDIENTES #########################

########################## FUNCION ELIMINAR INGREDIENTES ###########################
public function EliminarIngredientes()
{
self::SetNames();
	if ($_SESSION["acceso"]=="administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codingrediente FROM productosxingredientes 
	WHERE codingrediente = ? 
	AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codingrediente"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM ingredientes WHERE codingrediente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codingrediente);
		$stmt->bindParam(2,$codsucursal);

		$codingrediente = decrypt($_GET["codingrediente"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		$sql = "DELETE FROM kardex_ingredientes where codingrediente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codingrediente);
		$stmt->bindParam(2,$codsucursal);

		$codingrediente = decrypt($_GET["codingrediente"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR INGREDIENTES #################################

###################### FUNCION BUSCAR INGREDIENTES FACTURADOS #########################
public function BuscarIngredientesVendidos() 
{
	self::SetNames();
    $sql = "SELECT
	detalleventas.idproducto, 
	detalleventas.codproducto,
	detalleventas.producto,
	detalleventas.descproducto,
	detalleventas.ivaproducto,
	detalleventas.preciocompra, 
	detalleventas.precioventa, 
    ingredientes.codmedida, 
    ingredientes.cantingrediente,
    medidas.nommedida,
	ventas.iva, 
	ventas.fechaventa, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio, 
    SUM(detalleventas.cantventa) as cantidad
    FROM (ventas INNER JOIN detalleventas ON ventas.codventa = detalleventas.codventa) 
	INNER JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN ingredientes ON detalleventas.idproducto = ingredientes.idingrediente
    LEFT JOIN medidas ON ingredientes.codmedida = medidas.codmedida
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
    WHERE ventas.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
    AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?
    AND detalleventas.tipo = 3
	GROUP BY detalleventas.codproducto, detalleventas.precioventa, detalleventas.descproducto 
	ORDER BY detalleventas.codproducto ASC ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION INGREDIENTES FACTURADOS ###############################

######################## FUNCION BUSCA KARDEX INGREDIENTES ##########################
public function BuscarKardexIngrediente() 
    {
	self::SetNames();
	$sql ="SELECT * FROM kardex_ingredientes WHERE codingrediente = ? AND codsucursal = ?";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codingrediente"], decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION BUSCA KARDEX INGREDIENTES #########################

######################## FUNCION DETALLE KARDEX INGREDIENTE #########################
public function DetalleKardexIngrediente()
{
	self::SetNames();
	$sql = "SELECT
	ingredientes.idingrediente,
	ingredientes.codingrediente,
	ingredientes.nomingrediente,
	ingredientes.codmedida,
	ingredientes.preciocompra,
	ingredientes.precioventa,
	ingredientes.cantingrediente,
	ingredientes.stockminimo,
	ingredientes.stockmaximo,
	ingredientes.ivaingrediente,
	ingredientes.descingrediente,
	ingredientes.lote,
	ingredientes.fechaexpiracion,
	ingredientes.codproveedor,
    ingredientes.preparado,
	ingredientes.favorito,
	ingredientes.controlstocki,
	medidas.nommedida,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (ingredientes INNER JOIN sucursales ON ingredientes.codsucursal = sucursales.codsucursal)
	INNER JOIN medidas ON ingredientes.codmedida=medidas.codmedida
	LEFT JOIN proveedores ON ingredientes.codproveedor=proveedores.codproveedor 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ingredientes.codingrediente = ? AND ingredientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codingrediente"],decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION DETALLE KARDEX INGREDIENTE #########################

############################### FIN DE CLASE INGREDIENTES ###############################


































################################# CLASE PRODUCTOS ######################################

############################### FUNCION CARGAR PRODUCTOS ##############################
public function CargarProductos()
	{
	self::SetNames();
	if(empty($_FILES["sel_file"]))
	{
		echo "1";
		exit;
	}

	############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

    //Aquí es donde seleccionamos nuestro csv
     $fname = $_FILES['sel_file']['name'];
     //echo 'Cargando nombre del archivo: '.$fname.' ';
     $chk_ext = explode(".",$fname);
     
    if(strtolower(end($chk_ext)) == "csv")
    {
    //si es correcto, entonces damos permisos de lectura para subir
    $filename = $_FILES['sel_file']['tmp_name'];
    $handle = fopen($filename, "r");
    $this->dbh->beginTransaction();
    
    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {

    //Insertamos los datos con los valores...
    $query = "INSERT INTO productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproducto);
	$stmt->bindParam(2, $producto);
	$stmt->bindParam(3, $codcategoria);
	$stmt->bindParam(4, $preciocompra);
	$stmt->bindParam(5, $precioventa);
	$stmt->bindParam(6, $existencia);
	$stmt->bindParam(7, $stockminimo);
	$stmt->bindParam(8, $stockmaximo);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $codigobarra);
	$stmt->bindParam(12, $lote);
	$stmt->bindParam(13, $fechaelaboracion);
	$stmt->bindParam(14, $fechaexpiracion);
	$stmt->bindParam(15, $codproveedor);
	$stmt->bindParam(16, $stockteorico);
	$stmt->bindParam(17, $motivoajuste);
	$stmt->bindParam(18, $preparado);
	$stmt->bindParam(19, $favorito);
	$stmt->bindParam(20, $controlstockp);
    $stmt->bindParam(21, $codsucursal);

	$codproducto = limpiar($data[0]);
	$producto = limpiar($data[1]);
	$codcategoria = limpiar($data[2]);
	$preciocompra = limpiar($data[3]);
	$precioventa = limpiar($data[4]);
	$existencia = limpiar($data[5]);
	$stockminimo = limpiar($data[6]);
	$stockmaximo = limpiar($data[7]);
	$ivaproducto = limpiar($data[8]);
	$descproducto = limpiar($data[9]);
	$codigobarra = limpiar($data[10]);
	$lote = limpiar($data[11]);
	$fechaelaboracion = limpiar($data[12]);
	$fechaexpiracion = limpiar($data[13]);
	$codproveedor = limpiar($data[14]);
	$stockteorico = limpiar("0");
	$motivoajuste = limpiar("NINGUNO");
	$preparado = limpiar($data[15]);
	$favorito = limpiar($data[16]);
	$controlstockp = limpiar($data[17]);
    $codsucursal = limpiar($_SESSION["codsucursal"]);
	$stmt->execute();

    ##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproceso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
    $stmt->bindParam(14, $codsucursal);
	
	$codproceso = limpiar($data[0]);
	$codresponsable = limpiar("0");
	$codproducto = limpiar($data[0]);
	$movimiento = limpiar("ENTRADAS");
	$entradas = limpiar($data[5]);
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = limpiar($data[5]);
	$ivaproducto = limpiar($data[8] == 'SI' ? $valor : "0.00");
	$descproducto = limpiar($data[9]);
	$precio = limpiar($data[4]);
	$documento = limpiar("INVENTARIO INICIAL");
	$fechakardex = limpiar(date("Y-m-d"));
    $codsucursal = limpiar($_SESSION["codsucursal"]);
	$stmt->execute();
	##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	
    }
           
    $this->dbh->commit();
    //cerramos la lectura del archivo "abrir archivo" con un "cerrar archivo"
    fclose($handle);
	        
	echo "<span class='fa fa-check-square-o'></span> LA CARGA MASIVA DE PRODUCTOS FUE REALIZADA EXITOSAMENTE";
	exit;
             
    } else {
    //si aparece esto es posible que el archivo no tenga el formato adecuado, inclusive cuando es cvs, revisarlo para ver si esta separado por " , "
        echo "2";
		exit;
    }  
}
############################## FUNCION CARGAR PRODUCTOS ##############################

########################### FUNCION REGISTRAR PRODUCTOS ###############################
public function RegistrarProductos()
{
	self::SetNames();
	if(empty($_POST["codproducto"]) or empty($_POST["producto"]) or empty($_POST["codcategoria"]))
	{
		echo "1";
		exit;
	}

	if(!empty($_SESSION["CarritoIngrediente"])){

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoIngrediente"];
	for($i=0;$i<count($v);$i++){

		$sql = "SELECT cantingrediente
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($v[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		
		$cantingredientebd = $row['cantingrediente'];
		$cantidad = $v[$i]['cantidad'];

        if($cantidad == "" || $cantidad == 0 || $cantidad == 0.00){

		    echo "2";
		    exit;
	    }
	    elseif ($cantidad > $cantingredientebd) 
        { 
		    echo "3";
		    exit;
	    } 
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

    }

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

	$sql = "SELECT codproducto FROM productos WHERE codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codproducto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	$query = "INSERT INTO productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproducto);
	$stmt->bindParam(2, $producto);
	$stmt->bindParam(3, $codcategoria);
	$stmt->bindParam(4, $preciocompra);
	$stmt->bindParam(5, $precioventa);
	$stmt->bindParam(6, $existencia);
	$stmt->bindParam(7, $stockminimo);
	$stmt->bindParam(8, $stockmaximo);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $codigobarra);
	$stmt->bindParam(12, $lote);
	$stmt->bindParam(13, $fechaelaboracion);
	$stmt->bindParam(14, $fechaexpiracion);
	$stmt->bindParam(15, $codproveedor);
	$stmt->bindParam(16, $stockteorico);
	$stmt->bindParam(17, $motivoajuste);
	$stmt->bindParam(18, $preparado);
	$stmt->bindParam(19, $favorito);
	$stmt->bindParam(20, $controlstockp);
    $stmt->bindParam(21, $codsucursal);

	$codproducto = limpiar($_POST["codproducto"]);
	$producto = limpiar($_POST["producto"]);
	$codcategoria = limpiar($_POST["codcategoria"]);
	$preciocompra = limpiar($_POST["preciocompra"]);
	$precioventa = limpiar($_POST["precioventa"]);
	$existencia = limpiar($_POST["existencia"]);
	$stockminimo = limpiar($_POST["stockminimo"]);
	$stockmaximo = limpiar($_POST["stockmaximo"]);
	$ivaproducto = limpiar($_POST["ivaproducto"]);
	$descproducto = limpiar($_POST["descproducto"]);
	$codigobarra = limpiar($_POST['codigobarra'] == '' ? "0" : $_POST['codigobarra']);
	$lote = limpiar($_POST['lote'] == '' ? "0" : $_POST['lote']);			
	$fechaelaboracion = limpiar($_POST['fechaelaboracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaelaboracion'])));
	$fechaexpiracion = limpiar($_POST['fechaexpiracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaexpiracion'])));
	$codproveedor = limpiar($_POST['codproveedor'] == '' ? "0" : $_POST['codproveedor']);
	$stockteorico = limpiar("0");
	$motivoajuste = limpiar("NINGUNO");
	$preparado = limpiar($_POST["preparado"]);
	$favorito = limpiar($_POST["favorito"]);
	$controlstockp = limpiar($_POST["controlstockp"]);
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

	##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproceso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
    $stmt->bindParam(14, $codsucursal);

	$codproceso = limpiar($_POST['codproducto']);
	$codresponsable = limpiar("0");
	$codproducto = limpiar($_POST['codproducto']);
	$movimiento = limpiar("ENTRADAS");
	$entradas = limpiar($_POST['existencia']);
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = limpiar($_POST['existencia']);
	$ivaproducto = limpiar($_POST["ivaproducto"] == 'SI' ? $valor : "0.00");
	$descproducto = limpiar($_POST["descproducto"]);
	$precio = limpiar($_POST['precioventa']);
	$documento = limpiar("INVENTARIO INICIAL");
	$fechakardex = limpiar(date("Y-m-d"));
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################

	##################  SUBIR FOTO DE PRODUCTO ######################################
    //datos del arhivo  
    if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
    if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
    if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; } 
    //compruebo si las características del archivo son las que deseo  
    if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<8000000)//1MB 
    {  
    if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/productos/".$nombre_archivo) && rename("fotos/productos/".$nombre_archivo,"fotos/productos/".$codproducto.".jpg"))
	{ 
	## se puede dar un aviso
	} 
	## se puede dar otro aviso 
	}
	##################  FINALIZA SUBIR FOTO DE PRODUCTO ######################################

	if(!empty($_SESSION["CarritoIngrediente"])){

	################## PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ####################
	$this->dbh->beginTransaction();

	$detalle = $_SESSION["CarritoIngrediente"];
	for($i=0;$i<count($detalle);$i++){

		$query = " INSERT INTO productosxingredientes values (null, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproducto);
		$stmt->bindParam(2, $codingrediente);
		$stmt->bindParam(3, $cantidad);
		$stmt->bindParam(4, $codsucursal);
		
		$codproducto = limpiar($_POST["codproducto"]);
		$codingrediente = limpiar($detalle[$i]['txtCodigo']);
		$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	}
	unset($_SESSION["CarritoIngrediente"]);
    $this->dbh->commit();
	################### PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ##################

    }
		echo "<span class='fa fa-check-square-o'></span> EL PRODUCTO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "4";
		exit;
	}
}
########################## FUNCION REGISTRAR PRODUCTOS ###############################

########################### FUNCION LISTAR PRODUCTOS ################################
public function ListarProductos()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria
	LEFT JOIN proveedores ON productos.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE productos.codsucursal = ? 
	ORDER BY productos.producto ASC";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
	    exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}

	} else { 

    $sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria
	LEFT JOIN proveedores ON productos.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	ORDER BY productos.producto ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
########################## FUNCION LISTAR PRODUCTOS ################################

########################### FUNCION LISTAR PRODUCTOS CSV ################################
public function ListarProductosCsv()
{
	self::SetNames();
    $sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria  
	LEFT JOIN proveedores ON productos.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR PRODUCTOS CSV ################################

########################### FUNCION LISTAR PRODUCTOS FAVORITOS ################################
public function ListarProductosFavoritos()
{
	self::SetNames();
    $sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.ivaproducto,
	productos.descproducto,
	productos.preparado,
	categorias.nomcategoria
	FROM productos INNER JOIN categorias ON productos.codcategoria=categorias.codcategoria
	WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	AND productos.existencia > 0 
	AND productos.favorito = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR PRODUCTOS FAVORITOS ################################

########################### FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ################################
public function ListarProductosMinimo()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria 
	LEFT JOIN proveedores ON productos.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE CAST(productos.existencia AS DECIMAL(10,2)) <= CAST(productos.stockminimo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

    $sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria 
	LEFT JOIN proveedores ON productos.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND CAST(productos.existencia AS DECIMAL(10,2)) <= CAST(productos.stockminimo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
   }
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ################################

########################### FUNCION LISTAR PRODUCTOS EN STOCK MAXIMO ################################
public function ListarProductosMaximo()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria
	LEFT JOIN proveedores ON productos.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE CAST(productos.existencia AS DECIMAL(10,2)) >= CAST(productos.stockmaximo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

    $sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria 
	LEFT JOIN proveedores ON productos.codproveedor = proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND CAST(productos.existencia AS DECIMAL(10,2)) >= CAST(productos.stockmaximo AS DECIMAL(10,2))";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
   }
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MAXIMO ################################

############################# FUNCION LISTAR PRODUCTOS ################################
public function ListarProductosModal()
{
	self::SetNames();
	$sql = "SELECT 
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.ivaproducto,
	productos.descproducto,
	productos.preparado,
	productos.codsucursal,
	categorias.nomcategoria,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
    LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2  
    WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
    AND productos.existencia != '0.00'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR PRODUCTOS ################################

############################# FUNCION LISTAR PRODUCTOS PARA MENU ################################
public function ListarProductosMenu()
	{
	self::SetNames();
    $sql = "
	SELECT
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	categorias.nomcategoria, 
	GROUP_CONCAT(producto, '|', precioventa, '|', existencia SEPARATOR '<br>') AS menu_productos
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento  
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
    WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
    GROUP BY productos.codcategoria";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR PRODUCTOS PARA MENU ################################

############################ FUNCION ID PRODUCTOS #################################
public function ProductosPorId()
{
	self::SetNames();
	$sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	productos.codsucursal,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	INNER JOIN categorias ON productos.codcategoria=categorias.codcategoria
	LEFT JOIN proveedores ON productos.codproveedor=proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE productos.codproducto = ? AND productos.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproducto"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID PRODUCTOS #################################

############################ FUNCION VER PRODUCTOS EN COMBOS ############################
public function VerDetallesProductos()
{
	self::SetNames();
	$sql ="SELECT 
	combosxproductos.codcombo, 
	combosxproductos.cantidad, 
	combosxproductos.codsucursal,
	productos.codproducto, 
	productos.producto, 
	productos.preciocompra,  
	productos.precioventa, 
	productos.existencia,
	productos.descproducto, 
	productos.codcategoria,
	productos.preparado, 
	categorias.nomcategoria
	FROM combosxproductos 
	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria 
	WHERE combosxproductos.codcombo = ? 
	AND combosxproductos.codsucursal = ?
	GROUP BY combosxproductos.codproducto, combosxproductos.codsucursal";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcombo"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "";		
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION VER PRODUCTOS EN COMBOS ############################

############################ FUNCION VER MODAL PRODUCTOS EN COMBOS ############################
public function VerDetallesProductosModal()
{
	self::SetNames();
	$sql ="SELECT 
	combosxproductos.codcombo, 
	combosxproductos.cantidad, 
	productos.codproducto, 
	productos.producto, 
	productos.preciocompra,  
	productos.precioventa, 
	productos.existencia,
	productos.descproducto, 
	productos.codcategoria,
	productos.preparado, 
	categorias.nomcategoria
	FROM combosxproductos 
	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto
	LEFT JOIN categorias ON productos.codcategoria = categorias.codcategoria 
	WHERE combosxproductos.codcombo = ? 
	AND combosxproductos.codsucursal = ?
	GROUP BY combosxproductos.codproducto, combosxproductos.codsucursal";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["d_codigo"]),limpiar($_SESSION["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "";		
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION VER MODAL PRODUCTOS EN COMBOS ############################

############################ FUNCION ID PRODUCTOS #################################
public function DetallesProductoPorId()
{
	self::SetNames();
	$sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor
	FROM (productos LEFT JOIN categorias ON productos.codcategoria=categorias.codcategoria)
	LEFT JOIN proveedores ON productos.codproveedor=proveedores.codproveedor 
	WHERE productos.codproducto = ? AND productos.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["d_codigo"]),limpiar($_SESSION["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID PRODUCTOS #################################

############################ FUNCION ACTUALIZAR PRODUCTOS ############################
public function ActualizarProductos()
	{
	self::SetNames();
	if(empty($_POST["codproducto"]) or empty($_POST["producto"]) or empty($_POST["codcategoria"]))
	{
		echo "1";
		exit;
	}

	################## PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ####################
	$this->dbh->beginTransaction();
	if (isset($_POST["codingrediente"])) {
	    for($i=0;$i<count($_POST['codingrediente']);$i++){  //recorro el array
		   if (!empty($_POST['codingrediente'][$i])) {

		        if($_POST['cantidad'][$i] == "" || $_POST['cantidad'][$i] == 0 || $_POST['cantidad'][$i] == 0.00){

		            echo "2";
		            exit;
	            }
	            elseif ($_POST['cantidad'][$i] > $_POST['cantingrediente'][$i]) 
	            { 
	            	echo "3";
	            	exit;
	            }
		   }
       }
	}
	$this->dbh->commit();
	################### PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ##################

	$sql = "SELECT codproducto FROM productos WHERE idproducto != ? AND codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["idproducto"],$_POST["codproducto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE productos set"
		." producto = ?, "
		." codcategoria = ?, "
		." preciocompra = ?, "
		." precioventa = ?, "
		." existencia = ?, "
		." stockminimo = ?, "
		." stockmaximo = ?, "
		." ivaproducto = ?, "
		." descproducto = ?, "
		." codigobarra = ?, "
		." lote = ?, "
		." fechaelaboracion = ?, "
		." fechaexpiracion = ?, "
		." codproveedor = ?, "
		." preparado = ?, "
		." favorito = ?, "
		." controlstockp = ? "
		." WHERE "
		." idproducto = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $producto);
		$stmt->bindParam(2, $codcategoria);
		$stmt->bindParam(3, $preciocompra);
		$stmt->bindParam(4, $precioventa);
		$stmt->bindParam(5, $existencia);
		$stmt->bindParam(6, $stockminimo);
		$stmt->bindParam(7, $stockmaximo);
		$stmt->bindParam(8, $ivaproducto);
		$stmt->bindParam(9, $descproducto);
		$stmt->bindParam(10, $codigobarra);
		$stmt->bindParam(11, $lote);
		$stmt->bindParam(12, $fechaelaboracion);
		$stmt->bindParam(13, $fechaexpiracion);
		$stmt->bindParam(14, $codproveedor);
		$stmt->bindParam(15, $preparado);
		$stmt->bindParam(16, $favorito);
		$stmt->bindParam(17, $controlstockp);
		$stmt->bindParam(18, $idproducto);

		$producto = limpiar($_POST["producto"]);
		$codcategoria = limpiar($_POST["codcategoria"]);
		$preciocompra = limpiar($_POST["preciocompra"]);
		$precioventa = limpiar($_POST["precioventa"]);
		$existencia = limpiar($_POST["existencia"]);
		$stockminimo = limpiar($_POST["stockminimo"]);
		$stockmaximo = limpiar($_POST["stockmaximo"]);
		$ivaproducto = limpiar($_POST["ivaproducto"]);
		$descproducto = limpiar($_POST["descproducto"]);
		$codigobarra = limpiar($_POST['codigobarra'] == '' ? "0" : $_POST['codigobarra']);
		$lote = limpiar($_POST['lote'] == '' ? "0" : $_POST['lote']);			
		$fechaelaboracion = limpiar($_POST['fechaelaboracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaelaboracion'])));
		$fechaexpiracion = limpiar($_POST['fechaexpiracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaexpiracion'])));
		$codproveedor = limpiar($_POST['codproveedor'] == '' ? "0" : $_POST['codproveedor']);
		$preparado = limpiar($_POST["preparado"]);
		$favorito = limpiar($_POST["favorito"]);
		$controlstockp = limpiar($_POST["controlstockp"]);
		$codproducto = limpiar($_POST["codproducto"]);
		$idproducto = limpiar($_POST["idproducto"]);
		$stmt->execute();

		if (isset($_POST["codingrediente"])) {
		$sql = "DELETE FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproducto);
		$stmt->bindParam(2,$codsucursal);
		$codproducto = limpiar($_POST["codproducto"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	    }

	##################  SUBIR FOTO DE PRODUCTO ######################################
         //datos del arhivo  
if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; } 
         //compruebo si las características del archivo son las que deseo  
if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<8000000)//1MB 
		 {  
if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/productos/".$nombre_archivo) && rename("fotos/productos/".$nombre_archivo,"fotos/productos/".$codproducto.".jpg"))
		 { 
		 ## se puede dar un aviso
		 } 
		 ## se puede dar otro aviso 
		 }
	################## FINALIZA SUBIR FOTO DE PRODUCTO ##########################

	################## PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ####################
	if (isset($_POST["codingrediente"])) {
	    for($i=0;$i<count($_POST['codingrediente']);$i++){  //recorro el array
		   if (!empty($_POST['codingrediente'][$i])) {

			$query = "INSERT INTO productosxingredientes values (null, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codproducto);
			$stmt->bindParam(2, $codingrediente);
			$stmt->bindParam(3, $cantidad);
			$stmt->bindParam(4, $codsucursal);

			$codproducto = limpiar($_POST["codproducto"]);
			$codingrediente = limpiar($_POST['codingrediente'][$i]);
			$cantidad = limpiar($_POST['cantidad'][$i]);
		    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
		   }
       }
	}
	################### PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ##################
        
	echo "<span class='fa fa-check-square-o'></span> EL PRODUCTO HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "4";
		exit;
	}
}
############################ FUNCION ACTUALIZAR PRODUCTOS ############################

############################ FUNCION AGREGAR INGREDIENTES A PRODUCTOS ############################
public function AgregarIngredientes()
	{
	self::SetNames();
	if(empty($_POST["codproducto"]) or empty($_SESSION["CarritoIngrediente"]))
	{
		echo "1";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoIngrediente"];
	for($i=0;$i<count($v);$i++){

		$sql = "SELECT cantingrediente
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($v[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		
		$cantingredientebd = $row['cantingrediente'];
		$cantidad = $v[$i]['cantidad'];

        if($cantidad == "" || $cantidad == 0 || $cantidad == 0.00)
        {
		    echo "2";
		    exit;
	    }
	    elseif ($cantidad > $cantingredientebd) 
        { 
		    echo "3";
		    exit;
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################## PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ####################
	$this->dbh->beginTransaction();

	$detalle = $_SESSION["CarritoIngrediente"];
	for($i=0;$i<count($detalle);$i++){

		$sql = "SELECT 
		codproducto, 
		codingrediente 
		FROM productosxingredientes 
		WHERE codproducto = '".limpiar($_POST['codproducto'])."' 
		AND codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num == 0)
		{

		$query = " INSERT INTO productosxingredientes values (null, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproducto);
		$stmt->bindParam(2, $codingrediente);
		$stmt->bindParam(3, $cantidad);
		$stmt->bindParam(4, $codsucursal);
		
		$codproducto = limpiar($_POST["codproducto"]);
		$codingrediente = limpiar($detalle[$i]['txtCodigo']);
		$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		} else {

		$sql = "SELECT 
		cantracion 
		FROM productosxingredientes 
		WHERE codproducto = '".limpiar($_POST['codproducto'])."' 
		AND codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$racionbd = $row['cantracion'];

		$query = "UPDATE productosxingredientes set"
		." cantracion = ? "
		." WHERE "
		." codproducto = ? AND codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantracion);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codingrediente);
		$stmt->bindParam(4, $codsucursal);

		$cantracion = limpiar($racionbd+$detalle[$i]['cantidad']);
		$codproducto = limpiar($_POST["codproducto"]);
		$codingrediente = limpiar($detalle[$i]['txtCodigo']);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		}
	}
	unset($_SESSION["CarritoIngrediente"]);
    $this->dbh->commit();
	################### PROCESO DE REGISTRO DE INSCREDIENTES A PRODUCTOS ##################

	############## ACTUALIZAMOS LOS PRECIO DEL PRODUCTO ###################
    $sql2 = " UPDATE productos set "
    ." preciocompra = ?, "
    ." precioventa = ? "
    ." WHERE "
    ." codproducto = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->bindParam(1, $preciocompra);
    $stmt->bindParam(2, $precioventa);
    $stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $codsucursal);

    $preciocompra = number_format($_POST["preciocomprabd"]+$_POST["preciocompra"], 2, '.', '');
    $precioventa = number_format($_POST["precioventabd"]+$_POST["precioventa"], 2, '.', '');
	$codproducto = limpiar($_POST["codproducto"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
    $stmt->execute();
    ############## ACTUALIZAMOS LOS PRECIO DEL PRODUCTO ###################
        
	echo "<span class='fa fa-check-square-o'></span> LOS INGREDIENTES FUERON AGREGADOS AL PRODUCTO EXITOSAMENTE";
	exit;
}
############################ FUNCION AGREGAR INGREDIENTES A PRODUCTOS ############################

########################## FUNCION AJUSTAR STOCK DE PRODUCTOS ###########################
public function SumarStockProducto()
{
	self::SetNames();
	if(empty($_POST["idproducto"]) or empty($_POST["cantidad"]))
	{
		echo "1";
	    exit;
	}
	elseif($_POST["cantidad"] == 0 || $_POST["cantidad"] == 0.00){

		echo "2";
		exit;
	}

	################ OBTENGO EXISTENCIA DE PRODUCTO ################
	$sql = "SELECT
	codproducto,
	producto,
	existencia,
	precioventa,
	ivaproducto, 
	descproducto 
	FROM productos 
	WHERE idproducto = '".limpiar($_POST['idproducto'])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codproductobd = $row['codproducto'];
	$productobd = $row['producto'];
	$existenciabd = $row['existencia'];
	$precioventabd = $row['precioventa'];
	$ivaproductobd = $row['ivaproducto'];
	$descproductobd = $row['descproducto'];
    ################ OBTENGO EXISTENCIA DE PRODUCTO ################

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
    $valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################
	
	################ ACTUALIZO EXISTENCIA DE PRODUCTO ################
	$sql = "UPDATE productos set"
		  ." existencia = ? "
		  ." where "
		  ." idproducto = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$stmt->bindParam(2, $idproducto);
	
	$existencia = number_format($_POST["cantidad"] + $existenciabd, 2, '.', '');
	$idproducto = limpiar($_POST["idproducto"]);
	$stmt->execute();
	################ ACTUALIZO EXISTENCIA DE PRODUCTO ################

	##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproceso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14, $codsucursal);

	$codproceso = limpiar($codproductobd);
	$codresponsable = limpiar("0");
	$codproducto = limpiar($codproductobd);
	$movimiento = limpiar("ENTRADAS");
	$entradas = limpiar($_POST['cantidad']);
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = number_format($_POST["cantidad"] + $existenciabd, 2, '.', '');
	$ivaproducto = limpiar($ivaproductobd == "SI" ? $valor : "0.00");
	$descproducto = limpiar($descproductobd);
	$precio = limpiar($precioventabd);
	$documento = limpiar("SUMA DE STOCK");
	$fechakardex = limpiar(date("Y-m-d"));
	$codsucursal = limpiar($_SESSION["codsucursal"]);
	$stmt->execute();
    ##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################

	echo "<span class='fa fa-check-square-o'></span> LA CANTIDAD FUE SUMADA AL STOCK DEL PRODUCTO EXITOSAMENTE";
	exit;
}
###################### FUNCION AJUSTAR STOCK DE PRODUCTOS #########################

########################## FUNCION AJUSTAR STOCK DE PRODUCTOS ###########################
public function ActualizarAjuste()
{
self::SetNames();
	if(empty($_POST["codproducto"]) or empty($_POST["stockteorico"]) or empty($_POST["motivoajuste"]))
	{
		echo "1";
	    exit;
	}
	
	$sql = "UPDATE productos set"
		  ." stockteorico = ?, "
		  ." motivoajuste = ? "
		  ." WHERE "
		  ." idproducto = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $stockteorico);
	$stmt->bindParam(2, $motivoajuste);
    $stmt->bindParam(3, $idproducto);
	
	$stockteorico = limpiar($_POST["stockteorico"]);
	$motivoajuste = limpiar($_POST["motivoajuste"]);
	$idproducto = limpiar($_POST["idproducto"]);
	$stmt->execute();

	echo "<span class='fa fa-check-square-o'></span> EL AJUSTE DE STOCK DEL PRODUCTO SE HA REALIZADO EXITOSAMENTE";
	exit;
}
###################### FUNCION AJUSTAR STOCK DE PRODUCTOS #########################

########################## FUNCION ELIMINAR DETALLES PRODUCTOS ###########################
public function EliminarDetalleProducto()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT 
	cantingrediente,
	preciocompra,
	precioventa FROM ingredientes 
	WHERE codingrediente = '".limpiar(decrypt($_GET["codingrediente"]))."'
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
	$this->p[] = $row;
	}
	$preciocomprabd = $row["preciocompra"];
	$precioventabd = $row["precioventa"];

	$racionbd = decrypt($_GET["cantracion"]);
	$totalracioncompra = number_format($racionbd * $preciocomprabd, 2, '.', '');
	$totalracionventa = number_format($racionbd * $precioventabd, 2, '.', '');
    
    $sql = "DELETE FROM productosxingredientes 
    WHERE codproducto = ? 
    AND codingrediente = ? 
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codproducto);
	$stmt->bindParam(2,$codingrediente);
	$stmt->bindParam(3,$codsucursal);

	$codproducto = limpiar(decrypt($_GET["codproducto"]));
	$codingrediente = decrypt($_GET["codingrediente"]);
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();

	############ ACTUALIZAMOS PRECIO DEL PRODUCTO ################
    /*$sql2 = " UPDATE productos set "
    ." preciocompra = ?, "
    ." precioventa = ? "
    ." WHERE "
    ." codproducto = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->bindParam(1, $preciocompra);
    $stmt->bindParam(2, $precioventa);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $codsucursal);

    $preciocompra = number_format($preciocomprabd-$totalracioncompra, 2, '.', '');
    $precioventa = number_format($precioventabd-$totalracionventa, 2, '.', '');
	$codproducto = limpiar(decrypt($_GET["codproducto"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
    $stmt->execute();*/
    ############ ACTUALIZAMOS PRECIO DEL PRODUCTO ################

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
}
########################## FUNCION ELIMINAR DETALLES PRODUCTOS #################################

########################## FUNCION ELIMINAR PRODUCTOS ###########################
public function EliminarProductos()
{
self::SetNames();
	if ($_SESSION["acceso"]=="administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codproducto FROM detalleventas WHERE codproducto = ? AND codsucursal = ? AND tipo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproducto"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM productos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproducto);
		$stmt->bindParam(2,$codsucursal);

		$codproducto = limpiar(decrypt($_GET["codproducto"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		$sql = "DELETE FROM kardex_productos where codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproducto);
		$stmt->bindParam(2,$codsucursal);

		$codproducto = limpiar(decrypt($_GET["codproducto"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		$codproducto = limpiar(decrypt($_GET["codproducto"]));
		if (file_exists("fotos/productos/".$codproducto.".jpg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/productos/".$codproducto.".jpg";		
		unlink($archivos);
		}

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR PRODUCTOS #################################

###################### FUNCION BUSCAR PRODUCTOS FACTURADOS #########################
public function BuscarProductosVendidos() 
    {
	self::SetNames();
	$sql ="SELECT
	detalleventas.idproducto, 
	detalleventas.codproducto,
	detalleventas.producto,
	detalleventas.codcategoria,
	detalleventas.descproducto,
	detalleventas.ivaproducto,
	detalleventas.preciocompra, 
	detalleventas.precioventa, 
	productos.existencia,
	categorias.nomcategoria,
	ventas.iva, 
	ventas.fechaventa, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	SUM(detalleventas.cantventa) as cantidad
	FROM (ventas INNER JOIN detalleventas ON ventas.codventa = detalleventas.codventa)
	INNER JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN productos ON detalleventas.idproducto = productos.idproducto
	LEFT JOIN categorias ON detalleventas.codcategoria = categorias.codcategoria
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE ventas.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
    AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?
    AND detalleventas.tipo = 1
	GROUP BY detalleventas.codproducto, detalleventas.precioventa, detalleventas.ivaproducto, detalleventas.descproducto,  detalleventas.tipo 
	ORDER BY detalleventas.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION PRODUCTOS FACTURADOS ###############################

######################## FUNCION BUSCA KARDEX PRODUCTOS ##########################
public function BuscarKardexProducto() 
    {
	self::SetNames();
	$sql ="SELECT * FROM kardex_productos WHERE codproducto = ? AND codsucursal = ?";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codproducto"], decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION BUSCA KARDEX PRODUCTOS #########################

######################## FUNCION DETALLE KARDEX INGREDIENTE #########################
public function DetalleKardexProducto()
{
	self::SetNames();
	$sql = "SELECT
	productos.idproducto,
	productos.codproducto,
	productos.producto,
	productos.codcategoria,
	productos.preciocompra,
	productos.precioventa,
	productos.existencia,
	productos.stockminimo,
	productos.stockmaximo,
	productos.ivaproducto,
	productos.descproducto,
	productos.codigobarra,
	productos.lote,
	productos.fechaelaboracion,
	productos.fechaexpiracion,
	productos.codproveedor,
	productos.stockteorico,
	productos.motivoajuste,
	productos.preparado,
	productos.favorito,
	productos.controlstockp,
	categorias.nomcategoria,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
	INNER JOIN categorias ON productos.codcategoria=categorias.codcategoria
	LEFT JOIN proveedores ON productos.codproveedor=proveedores.codproveedor
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE productos.codproducto = ? AND productos.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codproducto"],decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION DETALLE KARDEX PRODUCTO #########################

###################### FUNCION KARDEX PRODUCTOS POR FECHAS #########################
public function BuscarKardexProductosValorizadoxFechas() 
{
	self::SetNames();
	$sql ="SELECT
	detalleventas.idproducto, 
	detalleventas.codproducto,
	detalleventas.producto,
	detalleventas.descproducto,
	detalleventas.ivaproducto,
	detalleventas.preciocompra, 
	detalleventas.precioventa, 
	productos.codcategoria,
	productos.existencia,
	categorias.nomcategoria,
	ventas.iva, 
	ventas.fechaventa, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	SUM(detalleventas.cantventa) as cantidad
	FROM (ventas INNER JOIN detalleventas ON ventas.codventa = detalleventas.codventa)
	INNER JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN productos ON detalleventas.idproducto = productos.idproducto
	LEFT JOIN categorias ON productos.codcategoria=categorias.codcategoria
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
    AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?
    AND detalleventas.tipo = 1
	GROUP BY detalleventas.codproducto, detalleventas.precioventa, detalleventas.ivaproducto, detalleventas.descproducto,  detalleventas.tipo 
	ORDER BY detalleventas.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION KARDEX PRODUCTOS POR FECHAS ###############################

############################### FIN DE CLASE PRODUCTOS ###############################


































################################# CLASE COMBOS ######################################

########################### FUNCION REGISTRAR PRODUCTOS ###############################
public function RegistrarCombos()
	{
	self::SetNames();
	if(empty($_POST["codcombo"]) or empty($_POST["nomcombo"]) or empty($_POST["existencia"]))
	{
		echo "1";
		exit;
	}

	if(!empty($_SESSION["CarritoProducto"])){

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($v);$i++){

		$sql = "SELECT existencia
		FROM productos 
		WHERE codproducto = '".limpiar($v[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		
		$cantproductobd = $row['existencia'];
		$cantidad = $v[$i]['cantidad'];

        if($cantidad == "" || $cantidad == 0 || $cantidad == 0.00){

		    echo "2";
		    exit;
	    }
	    elseif ($cantidad > $cantproductobd) 
        { 
		    echo "3";
		    exit;
	    } 
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

    }

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

	$sql = " SELECT codcombo FROM combos WHERE codcombo = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcombo"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
    $query = "INSERT INTO combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcombo);
	$stmt->bindParam(2, $nomcombo);
	$stmt->bindParam(3, $preciocompra);
	$stmt->bindParam(4, $precioventa);
	$stmt->bindParam(5, $existencia);
	$stmt->bindParam(6, $stockminimo);
	$stmt->bindParam(7, $stockmaximo);
	$stmt->bindParam(8, $ivacombo);
	$stmt->bindParam(9, $desccombo);
	$stmt->bindParam(10, $preparado);
	$stmt->bindParam(11, $favorito);
    $stmt->bindParam(12, $codsucursal);

	$codcombo = limpiar($_POST["codcombo"]);
	$nomcombo = limpiar($_POST["nomcombo"]);
	$preciocompra = limpiar($_POST["preciocompra"]);
	$precioventa = limpiar($_POST["precioventa"]);
	$existencia = limpiar($_POST["existencia"]);
	$stockminimo = limpiar($_POST["stockminimo"]);
	$stockmaximo = limpiar($_POST["stockmaximo"]);
	$ivacombo = limpiar($_POST["ivacombo"]);
	$desccombo = limpiar($_POST["desccombo"]);
	$preparado = limpiar($_POST["preparado"]);
	$favorito = limpiar($_POST["favorito"]);
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

    ##################### REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX #####################
	$query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproceso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codcombo);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivacombo);
	$stmt->bindParam(10, $desccombo);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
    $stmt->bindParam(14, $codsucursal);

	$codproceso = limpiar($_POST['codcombo']);
	$codresponsable = limpiar("0");
	$codcombo = limpiar($_POST['codcombo']);
	$movimiento = limpiar("ENTRADAS");
	$entradas = limpiar($_POST['existencia']);
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = limpiar($_POST['existencia']);
	$ivacombo = limpiar($_POST["ivacombo"] == 'SI' ? $valor : "0.00");
	$desccombo = limpiar($_POST["desccombo"]);
	$precio = limpiar($_POST['precioventa']);
	$documento = limpiar("INVENTARIO INICIAL");
	$fechakardex = limpiar(date("Y-m-d"));
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
    ##################### REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX #####################

    ##################  SUBIR FOTO DE COMBO ######################################
     //datos del arhivo  
    if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
    if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
    if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; } 
     //compruebo si las características del archivo son las que deseo  
    if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<8000000)//1MB 
	 {  
	 	if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/combos/".$nombre_archivo) && rename("fotos/combos/".$nombre_archivo,"fotos/combos/".$codcombo.".jpg"))
	 { 
	 ## se puede dar un aviso
	 } 
	 ## se puede dar otro aviso 
	 }
    ##################  FINALIZA SUBIR FOTO DE COMBO ######################################

	if(!empty($_SESSION["CarritoProducto"])){

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();

	$detalle = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($detalle);$i++){

		$query = " INSERT INTO combosxproductos values (null, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcombo);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $cantidad);
		$stmt->bindParam(4, $codsucursal);
		
		$codcombo = limpiar($_POST["codcombo"]);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	}
	unset($_SESSION["CarritoProducto"]);
    $this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################

    }
		echo "<span class='fa fa-check-square-o'></span> EL COMBO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "4";
		exit;
	}
}
########################## FUNCION REGISTRAR COMBOS ###############################

########################### FUNCION LISTAR COMBOS ################################
public function ListarCombos()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	categorias.nomcategoria,
	GROUP_CONCAT(combosxproductos.cantidad, ' | ', productos2.producto, ' | ', categorias.nomcategoria SEPARATOR '<br>') AS detalles_productos,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN combosxproductos ON combos.codcombo = combosxproductos.codcombo
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
       (SELECT
       productos.codproducto, productos.producto, productos.codcategoria    
       FROM productos WHERE codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."') productos2 ON productos2.codproducto = combosxproductos.codproducto
       LEFT JOIN categorias ON productos2.codcategoria = categorias.codcategoria 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' 
	GROUP BY combos.codcombo
	ORDER BY combos.codcombo DESC";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
	    exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}

	} else { 

    $sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	categorias.nomcategoria,
	GROUP_CONCAT(combosxproductos.cantidad, ' | ', productos2.producto, ' | ', categorias.nomcategoria SEPARATOR '<br>') AS detalles_productos,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN combosxproductos ON combos.codcombo = combosxproductos.codcombo
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
       (SELECT
       productos.codproducto, productos.producto, productos.codcategoria    
       FROM productos WHERE codsucursal = '".limpiar($_SESSION["codsucursal"])."') productos2 ON productos2.codproducto = combosxproductos.codproducto
       LEFT JOIN categorias ON productos2.codcategoria = categorias.codcategoria 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	GROUP BY combos.codcombo
	ORDER BY combos.codcombo DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
########################## FUNCION LISTAR COMBOS ################################

########################### FUNCION LISTAR COMBOS FAVORITOS ################################
public function ListarCombosFavoritos()
{
	self::SetNames();
    $sql = "SELECT
	idcombo,
	codcombo,
	nomcombo,
	preciocompra,
	precioventa,
	existencia,
	stockminimo,
	stockmaximo,
	ivacombo,
	desccombo,
	preparado,
	favorito,
	codsucursal
	FROM combos WHERE codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	AND existencia > 0
	AND favorito = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR COMBOS FAVORITOS ################################

########################### FUNCION LISTAR COMBOS EN STOCK MINIMO ################################
public function ListarCombosMinimo()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	categorias.nomcategoria,
	GROUP_CONCAT(combosxproductos.cantidad, ' | ', productos2.producto, ' | ', categorias.nomcategoria SEPARATOR '<br>') AS detalles_productos,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN combosxproductos ON combos.codcombo = combosxproductos.codcombo
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
       (SELECT
       productos.codproducto, productos.producto, productos.codcategoria    
       FROM productos WHERE codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."') productos2 ON productos2.codproducto = combosxproductos.codproducto
       LEFT JOIN categorias ON productos2.codcategoria = categorias.codcategoria 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'
	AND	CAST(combos.existencia AS DECIMAL(10,2)) <= CAST(combos.stockminimo AS DECIMAL(10,2))
	GROUP BY combos.codcombo
	ORDER BY combos.codcombo DESC";
    foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else { 

    $sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	categorias.nomcategoria,
	GROUP_CONCAT(combosxproductos.cantidad, ' | ', productos2.producto, ' | ', categorias.nomcategoria SEPARATOR '<br>') AS detalles_productos,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN combosxproductos ON combos.codcombo = combosxproductos.codcombo
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
       (SELECT
       productos.codproducto, productos.producto, productos.codcategoria    
       FROM productos WHERE codsucursal = '".limpiar($_SESSION["codsucursal"])."') productos2 ON productos2.codproducto = combosxproductos.codproducto
       LEFT JOIN categorias ON productos2.codcategoria = categorias.codcategoria 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE combos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	AND CAST(combos.existencia AS DECIMAL(10,2)) <= CAST(combos.stockminimo AS DECIMAL(10,2))
	GROUP BY combos.codcombo
	ORDER BY combos.codcombo DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
########################## FUNCION LISTAR COMBOS EN STOCK MINIMO ################################

########################### FUNCION LISTAR COMBOS EN STOCK MAXIMO ################################
public function ListarCombosMaximo()
	{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	categorias.nomcategoria,
	GROUP_CONCAT(combosxproductos.cantidad, ' | ', productos2.producto, ' | ', categorias.nomcategoria SEPARATOR '<br>') AS detalles_productos,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN combosxproductos ON combos.codcombo = combosxproductos.codcombo
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
       (SELECT
       productos.codproducto, productos.producto, productos.codcategoria    
       FROM productos WHERE codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."') productos2 ON productos2.codproducto = combosxproductos.codproducto
       LEFT JOIN categorias ON productos2.codcategoria = categorias.codcategoria 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'
	AND	CAST(combos.existencia AS DECIMAL(10,2)) >= CAST(combos.stockmaximo AS DECIMAL(10,2))
	GROUP BY combos.codcombo
	ORDER BY combos.codcombo DESC";
    foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else { 

    $sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	categorias.nomcategoria,
	GROUP_CONCAT(combosxproductos.cantidad, ' | ', productos2.producto, ' | ', categorias.nomcategoria SEPARATOR '<br>') AS detalles_productos,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN combosxproductos ON combos.codcombo = combosxproductos.codcombo
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
       (SELECT
       productos.codproducto, productos.producto, productos.codcategoria    
       FROM productos WHERE codsucursal = '".limpiar($_SESSION["codsucursal"])."') productos2 ON productos2.codproducto = combosxproductos.codproducto
       LEFT JOIN categorias ON productos2.codcategoria = categorias.codcategoria 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	AND CAST(combos.existencia AS DECIMAL(10,2)) >= CAST(combos.stockmaximo AS DECIMAL(10,2))
	GROUP BY combos.codcombo
	ORDER BY combos.codcombo DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
########################## FUNCION LISTAR COMBOS EN STOCK MAXIMO ################################

############################# FUNCION LISTAR COMBOS EN MODAL ################################
public function ListarCombosModal()
{
	self::SetNames();
	$sql = "SELECT 
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2  
    WHERE combos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
    AND combos.existencia != '0.00'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR COMBOS EN MODAL ################################

############################# FUNCION LISTAR COMBOS PARA MENU ################################
public function ListarCombosMenu()
	{
	self::SetNames();
    $sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	categorias.nomcategoria,
	GROUP_CONCAT(combosxproductos.cantidad, ' | ', productos2.producto SEPARATOR '<br>') AS detalles_productos,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN combosxproductos ON combos.codcombo = combosxproductos.codcombo
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
       (SELECT
       productos.codproducto, productos.producto, productos.codcategoria    
       FROM productos WHERE codsucursal = '".limpiar($_SESSION["codsucursal"])."') productos2 ON productos2.codproducto = combosxproductos.codproducto
       LEFT JOIN categorias ON productos2.codcategoria = categorias.codcategoria 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	GROUP BY combos.codcombo
	ORDER BY combos.codcombo DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################## FUNCION LISTAR COMBOS PARA MENU ################################

############################ FUNCION ID COMBOS #################################
public function CombosPorId()
{
	self::SetNames();
	$sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	combos.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codcombo = ? AND combos.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcombo"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID COMBOS #################################

############################ FUNCION ID PRODUCTOS #################################
public function DetallesComboPorId()
{
	self::SetNames();
	$sql = "SELECT
	idcombo,
	codcombo,
	nomcombo,
	preciocompra,
	precioventa,
	existencia,
	stockminimo,
	stockmaximo,
	ivacombo,
	desccombo,
	preparado,
	favorito
	FROM combos 
	WHERE codcombo = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["d_codigo"]),limpiar($_SESSION["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID PRODUCTOS #################################

############################ FUNCION ACTUALIZAR COMBOS ############################
public function ActualizarCombos()
	{
	self::SetNames();
	if(empty($_POST["codcombo"]) or empty($_POST["nomcombo"]) or empty($_POST["existencia"]))
	{
	    echo "1";
		exit;
	}

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();
	if (isset($_POST["codproducto"])) {
	    for($i=0;$i<count($_POST['codproducto']);$i++){  //recorro el array
		   if (!empty($_POST['codproducto'][$i])) {

		        if($_POST['cantidad'][$i] == "" || $_POST['cantidad'][$i] == 0 || $_POST['cantidad'][$i] == 0.00){

		            echo "2";
		            exit;
	            }
	            elseif ($_POST['cantidad'][$i] > $_POST['existencia2'][$i]) 
	            { 
	            	echo "3";
	            	exit;
	            }
		   }
       }
	}
	$this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################

	$sql = "SELECT codcombo FROM combos WHERE idcombo != ? AND codcombo = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["idcombo"],$_POST["codcombo"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE combos set"
		." nomcombo = ?, "
		." preciocompra = ?, "
		." precioventa = ?, "
		." existencia = ?, "
		." stockminimo = ?, "
		." stockmaximo = ?, "
		." ivacombo = ?, "
		." desccombo = ?, "
		." preparado = ?, "
		." favorito = ? "
		." where "
		." idcombo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomcombo);
		$stmt->bindParam(2, $preciocompra);
		$stmt->bindParam(3, $precioventa);
		$stmt->bindParam(4, $existencia);
		$stmt->bindParam(5, $stockminimo);
		$stmt->bindParam(6, $stockmaximo);
		$stmt->bindParam(7, $ivacombo);
		$stmt->bindParam(8, $desccombo);
		$stmt->bindParam(9, $preparado);
		$stmt->bindParam(10, $favorito);
		$stmt->bindParam(11, $idcombo);

		$nomcombo = limpiar($_POST["nomcombo"]);
		$preciocompra = limpiar($_POST["preciocompra"]);
		$precioventa = limpiar($_POST["precioventa"]);
		$existencia = limpiar($_POST["existencia"]);
		$stockminimo = limpiar($_POST["stockminimo"]);
		$stockmaximo = limpiar($_POST["stockmaximo"]);
		$ivacombo = limpiar($_POST["ivacombo"]);
		$desccombo = limpiar($_POST["desccombo"]);
		$preparado = limpiar($_POST["preparado"]);
		$favorito = limpiar($_POST["favorito"]);
		$codcombo = limpiar($_POST["codcombo"]);
		$idcombo = limpiar($_POST["idcombo"]);
		$stmt->execute();

	##################  SUBIR FOTO DE COMBO ######################################
     //datos del arhivo  
    if (isset($_FILES['imagen']['name'])) { $nombre_archivo = $_FILES['imagen']['name']; } else { $nombre_archivo =''; }
    if (isset($_FILES['imagen']['type'])) { $tipo_archivo = $_FILES['imagen']['type']; } else { $tipo_archivo =''; }
    if (isset($_FILES['imagen']['size'])) { $tamano_archivo = $_FILES['imagen']['size']; } else { $tamano_archivo =''; } 
     //compruebo si las características del archivo son las que deseo  
    if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<8000000)//1MB 
	 {  
	 	if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/combos/".$nombre_archivo) && rename("fotos/combos/".$nombre_archivo,"fotos/combos/".$codcombo.".jpg"))
	 { 
	 ## se puede dar un aviso
	 } 
	 ## se puede dar otro aviso 
	 }
    ##################  FINALIZA SUBIR FOTO DE COMBO ######################################

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();
	if (isset($_POST["codproducto"])) {
	    for($i=0;$i<count($_POST['codproducto']);$i++){  //recorro el array
		   if (!empty($_POST['codproducto'][$i])) {

		   	$query = "UPDATE combosxproductos set"
		   	." cantidad = ? "
		   	." WHERE "
		   	." codcombo = ? AND codproducto = ? AND codsucursal = ?;
		   	";
		   	$stmt = $this->dbh->prepare($query);
		   	$stmt->bindParam(1, $cantidad);
		   	$stmt->bindParam(2, $codcombo);
		   	$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $codsucursal);

		   	$cantidad = limpiar($_POST['cantidad'][$i]);
		   	$codcombo = limpiar($_POST["codcombo"]);
		   	$codproducto = limpiar($_POST['codproducto'][$i]);
		    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		   	$stmt->execute();

		   }
       }
	}
	$this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################
        
	echo "<span class='fa fa-check-square-o'></span> EL COMBO HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "4";
		exit;
	}
}
############################ FUNCION ACTUALIZAR COMBOS ############################

############################ FUNCION AGREGAR PRODUCTOS A COMBOS ############################
public function AgregarProductos()
{
self::SetNames();
	if(empty($_POST["codcombo"]) or empty($_SESSION["CarritoProducto"]))
	{
		echo "1";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($v);$i++){

		$sql = "SELECT existencia
		FROM productos 
		WHERE codproducto = '".limpiar($v[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		
		$cantproductobd = $row['existencia'];
		$cantidad = $v[$i]['cantidad'];

        if($cantidad == "" || $cantidad == 0 || $cantidad == 0.00){

		    echo "2";
		    exit;
	    }
	    elseif ($cantidad > $cantproductobd) 
        { 
		    echo "3";
		    exit;
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();

	$detalle = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($detalle);$i++){

		$sql = "SELECT 
		codcombo, 
		codproducto 
		FROM combosxproductos 
		WHERE codcombo = '".limpiar($_POST['codcombo'])."' 
		AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num == 0)
		{

		$query = " INSERT INTO combosxproductos values (null, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcombo);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $cantidad);
		$stmt->bindParam(4, $codsucursal);
		
		$codcombo = limpiar($_POST["codcombo"]);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		} else {

		$sql = "SELECT 
		cantidad
		FROM combosxproductos 
		WHERE codcombo = '".limpiar($_POST['codcombo'])."' 
		AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidadbd = $row['cantidad'];

		$query = "UPDATE combosxproductos set"
		." cantidad = ? "
		." WHERE "
		." codcombo = ? AND codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantidad);
		$stmt->bindParam(2, $codcombo);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $codsucursal);

		$cantidad = limpiar($cantidadbd+$detalle[$i]['cantidad']);
		$codcombo = limpiar($_POST["codcombo"]);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		}
	}
	unset($_SESSION["CarritoProducto"]);
    $this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################

	############## ACTUALIZAMOS LOS PRECIO DEL COMBO ###################
    $sql2 = " UPDATE combos set "
    ." preciocompra = ?, "
    ." precioventa = ? "
    ." WHERE "
    ." codcombo = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->bindParam(1, $preciocompra);
    $stmt->bindParam(2, $precioventa);
    $stmt->bindParam(3, $codcombo);
	$stmt->bindParam(4, $codsucursal);

    $preciocompra = number_format($_POST["preciocomprabd"]+$_POST["preciocompra"], 2, '.', '');
    $precioventa = number_format($_POST["precioventabd"]+$_POST["precioventa"], 2, '.', '');
	$codcombo = limpiar($_POST["codcombo"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
    $stmt->execute();
    ############## ACTUALIZAMOS LOS PRECIO DEL COMBO ###################
        
	echo "<span class='fa fa-check-square-o'></span> LOS PRODUCTOS FUERON AGREGADOS AL COMBO EXITOSAMENTE";
	exit;
}
############################ FUNCION AGREGAR PRODUCTOS A COMBOS ############################

########################## FUNCION AJUSTAR STOCK DE COMBOS ###########################
public function SumarStockCombo()
{
	self::SetNames();
	if(empty($_POST["idcombo"]) or empty($_POST["cantidad"]))
	{
		echo "1";
	    exit;
	}
	elseif($_POST["cantidad"] == 0 || $_POST["cantidad"] == 0.00){

		echo "2";
		exit;
	}

	################ OBTENGO EXISTENCIA DE COMBO ################
	$sql = "SELECT
	codcombo,
	existencia,
	precioventa,
	ivacombo, 
	desccombo 
	FROM combos 
	WHERE idcombo = '".limpiar($_POST['idcombo'])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codcombobd = $row['codcombo'];
	$existenciabd = $row['existencia'];
	$precioventabd = $row['precioventa'];
	$ivacombobd = $row['ivacombo'];
	$desccombobd = $row['desccombo'];
    ################ OBTENGO EXISTENCIA DE COMBO ################

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 'ACTIVO'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
    $valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################
	
	################ ACTUALIZO EXISTENCIA DE COMBO ################
	$sql = "UPDATE combos set"
		  ." existencia = ? "
		  ." where "
		  ." idcombo = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$stmt->bindParam(2, $idcombo);
	
	$existencia = number_format($_POST["cantidad"] + $existenciabd, 2, '.', '');
	$idcombo = limpiar($_POST["idcombo"]);
	$stmt->execute();
	################ ACTUALIZO EXISTENCIA DE COMBO ################

	##################### REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX #####################
	$query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codproceso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codcombo);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivacombo);
	$stmt->bindParam(10, $desccombo);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14,$codsucursal);

	$codproceso = limpiar($codcombobd);
	$codresponsable = limpiar("0");
	$codcombo = limpiar($codcombobd);
	$movimiento = limpiar("ENTRADAS");
	$entradas = limpiar($_POST['cantidad']);
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = number_format($_POST["cantidad"] + $existenciabd, 2, '.', '');
	$ivacombo = limpiar($ivacombobd == "SI" ? $valor : "0.00");
	$desccombo = limpiar($desccombobd);
	$precio = limpiar($precioventabd);
	$documento = limpiar("SUMA DE STOCK");
	$fechakardex = limpiar(date("Y-m-d"));
	$codsucursal = limpiar($_SESSION["codsucursal"]);
	$stmt->execute();
    ##################### REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX #####################

	echo "<span class='fa fa-check-square-o'></span> LA CANTIDAD FUE SUMADA AL STOCK DEL COMBO EXITOSAMENTE";
	exit;
}
###################### FUNCION AJUSTAR STOCK DE COMBOS #########################

########################## FUNCION ELIMINAR DETALLES COMBOS ###########################
public function EliminarDetalleCombo()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT 
	preciocompra,
	precioventa FROM productos 
	WHERE codproducto = '".limpiar(decrypt($_GET["codproducto"]))."'
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
	$this->p[] = $row;
	}
	$preciocomprabd = $row["preciocompra"];
	$precioventabd = $row["precioventa"];

	$racionbd = decrypt($_GET["cantidad"]);
	$totalracioncompra = number_format($racionbd * $preciocomprabd, 2, '.', '');
	$totalracionventa = number_format($racionbd * $precioventabd, 2, '.', '');
    
    $sql = "DELETE FROM combosxproductos 
    WHERE codcombo = ? 
    AND codproducto = ? 
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codcombo);
	$stmt->bindParam(2,$codproducto);
	$stmt->bindParam(3,$codsucursal);

	$codcombo = limpiar(decrypt($_GET["codcombo"]));
	$codproducto = decrypt($_GET["codproducto"]);
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();

	############ ACTUALIZAMOS PRECIO DEL COMBO ################
    /*$sql2 = " UPDATE combos set "
    ." preciocompra = ?, "
    ." precioventa = ? "
    ." WHERE"
    ." codcombo = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->bindParam(1, $preciocompra);
    $stmt->bindParam(2, $precioventa);
    $stmt->bindParam(3, $codcombo);
    $stmt->bindParam(4, $codsucursal);

    $preciocompra = number_format($preciocomprabd-$totalracioncompra, 2, '.', '');
    $precioventa = number_format($precioventabd-$totalracionventa, 2, '.', '');
	$codcombo = limpiar(decrypt($_GET["codcombo"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
    $stmt->execute();*/
    ############ ACTUALIZAMOS PRECIO DEL COMBO ################

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
}
########################## FUNCION ELIMINAR DETALLES COMBOS #################################

########################## FUNCION ELIMINAR COMBOS ###########################
public function EliminarCombos()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codproducto FROM detalleventas WHERE codproducto = ? AND codsucursal = ? AND tipo = 2";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcombo"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM combos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcombo);
		$stmt->bindParam(2,$codsucursal);

		$codcombo = decrypt($_GET["codcombo"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		$sql = "DELETE FROM kardex_combos where codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcombo);
		$stmt->bindParam(2,$codsucursal);

		$codcombo = decrypt($_GET["codcombo"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		$sql = "DELETE FROM combosxproductos where codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcombo);
		$stmt->bindParam(2,$codsucursal);

		$codcombo = decrypt($_GET["codcombo"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		$codcombo = decrypt($_GET["codcombo"]);
		if (file_exists("fotos/combos/".$codcombo.".jpg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/combos/".$codcombo.".jpg";		
		unlink($archivos);
		}

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR COMBOS #################################

###################### FUNCION BUSCAR COMBOS FACTURADOS #########################
public function BuscarCombosVendidos() 
	{
	self::SetNames();
    $sql ="SELECT
	detalleventas.idproducto, 
	detalleventas.codproducto,
	detalleventas.producto,
	detalleventas.descproducto,
	detalleventas.ivaproducto,
	detalleventas.preciocompra, 
	detalleventas.precioventa, 
	combos.existencia,
	ventas.iva, 
	ventas.fechaventa, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	SUM(detalleventas.cantventa) as cantidad
	FROM (ventas INNER JOIN detalleventas ON ventas.codventa = detalleventas.codventa)
	INNER JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN combos ON detalleventas.idproducto = combos.idcombo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
    AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?
    AND detalleventas.tipo = 2
	GROUP BY detalleventas.codproducto, detalleventas.precioventa, detalleventas.descproducto 
	ORDER BY detalleventas.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN COMBOS FACTURADOS PARA EL RANGO DE FECHA INGRESADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION COMBOS FACTURADOS ###############################

######################## FUNCION BUSCA KARDEX COMBOS ##########################
public function BuscarKardexCombo() 
	{
	self::SetNames();
	$sql ="SELECT * FROM kardex_combos WHERE codcombo = ? AND codsucursal = ?";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codcombo"],decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN MOVIMIENTOS EN KARDEX PARA EL COMBO INGRESADO</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION BUSCA KARDEX COMBOS #########################

######################## FUNCION DETALLE KARDEX COMBO #########################
public function DetalleKardexCombo()
{
	self::SetNames();
	$sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.preparado,
	combos.favorito,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento
	FROM (combos INNER JOIN sucursales ON combos.codsucursal = sucursales.codsucursal)
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE combos.codcombo = ? AND combos.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codcombo"],decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION DETALLE KARDEX COMBO #########################

###################### FUNCION KARDEX COMBOS POR FECHAS #########################
public function BuscarKardexCombosValorizadoxFechas() 
{
	self::SetNames();
	$sql ="SELECT
	detalleventas.idproducto, 
	detalleventas.codproducto,
	detalleventas.producto,
	detalleventas.descproducto,
	detalleventas.ivaproducto,
	detalleventas.preciocompra, 
	detalleventas.precioventa, 
	combos.existencia,
	ventas.iva, 
	ventas.fechaventa, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	SUM(detalleventas.cantventa) as cantidad
	FROM (ventas INNER JOIN detalleventas ON ventas.codventa = detalleventas.codventa)
	INNER JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN combos ON detalleventas.idproducto = combos.idcombo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
    AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?
    AND detalleventas.tipo = 2
	GROUP BY detalleventas.codproducto, detalleventas.precioventa, detalleventas.descproducto 
	ORDER BY detalleventas.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION KARDEX COMBOS POR FECHAS ###############################

############################### FIN DE CLASE COMBOS ###############################































###################################### CLASE COMPRAS ###################################

############################# FUNCION REGISTRAR COMPRAS #############################
public function RegistrarCompras()
{
	self::SetNames();
	if(empty($_POST["codcompra"]) or empty($_POST["fechaemision"]) or empty($_POST["fecharecepcion"]) or empty($_POST["codproveedor"]))
	{
		echo "1";
		exit;
	}

	############## EN CASO DE SER A CREDITO ##############
	if (limpiar(isset($_POST['fechavencecredito']))) {  

		$fechaactual = date("Y-m-d");
		$fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));
		
	    if (strtotime($fechavence) < strtotime($fechaactual)) {
	  
	        echo "2";
		    exit;
	    }
    }
    ############## EN CASO DE SER A CREDITO ##############

	if(empty($_SESSION["CarritoCompra"]))
	{
		echo "3";
		exit;
	} 

    $sql = "SELECT codcompra FROM compras WHERE codcompra = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST['codcompra'],decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

    $query = "INSERT INTO compras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcompra);
	$stmt->bindParam(2, $codproveedor);
	$stmt->bindParam(3, $subtotalivasic);
	$stmt->bindParam(4, $subtotalivanoc);
	$stmt->bindParam(5, $ivac);
	$stmt->bindParam(6, $totalivac);
	$stmt->bindParam(7, $descontadoc);
	$stmt->bindParam(8, $descuentoc);
	$stmt->bindParam(9, $totaldescuentoc);
	$stmt->bindParam(10, $totalpagoc);
	$stmt->bindParam(11, $tipocompra);
	$stmt->bindParam(12, $formacompra);
	$stmt->bindParam(13, $fechavencecredito);
	$stmt->bindParam(14, $fechapagado);
	$stmt->bindParam(15, $observaciones);
	$stmt->bindParam(16, $statuscompra);
	$stmt->bindParam(17, $fechaemision);
	$stmt->bindParam(18, $fecharecepcion);
	$stmt->bindParam(19, $codigo);
	$stmt->bindParam(20, $codsucursal);
    
	$codcompra = limpiar($_POST["codcompra"]);
	$codproveedor = limpiar($_POST["codproveedor"]);
	$subtotalivasic = limpiar($_POST["txtsubtotal"]);
	$subtotalivanoc = limpiar($_POST["txtsubtotal2"]);
	$ivac = limpiar($_POST["iva"]);
	$totalivac = limpiar($_POST["txtIva"]);
	$descontadoc = limpiar($_POST["txtdescontado"]);
	$descuentoc = limpiar($_POST["descuento"]);
	$totaldescuentoc = limpiar($_POST["txtDescuento"]);
	$totalpagoc = limpiar($_POST["txtTotal"]);
	$tipocompra = limpiar($_POST["tipocompra"]);
	$formacompra = limpiar($_POST["tipocompra"]=="CONTADO" ? $_POST["formacompra"] : "CREDITO");
	$fechavencecredito = limpiar($_POST["tipocompra"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
    $fechapagado = limpiar("0000-00-00");
    $observaciones = limpiar($_POST["observaciones"]);
	$statuscompra = limpiar($_POST["tipocompra"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
    $fechaemision = limpiar(date("Y-m-d",strtotime($_POST['fechaemision'])));
    $fecharecepcion = limpiar(date("Y-m-d",strtotime($_POST['fecharecepcion'])));
	$codigo = limpiar($_SESSION["codigo"]);
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	
	$this->dbh->beginTransaction();

	$detalle = $_SESSION["CarritoCompra"];
	for($i=0;$i<count($detalle);$i++){

	$query = "INSERT INTO detallecompras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcompra);
    $stmt->bindParam(2, $tipo);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $producto);
    $stmt->bindParam(5, $codcategoria);
	$stmt->bindParam(6, $preciocomprac);
	$stmt->bindParam(7, $precioventac);
	$stmt->bindParam(8, $cantcompra);
	$stmt->bindParam(9, $ivaproductoc);
	$stmt->bindParam(10, $descproductoc);
	$stmt->bindParam(11, $descfactura);
	$stmt->bindParam(12, $valortotal);
	$stmt->bindParam(13, $totaldescuentoc);
	$stmt->bindParam(14, $subtotalimpuestos);
	$stmt->bindParam(15, $valorneto);
	$stmt->bindParam(16, $lotec);
	$stmt->bindParam(17, $fechaelaboracionc);
	$stmt->bindParam(18, $fechaexpiracionc);
    $stmt->bindParam(19, $codsucursal);
		
	$codcompra = limpiar($_POST['codcompra']);
	$tipo = limpiar($detalle[$i]['tipo']);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$producto = limpiar($detalle[$i]['producto']);
	$codcategoria = limpiar($detalle[$i]['codcategoria']);
	$preciocomprac = limpiar($detalle[$i]['precio']);
	$precioventac = limpiar($detalle[$i]['precio2']);
	$precioconiva = limpiar($detalle[$i]['ivaproducto'] == "0.00" ? "0.00" : $detalle[$i]['precio']);
	$cantcompra = limpiar(number_format($detalle[$i]['cantidad'], 2, '.', ''));
	$ivaproductoc = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproductoc = limpiar($detalle[$i]['descproducto']);
	$descfactura = limpiar($detalle[$i]['descproductofact']);
	$descuento = $detalle[$i]["descproductofact"]/100;
	$valortotal = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentoc = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto = 1 + ($_POST["iva"]/100);
	$Discriminado = $precioconiva/$ValorImpuesto;
    $SubtotalDiscriminado = $precioconiva - $Discriminado;
    $BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto = number_format($valortotal-$totaldescuentoc, 2, '.', '');
	$lotec = limpiar($detalle[$i]['lote']);
	$fechaelaboracionc = limpiar($detalle[$i]['fechaelaboracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaelaboracion'])));
	$fechaexpiracionc = limpiar($detalle[$i]['fechaexpiracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion'])));
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

	if(limpiar($detalle[$i]['tipo'])==1){// SI DETALLE ES UN PRODUCTO

    ############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
	$sql = "SELECT 
	ivaproducto,
	existencia 
	FROM productos 
	WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$ivaproductobd = $row['ivaproducto'];
	$existenciaproductobd = $row['existencia'];
	############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

	############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS COMPRADOS ###############
	$sql = "UPDATE productos set "
	      ." preciocompra = ?, "
		  ." precioventa = ?, "
		  ." existencia = ?, "
		  ." ivaproducto = ?, "
		  ." descproducto = ?, "
		  ." fechaelaboracion = ?, "
		  ." fechaexpiracion = ?, "
		  ." codproveedor = ?, "
		  ." lote = ? "
		  ." WHERE "
		  ." codproducto = ? AND codsucursal = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $preciocompra);
	$stmt->bindParam(2, $precioventa);
	$stmt->bindParam(3, $existencia);
	$stmt->bindParam(4, $ivaproducto);
	$stmt->bindParam(5, $descproducto);
	$stmt->bindParam(6, $fechaelaboracion);
	$stmt->bindParam(7, $fechaexpiracion);
	$stmt->bindParam(8, $codproveedor);
	$stmt->bindParam(9, $lote);
	$stmt->bindParam(10, $codproducto);
	$stmt->bindParam(11, $codsucursal);
	
	$preciocompra = limpiar($detalle[$i]['precio']);
	$precioventa = limpiar($detalle[$i]['precio2']);
	$existencia = limpiar(number_format($detalle[$i]['cantidad']+$existenciaproductobd, 2, '.', ''));
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$fechaelaboracion = limpiar($detalle[$i]['fechaelaboracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaelaboracion'])));
	$fechaexpiracion = limpiar($detalle[$i]['fechaexpiracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion'])));
	$codproveedor = limpiar($_POST['codproveedor']);
	$lote = limpiar($detalle[$i]['lote']);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS COMPRADOS ###############

	############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
    $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcompra);
	$stmt->bindParam(2, $codproveedor);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);	
	$stmt->bindParam(14, $codsucursal);	

	$codcompra = limpiar($_POST['codcompra']);
	$codproveedor = limpiar($_POST["codproveedor"]);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$movimiento = limpiar("ENTRADAS");
	$entradas= limpiar(number_format($detalle[$i]['cantidad'], 2, '.', ''));
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = limpiar(number_format($detalle[$i]['cantidad']+$existenciaproductobd, 2, '.', ''));
	$precio = limpiar($detalle[$i]["precio"]);
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$documento = limpiar("COMPRA");
	$fechakardex = limpiar(date("Y-m-d"));
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################

	} else {

	############### VERIFICO LA EXISTENCIA DEL INSUMO EN ALMACEN ################
	$sql = "SELECT 
	cantingrediente 
	FROM ingredientes 
	WHERE codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$existenciaingredientebd = $row['cantingrediente'];
	############### VERIFICO LA EXISTENCIA DEL INSUMO EN ALMACEN ################

	############# ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTES COMPRADOS ###############
	$sql = "UPDATE ingredientes set "
	      ." preciocompra = ?, "
		  ." precioventa = ?, "
		  ." cantingrediente = ?, "
		  ." ivaingrediente = ?, "
		  ." descingrediente = ?, "
		  ." fechaexpiracion = ?, "
		  ." codproveedor = ?, "
		  ." lote = ? "
		  ." WHERE "
		  ." codingrediente = ? AND codsucursal = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $preciocompra);
	$stmt->bindParam(2, $precioventa);
	$stmt->bindParam(3, $cantingrediente);
	$stmt->bindParam(4, $ivaingrediente);
	$stmt->bindParam(5, $descingrediente);
	$stmt->bindParam(6, $fechaexpiracion);
	$stmt->bindParam(7, $codproveedor);
	$stmt->bindParam(8, $lote);
	$stmt->bindParam(9, $codingrediente);
	$stmt->bindParam(10, $codsucursal);	
	
	$preciocompra = limpiar($detalle[$i]['precio']);
	$precioventa = limpiar($detalle[$i]['precio2']);
	$cantingrediente = limpiar(number_format($detalle[$i]['cantidad']+$existenciaingredientebd, 2, '.', ''));
	$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
	$descingrediente = limpiar($detalle[$i]['descproducto']);
	$fechaexpiracion = limpiar($detalle[$i]['fechaexpiracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion'])));
	$codproveedor = limpiar($_POST['codproveedor']);
	$lote = limpiar($detalle[$i]['lote']);
	$codingrediente = limpiar($detalle[$i]['txtCodigo']);
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############# ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTES COMPRADOS ###############

	############### REGISTRAMOS LOS DATOS DE INSUMOS EN KARDEX ###################
    $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcompra);
	$stmt->bindParam(2, $codproveedor);
	$stmt->bindParam(3, $codingrediente);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaingrediente);
	$stmt->bindParam(10, $descingrediente);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14, $codsucursal);			

	$codcompra = limpiar($_POST['codcompra']);
	$codproveedor = limpiar($_POST["codproveedor"]);
	$codingrediente = limpiar($detalle[$i]['txtCodigo']);
	$movimiento = limpiar("ENTRADAS");
	$entradas= limpiar(number_format($detalle[$i]['cantidad'], 2, '.', ''));
	$salidas = limpiar("0.00");
	$devolucion = limpiar("0.00");
	$stockactual = limpiar(number_format($detalle[$i]['cantidad']+$existenciaingredientebd, 2, '.', ''));
	$precio = limpiar($detalle[$i]["precio"]);
	$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descingrediente = limpiar($detalle[$i]['descproducto']);
	$documento = limpiar("COMPRA");
	$fechakardex = limpiar(date("Y-m-d"));
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############### REGISTRAMOS LOS DATOS DE INSUMOS EN KARDEX ###################

	     }
    }
	####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoCompra"]);
    $this->dbh->commit();
		
        echo "<span class='fa fa-check-square-o'></span> LA COMPRA DE PRODUCTOS E INGREDIENTES HA SIDO REGISTRADA EXITOSAMENTE <a href='reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR DOCUMENTO</strong></font color></a></div>";

        echo "<script>window.open('reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."', '_blank');</script>";
	    exit;

	} else {

		echo "4";
		exit;
	}
}
############################ FUNCION REGISTRAR COMPRAS ##########################

########################## FUNCION BUSQUEDA DE COMPRAS ###############################
public function BusquedaCompras()
	{
	self::SetNames();

    if ($_SESSION['acceso'] == "administradorG") {

    $sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE CONCAT(compras.codcompra, ' ',proveedores.cuitproveedor, ' ',proveedores.nomproveedor, ' ',compras.formacompra) LIKE '%".limpiar($_GET['bcompras'])."%' 
	AND compras.statuscompra = 'PAGADA' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0) {

	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</div></center>";
	exit;
		
	} else {
			
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
		}
	} else {

	$sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE CONCAT(compras.codcompra, ' ',proveedores.cuitproveedor, ' ',proveedores.nomproveedor, ' ',compras.formacompra) LIKE '%".limpiar($_GET['bcompras'])."%' 
	AND compras.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
    AND compras.statuscompra = 'PAGADA' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0) {

	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</div></center>";
	exit;
		
	} else {
			
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
		}
	}
}
########################## FUNCION BUSQUEDA DE COMPRAS ###############################

######################### FUNCION LISTAR COMPRAS ################################
public function ListarCompras()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE compras.statuscompra = 'PAGADA' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else {

	$sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE compras.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND compras.statuscompra = 'PAGADA' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
	}
}
################################## FUNCION LISTAR COMPRAS ############################

########################## FUNCION BUSQUEDA DE CUENTAS POR PAGAR ###############################
public function BusquedaCuentasxPagar()
	{
	self::SetNames();

    if ($_SESSION['acceso'] == "administradorG") {

    $sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE CONCAT(compras.codcompra, ' ',proveedores.cuitproveedor, ' ',proveedores.nomproveedor, ' ',compras.formacompra) LIKE '%".limpiar($_GET['bcompras'])."%' 
	AND compras.statuscompra = 'PENDIENTE' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0) {

	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</div></center>";
	exit;
		
	} else {
			
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
		}
	} else {

	$sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE CONCAT(compras.codcompra, ' ',proveedores.cuitproveedor, ' ',proveedores.nomproveedor, ' ',compras.formacompra) LIKE '%".limpiar($_GET['bcompras'])."%' 
	AND compras.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
    AND compras.statuscompra = 'PENDIENTE' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0) {

	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</div></center>";
	exit;
		
	} else {
			
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
		}
	}
}
########################## FUNCION BUSQUEDA DE CUENTAS POR PAGAR ###############################

########################### FUNCION LISTAR CUENTAS POR PAGAR #######################
public function ListarCuentasxPagar()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE compras.statuscompra = 'PENDIENTE' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else {

	$sql = "SELECT 
	compras.codcompra, 
	compras.codproveedor, 
	compras.subtotalivasic, 
	compras.subtotalivanoc, 
	compras.ivac, 
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc, 
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.statuscompra, 
	compras.fechavencecredito, 
	compras.fechapagado,
	compras.observaciones,
	compras.fecharecepcion, 
	compras.fechaemision, 
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor, 
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	SUM(detallecompras.cantcompra) AS articulos
	FROM (compras LEFT JOIN detallecompras ON detallecompras.codcompra = compras.codcompra) 
	LEFT JOIN sucursales ON compras.codsucursal = sucursales.codsucursal  
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE compras.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND compras.statuscompra = 'PENDIENTE' 
	GROUP BY detallecompras.codcompra 
	ORDER BY compras.idcompra DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
	}
}
######################### FUNCION LISTAR CUENTAS POR PAGAR ############################

############################ FUNCION PARA PAGAR COMPRAS ############################
public function PagarCompras()
	{
	if ($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"]=="secretaria") {
	
	self::SetNames();
	$sql = " UPDATE compras SET"
		  ." statuscompra = ?, "
		  ." fechapagado = ? "
		  ." WHERE "
		  ." codcompra = ? AND codsucursal = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statuscompra);
	$stmt->bindParam(2, $fechapagado);
	$stmt->bindParam(3, $codcompra);
	$stmt->bindParam(4, $codsucursal);

	$statuscompra = limpiar("PAGADA");
	$fechapagado = limpiar(date("Y-m-d"));
	$codcompra = limpiar(decrypt($_GET["codcompra"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();

	   echo "1";
	   exit;
	   
	} else {
	   
		echo "2";
		exit;
	}
}
########################## FUNCION PARA PAGAR COMPRAS ###############################

############################ FUNCION ID COMPRAS #################################
public function ComprasPorId()
{
	self::SetNames();
	$sql = "SELECT 
	compras.idcompra, 
	compras.codcompra,
	compras.codproveedor, 
	compras.subtotalivasic,
	compras.subtotalivanoc, 
	compras.ivac,
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc,
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.tipocompra,
	compras.formacompra,
	compras.fechavencecredito,
    compras.fechapagado,
    compras.observaciones,
	compras.statuscompra,
	compras.fechaemision,
	compras.fecharecepcion,
	compras.codigo,
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.tlfsucursal,
	sucursales.correosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.fechaautorsucursal,
	sucursales.llevacontabilidad,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor,
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	proveedores.tlfproveedor, 
	proveedores.id_provincia AS id_provincia2, 
	proveedores.id_departamento AS id_departamento2,
	proveedores.direcproveedor, 
	proveedores.emailproveedor,
	proveedores.vendedor,
	proveedores.tlfvendedor,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	provincias.provincia,
	departamentos.departamento,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2
	FROM (compras INNER JOIN sucursales ON compras.codsucursal = sucursales.codsucursal) 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento 
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON proveedores.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON proveedores.id_departamento = departamentos2.id_departamento 
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE compras.codcompra = ? AND compras.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcompra"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID COMPRAS #################################
	
############################ FUNCION VER DETALLES COMPRAS ############################
public function VerDetallesCompras()
	{
	self::SetNames();
	$sql = "SELECT
	detallecompras.coddetallecompra,
	detallecompras.codcompra,
	detallecompras.tipo,
	detallecompras.codproducto,
	detallecompras.producto,
	detallecompras.codcategoria,
	detallecompras.preciocomprac,
	detallecompras.precioventac,
	detallecompras.cantcompra,
	detallecompras.ivaproductoc,
	detallecompras.descproductoc,
	detallecompras.descfactura,
	detallecompras.valortotal, 
	detallecompras.totaldescuentoc,
	detallecompras.subtotalimpuestos,
	detallecompras.valorneto,
	detallecompras.lotec,
	detallecompras.fechaelaboracionc,
	detallecompras.fechaexpiracionc,
	detallecompras.codsucursal,
	categorias.nomcategoria,
	medidas.nommedida
	FROM detallecompras 
	LEFT JOIN categorias ON detallecompras.codcategoria = categorias.codcategoria 
	LEFT JOIN medidas ON detallecompras.codcategoria = medidas.codmedida 
	WHERE detallecompras.codcompra = ? 
	AND detallecompras.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcompra"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$this->p[]=$row;
	}
	return $this->p;
	$this->dbh=null;
}
############################ FUNCION VER DETALLES COMPRAS ##############################

############################## FUNCION ACTUALIZAR COMPRAS #############################
public function ActualizarCompras()
{
	self::SetNames();
	if(empty($_POST["codsucursal"]) or empty($_POST["codcompra"]) or empty($_POST["fechaemision"]) or empty($_POST["fecharecepcion"]) or empty($_POST["codproveedor"]))
	{
		echo "1";
		exit;
	}

	####################### SI LA COMPRA ES A CREDITO #######################
	if (limpiar(isset($_POST['fechavencecredito']))) {  

		$fechaactual = date("Y-m-d");
		$fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));
		
	    if (strtotime($fechavence) < strtotime($fechaactual)) {
	  
	        echo "2";
		    exit;
	    }
    }
    ####################### SI LA COMPRA ES A CREDITO #######################

	####################### VERIFICO QUE NO EXISTAN CANTIDAD IGUAL A CERO #######################
	for($i=0;$i<count($_POST['coddetallecompra']);$i++){  //recorro el array
        if (!empty($_POST['coddetallecompra'][$i])) {

	        if($_POST['cantcompra'][$i]==0){

		      echo "3";
		      exit;

	        }
        }
    }
    ####################### VERIFICO QUE NO EXISTAN CANTIDAD IGUAL A CERO #######################

    $this->dbh->beginTransaction();

    for($i=0;$i<count($_POST['coddetallecompra']);$i++){  //recorro el array
         if (!empty($_POST['coddetallecompra'][$i])) {

	############ OBTENGO CANTIDAD EN DETALLES ##############
    $sql = "SELECT 
	cantcompra 
	FROM detallecompras 
	WHERE coddetallecompra = '".limpiar($_POST['coddetallecompra'][$i])."' 
	AND codcompra = '".limpiar($_POST["codcompra"])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
		
	$cantidadbd = $row['cantcompra'];
	############ OBTENGO CANTIDAD EN DETALLES ##############

	if($cantidadbd != $_POST['cantcompra'][$i]){

		################## ACTUALIZO DETALLE DE COMPRAS ##################
		$query = "UPDATE detallecompras set"
		." cantcompra = ?, "
		." valortotal = ?, "
		." totaldescuentoc = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ? "
		." WHERE "
		." coddetallecompra = ? AND codcompra = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantcompra);
		$stmt->bindParam(2, $valortotal);
		$stmt->bindParam(3, $totaldescuento);
		$stmt->bindParam(4, $valorneto);
		$stmt->bindParam(5, $coddetallecompra);
		$stmt->bindParam(6, $codcompra);
		$stmt->bindParam(7, $codsucursal);

		$cantcompra = number_format($_POST['cantcompra'][$i], 2, '.', '');
		$preciocompra = limpiar($_POST['preciocompra'][$i]);
		$precioventa = limpiar($_POST['precioventa'][$i]);
		$ivaproducto = limpiar($_POST['ivaproducto'][$i]);
		$descuento = $_POST['descfactura'][$i]/100;
		$valortotal = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuento = number_format($_POST['totaldescuentoc'][$i], 2, '.', '');
	    $subtotalimpuestos = number_format($_POST['subtotalimpuestos'][$i], 2, '.', '');
		$valorneto = number_format($_POST['valorneto'][$i], 2, '.', '');
		$coddetallecompra = limpiar($_POST['coddetallecompra'][$i]);
		$codcompra = limpiar($_POST["codcompra"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################## ACTUALIZO DETALLE DE COMPRAS ##################

	if(limpiar($_POST['tipo'][$i])==1){// SI DETALLE ES UN PRODUCTO

		##################### OBTENGO EXISTENCIA POR CODIGO ####################
		$sql = "SELECT 
		existencia 
		FROM productos 
		WHERE codproducto = '".limpiar($_POST['codproducto'][$i])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    foreach ($this->dbh->query($sql) as $row)
	    {
		$this->p[] = $row;
	    }
	    $existenciaproductobd = $row['existencia'];
	    $cantcompra = $_POST["cantcompra"][$i];
	    $cantidadcomprabd = $_POST["cantidadcomprabd"][$i];
	    $totalcompra = $cantcompra-$cantidadcomprabd;
	    ##################### OBTENGO EXISTENCIA POR CODIGO ####################

	    ############ ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ################
	    $sql2 = " UPDATE productos set "
	    ." existencia = ? "
	    ." WHERE "
	    ." codproducto = '".limpiar($_POST["codproducto"][$i])."' 
		   AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	    ";
	    $stmt = $this->dbh->prepare($sql2);
	    $stmt->bindParam(1, $existencia);
	    $existencia = limpiar(number_format($existenciaproductobd+$totalcompra, 2, '.', ''));
	    $stmt->execute();
	    ############ ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ################

	    ############## ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###################
	    $sql3 = " UPDATE kardex_productos set "
	    ." entradas = ?, "
	    ." stockactual = ? "
	    ." WHERE "
	    ." codproceso = '".limpiar($_POST["codcompra"])."' 
	        AND codproducto = '".limpiar($_POST["codproducto"][$i])."'
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	    ";
	    $stmt = $this->dbh->prepare($sql3);
	    $stmt->bindParam(1, $entradas);
	    $stmt->bindParam(2, $existencia);

	    $entradas = limpiar(number_format($_POST["cantcompra"][$i], 2, '.', ''));
	    $existencia = limpiar(number_format($existenciaproductobd+$totalcompra, 2, '.', ''));
	    $stmt->execute();
	    ############## ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###################

		} else {// SI DETALLE ES UN INGREDIENTE

	    ############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ################	
		$sql = "SELECT 
		cantingrediente 
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($_POST['codproducto'][$i])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$cantcompra = $_POST["cantcompra"][$i];
		$cantidadcomprabd = $_POST["cantidadcomprabd"][$i];
		$totalcompra = $cantcompra-$cantidadcomprabd;
		############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ################

	    ############ ACTUALIZAMOS EXISTENCIA DEL INGREDIENTE EN ALMACEN ################
		$sql2 = " UPDATE ingredientes set "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = '".limpiar($_POST["codproducto"][$i])."'
		   AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->bindParam(1, $cantingrediente);
		$cantingrediente = limpiar(number_format($existenciaingredientebd+$totalcompra, 2, '.', ''));
		$stmt->execute();
		############ ACTUALIZAMOS EXISTENCIA DEL INGREDIENTE EN ALMACEN ################

	    ############## ACTUALIZAMOS LOS DATOS DEL INGREDIENTE EN KARDEX ###################
		$sql3 = " UPDATE kardex_ingredientes set "
		." entradas = ?, "
		." stockactual = ? "
		." WHERE "
		." codproceso = '".limpiar($_POST["codcompra"])."' 
		    AND codingrediente = '".limpiar($_POST["codproducto"][$i])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql3);
		$stmt->bindParam(1, $entradas);
		$stmt->bindParam(2, $cantingrediente);

		$entradas = limpiar(number_format($_POST["cantcompra"][$i], 2, '.', ''));
		$cantingrediente = limpiar(number_format($existenciaingredientebd+$totalcompra, 2, '.', ''));
		$stmt->execute();
		############## ACTUALIZAMOS LOS DATOS DEL INGREDIENTE EN KARDEX ###################

		}


		} else {

           echo "";

	       }
        }
    }

    $this->dbh->commit();

   ############ ACTUALIZO LOS TOTALES EN LA COMPRA ##############
	$sql = " UPDATE compras SET "
	." codproveedor = ?, "
	." subtotalivasic = ?, "
	." subtotalivanoc = ?, "
	." totalivac = ?, "
	." descontadoc = ?, "
	." descuentoc = ?, "
	." totaldescuentoc = ?, "
	." totalpagoc = ?, "
	." tipocompra = ?, "
	." formacompra = ?, "
	." fechavencecredito = ?, "
	." observaciones = ?, "
	." fechaemision = ?, "
	." fecharecepcion = ? "
	." WHERE "
	." codcompra = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $codproveedor);
	$stmt->bindParam(2, $subtotalivasi);
	$stmt->bindParam(3, $subtotalivano);
	$stmt->bindParam(4, $totaliva);
	$stmt->bindParam(5, $descontado);
	$stmt->bindParam(6, $descuento);
	$stmt->bindParam(7, $totaldescuento);
	$stmt->bindParam(8, $totalpago);
	$stmt->bindParam(9, $tipocompra);
	$stmt->bindParam(10, $formacompra);
	$stmt->bindParam(11, $fechavencecredito);
	$stmt->bindParam(12, $observaciones);
	$stmt->bindParam(13, $fechaemision);
	$stmt->bindParam(14, $fecharecepcion);
	$stmt->bindParam(15, $codcompra);
	$stmt->bindParam(16, $codsucursal);

	$codproveedor = limpiar($_POST["codproveedor"]);
	$subtotalivasi = number_format($_POST["txtsubtotal"], 2, '.', '');
	$subtotalivano = number_format($_POST["txtsubtotal2"], 2, '.', '');
	$totaliva = number_format($_POST["txtIva"], 2, '.', '');
	$descontado = number_format($_POST["txtdescontado"], 2, '.', '');
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = number_format($_POST["txtDescuento"], 2, '.', '');
	$totalpago = number_format($_POST["txtTotal"], 2, '.', '');
	$tipocompra = limpiar($_POST["tipocompra"]);
	$formacompra = limpiar($_POST["tipocompra"]=="CONTADO" ? $_POST["formacompra"] : "CREDITO");
	$fechavencecredito = limpiar($_POST["tipocompra"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
	$observaciones = limpiar($_POST["observaciones"]);
	$statuscompra = limpiar($_POST["tipocompra"]=="CONTADO" ? "PAGADA" : "PENDIENTE");			
	$fechaemision = limpiar(date("Y-m-d",strtotime($_POST['fechaemision'])));
	$fecharecepcion = limpiar(date("Y-m-d",strtotime($_POST['fecharecepcion'])));
	$codcompra = limpiar($_POST["codcompra"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

	echo "<span class='fa fa-check-square-o'></span> LA COMPRA DE PRODUCTOS E INGREDIENTES HA SIDO ACTUALIZADA EXITOSAMENTE <a href='reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

	echo "<script>window.open('reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."', '_blank');</script>";
	exit;
}
############################# FUNCION ACTUALIZAR COMPRAS #########################

########################## FUNCION ELIMINAR DETALLES COMPRAS ########################
public function EliminarDetallesCompras()
{
    self::SetNames();
	if ($_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT * FROM detallecompras WHERE codcompra = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcompra"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{

		#################### SELECCIONO DATOS DE COMPRA ####################
		$sql = "SELECT 
		tipo, 
		codproducto, 
		cantcompra, 
		preciocomprac, 
		ivaproductoc, 
		descproductoc 
		FROM detallecompras 
		WHERE coddetallecompra = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["coddetallecompra"]),decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$tipo = $row['tipo'];
		$codproducto = $row['codproducto'];
		$cantidadbd = $row['cantcompra'];
		$preciocomprabd = $row['preciocomprac'];
		$ivaproductobd = $row['ivaproductoc'];
		$descproductobd = $row['descproductoc'];
		#################### SELECCIONO DATOS DE COMPRA ####################

 	if(limpiar($tipo)==1){// SI DETALLE ES UN PRODUCTO

		########### SELECCIONO EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql2 = "SELECT 
		existencia 
		FROM productos 
		WHERE codproducto = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproducto,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		########### SELECCIONO EXISTENCIA DE PRODUCTO EN ALMACEN #############

		############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$existencia = limpiar(number_format($existenciaproductobd-$cantidadbd, 2, '.', ''));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);	

		$codcompra = limpiar(decrypt($_GET["codcompra"]));
	    $codproveedor = limpiar(decrypt($_GET["codproveedor"]));
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar(number_format($cantidadbd, 2, '.', ''));
		$stockactual = limpiar(number_format($existenciaproductobd-$cantidadbd, 2, '.', ''));
		$precio = limpiar($preciocomprabd);
		$ivaproducto = limpiar($ivaproductobd);
		$descproducto = limpiar($descproductobd);
		$documento = limpiar("DEVOLUCION COMPRA");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

	} else {// SI DETALLE ES UN INGREDIENTE

		############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ################
		$sql2 = "SELECT 
		cantingrediente 
		FROM ingredientes 
		WHERE codingrediente = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproducto,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ################

		############# ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql = "UPDATE ingredientes SET "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $cantingrediente);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$cantingrediente = limpiar(number_format($existenciaingredientebd-$cantidadbd, 2, '.', ''));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############# ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $codsucursal);		

		$codcompra = limpiar(decrypt($_GET["codcompra"]));
	    $codproveedor = limpiar(decrypt($_GET["codproveedor"]));
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar(number_format($cantidadbd, 2, '.', ''));
		$stockactual = limpiar(number_format($existenciaingredientebd-$cantidadbd, 2, '.', ''));
		$ivaingrediente = limpiar($ivaproductobd);
		$descingrediente = limpiar($descproductobd);
		$precio = limpiar($preciocomprabd);
		$documento = limpiar("DEVOLUCION COMPRA");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########

	}


	########## ELIMINAMOS EL PRODUCTO EN DETALLES DE COMPRAS ###########
	$sql = "DELETE FROM detallecompras WHERE coddetallecompra = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$coddetallecompra);
	$stmt->bindParam(2,$codsucursal);
	
	$coddetallecompra = limpiar(decrypt($_GET["coddetallecompra"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	########## ELIMINAMOS EL PRODUCTO EN DETALLES DE COMPRAS ###########

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
	$sql3 = "SELECT SUM(totaldescuentoc) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto FROM detallecompras WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproductoc != '0.00'";
	foreach ($this->dbh->query($sql3) as $row3)
	{
		$this->p[] = $row3;
	}
	$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	$subtotalimpuestos = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
	$subtotalivasic = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
	############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
	$sql4 = "SELECT SUM(totaldescuentoc) AS totaldescuentono, SUM(valorneto) AS valorneto FROM detallecompras WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproductoc = '0.00'";
	foreach ($this->dbh->query($sql4) as $row4)
	{
		$this->p[] = $row4;
	}
	$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
	$subtotalivanoc = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ############ ACTUALIZO LOS TOTALES EN LA COMPRAS ##############
	$sql = " UPDATE compras SET "
	." subtotalivasic = ?, "
	." subtotalivanoc = ?, "
	." totalivac = ?, "
	." descontadoc = ?, "
	." totaldescuentoc = ?, "
	." totalpagoc = ? "
	." WHERE "
	." codcompra = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $subtotalivasic);
	$stmt->bindParam(2, $subtotalivanoc);
	$stmt->bindParam(3, $totalivac);
	$stmt->bindParam(4, $descontadoc);
	$stmt->bindParam(5, $totaldescuentoc);
	$stmt->bindParam(6, $totalpagoc);
	$stmt->bindParam(7, $codcompra);
	$stmt->bindParam(8, $codsucursal);

	$totalivac= number_format($subtotalimpuestos, 2, '.', '');
	$descontadoc = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
    $total= number_format($subtotalivasic+$subtotalivanoc+$totalivac, 2, '.', '');
    $totaldescuentoc = number_format($total*$descuento, 2, '.', '');
    $totalpagoc = number_format($total-$totaldescuentoc, 2, '.', '');
	$codcompra = limpiar(decrypt($_GET["codcompra"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
###################### FUNCION ELIMINAR DETALLES COMPRAS #######################

####################### FUNCION ELIMINAR COMPRAS #################################
public function EliminarCompras()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT 
	tipo, 
	codproducto, 
	cantcompra, 
	preciocomprac, 
	ivaproductoc, 
	descproductoc 
	FROM detallecompras 
	WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."'
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";

	$array=array();

	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;

		$tipo = $row['tipo'];
		$codproducto = $row['codproducto'];
		$cantidadbd = $row['cantcompra'];
		$preciocomprabd = $row['preciocomprac'];
		$ivaproductobd = $row['ivaproductoc'];
		$descproductobd = $row['descproductoc'];

	if(limpiar($tipo)==1){

		########### SELECCIONO EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql2 = "SELECT 
		existencia 
		FROM productos 
		WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproducto,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		########### SELECCIONO EXISTENCIA DE PRODUCTO EN ALMACEN #############

		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$existencia = limpiar(number_format($existenciaproductobd-$cantidadbd, 2, '.', ''));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);	

		$codcompra = limpiar(decrypt($_GET["codcompra"]));
	    $codproveedor = limpiar(decrypt($_GET["codproveedor"]));
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar($cantidadbd);
		$stockactual = limpiar($existenciaproductobd-$cantidadbd);
		$precio = limpiar($preciocomprabd);
		$ivaproducto = limpiar($ivaproductobd);
		$descproducto = limpiar($descproductobd);
		$documento = limpiar("DEVOLUCION COMPRA");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

	} else {

		############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ################
		$sql2 = "SELECT 
		cantingrediente 
		FROM ingredientes 
		WHERE codingrediente = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproducto,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ################

		############# ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql = "UPDATE ingredientes SET "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$existencia = limpiar(number_format($existenciaingredientebd-$cantidadbd, 2, '.', ''));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############# ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $codsucursal);		

		$codcompra = limpiar(decrypt($_GET["codcompra"]));
	    $codproveedor = limpiar(decrypt($_GET["codproveedor"]));
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar($cantidadbd);
		$stockactual = limpiar(number_format($existenciaingredientebd-$cantidadbd, 2, '.', ''));
		$ivaingrediente = limpiar($ivaproductobd);
		$descingrediente = limpiar($descproductobd);
		$precio = limpiar($preciocomprabd);
		$documento = limpiar("DEVOLUCION COMPRA");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();

		}

	}

		######################### ELIMINO COMPRA #########################
		$sql = "DELETE FROM compras WHERE codcompra = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcompra);
		$stmt->bindParam(2,$codsucursal);
		$codcompra = limpiar(decrypt($_GET["codcompra"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		######################### ELIMINO COMPRA #########################

		######################### ELIMINO DETALLE COMPRA #########################
		$sql = "DELETE FROM detallecompras WHERE codcompra = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcompra);
		$stmt->bindParam(2,$codsucursal);
		$codcompra = limpiar(decrypt($_GET["codcompra"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		######################### ELIMINO DETALLE COMPRA #########################

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
######################### FUNCION ELIMINAR COMPRAS #################################

###################### FUNCION BUSQUEDA COMPRAS POR FECHAS ###########################
public function BuscarComprasxFechas() 
{
	self::SetNames();
	$sql ="SELECT 
	compras.idcompra, 
	compras.codcompra,
	compras.codproveedor, 
	compras.subtotalivasic,
	compras.subtotalivanoc, 
	compras.ivac,
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc,
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.tipocompra,
	compras.formacompra,
	compras.fechavencecredito,
    compras.fechapagado,
    compras.observaciones,
	compras.statuscompra,
	compras.fechaemision,
	compras.fecharecepcion,
	compras.codigo,
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.correosucursal,
	sucursales.llevacontabilidad,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor,
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	proveedores.tlfproveedor, 
	proveedores.id_provincia, 
	proveedores.id_departamento, 
	proveedores.direcproveedor, 
	proveedores.emailproveedor,
	proveedores.vendedor,
	proveedores.tlfvendedor,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	provincias.provincia,
	departamentos.departamento,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2, 
	SUM(detallecompras.cantcompra) as articulos
	FROM (compras LEFT JOIN detallecompras ON compras.codcompra = detallecompras.codcompra)
	INNER JOIN sucursales ON compras.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento 
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON proveedores.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON proveedores.id_departamento = departamentos2.id_departamento 
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE compras.codsucursal = ? 
	AND DATE_FORMAT(compras.fecharecepcion,'%Y-%m-%d') BETWEEN ? AND ?
	GROUP BY detallecompras.codcompra";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA COMPRAS POR FECHAS ###########################

##################### FUNCION BUSQUEDA COMPRAS POR PROVEEDORES ###################
public function BuscarComprasxProveedor() 
{
	self::SetNames();
	$sql = "SELECT 
	compras.idcompra, 
	compras.codcompra,
	compras.codproveedor, 
	compras.subtotalivasic,
	compras.subtotalivanoc, 
	compras.ivac,
	compras.totalivac,
	compras.descontadoc, 
	compras.descuentoc,
	compras.totaldescuentoc, 
	compras.totalpagoc, 
	compras.tipocompra,
	compras.formacompra,
	compras.fechavencecredito,
    compras.fechapagado,
    compras.observaciones,
	compras.statuscompra,
	compras.fechaemision,
	compras.fecharecepcion,
	compras.codigo,
	compras.codsucursal,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.correosucursal,
	sucursales.llevacontabilidad,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	proveedores.documproveedor,
	proveedores.cuitproveedor, 
	proveedores.nomproveedor, 
	proveedores.tlfproveedor, 
	proveedores.id_provincia, 
	proveedores.id_departamento, 
	proveedores.direcproveedor, 
	proveedores.emailproveedor,
	proveedores.vendedor,
	proveedores.tlfvendedor,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3, 
	usuarios.dni, 
	usuarios.nombres,
	provincias.provincia,
	departamentos.departamento,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2, 
	SUM(detallecompras.cantcompra) as articulos
	FROM (compras LEFT JOIN detallecompras ON compras.codcompra = detallecompras.codcompra)
	INNER JOIN sucursales ON compras.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento 
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN proveedores ON compras.codproveedor = proveedores.codproveedor 
	LEFT JOIN documentos AS documentos3 ON proveedores.documproveedor = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON proveedores.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON proveedores.id_departamento = departamentos2.id_departamento 
	LEFT JOIN usuarios ON compras.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE compras.codsucursal = ? 
	AND compras.codproveedor = ? 
	GROUP BY detallecompras.codcompra";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"]),decrypt($_GET["codproveedor"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################### FUNCION BUSQUEDA COMPRAS POR PROVEEDORES ###################

############################# FIN DE CLASE COMPRAS ###################################






























###################################### CLASE TRASPASOS ##################################

######################### FUNCION REGISTRAR TRASPASOS #######################
public function RegistrarTraspasos()
{
	self::SetNames();
	if(empty($_POST["recibe"]) or empty($_POST["codsucursal"]) or empty($_POST["fechatraspaso"]))
	{
		echo "1";
		exit;
	}
	elseif(empty($_SESSION["CarritoTraspaso"]) || $_POST["txtTotal"]=="0.00")
	{
		echo "2";
		exit;
		
	}

    ############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoTraspaso"];
	for($i=0;$i<count($v);$i++){

	if(limpiar($v[$i]['tipo']) == 1){

			$sql = "SELECT existencia
			FROM productos 
			WHERE codproducto = '".$v[$i]['txtCodigo']."'
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			
			$existenciabd = $row['existencia'];
			$cantidad = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
			    echo "3";
			    exit;
		    }

	    } else { 

		    $sql = "SELECT 
		    cantingrediente 
		    FROM ingredientes 
		    WHERE codingrediente = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['cantingrediente'];
		    $cantidad = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		       echo "3";
		       exit;
	        }
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	$fecha = date("Y-m-d H:i:s");

	####################################################################################
	#                                                                                  #
	#                               CREO CODIGO DE TRASPASO                            #
	#                                                                                  #
	####################################################################################
	
	####################### OBTENGO DATOS DE TRASPASO #######################
	$sql = "SELECT
	codtraspaso 
	FROM traspasos 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'  
	ORDER BY idtraspaso DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$traspaso=$row["codtraspaso"];
	}
	####################### OBTENGO DATOS DE TRASPASO #######################
	
	####################### CREO CODIGO DE TRASPASO #######################
	if(empty($traspaso))
	{
		$codtraspaso = "1";

	} else {

		$codtraspaso = $traspaso + 1;
	}
	####################### CREO CODIGO DE TRASPASO #######################

    ####################################################################################
	#                                                                                  #
	#                               CREO CODIGO DE TRASPASO                            #
	#                                                                                  #
	####################################################################################

    ################################### REGISTRO LA COTIZACION ###################################
    $query = "INSERT INTO traspasos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $recibe);
	$stmt->bindParam(3, $subtotalivasi);
	$stmt->bindParam(4, $subtotalivano);
	$stmt->bindParam(5, $iva);
	$stmt->bindParam(6, $totaliva);
	$stmt->bindParam(7, $descontado);
	$stmt->bindParam(8, $descuento);
	$stmt->bindParam(9, $totaldescuento);
	$stmt->bindParam(10, $totalpago);
	$stmt->bindParam(11, $totalpago2);
	$stmt->bindParam(12, $fechatraspaso);
	$stmt->bindParam(13, $observaciones);
	$stmt->bindParam(14, $codigo);
	$stmt->bindParam(15, $codsucursal);
   
	$recibe = limpiar(decrypt($_POST["recibe"]));
	$subtotalivasi = limpiar($_POST["txtsubtotal"]);
	$subtotalivano = limpiar($_POST["txtsubtotal2"]);
	$iva = limpiar($_POST["iva"]);
	$totaliva = limpiar($_POST["txtIva"]);
	$descontado = limpiar($_POST["txtdescontado"]);
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago = limpiar($_POST["txtTotal"]);
	$totalpago2 = limpiar($_POST["txtTotalCompra"]);
    $fechatraspaso = limpiar($fecha);
    $observaciones = limpiar(isset($_POST['observaciones']) ? $_POST['observaciones'] : "");
	$codigo = limpiar($_SESSION["codigo"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################### REGISTRO LA COTIZACION ###################################

    $this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoTraspaso"];
	for($i=0;$i<count($detalle);$i++){

	################################### REGISTRO DETALLES DE TRASPASO ###################################
	$query = "INSERT INTO detalletraspasos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $tipo);
	$stmt->bindParam(3, $idproducto);
    $stmt->bindParam(4, $codproducto);
    $stmt->bindParam(5, $producto);
    $stmt->bindParam(6, $codcategoria);
	$stmt->bindParam(7, $preciocompra);
	$stmt->bindParam(8, $precioventa);
	$stmt->bindParam(9, $cantidad);
	$stmt->bindParam(10, $ivaproducto);
	$stmt->bindParam(11, $descproducto);
	$stmt->bindParam(12, $valortotal);
	$stmt->bindParam(13, $totaldescuentov);
	$stmt->bindParam(14, $subtotalimpuestos);
	$stmt->bindParam(15, $valorneto);
	$stmt->bindParam(16, $valorneto2);
	$stmt->bindParam(17, $lote);
	$stmt->bindParam(18, $fechaelaboracion);
	$stmt->bindParam(19, $fechaexpiracion);
	$stmt->bindParam(20, $codsucursal);
		
	$tipo = limpiar($detalle[$i]['tipo']);
	$idproducto = limpiar($detalle[$i]['id']);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$producto = limpiar($detalle[$i]['producto']);
	$codcategoria = limpiar($detalle[$i]['codcategoria']);
	$preciocompra = limpiar($detalle[$i]['precio']);
	$precioventa = limpiar($detalle[$i]['precio2']);
	$precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$cantidad = limpiar($detalle[$i]['cantidad']);
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$descuento = $detalle[$i]['descproducto']/100;
	$valortotal = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto = 1 + ($_POST["iva"]/100);
	$Discriminado = $precioconiva/$ValorImpuesto;
    $SubtotalDiscriminado = $precioconiva - $Discriminado;
    $BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto = number_format($valortotal-$totaldescuentov, 2, '.', '');
	$valorneto2 = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
	$lote = limpiar($detalle[$i]['lote']);
	$fechaelaboracion = limpiar($detalle[$i]['fechaelaboracion']);
	$fechaexpiracion = limpiar($detalle[$i]['fechaexpiracion']);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################### REGISTRO DETALLES DE TRASPASO ###################################


    ##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################

	if(limpiar($detalle[$i]['tipo']) == 1){// SI DETALLE ES UN PRODUCTO

	############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ##################
	$sql = "SELECT * FROM 
	productos 
	WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$existenciabd = $row['existencia'];
	############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ##################

	##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
	$sql = " UPDATE productos set "
		  ." existencia = ? "
		  ." where "
		  ." codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$canttraspaso = limpiar($detalle[$i]['cantidad']);
	$existencia = $existenciabd-$canttraspaso;
	$stmt->execute();
	##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	############### REGISTRAMOS LOS PRODUCTOS SALIENTES EN KARDEX ###############
    $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14, $codsucursal);

	$codresponsable = limpiar(decrypt($_POST["recibe"]));
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$movimiento = limpiar("SALIDAS");
	$entradas = limpiar("0.00");
	$salidas= limpiar($detalle[$i]['cantidad']);
	$devolucion = limpiar("0.00");
	$stockactual = limpiar($existenciabd-$detalle[$i]['cantidad']);
	$precio = limpiar($detalle[$i]["precio2"]);
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$documento = limpiar("TRASPASO: ".$codtraspaso);
	$fechakardex = limpiar(date("Y-m-d"));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############### REGISTRAMOS LOS PRODUCTOS SALIENTES EN KARDEX ###############

    } else {// SI DETALLE ES UN INGREDIENTE

    ############### VERIFICO LA EXISTENCIA DEL INSUMO EN ALMACEN ################
	$sql = "SELECT 
	cantingrediente 
	FROM ingredientes 
	WHERE codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cantingredientebd = $row['cantingrediente'];
	############### VERIFICO LA EXISTENCIA DEL INSUMO EN ALMACEN ################

	##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
	$sql = " UPDATE ingredientes set "
		  ." cantingrediente = ? "
		  ." where "
		  ." codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."' 
		     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $cantingrediente);
	$canttraspaso = limpiar($detalle[$i]['cantidad']);
	$cantingrediente = $cantingredientebd-$canttraspaso;
	$stmt->execute();
	##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	############### REGISTRAMOS LOS INGREDIENTES SALIENTES EN KARDEX ###############
    $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codingrediente);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaingrediente);
	$stmt->bindParam(10, $descingrediente);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14, $codsucursal);

	$codresponsable = limpiar(decrypt($_POST["recibe"]));
	$codingrediente = limpiar($detalle[$i]['txtCodigo']);
	$movimiento = limpiar("SALIDAS");
	$entradas = limpiar("0.00");
	$salidas= limpiar($detalle[$i]['cantidad']);
	$devolucion = limpiar("0.00");
	$stockactual = limpiar($existenciabd-$detalle[$i]['cantidad']);
	$precio = limpiar($detalle[$i]["precio2"]);
	$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descingrediente = limpiar($detalle[$i]['descproducto']);
	$documento = limpiar("TRASPASO: ".$codtraspaso);
	$fechakardex = limpiar(date("Y-m-d"));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############### REGISTRAMOS LOS INGREDIENTES SALIENTES EN KARDEX ###############

    }

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################


	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS ENTRANTES                                       #
	#                                                                                                        #
	##########################################################################################################

	if(limpiar($detalle[$i]['tipo']) == 1){// SI DETALLE ES UN PRODUCTO

	############ VERIFICO SI EL PRODUCTO YA EXISTE EN LA SUCURSAL QUE RECIBE ###########
	$sql = "SELECT 
	codproducto 
	FROM productos 
	WHERE codproducto = ?
	AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($detalle[$i]['txtCodigo']),limpiar(decrypt($_POST['recibe']))));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		############### OBTENGO DATOS DE PRODUCTOS SALIENTES ##################
		$sql = "SELECT * FROM 
		productos 
		WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
	    ############### OBTENGO DATOS DE PRODUCTOS SALIENTES ##################

	    ############################## REGISTRO DATOS DE PRODUCTOS ##############################
	    $query = "INSERT INTO productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproducto);
		$stmt->bindParam(2, $producto);
		$stmt->bindParam(3, $codcategoria);
		$stmt->bindParam(4, $preciocompra);
		$stmt->bindParam(5, $precioventa);
		$stmt->bindParam(6, $existencia);
		$stmt->bindParam(7, $stockminimo);
		$stmt->bindParam(8, $stockmaximo);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $codigobarra);
		$stmt->bindParam(12, $lote);
		$stmt->bindParam(13, $fechaelaboracion);
		$stmt->bindParam(14, $fechaexpiracion);
		$stmt->bindParam(15, $codproveedor);
		$stmt->bindParam(16, $stockteorico);
		$stmt->bindParam(17, $motivoajuste);
		$stmt->bindParam(18, $preparado);
		$stmt->bindParam(19, $favorito);
		$stmt->bindParam(20, $controlstockp);
		$stmt->bindParam(21, $recibe);

		$codproducto = limpiar($detalle[$i]["txtCodigo"]);
		$producto = limpiar($detalle[$i]["producto"]);
		$codcategoria = limpiar($detalle[$i]["codcategoria"]);
		$preciocompra = limpiar($detalle[$i]["precio"]);
		$precioventa = limpiar($detalle[$i]["precio2"]);
		$existencia = limpiar($detalle[$i]["cantidad"]);
		$stockminimo = limpiar($row["stockminimo"]);
		$stockmaximo = limpiar($row["stockmaximo"]);
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$codigobarra = limpiar($row["codigobarra"]);
		$lote = limpiar($row["lote"]);
		$fechaelaboracion = limpiar($detalle[$i]['fechaelaboracion']);
		$fechaexpiracion = limpiar($detalle[$i]['fechaexpiracion']);
		$codproveedor = limpiar($row["codproveedor"]);
		$stockteorico = limpiar("0");
		$motivoajuste = limpiar("NINGUNO");
		$preparado = limpiar($row["preparado"]);
		$favorito = limpiar($row["favorito"]);
		$controlstockp = limpiar($row["controlstockp"]);
		$recibe = limpiar(decrypt($_POST['recibe']));
		$stmt->execute();
		############################## REGISTRO DATOS DE PRODUCTOS ##############################

		############### REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $codsucursal);

		$codresponsable = limpiar(decrypt($_POST["codsucursal"]));
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("ENTRADAS");
		$entradas = limpiar($detalle[$i]['cantidad']);
		$salidas= limpiar("0");
		$devolucion = limpiar("0.00");
		$stockactual = limpiar($detalle[$i]['cantidad']);
		$precio = limpiar($detalle[$i]["precio2"]);
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$documento = limpiar("TRASPASO: ".$codtraspaso);
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	    ############## REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############

	} else {

		############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ##################
		$sql = "SELECT 
		existencia 
		FROM 
		productos 
		WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["recibe"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciarecibebd = $row['existencia'];
	    ############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ##################

	    ############################## ACTUALIZAMOS DATOS DE PRODUCTOS ##############################
		$sql = "UPDATE productos set "
		      ." preciocompra = ?, "
			  ." precioventa = ?, "
			  ." existencia = ?, "
			  ." ivaproducto = ?, "
			  ." descproducto = ?, "
			  ." lote = ?, "
			  ." fechaelaboracion = ?, "
			  ." fechaexpiracion = ? "
			  ." WHERE "
			  ." codproducto = ? AND codsucursal = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $preciocompra);
		$stmt->bindParam(2, $precioventa);
		$stmt->bindParam(3, $existencia);
		$stmt->bindParam(4, $ivaproducto);
		$stmt->bindParam(5, $descproducto);
		$stmt->bindParam(6, $lote);
		$stmt->bindParam(7, $fechaelaboracion);
		$stmt->bindParam(8, $fechaexpiracion);
		$stmt->bindParam(9, $codproducto);
		$stmt->bindParam(10, $recibe);
		
		$preciocompra = limpiar($detalle[$i]['precio']);
		$precioventa = limpiar($detalle[$i]['precio2']);
		$existencia = limpiar($existenciarecibebd+$detalle[$i]['cantidad']);
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$lote = limpiar($detalle[$i]['lote']);
		$fechaelaboracion = limpiar($detalle[$i]['fechaelaboracion']);
		$fechaexpiracion = limpiar($detalle[$i]['fechaexpiracion']);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$recibe = limpiar(decrypt($_POST["recibe"]));
		$stmt->execute();
		############################## ACTUALIZAMOS DATOS DE PRODUCTOS ##############################

		############### REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $codsucursal);

		$codresponsable = limpiar(decrypt($_POST["codsucursal"]));
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("ENTRADAS");
		$entradas = limpiar($detalle[$i]['cantidad']);
		$salidas= limpiar("0");
		$devolucion = limpiar("0.00");
		$stockactual = limpiar($existenciarecibebd+$detalle[$i]['cantidad']);
		$precio = limpiar($detalle[$i]["precio2"]);
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$documento = limpiar("TRASPASO: ".$codtraspaso);
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["recibe"]));
		$stmt->execute();
	    ############## REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############

	    }//FIN DE REGISTRO DE PRODUCTOS

    } else {// SI DETALLE ES UN INGREDIENTE

    	############ VERIFICO SI EL PRODUCTO YA EXISTE EN LA SUCURSAL QUE RECIBE ###########
    	$sql = "SELECT 
    	codingrediente 
    	FROM ingredientes 
    	WHERE codingrediente = ?
    	AND codsucursal = ?";
    	$stmt = $this->dbh->prepare($sql);
    	$stmt->execute(array(limpiar($detalle[$i]['txtCodigo']),limpiar(decrypt($_POST['recibe']))));
    	$num = $stmt->rowCount();
    	if($num == 0)
    	{ 

    	############### OBTENGO DATOS DE INGREDIENTES SALIENTES ##################
		$sql = "SELECT * FROM 
		ingredientes 
		WHERE codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
	    ############### OBTENGO DATOS DE INGREDIENTES SALIENTES ##################

    	############################## REGISTRO DATOS DE INGREDIENTES ##############################
	    $query = "INSERT INTO ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codingrediente);
		$stmt->bindParam(2, $nomingrediente);
		$stmt->bindParam(3, $codmedida);
		$stmt->bindParam(4, $preciocompra);
		$stmt->bindParam(5, $precioventa);
		$stmt->bindParam(6, $cantingrediente);
		$stmt->bindParam(7, $stockminimo);
		$stmt->bindParam(8, $stockmaximo);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $lote);
		$stmt->bindParam(12, $fechaexpiracion);
		$stmt->bindParam(13, $codproveedor);
		$stmt->bindParam(14, $preparado);
		$stmt->bindParam(15, $favorito);
		$stmt->bindParam(16, $controlstocki);
		$stmt->bindParam(17, $recibe);

		$codingrediente = limpiar($detalle[$i]["txtCodigo"]);
		$nomingrediente = limpiar($detalle[$i]["producto"]);
		$codmedida = limpiar($detalle[$i]["codcategoria"]);
		$preciocompra = limpiar($detalle[$i]["precio"]);
		$precioventa = limpiar($detalle[$i]["precio2"]);
		$cantingrediente = limpiar($detalle[$i]["cantidad"]);
		$stockminimo = limpiar($row["stockminimo"]);
		$stockmaximo = limpiar($row["stockmaximo"]);
		$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
		$descingrediente = limpiar($detalle[$i]['descproducto']);
		$lote = limpiar($row["lote"]);
		$fechaexpiracion = limpiar($detalle[$i]['fechaexpiracion']);
		$codproveedor = limpiar($row["codproveedor"]);
		$preparado = limpiar($row["preparado"]);
		$favorito = limpiar($row["favorito"]);
		$controlstocki = limpiar($row["controlstocki"]);
		$recibe = limpiar(decrypt($_POST['recibe']));
		$stmt->execute();
		############################## REGISTRO DATOS DE INGREDIENTES ##############################

		############### REGISTRAMOS LOS INGREDIENTES ENTRANTES EN KARDEX ###############
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codingrediente);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $codsucursal);

		$codresponsable = limpiar(decrypt($_POST["codsucursal"]));
		$codingrediente = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("ENTRADAS");
		$entradas = limpiar($detalle[$i]['cantidad']);
		$salidas= limpiar("0");
		$devolucion = limpiar("0.00");
		$stockactual = limpiar($detalle[$i]['cantidad']);
		$precio = limpiar($detalle[$i]["precio2"]);
		$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descingrediente = limpiar($detalle[$i]['descproducto']);
		$documento = limpiar("TRASPASO: ".$codtraspaso);
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	    ############## REGISTRAMOS LOS INGREDIENTES ENTRANTES EN KARDEX ###############

	    } else {

	    ############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ##################
		$sql = "SELECT 
		cantingrediente 
		FROM 
		ingredientes 
		WHERE codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["recibe"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantrecibebd = $row['cantingrediente'];
	    ############### VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN ##################

	    ############################## ACTUALIZAMOS DATOS DE INGREDIENTES ##############################
		$sql = "UPDATE ingredientes set "
		      ." preciocompra = ?, "
			  ." precioventa = ?, "
			  ." cantingrediente = ?, "
			  ." ivaingrediente = ?, "
			  ." descingrediente = ?, "
			  ." lote = ?, "
			  ." fechaexpiracion = ? "
			  ." WHERE "
			  ." codingrediente = ? AND codsucursal = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $preciocompra);
		$stmt->bindParam(2, $precioventa);
		$stmt->bindParam(3, $cantingrediente);
		$stmt->bindParam(4, $ivaingrediente);
		$stmt->bindParam(5, $descingrediente);
		$stmt->bindParam(6, $lote);
		$stmt->bindParam(7, $fechaexpiracion);
		$stmt->bindParam(8, $codingrediente);
		$stmt->bindParam(9, $recibe);
		
		$preciocompra = limpiar($detalle[$i]['precio']);
		$precioventa = limpiar($detalle[$i]['precio2']);
		$cantingrediente = limpiar($cantrecibebd+$detalle[$i]['cantidad']);
		$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
		$descingrediente = limpiar($detalle[$i]['descproducto']);
		$lote = limpiar($detalle[$i]['lote']);
		$fechaexpiracion = limpiar($detalle[$i]['fechaexpiracion']);
		$codingrediente = limpiar($detalle[$i]['txtCodigo']);
		$recibe = limpiar(decrypt($_POST["recibe"]));
		$stmt->execute();
		############################## ACTUALIZAMOS DATOS DE INGREDIENTES ##############################

		############### REGISTRAMOS LOS INGREDIENTES ENTRANTES EN KARDEX ###############
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codingrediente);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $codsucursal);

		$codresponsable = limpiar(decrypt($_POST["codsucursal"]));
		$codingrediente = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("ENTRADAS");
		$entradas = limpiar($detalle[$i]['cantidad']);
		$salidas= limpiar("0");
		$devolucion = limpiar("0.00");
		$stockactual = limpiar($existenciarecibebd+$detalle[$i]['cantidad']);
		$precio = limpiar($detalle[$i]["precio2"]);
		$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descingrediente = limpiar($detalle[$i]['descproducto']);
		$documento = limpiar("TRASPASO: ".$codtraspaso);
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["recibe"]));
		$stmt->execute();
	    ############## REGISTRAMOS LOS INGREDIENTES ENTRANTES EN KARDEX ###############

	    }
    }

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS ENTRANTES                                       #
	#                                                                                                        #
	##########################################################################################################

    }

	####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoTraspaso"]);
    $this->dbh->commit();
    ################################### REGISTRO DETALLES DE FACTURA ###################################

	echo "<span class='fa fa-check-square-o'></span> EL TRASPASO DE PRODUCTOS HA SIDO REGISTRADO EXITOSAMENTE <a href='reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codresponsable)."&tipo=".encrypt("FACTURATRASPASO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR DOCUMENTO</strong></font color></a>";

	echo "<script>window.open('reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codresponsable)."&tipo=".encrypt("FACTURATRASPASO")."', '_blank');</script>";
	exit;
}
######################### FUNCION REGISTRAR TRASPASOS #########################

############################## FUNCION LISTAR TRASPASOS ################################
public function ListarTraspasos()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT 
	traspasos.idtraspaso, 
	traspasos.codtraspaso, 
	traspasos.recibe, 
	traspasos.subtotalivasi, 
	traspasos.subtotalivano, 
	traspasos.iva, 
	traspasos.totaliva,
	traspasos.descontado, 
	traspasos.descuento, 
	traspasos.totaldescuento,
	traspasos.totalpago, 
	traspasos.totalpago2, 
	traspasos.fechatraspaso, 
	traspasos.observaciones, 
	traspasos.codigo,
	traspasos.codsucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	documentos.documento,
	documentos2.documento AS documento2,
	sucursales2.documsucursal AS documsucursal2,
	sucursales2.cuitsucursal AS cuitsucursal2,
	sucursales2.nomsucursal AS nomsucursal2,
	sucursales2.documencargado AS documencargado2,
	sucursales2.dniencargado AS dniencargado2,
	sucursales2.nomencargado AS nomencargado2,
	documentos3.documento AS documento3,
	documentos4.documento AS documento4,
	SUM(detalletraspasos.cantidad) AS sumarticulos 
	FROM (traspasos LEFT JOIN detalletraspasos ON detalletraspasos.codtraspaso = traspasos.codtraspaso)
	LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN sucursales AS sucursales2 ON traspasos.recibe = sucursales2.codsucursal
	LEFT JOIN documentos AS documentos3 ON sucursales.documsucursal = documentos3.coddocumento
	LEFT JOIN documentos AS documentos4 ON sucursales.documencargado = documentos4.coddocumento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	GROUP BY traspasos.codtraspaso, traspasos.codsucursal 
	ORDER BY traspasos.idtraspaso ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else {

   $sql = "SELECT 
	traspasos.idtraspaso, 
	traspasos.codtraspaso, 
	traspasos.recibe, 
	traspasos.subtotalivasi, 
	traspasos.subtotalivano, 
	traspasos.iva, 
	traspasos.totaliva,
	traspasos.descontado, 
	traspasos.descuento, 
	traspasos.totaldescuento,
	traspasos.totalpago, 
	traspasos.totalpago2, 
	traspasos.fechatraspaso, 
	traspasos.observaciones, 
	traspasos.codigo,
	traspasos.codsucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	documentos.documento,
	documentos2.documento AS documento2,
	sucursales2.documsucursal AS documsucursal2,
	sucursales2.cuitsucursal AS cuitsucursal2,
	sucursales2.nomsucursal AS nomsucursal2,
	sucursales2.documencargado AS documencargado2,
	sucursales2.dniencargado AS dniencargado2,
	sucursales2.nomencargado AS nomencargado2,
	documentos3.documento AS documento3,
	documentos4.documento AS documento4,
	SUM(detalletraspasos.cantidad) AS sumarticulos 
	FROM (traspasos LEFT JOIN detalletraspasos ON detalletraspasos.codtraspaso = traspasos.codtraspaso)
	LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN sucursales AS sucursales2 ON traspasos.recibe = sucursales2.codsucursal
	LEFT JOIN documentos AS documentos3 ON sucursales.documsucursal = documentos3.coddocumento
	LEFT JOIN documentos AS documentos4 ON sucursales.documencargado = documentos4.coddocumento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE traspasos.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	OR traspasos.recibe = '".limpiar($_SESSION["codsucursal"])."' 
	GROUP BY traspasos.codtraspaso, traspasos.codsucursal 
	ORDER BY traspasos.idtraspaso ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

     }
}
############################ FUNCION LISTAR TRASPASOS ############################

############################ FUNCION ID TRASPASOS #################################
public function TraspasosPorId()
	{
	self::SetNames();
	$sql = "SELECT 
	traspasos.idtraspaso, 
	traspasos.codtraspaso, 
	traspasos.recibe, 
	traspasos.subtotalivasi, 
	traspasos.subtotalivano, 
	traspasos.iva, 
	traspasos.totaliva,
	traspasos.descontado, 
	traspasos.descuento, 
	traspasos.totaldescuento,
	traspasos.totalpago, 
	traspasos.totalpago2, 
	traspasos.fechatraspaso, 
	traspasos.observaciones, 
	traspasos.codigo,
	traspasos.codsucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	provincias.provincia,
	departamentos.departamento,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	documentos.documento,
	documentos2.documento AS documento2,
	sucursales2.documsucursal AS documsucursal2,
	sucursales2.cuitsucursal AS cuitsucursal2,
	sucursales2.nomsucursal AS nomsucursal2,
	sucursales.codgiro AS codgiro2,
	sucursales.girosucursal AS girosucursal2,
	sucursales2.id_provincia AS id_provincia2,
	sucursales2.id_departamento AS id_departamento2,
	sucursales2.direcsucursal AS direcsucursal2,
	sucursales2.correosucursal AS correosucursal2,
	sucursales2.tlfsucursal AS tlfsucursal2,
	sucursales2.documencargado AS documencargado2,
	sucursales2.dniencargado AS dniencargado2,
	sucursales2.nomencargado AS nomencargado2,
	sucursales2.tlfencargado AS tlfencargado2,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2,
	documentos3.documento AS documento3,
	documentos4.documento AS documento4,
	SUM(detalletraspasos.cantidad) AS sumarticulos 
	FROM (traspasos LEFT JOIN detalletraspasos ON detalletraspasos.codtraspaso = traspasos.codtraspaso)
	LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN sucursales AS sucursales2 ON traspasos.recibe = sucursales2.codsucursal
	LEFT JOIN documentos AS documentos3 ON sucursales.documsucursal = documentos3.coddocumento
	LEFT JOIN documentos AS documentos4 ON sucursales.documencargado = documentos4.coddocumento
	LEFT JOIN provincias AS provincias2 ON sucursales.id_provincia = provincias2.id_provincia
	LEFT JOIN departamentos AS departamentos2 ON sucursales.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE traspasos.codtraspaso = ? AND traspasos.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codtraspaso"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID TRASPASOS #################################

########################### FUNCION VER DETALLES TRASPASOS ##########################
public function VerDetallesTraspasos()
	{
	self::SetNames();
	$sql = "SELECT
	detalletraspasos.coddetalletraspaso,
	detalletraspasos.codtraspaso,
	detalletraspasos.tipo,
	detalletraspasos.idproducto,
	detalletraspasos.codproducto,
	detalletraspasos.producto,
	detalletraspasos.codcategoria,
	detalletraspasos.cantidad,
	detalletraspasos.preciocompra,
	detalletraspasos.precioventa,
	detalletraspasos.ivaproducto,
	detalletraspasos.descproducto,
	detalletraspasos.valortotal, 
	detalletraspasos.totaldescuentov,
	detalletraspasos.subtotalimpuestos,
	detalletraspasos.valorneto,
	detalletraspasos.lote,
	detalletraspasos.fechaelaboracion,
	detalletraspasos.fechaexpiracion,
	detalletraspasos.codsucursal,
	categorias.nomcategoria,
	medidas.nommedida
	FROM detalletraspasos 
	LEFT JOIN categorias ON detalletraspasos.codcategoria = categorias.codcategoria
	LEFT JOIN medidas ON detalletraspasos.codcategoria = medidas.codmedida
	WHERE detalletraspasos.codtraspaso = ? AND detalletraspasos.codsucursal = ? 
	ORDER BY detalletraspasos.coddetalletraspaso ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codtraspaso"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$this->p[]=$row;
	}
		return $this->p;
		$this->dbh=null;
}
############################ FUNCION VER DETALLES TRASPASOS #######################

############################ FUNCION ACTUALIZAR TRASPASOS ##########################
public function ActualizarTraspasos()
{
	self::SetNames();

}
######################### FUNCION ACTUALIZAR TRASPASOS ############################

########################## FUNCION ELIMINAR DETALLES TRASPASOS ##########################
public function EliminarDetallesTraspasos()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorS") {

    ############ CONSULTO DATOS DE TRASPASO ##############
	$sql = "SELECT * FROM traspasos 
	WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$recibebd = $row['recibe'];
	$totalpagobd = $row['totalpago'];
	############ CONSULTO DATOS DE TRASPASO ##############

	$sql = "SELECT * FROM detalletraspasos WHERE codtraspaso = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codtraspaso"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{

	############ OBTENGO DETALLES DE TRASPASO ##############
	$sql = "SELECT
	tipo,
	idproducto, 
	codproducto, 
	cantidad, 
	precioventa, 
	ivaproducto, 
	descproducto 
	FROM detalletraspasos 
	WHERE coddetalletraspaso = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["coddetalletraspaso"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();

	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$tipobd = $row['tipo'];
	$idproductobd = $row['idproducto'];
	$codproductobd = $row['codproducto'];
	$cantidadbd = $row['cantidad'];
	$precioventabd = $row['precioventa'];
	$ivaproductobd = $row['ivaproducto'];
	$descproductobd = $row['descproducto'];
	############ OBTENGO DETALLES DE TRASPASO ##############


    ######################### DATOS DE SUCURSAL QUE ENVIA TRASPASO #######################
    
    if($tipobd==1){// SI DETALLE ES UN PRODUCTO	
	
	############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
	$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();

	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$existenciabd = $row['existencia'];
	############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
	$sql = "UPDATE productos SET "
	." existencia = ? "
	." WHERE "
	." codproducto = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$stmt->bindParam(2, $codproductobd);
	$stmt->bindParam(3, $codsucursal);

	$existencia = limpiar($existenciabd+$cantidadbd);
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
	$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $recibe);
	$stmt->bindParam(3, $codproductobd);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);	
	$stmt->bindParam(14, $codsucursal);

	$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));
	$recibe = limpiar(decrypt($_GET["recibe"]));
	$movimiento = limpiar("DEVOLUCION");
	$entradas= limpiar("0.00");
	$salidas = limpiar("0.00");
	$devolucion = limpiar($cantidadbd);
	$stockactual = limpiar($existenciabd+$cantidadbd);
	$precio = limpiar($precioventabd);
	$ivaproducto = limpiar($ivaproductobd);
	$descproducto = limpiar($descproductobd);
	$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
	$fechakardex = limpiar(date("Y-m-d"));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

    } else {// SI DETALLE ES UN INGREDIENTE

    ############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
	$sql2 = "SELECT cantingrediente FROM ingredientes WHERE codingrediente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();

	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$cantingredientebd = $row['cantingrediente'];
	############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
	$sql = "UPDATE ingredientes SET "
	." cantingrediente = ? "
	." WHERE "
	." codingrediente = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $cantingrediente);
	$stmt->bindParam(2, $codproductobd);
	$stmt->bindParam(3, $codsucursal);

	$cantingrediente = limpiar($cantingredientebd+$cantidadbd);
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########
	$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $recibe);
	$stmt->bindParam(3, $codproductobd);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaingrediente);
	$stmt->bindParam(10, $descingrediente);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);	
	$stmt->bindParam(14, $codsucursal);

	$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));
	$recibe = limpiar(decrypt($_GET["recibe"]));
	$movimiento = limpiar("DEVOLUCION");
	$entradas= limpiar("0.00");
	$salidas = limpiar("0.00");
	$devolucion = limpiar($cantidadbd);
	$stockactual = limpiar($cantingredientebd+$cantidadbd);
	$precio = limpiar($precioventabd);
	$ivaingrediente = limpiar($ivaproductobd);
	$descingrediente = limpiar($descproductobd);
	$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
	$fechakardex = limpiar(date("Y-m-d"));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########

    }
	######################### DATOS DE SUCURSAL QUE ENVIA TRASPASO #######################


    ######################### DATOS DE SUCURSAL QUE RECIBE TRASPASO #######################	
    
    if($tipobd==1){// SI DETALLE ES UN PRODUCTO

	############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
	$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array($codproductobd,$recibebd));
	$num = $stmt->rowCount();

	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$existenciarecibebd = $row['existencia'];
	############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
	$sql = "UPDATE productos SET "
	." existencia = ? "
	." WHERE "
	." codproducto = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$stmt->bindParam(2, $codproductobd);
	$stmt->bindParam(3, $recibebd);

	$existencia = limpiar($existenciarecibebd-$cantidadbd);
	$stmt->execute();
	############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
	$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $codsucursal);
	$stmt->bindParam(3, $codproductobd);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14, $recibe);

	$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));			
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$movimiento = limpiar("DEVOLUCION");
	$entradas= limpiar("0.00");
	$salidas = limpiar("0.00");
	$devolucion = limpiar($cantidadbd);
	$stockactual = limpiar($existenciarecibebd-$cantidadbd);
	$precio = limpiar($precioventabd);
	$ivaproducto = limpiar($ivaproductobd);
	$descproducto = limpiar($descproductobd);
	$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
	$fechakardex = limpiar(date("Y-m-d"));
	$recibe = limpiar($recibebd);
	$stmt->execute();
	########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

    } else {// SI DETALLE ES UN INGREDIENTE

    ############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
	$sql2 = "SELECT cantingrediente FROM ingredientes WHERE codingrediente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array($codproductobd,$recibebd));
	$num = $stmt->rowCount();

	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$cantingredienterecibebd = $row['cantingrediente'];
	############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
	$sql = "UPDATE ingredientes SET "
	." cantingrediente = ? "
	." WHERE "
	." codingrediente = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $cantingrediente);
	$stmt->bindParam(2, $codproductobd);
	$stmt->bindParam(3, $recibebd);

	$cantingrediente = limpiar($cantingredienterecibebd-$cantidadbd);
	$stmt->execute();
	############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########
	$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $codsucursal);
	$stmt->bindParam(3, $codproductobd);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaingrediente);
	$stmt->bindParam(10, $descingrediente);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);
	$stmt->bindParam(14, $recibe);

	$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));			
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$movimiento = limpiar("DEVOLUCION");
	$entradas= limpiar("0.00");
	$salidas = limpiar("0.00");
	$devolucion = limpiar($cantidadbd);
	$stockactual = limpiar($cantingredienterecibebd-$cantidadbd);
	$precio = limpiar($precioventabd);
	$ivaingrediente = limpiar($ivaproductobd);
	$descingrediente = limpiar($descproductobd);
	$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
	$fechakardex = limpiar(date("Y-m-d"));
	$recibe = limpiar($recibebd);
	$stmt->execute();
	########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########

    }

	######################### DATOS DE SUCURSAL QUE RECIBE TRASPASO #######################


	########## ELIMINO DETALLES DE TRASPASOS ##########
	$sql = "DELETE FROM detalletraspasos WHERE coddetalletraspaso = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$coddetalletraspaso);
	$stmt->bindParam(2,$codsucursal);
	$coddetalletraspaso = decrypt($_GET["coddetalletraspaso"]);
	$codsucursal = decrypt($_GET["codsucursal"]);
	$stmt->execute();
	########## ELIMINO DETALLES DE TRASPASOS ##########

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
	$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detalletraspasos WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
	foreach ($this->dbh->query($sql3) as $row3)
	{
		$this->p[] = $row3;
	}
	$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	$subtotalimpuestos = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
	$subtotalivasi = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
	$subtotalivasi2 = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
	$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detalletraspasos WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
	foreach ($this->dbh->query($sql4) as $row4)
	{
		$this->p[] = $row4;
	}
	$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
	$subtotalivano = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
	$subtotalivano2 = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ############ ACTUALIZO LOS TOTALES EN EL TRASPASO ##############
	$sql = " UPDATE traspasos SET "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." totalpago2= ? "
	." WHERE "
	." codtraspaso = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $subtotalivasi);
	$stmt->bindParam(2, $subtotalivano);
	$stmt->bindParam(3, $totaliva);
	$stmt->bindParam(4, $descontado);
	$stmt->bindParam(5, $totaldescuento);
	$stmt->bindParam(6, $totalpago);
	$stmt->bindParam(7, $totalpago2);
	$stmt->bindParam(8, $codtraspaso);
	$stmt->bindParam(9, $codsucursal);

	$totaliva= number_format($subtotalimpuestos, 2, '.', '');
	$descontado = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
    $total= number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
    $totaldescuento= number_format($total*$descuento, 2, '.', '');
    $totalpago= number_format($total-$totaldescuento, 2, '.', '');
	$totalpago2 = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
	$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
######################### FUNCION ELIMINAR DETALLES TRASPASOS #########################

########################## FUNCION ELIMINAR TRASPASOS #############################
public function EliminarTraspasos()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorS") {

    ########################## CONSULTO DATOS DE TRASPASO ##########################
	$sql = "SELECT * FROM traspasos 
	WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$recibebd = $row['recibe'];
	$totalpagobd = $row['totalpago'];
	########################## CONSULTO DATOS DE TRASPASO ##########################

    $sql = "SELECT * FROM detalletraspasos 
    WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' 
    AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;

		$tipobd = $row['tipo'];
		$idproductobd = $row['idproducto'];
		$codproductobd = $row['codproducto'];
		$cantidadbd = $row['cantidad'];
		$precioventabd = $row['precioventa'];
		$ivaproductobd = $row['ivaproducto'];
		$descproductobd = $row['descproducto'];

        ######################### DATOS DE SUCURSAL QUE ENVIA TRASPASO #######################
        
        if($tipobd==1){// SI DETALLE ES UN PRODUCTO

        ############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute( array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciabd = $row['existencia'];
		############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN ############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproductobd);
		$stmt->bindParam(3, $codsucursal);

		$existencia = limpiar($existenciabd+$cantidadbd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN ############

	    ########### REGISTRAMOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ############
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $recibe);
		$stmt->bindParam(3, $codproductobd);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);

		$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));
	    $recibe = limpiar($recibebd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar($cantidadbd);
		$stockactual = limpiar($existenciabd+$cantidadbd);
		$precio = limpiar($precioventabd);
		$ivaproducto = limpiar($ivaproductobd);
		$descproducto = limpiar($descproductobd);
		$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### REGISTRAMOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ############

		} else {// SI DETALLE ES UN INGREDIENTE

		############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql2 = "SELECT cantingrediente FROM ingredientes WHERE codingrediente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$cantingredientebd = $row['cantingrediente'];
        ############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

        ############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql = "UPDATE ingredientes SET "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $cantingrediente);
		$stmt->bindParam(2, $codproductobd);
		$stmt->bindParam(3, $codsucursal);

		$cantingrediente = limpiar($cantingredientebd+$cantidadbd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
	    ############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $recibe);
		$stmt->bindParam(3, $codproductobd);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);

		$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));
		$recibe = limpiar($recibebd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar($cantidadbd);
		$stockactual = limpiar($cantingredientebd+$cantidadbd);
		$precio = limpiar($precioventabd);
		$ivaingrediente = limpiar($ivaproductobd);
		$descingrediente = limpiar($descproductobd);
		$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
	    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########

		}
		######################### DATOS DE SUCURSAL QUE ENVIA TRASPASO #######################			

		
		######################### DATOS DE SUCURSAL QUE RECIBE TRASPASO #######################			
        
        if($tipobd==1){// SI DETALLE ES UN PRODUCTO

		############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,$recibebd));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciarecibebd = $row['existencia'];
		############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

		############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproductobd);
		$stmt->bindParam(3, $recibebd);

		$existencia = limpiar($existenciarecibebd-$cantidadbd);
		$stmt->execute();
		############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codproductobd);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $recibe);

		$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));			
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar($cantidadbd);
		$stockactual = limpiar($existenciarecibebd-$cantidadbd);
		$precio = limpiar($precioventabd);
		$ivaproducto = limpiar($ivaproductobd);
		$descproducto = limpiar($descproductobd);
		$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
		$fechakardex = limpiar(date("Y-m-d"));
		$recibe = limpiar($recibebd);
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

	    } else {// SI DETALLE ES UN INGREDIENTE

	    ############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql2 = "SELECT cantingrediente FROM ingredientes WHERE codingrediente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,$recibebd));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$cantingredienterecibebd = $row['cantingrediente'];
		############ OBTENGO LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

		############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql = "UPDATE ingredientes SET "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $cantingrediente);
		$stmt->bindParam(2, $codproductobd);
		$stmt->bindParam(3, $recibebd);

		$cantingrediente = limpiar($cantingredienterecibebd-$cantidadbd);
		$stmt->execute();
		############ ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codproductobd);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $recibe);

		$codtraspaso = limpiar(decrypt($_GET["codtraspaso"]));			
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = limpiar($cantidadbd);
		$stockactual = limpiar($cantingredienterecibebd-$cantidadbd);
		$precio = limpiar($precioventabd);
		$ivaingrediente = limpiar($ivaproductobd);
		$descingrediente = limpiar($descproductobd);
		$documento = limpiar("DEVOLUCION TRASPASO: ".decrypt($_GET["codtraspaso"]));
		$fechakardex = limpiar(date("Y-m-d"));
		$recibe = limpiar($recibebd);
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ##########

	    }

		######################## DATOS DE SUCURSAL QUE RECIBE TRASPASO #######################		
	}

		########################## ELIMINO TRASPASOS ##########################
		$sql = "DELETE FROM traspasos WHERE codtraspaso = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codtraspaso);
		$stmt->bindParam(2,$codsucursal);
		$codtraspaso = decrypt($_GET["codtraspaso"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		########################## ELIMINO TRASPASOS ##########################

		########################## ELIMINO DETALLES TRASPASOS ##########################
		$sql = "DELETE FROM detalletraspasos WHERE codtraspaso = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codtraspaso);
		$stmt->bindParam(2,$codsucursal);
		$codtraspaso = decrypt($_GET["codtraspaso"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		########################## ELIMINO DETALLES TRASPASOS ##########################

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
########################## FUNCION ELIMINAR TRASPASOS ###########################

####################### FUNCION BUSQUEDA TRASPASOS POR SUCURSAL ######################
public function BuscarTraspasosxSucursal() 
	{
	self::SetNames();
	$sql ="SELECT 
	traspasos.idtraspaso, 
	traspasos.codtraspaso, 
	traspasos.recibe, 
	traspasos.subtotalivasi, 
	traspasos.subtotalivano, 
	traspasos.iva, 
	traspasos.totaliva,
	traspasos.descontado, 
	traspasos.descuento, 
	traspasos.totaldescuento,
	traspasos.totalpago, 
	traspasos.totalpago2, 
	traspasos.fechatraspaso, 
	traspasos.observaciones, 
	traspasos.codigo,
	traspasos.codsucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	provincias.provincia,
	departamentos.departamento,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	documentos.documento,
	documentos2.documento AS documento2,
	sucursales2.documsucursal AS documsucursal2,
	sucursales2.cuitsucursal AS cuitsucursal2,
	sucursales2.nomsucursal AS nomsucursal2,
	sucursales.codgiro AS codgiro2,
	sucursales.girosucursal AS girosucursal2,
	sucursales2.id_provincia AS id_provincia2,
	sucursales2.id_departamento AS id_departamento2,
	sucursales2.direcsucursal AS direcsucursal2,
	sucursales2.correosucursal AS correosucursal2,
	sucursales2.tlfsucursal AS tlfsucursal2,
	sucursales2.documencargado AS documencargado2,
	sucursales2.dniencargado AS dniencargado2,
	sucursales2.nomencargado AS nomencargado2,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2,
	documentos3.documento AS documento3,
	documentos4.documento AS documento4,
	SUM(detalletraspasos.cantidad) AS sumarticulos 
	FROM (traspasos LEFT JOIN detalletraspasos ON detalletraspasos.codtraspaso = traspasos.codtraspaso)
	LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN sucursales AS sucursales2 ON traspasos.recibe = sucursales2.codsucursal
	LEFT JOIN documentos AS documentos3 ON sucursales.documsucursal = documentos3.coddocumento
	LEFT JOIN documentos AS documentos4 ON sucursales.documencargado = documentos4.coddocumento
	LEFT JOIN provincias AS provincias2 ON sucursales.id_provincia = provincias2.id_provincia
	LEFT JOIN departamentos AS departamentos2 ON sucursales.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE traspasos.codsucursal = ?
	GROUP BY detalletraspasos.codtraspaso";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA TRASPASOS POR SUCURSAL ########################

####################### FUNCION BUSQUEDA TRASPASOS POR FECHAS #######################
public function BuscarTraspasosxFechas() 
	{
	self::SetNames();
	$sql ="SELECT 
	traspasos.idtraspaso, 
	traspasos.codtraspaso, 
	traspasos.recibe, 
	traspasos.subtotalivasi, 
	traspasos.subtotalivano, 
	traspasos.iva, 
	traspasos.totaliva,
	traspasos.descontado, 
	traspasos.descuento, 
	traspasos.totaldescuento,
	traspasos.totalpago, 
	traspasos.totalpago2, 
	traspasos.fechatraspaso, 
	traspasos.observaciones, 
	traspasos.codigo,
	traspasos.codsucursal,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	provincias.provincia,
	departamentos.departamento,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	documentos.documento,
	documentos2.documento AS documento2,
	sucursales2.documsucursal AS documsucursal2,
	sucursales2.cuitsucursal AS cuitsucursal2,
	sucursales2.nomsucursal AS nomsucursal2,
	sucursales.codgiro AS codgiro2,
	sucursales.girosucursal AS girosucursal2,
	sucursales2.id_provincia AS id_provincia2,
	sucursales2.id_departamento AS id_departamento2,
	sucursales2.direcsucursal AS direcsucursal2,
	sucursales2.correosucursal AS correosucursal2,
	sucursales2.tlfsucursal AS tlfsucursal2,
	sucursales2.documencargado AS documencargado2,
	sucursales2.dniencargado AS dniencargado2,
	sucursales2.nomencargado AS nomencargado2,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2,
	documentos3.documento AS documento3,
	documentos4.documento AS documento4,
	SUM(detalletraspasos.cantidad) AS sumarticulos 
	FROM (traspasos LEFT JOIN detalletraspasos ON detalletraspasos.codtraspaso = traspasos.codtraspaso)
	LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN sucursales AS sucursales2 ON traspasos.recibe = sucursales2.codsucursal
	LEFT JOIN documentos AS documentos3 ON sucursales.documsucursal = documentos3.coddocumento
	LEFT JOIN documentos AS documentos4 ON sucursales.documencargado = documentos4.coddocumento
	LEFT JOIN provincias AS provincias2 ON sucursales.id_provincia = provincias2.id_provincia
	LEFT JOIN departamentos AS departamentos2 ON sucursales.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE traspasos.codsucursal = ? 
	AND DATE_FORMAT(traspasos.fechatraspaso,'%Y-%m-%d') BETWEEN ? AND ? 
	GROUP BY detalletraspasos.codtraspaso";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA TRASPASOS POR FECHAS ###########################

###################### FUNCION BUSCAR DETALLES TRASPASOS POR FECHAS #########################
public function BuscarDetallesTraspasosxFechas() 
{
	self::SetNames();
	$sql ="SELECT 
	detalletraspasos.idproducto,
	detalletraspasos.codproducto,
	detalletraspasos.producto,
	detalletraspasos.codcategoria,
	detalletraspasos.descproducto,
	detalletraspasos.ivaproducto,
	detalletraspasos.preciocompra, 
	detalletraspasos.precioventa, 
	detalletraspasos.tipo, 
	productos.existencia,
	categorias.nomcategoria, 
	ingredientes.cantingrediente,
	medidas.nommedida,
	traspasos.fechatraspaso,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfsucursal,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.llevacontabilidad,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
    documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	provincias.provincia,
	departamentos.departamento,
	valor_cambio.montocambio,
	usuarios.dni,
	usuarios.nombres, 
	SUM(detalletraspasos.cantidad) as cantidad 
	FROM (traspasos INNER JOIN detalletraspasos ON traspasos.codtraspaso = detalletraspasos.codtraspaso) 
	LEFT JOIN productos ON detalletraspasos.idproducto = productos.idproducto
	LEFT JOIN categorias ON detalletraspasos.codcategoria = categorias.codcategoria  
	LEFT JOIN ingredientes ON detalletraspasos.idproducto = ingredientes.idingrediente
	LEFT JOIN medidas ON detalletraspasos.codcategoria = medidas.codmedida
	LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN usuarios ON traspasos.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE traspasos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	AND DATE_FORMAT(traspasos.fechatraspaso,'%Y-%m-%d') BETWEEN ? AND ? 
	GROUP BY detalletraspasos.codproducto, detalletraspasos.precioventa, detalletraspasos.ivaproducto, detalletraspasos.descproducto, detalletraspasos.tipo
	ORDER BY detalletraspasos.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN DETALLES COTIZADOS PARA EL RANGO DE FECHA INGRESADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION BUSCAR DETALLES TRASPASOS POR FECHAS ###############################

###################### FUNCION BUSCAR DETALLES TRASPASOS POR SUCURSAL #########################
public function BuscarDetallesTraspasosxSucursal() 
{
   self::SetNames();
	$sql ="SELECT 
	detalletraspasos.idproducto,
	detalletraspasos.codproducto,
	detalletraspasos.producto,
	detalletraspasos.codcategoria,
	detalletraspasos.descproducto,
	detalletraspasos.ivaproducto,
	detalletraspasos.preciocompra, 
	detalletraspasos.precioventa, 
	detalletraspasos.tipo, 
	productos.existencia,
	categorias.nomcategoria, 
	ingredientes.cantingrediente,
	medidas.nommedida,
	traspasos.fechatraspaso,
	sucursales.documsucursal,
	sucursales.cuitsucursal,
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.tlfsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	provincias.provincia,
	departamentos.departamento,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	sucursales2.documsucursal AS documsucursal2,
	sucursales2.cuitsucursal AS cuitsucursal2,
	sucursales2.nomsucursal AS nomsucursal2,
	sucursales.codgiro AS codgiro2,
	sucursales.girosucursal AS girosucursal2,
	sucursales2.id_provincia AS id_provincia2,
	sucursales2.id_departamento AS id_departamento2,
	sucursales2.direcsucursal AS direcsucursal2,
	sucursales2.correosucursal AS correosucursal2,
	sucursales2.tlfsucursal AS tlfsucursal2,
	sucursales2.documencargado AS documencargado2,
	sucursales2.dniencargado AS dniencargado2,
	sucursales2.nomencargado AS nomencargado2,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2,
	documentos3.documento AS documento3,
	documentos4.documento AS documento4,
	valor_cambio.montocambio,
	usuarios.dni,
	usuarios.nombres, 
	SUM(detalletraspasos.cantidad) as cantidad 
	FROM (traspasos INNER JOIN detalletraspasos ON traspasos.codtraspaso = detalletraspasos.codtraspaso) 
	LEFT JOIN productos ON detalletraspasos.idproducto = productos.idproducto
	LEFT JOIN categorias ON detalletraspasos.codcategoria = categorias.codcategoria  
	LEFT JOIN ingredientes ON detalletraspasos.idproducto = ingredientes.idingrediente
	LEFT JOIN medidas ON detalletraspasos.codcategoria = medidas.codmedida
	LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN usuarios ON traspasos.codigo = usuarios.codigo
	LEFT JOIN sucursales AS sucursales2 ON traspasos.recibe = sucursales2.codsucursal
	LEFT JOIN documentos AS documentos3 ON sucursales.documsucursal = documentos3.coddocumento
	LEFT JOIN documentos AS documentos4 ON sucursales.documencargado = documentos4.coddocumento
	LEFT JOIN provincias AS provincias2 ON sucursales.id_provincia = provincias2.id_provincia
	LEFT JOIN departamentos AS departamentos2 ON sucursales.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE traspasos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	AND traspasos.recibe = '".limpiar(decrypt($_GET['recibe']))."' 
	AND DATE_FORMAT(traspasos.fechatraspaso,'%Y-%m-%d') BETWEEN ? AND ? 
	GROUP BY detalletraspasos.codproducto, detalletraspasos.precioventa, detalletraspasos.ivaproducto, detalletraspasos.descproducto, detalletraspasos.tipo
	ORDER BY detalletraspasos.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN DETALLES COTIZADOS PARA EL RANGO DE FECHA INGRESADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSCAR DETALLES TRASPASOS POR SUCURSAL #########################

####################### FUNCION BUSQUEDA PRODUCTOS TRASPASOS POR FECHAS #######################
public function BuscarProductosTraspasos() 
	{
	self::SetNames();
   $sql ="SELECT 
   detalletraspasos.idproducto,
   detalletraspasos.codproducto,
   detalletraspasos.producto,
   detalletraspasos.codcategoria,
   detalletraspasos.preciocompra,
   detalletraspasos.precioventa,  
   detalletraspasos.ivaproducto,
   detalletraspasos.descproducto,
   productos.existencia,
   categorias.nomcategoria,
   traspasos.fechatraspaso,
   sucursales.documsucursal, 
   sucursales.cuitsucursal, 
   sucursales.nomsucursal,
   sucursales.codgiro,
   sucursales.girosucursal,
   sucursales.documencargado,
   sucursales.dniencargado,
   sucursales.nomencargado,
   sucursales.tlfsucursal,
   sucursales.direcsucursal,
   sucursales.correosucursal,
   sucursales.llevacontabilidad,
   sucursales.codmoneda,
   sucursales.codmoneda2,
   tiposmoneda.moneda,
   tiposmoneda.siglas,
   tiposmoneda.simbolo,
   tiposmoneda2.moneda AS moneda2,
   tiposmoneda2.siglas AS siglas2,
   tiposmoneda2.simbolo AS simbolo2,
   valor_cambio.montocambio,
   documentos.documento,
   documentos2.documento AS documento2,
   usuarios.dni,
   usuarios.nombres, 
   SUM(detalletraspasos.cantidad) as cantidad 
   FROM (traspasos INNER JOIN detalletraspasos ON traspasos.codtraspaso = detalletraspasos.codtraspaso)
   LEFT JOIN productos ON detalletraspasos.idproducto = productos.idproducto 
   LEFT JOIN categorias ON detalletraspasos.codcategoria = categorias.codcategoria
   LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
   LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
   LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
   LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
   LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
   LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
   LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
   LEFT JOIN usuarios ON traspasos.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
   WHERE traspasos.codsucursal = '".decrypt($_GET['codsucursal'])."'
   AND DATE_FORMAT(traspasos.fechatraspaso,'%Y-%m-%d') BETWEEN ? AND ?
   AND detalletraspasos.tipo = 1  
   GROUP BY detalletraspasos.codproducto, detalletraspasos.precioventa, detalletraspasos.descproducto 
   ORDER BY detalletraspasos.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	    echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA PRODUCTOS TRASPASOS POR FECHAS ###########################

####################### FUNCION BUSQUEDA INGREDIENTES TRASPASOS POR FECHAS #######################
public function BuscarIngredientesTraspasos() 
	{
	self::SetNames();
   $sql ="SELECT 
   detalletraspasos.idproducto,
   detalletraspasos.codproducto,
   detalletraspasos.producto,
   detalletraspasos.codcategoria,
   detalletraspasos.preciocompra,
   detalletraspasos.precioventa,  
   detalletraspasos.ivaproducto,
   detalletraspasos.descproducto,
   ingredientes.cantingrediente,
   medidas.nommedida,
   traspasos.fechatraspaso,
   sucursales.documsucursal, 
   sucursales.cuitsucursal, 
   sucursales.nomsucursal,
   sucursales.codgiro,
   sucursales.girosucursal,
   sucursales.documencargado,
   sucursales.dniencargado,
   sucursales.nomencargado,
   sucursales.tlfsucursal,
   sucursales.direcsucursal,
   sucursales.correosucursal,
   sucursales.llevacontabilidad,
   sucursales.codmoneda,
   sucursales.codmoneda2,
   tiposmoneda.moneda,
   tiposmoneda.siglas,
   tiposmoneda.simbolo,
   tiposmoneda2.moneda AS moneda2,
   tiposmoneda2.siglas AS siglas2,
   tiposmoneda2.simbolo AS simbolo2,
   valor_cambio.montocambio,
   documentos.documento,
   documentos2.documento AS documento2,
   usuarios.dni,
   usuarios.nombres, 
   SUM(detalletraspasos.cantidad) as cantidad 
   FROM (traspasos INNER JOIN detalletraspasos ON traspasos.codtraspaso = detalletraspasos.codtraspaso)
   LEFT JOIN ingredientes ON detalletraspasos.idproducto = ingredientes.idingrediente 
   LEFT JOIN medidas ON detalletraspasos.codcategoria = ingredientes.codmedida
   LEFT JOIN sucursales ON traspasos.codsucursal = sucursales.codsucursal
   LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
   LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
   LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
   LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
   LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
   LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
   LEFT JOIN usuarios ON traspasos.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
   WHERE traspasos.codsucursal = '".decrypt($_GET['codsucursal'])."'
   AND DATE_FORMAT(traspasos.fechatraspaso,'%Y-%m-%d') BETWEEN ? AND ?
   AND detalletraspasos.tipo = 2  
   GROUP BY detalletraspasos.codproducto, detalletraspasos.precioventa, detalletraspasos.descproducto 
   ORDER BY detalletraspasos.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	    echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA INGREDIENTES TRASPASOS POR FECHAS ###########################

################################## CLASE TRASPASOS ###################################





























############################## CLASE COTIZACIONES ###################################

########################### FUNCION REGISTRAR COTIZACIONES ##########################
public function RegistrarCotizaciones()
	{
	self::SetNames();
	if(empty($_POST["codsucursal"]) or empty($_POST["txtTotal"]))
	{
		echo "1";
		exit;
	}

	if(empty($_SESSION["CarritoCotizacion"]))
	{
		echo "2";
		exit;
	}

    ################### CREO CODIGO DE FACTURA ####################
	$sql4 = "SELECT codcotizacion FROM cotizaciones
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idcotizacion DESC LIMIT 1";
	foreach ($this->dbh->query($sql4) as $row4){

		$cotizacion=$row4["codcotizacion"];

	}
	if(empty($cotizacion))
	{
		$codcotizacion = "0000000001";

	} else {

        $var1 = substr($cotizacion , 0);
        $var2 = strlen($var1);
        $var3 = $var1 + 1;
        $var4 = str_pad($var3, $var2, "0", STR_PAD_LEFT);
        $codcotizacion = $var4;
	}
	################### CREO CODIGO DE FACTURA ####################

    $query = "INSERT INTO cotizaciones values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcotizacion);
	$stmt->bindParam(2, $codcliente);
	$stmt->bindParam(3, $subtotalivasi);
	$stmt->bindParam(4, $subtotalivano);
	$stmt->bindParam(5, $iva);
	$stmt->bindParam(6, $totaliva);
	$stmt->bindParam(7, $descontado);
	$stmt->bindParam(8, $descuento);
	$stmt->bindParam(9, $totaldescuento);
	$stmt->bindParam(10, $totalpago);
	$stmt->bindParam(11, $totalpago2);
	$stmt->bindParam(12, $observaciones);
	$stmt->bindParam(13, $fechacotizacion);
	$stmt->bindParam(14, $codigo);
	$stmt->bindParam(15, $codsucursal);
    
	$codcliente = limpiar($_POST["codcliente"]);
	$subtotalivasi = limpiar($_POST["txtsubtotal"]);
	$subtotalivano = limpiar($_POST["txtsubtotal2"]);
	$iva = limpiar($_POST["iva"]);
	$totaliva = limpiar($_POST["txtIva"]);
	$descontado = limpiar($_POST["txtdescontado"]);
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago = limpiar($_POST["txtTotal"]);
	$totalpago2 = limpiar($_POST["txtTotalCompra"]);
	$observaciones = limpiar($_POST["observaciones"]);
    $fechacotizacion = limpiar(date("Y-m-d H:i:s"));
	$codigo = limpiar($_SESSION["codigo"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	
	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoCotizacion"];
	for($i=0;$i<count($detalle);$i++){

	$query = "INSERT INTO detallecotizaciones values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcotizacion);
    $stmt->bindParam(2, $idproducto);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $producto);
    $stmt->bindParam(5, $codcategoria);
	$stmt->bindParam(6, $cantidad);
	$stmt->bindParam(7, $preciocompra);
	$stmt->bindParam(8, $precioventa);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $valortotal);
	$stmt->bindParam(12, $totaldescuentov);
	$stmt->bindParam(13, $subtotalimpuestos);
	$stmt->bindParam(14, $valorneto);
	$stmt->bindParam(15, $valorneto2);
	$stmt->bindParam(16, $detallesobservaciones);
	$stmt->bindParam(17, $detallesalsas);
	$stmt->bindParam(18, $preparado);
	$stmt->bindParam(19, $tipo);
	$stmt->bindParam(20, $codsucursal);
		
	$idproducto = limpiar($detalle[$i]['id']);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$producto = limpiar($detalle[$i]['producto']);
	$codcategoria = limpiar($detalle[$i]['codcategoria']);
	$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
	$preciocompra = limpiar($detalle[$i]['precio']);
	$precioventa = limpiar($detalle[$i]['precio2']);
	$precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$descuento = $detalle[$i]['descproducto']/100;
	$valortotal = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto = 1 + ($_POST["iva"]/100);
	$Discriminado = $precioconiva/$ValorImpuesto;
    $SubtotalDiscriminado = $precioconiva - $Discriminado;
    $BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto = number_format($valortotal-$totaldescuentov, 2, '.', '');
	$valorneto2 = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
	$detallesobservaciones = limpiar($detalle[$i]['observacion'] == ", " ? "" : $detalle[$i]['observacion']);
	$detallesalsas = limpiar($detalle[$i]['salsa'] == ", " ? "" : $detalle[$i]['salsa']);
	$preparado = limpiar($detalle[$i]['preparado']);
	$tipo = limpiar($detalle[$i]['tipo']);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
    }
        
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoCotizacion"]);
    $this->dbh->commit();

    echo "<span class='fa fa-check-square-o'></span> LA COTIZACIÓN HA SIDO REGISTRADA EXITOSAMENTE <a href='reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOTIZACION")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR DOCUMENTO</strong></font color></a>";

	echo "<script>window.open('reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOTIZACION")."', '_blank');</script>";
	exit;
}
########################## FUNCION REGISTRAR COTIZACIONES ############################

########################## FUNCION BUSQUEDA DE COTIZACIONES ###############################
public function BusquedaCotizaciones() 
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

  	$sql ="SELECT 
	cotizaciones.idcotizacion, 
	cotizaciones.codcotizacion,  
	cotizaciones.codcliente, 
	cotizaciones.subtotalivasi, 
	cotizaciones.subtotalivano, 
	cotizaciones.iva, 
	cotizaciones.totaliva, 
	cotizaciones.descontado,
	cotizaciones.descuento, 
	cotizaciones.totaldescuento,
	cotizaciones.totalpago, 
	cotizaciones.totalpago2, 
	cotizaciones.observaciones,
	cotizaciones.fechacotizacion,
	cotizaciones.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	usuarios.dni,
	usuarios.nombres,  
	SUM(detallecotizaciones.cantcotizacion) AS articulos
	FROM (cotizaciones LEFT JOIN detallecotizaciones ON detallecotizaciones.codcotizacion = cotizaciones.codcotizacion)
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON cotizaciones.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE CONCAT(cotizaciones.codcotizacion, ' ',if(cotizaciones.codcliente='0','0',clientes.dnicliente), ' ',if(cotizaciones.codcliente='0','0',clientes.nomcliente), ' ',if(cotizaciones.codcliente='0','0',clientes.girocliente)) LIKE '%".limpiar($_GET['bcotizaciones'])."%'
	GROUP BY detallecotizaciones.codcotizacion 
	ORDER BY cotizaciones.idcotizacion ASC LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BUSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}

	} else {

  	$sql ="SELECT 
	cotizaciones.idcotizacion, 
	cotizaciones.codcotizacion,  
	cotizaciones.codcliente, 
	cotizaciones.subtotalivasi, 
	cotizaciones.subtotalivano, 
	cotizaciones.iva, 
	cotizaciones.totaliva, 
	cotizaciones.descontado,
	cotizaciones.descuento, 
	cotizaciones.totaldescuento,
	cotizaciones.totalpago, 
	cotizaciones.totalpago2, 
	cotizaciones.observaciones,
	cotizaciones.fechacotizacion,
	cotizaciones.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	usuarios.dni,
	usuarios.nombres,  
	SUM(detallecotizaciones.cantcotizacion) AS articulos
	FROM (cotizaciones LEFT JOIN detallecotizaciones ON detallecotizaciones.codcotizacion = cotizaciones.codcotizacion)
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON cotizaciones.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE CONCAT(cotizaciones.codcotizacion, ' ',if(cotizaciones.codcliente='0','0',clientes.dnicliente), ' ',if(cotizaciones.codcliente='0','0',clientes.nomcliente), ' ',if(cotizaciones.codcliente='0','0',clientes.girocliente)) LIKE '%".limpiar($_GET['bcotizaciones'])."%'
	AND cotizaciones.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	GROUP BY detallecotizaciones.codcotizacion 
	ORDER BY cotizaciones.idcotizacion ASC LIMIT 0,60";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BUSQUEDA REALIZADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
		}
    }
}
########################## FUNCION BUSQUEDA DE COTIZACIONES ###############################

####################### FUNCION LISTAR COTIZACIONES ################################
public function ListarCotizaciones()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql ="SELECT 
	cotizaciones.idcotizacion, 
	cotizaciones.codcotizacion,  
	cotizaciones.codcliente, 
	cotizaciones.subtotalivasi, 
	cotizaciones.subtotalivano, 
	cotizaciones.iva, 
	cotizaciones.totaliva, 
	cotizaciones.descontado,
	cotizaciones.descuento, 
	cotizaciones.totaldescuento,
	cotizaciones.totalpago, 
	cotizaciones.totalpago2, 
	cotizaciones.observaciones,
	cotizaciones.fechacotizacion,
	cotizaciones.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	usuarios.dni,
	usuarios.nombres,  
	SUM(detallecotizaciones.cantcotizacion) AS articulos
	FROM (cotizaciones LEFT JOIN detallecotizaciones ON detallecotizaciones.codcotizacion = cotizaciones.codcotizacion)
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON cotizaciones.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	GROUP BY detallecotizaciones.codcotizacion 
	ORDER BY cotizaciones.idcotizacion ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else if($_SESSION["acceso"] == "cajero") {

	$sql ="SELECT 
	cotizaciones.idcotizacion, 
	cotizaciones.codcotizacion,  
	cotizaciones.codcliente, 
	cotizaciones.subtotalivasi, 
	cotizaciones.subtotalivano, 
	cotizaciones.iva, 
	cotizaciones.totaliva, 
	cotizaciones.descontado,
	cotizaciones.descuento, 
	cotizaciones.totaldescuento,
	cotizaciones.totalpago, 
	cotizaciones.totalpago2, 
	cotizaciones.observaciones,
	cotizaciones.fechacotizacion,
	cotizaciones.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	usuarios.dni,
	usuarios.nombres,  
	SUM(detallecotizaciones.cantcotizacion) AS articulos
	FROM (cotizaciones LEFT JOIN detallecotizaciones ON detallecotizaciones.codcotizacion = cotizaciones.codcotizacion)
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON cotizaciones.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE cotizaciones.codigo = '".limpiar($_SESSION["codigo"])."'
	AND cotizaciones.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	GROUP BY detallecotizaciones.codcotizacion 
	ORDER BY cotizaciones.idcotizacion ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else {

	$sql ="SELECT 
	cotizaciones.idcotizacion, 
	cotizaciones.codcotizacion,  
	cotizaciones.codcliente, 
	cotizaciones.subtotalivasi, 
	cotizaciones.subtotalivano, 
	cotizaciones.iva, 
	cotizaciones.totaliva, 
	cotizaciones.descontado,
	cotizaciones.descuento, 
	cotizaciones.totaldescuento,
	cotizaciones.totalpago, 
	cotizaciones.totalpago2, 
	cotizaciones.observaciones,
	cotizaciones.fechacotizacion,
	cotizaciones.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	usuarios.dni,
	usuarios.nombres,  
	SUM(detallecotizaciones.cantcotizacion) AS articulos
	FROM (cotizaciones LEFT JOIN detallecotizaciones ON detallecotizaciones.codcotizacion = cotizaciones.codcotizacion)
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON cotizaciones.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE cotizaciones.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
	GROUP BY detallecotizaciones.codcotizacion 
	ORDER BY cotizaciones.idcotizacion ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
######################### FUNCION LISTAR COTIZACIONES ############################

############################ FUNCION ID COTIZACIONES #################################
public function CotizacionesPorId()
	{
	self::SetNames();
	$sql ="SELECT 
	cotizaciones.idcotizacion, 
	cotizaciones.codcotizacion,  
	cotizaciones.codcliente, 
	cotizaciones.subtotalivasi, 
	cotizaciones.subtotalivano, 
	cotizaciones.iva, 
	cotizaciones.totaliva, 
	cotizaciones.descontado,
	cotizaciones.descuento, 
	cotizaciones.totaldescuento,
	cotizaciones.totalpago, 
	cotizaciones.totalpago2, 
	cotizaciones.observaciones,
	cotizaciones.fechacotizacion,
	cotizaciones.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.codgiro,
	sucursales.girosucursal,
	sucursales.tlfsucursal,
	sucursales.correosucursal,
	sucursales.id_provincia,
	sucursales.id_departamento,
	sucursales.direcsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfencargado,
	sucursales.fechaautorsucursal,
	sucursales.llevacontabilidad,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia AS id_provincia2, 
	clientes.id_departamento AS id_departamento2,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	provincias.provincia,
    departamentos.departamento,
    provincias2.provincia AS provincia2,
    departamentos2.departamento AS departamento2,
	usuarios.dni,
	usuarios.nombres,  
	SUM(detallecotizaciones.cantcotizacion) AS articulos
	FROM (cotizaciones LEFT JOIN detallecotizaciones ON detallecotizaciones.codcotizacion = cotizaciones.codcotizacion)
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON cotizaciones.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON clientes.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON clientes.id_departamento = departamentos2.id_departamento
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE cotizaciones.codcotizacion = ? 
	AND cotizaciones.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcotizacion"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID COTIZACIONES #################################
	
######################## FUNCION VER DETALLES COTIZACIONES ############################
public function VerDetallesCotizaciones()
	{
	self::SetNames();
	$sql = "SELECT
	detallecotizaciones.coddetallecotizacion,
	detallecotizaciones.codcotizacion,
	detallecotizaciones.coddetallecotizacion,
	detallecotizaciones.idproducto,
	detallecotizaciones.codproducto,
	detallecotizaciones.codcategoria,
	detallecotizaciones.producto,
	detallecotizaciones.cantcotizacion,
	detallecotizaciones.preciocompra,
	detallecotizaciones.precioventa,
	detallecotizaciones.ivaproducto,
	detallecotizaciones.descproducto,
	detallecotizaciones.valortotal, 
	detallecotizaciones.totaldescuentov,
	detallecotizaciones.subtotalimpuestos,
	detallecotizaciones.valorneto,
	detallecotizaciones.valorneto2,
	detallecotizaciones.detallesobservaciones,
	detallecotizaciones.detallesalsas,
	detallecotizaciones.preparado,
	detallecotizaciones.tipo,
	detallecotizaciones.codsucursal,
	categorias.nomcategoria,
	medidas.nommedida
	FROM detallecotizaciones 
	LEFT JOIN categorias ON detallecotizaciones.codcategoria = categorias.codcategoria
	LEFT JOIN medidas ON detallecotizaciones.codcategoria = medidas.codmedida 
	WHERE detallecotizaciones.codcotizacion = ? AND detallecotizaciones.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcotizacion"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$this->p[]=$row;
	}
	return $this->p;
	$this->dbh=null;
}
##################### FUNCION VER DETALLES COTIZACIONES #########################

######################## FUNCION ACTUALIZAR COTIZACIONES #######################
public function ActualizarCotizaciones()
	{
	self::SetNames();
	if(empty($_POST["codsucursal"]) or empty($_POST["codcotizacion"]))
	{
		echo "1";
		exit;
	}

	####################### VERIFICO QUE NO EXISTAN CANTIDAD IGUAL A CERO #######################
	for($i=0;$i<count($_POST['coddetallecotizacion']);$i++){  //recorro el array
        if (!empty($_POST['coddetallecotizacion'][$i])) {

	       if($_POST['cantcotizacion'][$i]==0){

		      echo "2";
		      exit;

	       }
        }
    }
    ####################### VERIFICO QUE NO EXISTAN CANTIDAD IGUAL A CERO #######################

	$this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetallecotizacion']);$i++){  //recorro el array
	if (!empty($_POST['coddetallecotizacion'][$i])) {

	############ OBTENGO CANTIDAD EN DETALLES ##############
	$sql = "SELECT cantcotizacion FROM detallecotizaciones 
	WHERE coddetallecotizacion = '".limpiar($_POST['coddetallecotizacion'][$i])."' 
	AND codcotizacion = '".limpiar($_POST["codcotizacion"])."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
		
	$cantidadbd = $row['cantcotizacion'];
	############ OBTENGO CANTIDAD EN DETALLES ##############

	if($cantidadbd != $_POST['cantcotizacion'][$i]){

		##################### ACTUALIZAMOS DETALLES DE COTIZACION ####################
		$query = "UPDATE detallecotizaciones set"
		." cantcotizacion = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." coddetallecotizacion = ? AND codcotizacion = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantcotizacion);
		$stmt->bindParam(2, $valortotal);
		$stmt->bindParam(3, $totaldescuentov);
		$stmt->bindParam(4, $subtotalimpuestos);
		$stmt->bindParam(5, $valorneto);
		$stmt->bindParam(6, $valorneto2);
		$stmt->bindParam(7, $coddetallecotizacion);
		$stmt->bindParam(8, $codcotizacion);
		$stmt->bindParam(9, $codsucursal);

		$cantcotizacion = limpiar($_POST['cantcotizacion'][$i]);
		$preciocompra = limpiar($_POST['preciocompra'][$i]);
		$precioventa = limpiar($_POST['precioventa'][$i]);
		$ivaproducto = limpiar($_POST['ivaproducto'][$i]);
		$descuento = $_POST['descproducto'][$i]/100;
		$valortotal = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuento = number_format($_POST['totaldescuentov'][$i], 2, '.', '');
		$subtotalimpuestos = number_format($_POST['subtotalimpuestos'][$i], 2, '.', '');
		$valorneto = number_format($_POST['valorneto'][$i], 2, '.', '');
		$valorneto2 = number_format($_POST['valorneto2'][$i], 2, '.', '');
		$coddetallecotizacion = limpiar($_POST['coddetallecotizacion'][$i]);
		$codcotizacion = limpiar($_POST["codcotizacion"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		##################### ACTUALIZAMOS DETALLES DE COTIZACION ####################

		} else {

           echo "";

	       }
        }
    }
    $this->dbh->commit();

    ############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############
	$sql = " UPDATE cotizaciones SET "
	." codcliente = ?, "
	." observaciones = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." totalpago2= ? "
	." WHERE "
	." codcotizacion = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $codcliente);
	$stmt->bindParam(2, $observaciones);
	$stmt->bindParam(3, $subtotalivasi);
	$stmt->bindParam(4, $subtotalivano);
	$stmt->bindParam(5, $totaliva);
	$stmt->bindParam(6, $descontado);
	$stmt->bindParam(7, $descuento);
	$stmt->bindParam(8, $totaldescuento);
	$stmt->bindParam(9, $totalpago);
	$stmt->bindParam(10, $totalpago2);
	$stmt->bindParam(11, $codcotizacion);
	$stmt->bindParam(12, $codsucursal);

	$codcliente = limpiar($_POST["codcliente"]);
	$observaciones = limpiar($_POST["observaciones"]);
	$subtotalivasi = number_format($_POST["txtsubtotal"], 2, '.', '');
	$subtotalivano = number_format($_POST["txtsubtotal2"], 2, '.', '');
	$totaliva = number_format($_POST["txtIva"], 2, '.', '');
	$descontado = number_format($_POST["txtdescontado"], 2, '.', '');
	$descuento = limpiar($_POST["descuento"]);
    $totaldescuento = number_format($_POST["txtDescuento"], 2, '.', '');
    $totalpago = number_format($_POST["txtTotal"], 2, '.', '');
    $totalpago2 = number_format($_POST["txtTotalCompra"], 2, '.', '');
	$codcotizacion = limpiar($_POST["codcotizacion"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

echo "<span class='fa fa-check-square-o'></span> LA COTIZACIÓN HA SIDO ACTUALIZADA EXITOSAMENTE <a href='reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOTIZACION")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

echo "<script>window.open('reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOTIZACION")."', '_blank');</script>";
	exit;
}
####################### FUNCION ACTUALIZAR COTIZACIONES ############################

####################### FUNCION AGREGAR DETALLES COTIZACIONES ########################
public function AgregarDetallesCotizaciones()
	{
	self::SetNames();
	if(empty($_POST["codsucursal"]) or empty($_POST["codcotizacion"]))
	{
		echo "1";
		exit;
	}
    elseif(empty($_SESSION["CarritoCotizacion"]))
	{
		echo "2";
		exit;
	}

    ############ CONSULTO TOTAL EN FACTURA ##############
	$sql = "SELECT 
	descuento,
	totalpago
	FROM cotizaciones 
	WHERE codcotizacion = '".limpiar($_POST["codcotizacion"])."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$descuentobd = $row['descuento'];
	$totalpagobd = $row['totalpago'];
	############ CONSULTO TOTAL EN FACTURA ##############

    $this->dbh->beginTransaction();
    $detalle = $_SESSION["CarritoCotizacion"];
	for($i=0;$i<count($detalle);$i++){

	$sql = "SELECT 
	codcotizacion, 
	codproducto, 
	tipo 
	FROM detallecotizaciones 
	WHERE codcotizacion = '".limpiar($_POST['codcotizacion'])."' 
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	AND tipo = '".limpiar($detalle[$i]['tipo'])."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{

        $query = "INSERT INTO detallecotizaciones values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcotizacion);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $codcategoria);
		$stmt->bindParam(6, $cantidad);
		$stmt->bindParam(7, $preciocompra);
		$stmt->bindParam(8, $precioventa);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $valortotal);
		$stmt->bindParam(12, $totaldescuentov);
	    $stmt->bindParam(13, $subtotalimpuestos);
		$stmt->bindParam(14, $valorneto);
		$stmt->bindParam(15, $valorneto2);
		$stmt->bindParam(16, $detallesobservaciones);
		$stmt->bindParam(17, $detallesalsas);
		$stmt->bindParam(18, $preparado);
		$stmt->bindParam(19, $tipo);
		$stmt->bindParam(20, $codsucursal);
			
		$codcotizacion = limpiar($_POST["codcotizacion"]);
		$idproducto = limpiar($detalle[$i]['id']);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$producto = limpiar($detalle[$i]['producto']);
		$codcategoria = limpiar($detalle[$i]['codcategoria']);
		$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$preciocompra = limpiar($detalle[$i]['precio']);
		$precioventa = limpiar($detalle[$i]['precio2']);
	    $precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$descuento = $detalle[$i]['descproducto']/100;
		$valortotal = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	    //CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto = 1 + ($_POST["iva"]/100);
		$Discriminado = $precioconiva/$ValorImpuesto;
		$SubtotalDiscriminado = $precioconiva - $Discriminado;
		$BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
		$subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto = number_format($valortotal-$totaldescuentov, 2, '.', '');
		$valorneto2 = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
	    $detallesobservaciones = limpiar($detalle[$i]['observacion'] == ", " ? "" : $detalle[$i]['observacion']);
	    $detallesalsas = limpiar($detalle[$i]['salsa'] == ", " ? "" : $detalle[$i]['salsa']);
	    $preparado = limpiar($detalle[$i]['preparado']);
	    $tipo = limpiar($detalle[$i]['tipo']);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	  } else {

	  	$sql = "SELECT 
	  	cantcotizacion 
	  	FROM detallecotizaciones 
	  	WHERE codcotizacion = '".limpiar($_POST['codcotizacion'])."' 
	  	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
	  	AND tipo = '".limpiar($detalle[$i]['tipo'])."'
	  	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidad = $row['cantcotizacion'];

	  	$query = "UPDATE detallecotizaciones set"
		." cantcotizacion = ?, "
		." descproducto = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." codcotizacion = ? AND codproducto = ? AND tipo = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantcotizacion);
		$stmt->bindParam(2, $descproducto);
		$stmt->bindParam(3, $valortotal);
		$stmt->bindParam(4, $totaldescuentov);
		$stmt->bindParam(5, $subtotalimpuestos);
		$stmt->bindParam(6, $valorneto);
		$stmt->bindParam(7, $valorneto2);
		$stmt->bindParam(8, $codcotizacion);
		$stmt->bindParam(9, $codproducto);
		$stmt->bindParam(10, $tipo);
		$stmt->bindParam(11, $codsucursal);

		$cantcotizacion = limpiar($detalle[$i]['cantidad']+$cantidad);
		$preciocompra = limpiar($detalle[$i]['precio']);
		$precioventa = limpiar($detalle[$i]['precio2']);
	    $precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$descuento = $detalle[$i]['descproducto']/100;
		$valortotal = number_format($detalle[$i]['precio2'] * $cantcotizacion, 2, '.', '');
		$totaldescuentov = number_format($valortotal * $descuento, 2, '.', '');

	    //CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto = 1 + ($_POST["iva"]/100);
		$Discriminado = $precioconiva/$ValorImpuesto;
		$SubtotalDiscriminado = $precioconiva - $Discriminado;
		$BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
		$subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

		$valorneto = number_format($valortotal - $totaldescuentov, 2, '.', '');
		$valorneto2 = number_format($detalle[$i]['precio'] * $cantcotizacion, 2, '.', '');
		$codcotizacion = limpiar($_POST["codcotizacion"]);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$tipo = limpiar($detalle[$i]['tipo']);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	 }
   }    
        ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	    unset($_SESSION["CarritoCotizacion"]);
        $this->dbh->commit();

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
        $sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar($_POST["codcotizacion"])."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00'";
        foreach ($this->dbh->query($sql3) as $row3)
        {
        	$this->p[] = $row3;
        }
        $subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	    $subtotalimpuestos = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
        $subtotalivasi = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
        $subtotalivasi2 = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
        $sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar($_POST["codcotizacion"])."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00'";
        foreach ($this->dbh->query($sql4) as $row4)
        {
        	$this->p[] = $row4;
        }
        $subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
        $subtotalivano = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
        $subtotalivano2 = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
        ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

        ############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############
        $sql = " UPDATE cotizaciones SET "
        ." codcliente = ?, "
        ." observaciones = ?, "
        ." subtotalivasi = ?, "
        ." subtotalivano = ?, "
        ." totaliva = ?, "
        ." descontado = ?, "
        ." descuento = ?, "
        ." totaldescuento = ?, "
        ." totalpago = ?, "
        ." totalpago2= ? "
        ." WHERE "
        ." codcotizacion = ? AND codsucursal = ?;
        ";
        $stmt = $this->dbh->prepare($sql);
        $stmt->bindParam(1, $codcliente);
        $stmt->bindParam(2, $observaciones);
        $stmt->bindParam(3, $subtotalivasi);
        $stmt->bindParam(4, $subtotalivano);
        $stmt->bindParam(5, $totaliva);
        $stmt->bindParam(6, $descontado);
        $stmt->bindParam(7, $descuento);
        $stmt->bindParam(8, $totaldescuento);
        $stmt->bindParam(9, $totalpago);
        $stmt->bindParam(10, $totalpago2);
        $stmt->bindParam(11, $codcotizacion);
		$stmt->bindParam(12, $codsucursal);

        $codcliente = limpiar($_POST["codcliente"]);
        $observaciones = limpiar($_POST["observaciones"]);
        $iva = $_POST["iva"]/100;
        $totaliva = number_format($subtotalimpuestos, 2, '.', '');
        $descontado = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
        $descuento = limpiar($_POST["descuento"]+$descuentobd);
        $txtDescuento = $descuento/100;
        $total = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
        $totaldescuento = number_format($total*$txtDescuento, 2, '.', '');
        $totalpago = number_format($total-$totaldescuento, 2, '.', '');
        $totalpago2 = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
        $codcotizacion = limpiar($_POST["codcotizacion"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
        $stmt->execute();
        ############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############

echo "<span class='fa fa-check-square-o'></span> LOS DETALLES DE PRODUCTOS FUERON AGREGADOS A LA COTIZACI&Oacute;N EXITOSAMENTE <a href='reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOTIZACION")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

echo "<script>window.open('reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOTIZACION")."', '_blank');</script>";
	exit;
}
######################### FUNCION AGREGAR DETALLES COTIZACIONES #######################

######################## FUNCION ELIMINAR DETALLES COTIZACIONES #######################
public function EliminarDetallesCotizaciones()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorS" || $_SESSION["acceso"]=="secretaria" || $_SESSION["acceso"]=="cajero") {

	$sql = "SELECT * FROM detallecotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcotizacion"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{

		########## ELIMINAMOS EL DETALLE EN COTIZACION ###########
		$sql = "DELETE FROM detallecotizaciones WHERE coddetallecotizacion = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddetallecotizacion);
		$stmt->bindParam(2,$codsucursal);

		$coddetallecotizacion = limpiar(decrypt($_GET["coddetallecotizacion"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########## ELIMINAMOS EL DETALLE EN COTIZACION ###########

	    ############ CONSULTO LOS TOTALES DE COTIZACIONES ##############
	    $sql2 = "SELECT iva, descuento FROM cotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
	    $stmt = $this->dbh->prepare($sql2);
	    $stmt->execute(array(decrypt($_GET["codcotizacion"]),decrypt($_GET["codsucursal"])));
	    $num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$paea[] = $row;
		}
		$iva = $paea[0]["iva"]/100;
	    $descuento = $paea[0]["descuento"]/100;
	    ############ CONSULTO LOS TOTALES DE COTIZACIONES ##############

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
		$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_GET["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
		foreach ($this->dbh->query($sql3) as $row3)
		{
			$this->p[] = $row3;
		}
		$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	    $subtotalimpuestos = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
		$subtotalivasi = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
		$subtotalivasi2 = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
		$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_GET["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
		foreach ($this->dbh->query($sql4) as $row4)
		{
			$this->p[] = $row4;
		}
		$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
		$subtotalivano = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
		$subtotalivano2 = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

        ############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############
		$sql = " UPDATE cotizaciones SET "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." totalpago2= ? "
		." WHERE "
		." codcotizacion = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $subtotalivasi);
		$stmt->bindParam(2, $subtotalivano);
		$stmt->bindParam(3, $totaliva);
		$stmt->bindParam(4, $descontado);
		$stmt->bindParam(5, $totaldescuento);
		$stmt->bindParam(6, $totalpago);
		$stmt->bindParam(7, $totalpago2);
		$stmt->bindParam(8, $codcotizacion);
		$stmt->bindParam(9, $codsucursal);

		$totaliva= number_format($subtotalimpuestos, 2, '.', '');
		$descontado = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
	    $total= number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
	    $totaldescuento= number_format($total*$descuento, 2, '.', '');
	    $totalpago= number_format($total-$totaldescuento, 2, '.', '');
		$totalpago2 = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
		$codcotizacion = limpiar(decrypt($_GET["codcotizacion"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
################### FUNCION ELIMINAR DETALLES COTIZACIONES #####################

####################### FUNCION ELIMINAR COTIZACIONES #################################
public function EliminarCotizaciones()
	{
	self::SetNames();
	if ($_SESSION["acceso"]=="administradorS" || $_SESSION["acceso"]=="secretaria" || $_SESSION["acceso"]=="cajero") {

		######################### ELIMINO COTIZACION #########################
		$sql = "DELETE FROM cotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcotizacion);
		$stmt->bindParam(2,$codsucursal);
		$codcotizacion = limpiar(decrypt($_GET["codcotizacion"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		######################### ELIMINO COTIZACION #########################

		########## ELIMINAMOS EL DETALLE EN COTIZACION ###########
		$sql = "DELETE FROM detallecotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcotizacion);
		$stmt->bindParam(2,$codsucursal);
		$codcotizacion = limpiar(decrypt($_GET["codcotizacion"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########## ELIMINAMOS EL DETALLE EN COTIZACION ###########

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
###################### FUNCION ELIMINAR COTIZACIONES #################################

####################### FUNCION PROCESAR COTIZACIONES A VENTA #################################
public function ProcesarCotizaciones()
	{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueo = $row['codarqueo'];
		$codcaja = $row['codcaja'];
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################

    ############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$sql = "SELECT * FROM detallecotizaciones 
	WHERE codcotizacion = '".limpiar(decrypt($_POST['codcotizacion']))."'
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
    	foreach ($this->dbh->query($sql) as $row2) {

	    $cantidad = $row2['cantcotizacion'];
	    $tipo = $row2['tipo'];

		if(limpiar($tipo) == 1){ // SI EL DETALLE ES PRODUCTO

	    	$sql = "SELECT 
	    	existencia 
	    	FROM productos 
	    	WHERE codproducto = '".limpiar($row2['codproducto'])."'
	        AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
	    	{
	    		$this->p[] = $row;
	    	}

	    	$existenciabd = $row['existencia'];

	    	if ($cantidad > $existenciabd) 
	    	{ 
	    		echo "2";
	    		exit;
	    	}

		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
		    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array(limpiar($row2['codproducto']),decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
		    if($num>0) { 

		    	$sql = "SELECT 
		    	productosxingredientes.codproducto,
		    	productosxingredientes.codingrediente,
		    	productosxingredientes.cantracion,
		    	productosxingredientes.codsucursal,
		    	ingredientes.cantingrediente,
		    	ingredientes.controlstocki
		    	FROM productosxingredientes 
		    	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
		    	WHERE productosxingredientes.codproducto IN ('".limpiar($row2['codproducto'])."') 
		    	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
		    	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				    $cantracionbd = $row['cantracion'];
				    $codingredientebd = $row['codingrediente'];
				    $cantingredientebd = $row['cantingrediente'];
			        $controlingredientebd = $row['controlstocki'];

			        $racion = number_format($cantracionbd*$cantidad, 2, '.', '');

			        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

			        	if ($racion > $cantingredientebd) 
			        	{ 
			        		echo "3";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK INGREDIENTE
			    }
		    }//fin de consulta de ingredientes de productos	
		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

	    } elseif(limpiar($tipo) == 2){ // SI EL DETALLE ES UN COMBO

	    	$sql = "SELECT 
	    	existencia 
	    	FROM combos 
	    	WHERE codcombo = '".limpiar($row2['codproducto'])."'
	        AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
	    	{
	    		$this->p[] = $row;
	    	}

	    	$existenciabd = $row['existencia'];

	    	if ($cantidad > $existenciabd) 
	    	{ 
	    		echo "4";
	    		exit;
	    	}

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($row2['codproducto'],decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia,
	        	productos.controlstockp
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($row2['codproducto'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				   $cantracionbd = $row['cantidad'];
				   $codproductobd = $row['codproducto'];
				   $cantproductobd = $row['existencia'];
			       $controlproductobd = $row['controlstockp'];

			        $racion = number_format($cantracionbd*$cantidad, 2, '.', '');

			        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

			        	if ($racion > $cantproductobd) 
			        	{ 
			        		echo "5";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK PRODUCTO
			    }
		    }//fin de consulta de ingredientes de productos	
		   ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

		} else {  // SI EL DETALLE ES UN EXTRA O INGREDIENTE

	    	$sql = "SELECT 
	    	cantingrediente 
	    	FROM ingredientes 
	    	WHERE codingrediente = '".limpiar($row2['codproducto'])."'
	        AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
	    	{
	    		$this->p[] = $row;
	    	}

	    	$existenciabd = $row['cantingrediente'];

	    	if ($cantidad > $existenciabd) 
	    	{ 
	    		echo "6";
	    		exit;
	    	}

		}
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	 if(empty($_POST["codsucursal"]) or empty($_POST["tipodocumento"]) or empty($_POST["tipopago"]))
	{
		echo "7";
		exit;
	}
	elseif(isset($_POST['formapago2']) && $_POST["formapago2"] != ""){

		/*if($_POST["txtTotal"] > $_POST["txtAgregado"])
	    {
		   echo "4";
		   exit;
	    }***/
	}
	else if(limpiar($_POST["tipodocumento"]) == "FACTURA" && limpiar($_POST["codcliente"]) == "0"){

    	echo "8";
	    exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
    clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
    clientes.girocliente,
    clientes.emailcliente, 
    clientes.tipocliente,
    clientes.limitecredito,
    clientes.id_provincia,
    clientes.id_departamento,
    clientes.direccliente,
    provincias.provincia,
    departamentos.departamento,
    ROUND(SUM(if(pag.montocredito!='0',pag.montocredito,'0.00')), 2) montoactual,
    ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 2) creditodisponible
    FROM clientes 
    LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes
       WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.codcliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['codcliente'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente = ($row['codcliente'] == "" ? "0" : $row['codcliente']);
    $tipocliente = ($row['tipocliente'] == "" ? "0" : $row['tipocliente']);
    $dnicliente = ($row['dnicliente'] == "" ? "0" : $row['dnicliente']);
    $nomcliente = ($row['nomcliente'] == "" ? "0" : $row['nomcliente']);
    $girocliente = ($row['girocliente'] == "" ? "0" : $row['girocliente']);
    $emailcliente = $row['emailcliente'];
    $provincia = ($row['id_provincia'] == "" || $row['id_provincia'] == "0" ? "0" : $row['provincia']);
    $departamento = ($row['id_departamento'] == "" || $row['id_departamento'] == "0" ? "0" : $row['departamento']);
    $direccliente = ($row['direccliente'] == "" ? "0" : $row['direccliente']);
    $limitecredito = $row['limitecredito'];
    $montoactual = $row['montoactual'];
    $creditodisponible = $row['creditodisponible'];
    $medioabono = (empty($_POST["medioabono"]) ? "" : $_POST["medioabono"]);
    $montoabono = (empty($_POST["montoabono"]) ? "0.00" : $_POST["montoabono"]);
    $total = number_format($_POST["txtImporte"]-$montoabono, 2, '.', '');
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ################### VERIFICO CONDICIONES DEL CLIENTE ######################
    if(limpiar($_POST["tipodocumento"] == "FACTURA" && $tipocliente == "NATURAL")){ 

    	    echo "9";
	        exit;

    } else if ($_POST["tipopago"] == "CREDITO") {

		$fechaactual = date("Y-m-d");
		$fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));

		if ($_POST["codcliente"] == '0') { 

	        echo "10";
	        exit;

        } else if (strtotime($fechavence) < strtotime($fechaactual)) {

			echo "11";
			exit;

		} else if ($montoabono != "0.00" && $medioabono == "") {
  
           echo "12";
	       exit;

		} else if ($limitecredito != "0.00" && $total > $creditodisponible) {
  
           echo "13";
	       exit;

		} else if($_POST["montoabono"] >= $_POST["txtImporte"]) { 
	
		   echo "14";
		   exit;

	    }
	}
	################### VERIFICO CONDICIONES DEL CLIENTE ######################

	####################### OBTENGO DATOS DE SUCURSAL #######################
	$sql = "SELECT 
	codsucursal, 
	cuitsucursal,
	nomsucursal, 
	codgiro, 
	girosucursal, 
	nroactividadsucursal,
	inicioticket,
	inicioboleta, 
	iniciofactura 
	FROM sucursales 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$rucemisor = $row['cuitsucursal'];
    $razonsocial = $row['nomsucursal'];
    $actecoemisor = $row['codgiro'];
    $giroemisor = $row['girosucursal'];
    $nroactividad = $row['nroactividadsucursal'];
	$inicioticket = $row['inicioticket'];
	$inicioboleta = $row['inicioboleta'];
	$iniciofactura = $row['iniciofactura'];
	####################### OBTENGO DATOS DE SUCURSAL #######################

	##################### AGREGAMOS EL NUMERO DE PEDIDO #######################
	$sql = "SELECT 
	codpedido 
	FROM pedidos 
	ORDER BY idpedido 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$pedido=$row["codpedido"];
	}
	$codpedido = (empty($pedido) ? "1" : $pedido + 1);
	##################### AGREGAMOS EL NUMERO DE PEDIDO #######################

	##################### AGREGAMOS NUMERO DE PEDIDO #######################
	$sql = "SELECT 
	numpedido 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idnum=$row["numpedido"];
	}
	$numpedido = (empty($idnum) ? "1" : $idnum + 1);
	##################### AGREGAMOS NUMERO DE PEDIDO #######################

	##################### AGREGAMOS NUMERO DE CONTROL #######################
	$sql = "SELECT 
	numero 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idcontrol=$row["numero"];
	}
	$numero = (empty($idcontrol) ? "1" : $idcontrol + 1);
	##################### AGREGAMOS NUMERO DE CONTROL #######################

	##################### AGREGAMOS EL NUMERO DE VENTA #######################
	$sql = "SELECT 
	codventa 
	FROM ventas
	ORDER BY idventa 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$venta=$row["codventa"];

	}
	$codventa = (empty($venta) ? "1" : $venta + 1);
	##################### AGREGAMOS EL NUMERO DE VENTA #######################

	################ CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ################
	$sql = "SELECT 
	codfactura 
	FROM ventas 
	WHERE tipodocumento = '".limpiar($_POST['tipodocumento'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idventa 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$factura=$row["codfactura"];
	}
	
	if($_POST['tipodocumento']=="TICKET") {

        $codfactura = (empty($factura) ? $inicioticket : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="BOLETA") {

        $codfactura = (empty($factura) ? $inicioboleta : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="FACTURA") {

		$codfactura = (empty($factura) ? $iniciofactura : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());
	}
    ################# CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ###############

	################### SELECCIONE LOS DATOS DE LA COTIZACION ######################
    $sql = "SELECT * FROM cotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST['codcotizacion']),decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    ################### SELECCIONE LOS DATOS DE LA COTIZACION ######################

    $fecha = date("Y-m-d H:i:s");

    ################################# REGISTRO DATOS DE PEDIDO #################################
	$query = "INSERT INTO pedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $numpedido);
	$stmt->bindParam(3, $numero);
	$stmt->bindParam(4, $codmesa);
	$stmt->bindParam(5, $referencia);
	$stmt->bindParam(6, $codcliente);
	$stmt->bindParam(7, $subtotalivasi);
	$stmt->bindParam(8, $subtotalivano);
	$stmt->bindParam(9, $iva);
	$stmt->bindParam(10, $totaliva);
	$stmt->bindParam(11, $descontado);
	$stmt->bindParam(12, $descuento);
	$stmt->bindParam(13, $totaldescuento);
	$stmt->bindParam(14, $totalpago);
	$stmt->bindParam(15, $totalpago2);
	$stmt->bindParam(16, $descripciones);
	$stmt->bindParam(17, $tipopedido);
	$stmt->bindParam(18, $statuspedido);
	$stmt->bindParam(19, $repartidor);
	$stmt->bindParam(20, $fechapedido);
	$stmt->bindParam(21, $fechaentrega);
	$stmt->bindParam(22, $codigo);
	$stmt->bindParam(23, $mesero);
	$stmt->bindParam(24, $codsucursal);

	$codmesa = limpiar("0");
	$referencia = limpiar("0");
	$subtotalivasi = limpiar($row["subtotalivasi"]);
	$subtotalivano = limpiar($row["subtotalivano"]);
	$iva = limpiar($row["iva"]);
	$totaliva = limpiar($row["totaliva"]);
	$descontado = limpiar($row["descontado"]);
	$descuento = limpiar($row["descuento"]);
	$totaldescuento = limpiar($row["totaldescuento"]);
	$totalpago = limpiar($row["totalpago"]);
	$totalpago2 = limpiar($row["totalpago2"]);
	$descripciones = limpiar($row['observaciones']=="" ? "" : $row['observaciones']);
    $tipopedido = limpiar("4");
    $statuspedido = limpiar("1");
	$repartidor = limpiar($_POST["repartidores"]!="" ? decrypt($_POST['repartidores']) : "0");
    $fechapedido = limpiar($fecha);
    $fechaentrega = limpiar("0000-00-00 00:00:00");
	$codigo = limpiar($_SESSION["codigo"]);
	$mesero = limpiar("0");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################# REGISTRO DATOS DE PEDIDO #################################

	################################# REGISTRO DATOS DE VENTA #################################
    $query = "INSERT INTO ventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codmesa);
	$stmt->bindParam(4, $tipodocumento);
	$stmt->bindParam(5, $codcaja);
	$stmt->bindParam(6, $codfactura);
	$stmt->bindParam(7, $codserie);
	$stmt->bindParam(8, $codautorizacion);
	$stmt->bindParam(9, $codcliente);
	$stmt->bindParam(10, $subtotalivasi);
	$stmt->bindParam(11, $subtotalivano);
	$stmt->bindParam(12, $iva);
	$stmt->bindParam(13, $totaliva);
	$stmt->bindParam(14, $descontado);
	$stmt->bindParam(15, $descuento);
	$stmt->bindParam(16, $totaldescuento);
	$stmt->bindParam(17, $totalpago);
	$stmt->bindParam(18, $totalpago2);
	$stmt->bindParam(19, $creditopagado);
	$stmt->bindParam(20, $montodelivery);
	$stmt->bindParam(21, $tipopago);
	$stmt->bindParam(22, $formapago);
	$stmt->bindParam(23, $montopagado);
	$stmt->bindParam(24, $formapago2);
	$stmt->bindParam(25, $montopagado2);
	$stmt->bindParam(26, $formapropina);
	$stmt->bindParam(27, $montopropina);
	$stmt->bindParam(28, $montodevuelto);
	$stmt->bindParam(29, $fechavencecredito);
	$stmt->bindParam(30, $fechapagado);
	$stmt->bindParam(31, $statusventa);
	$stmt->bindParam(32, $fechaventa);
	$stmt->bindParam(33, $delivery);
	$stmt->bindParam(34, $repartidor);
	$stmt->bindParam(35, $entregado);
	$stmt->bindParam(36, $descripciones);
	$stmt->bindParam(37, $observaciones);
	$stmt->bindParam(38, $fechaentrega);
	$stmt->bindParam(39, $statuspedido);
	$stmt->bindParam(40, $tipoventa);
	$stmt->bindParam(41, $codigo);
	$stmt->bindParam(42, $mesero);
	$stmt->bindParam(43, $docelectronico);
	$stmt->bindParam(44, $codsucursal);
    
	$codmesa = limpiar("0");
	$tipodocumento = limpiar($_POST["tipodocumento"]);
	$codcliente = limpiar($_POST['codcliente']);
	$subtotalivasi = limpiar($row["subtotalivasi"]);
	$subtotalivano = limpiar($row["subtotalivano"]);
	$iva = limpiar($row["iva"]);
	$totaliva = limpiar($row["totaliva"]);
	$descontado = limpiar($row["descontado"]);
	$descuento = limpiar($row["descuento"]);
	$totaldescuento = limpiar($row["totaldescuento"]);
	$totalpago = limpiar($row["totalpago"]);
	$totalpago2 = limpiar($row["totalpago2"]);
    $creditopagado = limpiar(isset($_POST['montoabono']) ? $_POST["montoabono"] : "0.00");
	$montodelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");

	$tipopago = limpiar($_POST["tipopago"]);
	$formapago = limpiar($_POST["tipopago"]=="CONTADO" ? $_POST["formapago"] : "CREDITO");
	$montopagado = limpiar(isset($_POST['montopagado']) ? $_POST["montopagado"] : "0.00");
	$formapago2 = limpiar(isset($_POST['montopagado2']) ? $_POST["formapago2"] : "0");
	$montopagado2 = limpiar(isset($_POST['montopagado2']) ? $_POST["montopagado2"] : "0.00");
	$formapropina = limpiar(isset($_POST['formapropina']) ? $_POST["formapropina"] : "0");
	$montopropina = limpiar(isset($_POST['montopropina']) ? $_POST["montopropina"] : "0.00");
	$montodevuelto = limpiar(isset($_POST['montodevuelto']) ? $_POST["montodevuelto"] : "0.00");

    $fechavencecredito = limpiar($_POST["tipopago"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
    $fechapagado = limpiar("0000-00-00");
    $statusventa = limpiar($_POST["tipopago"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
    $fechaventa = limpiar($fecha);

	$delivery = limpiar($_POST["repartidores"]!="" ? "1" : "0");
	$repartidor = limpiar($_POST["repartidores"]!="" ? decrypt($_POST['repartidores']) : "0");
	$entregado = limpiar($_POST["repartidores"]!="" ? "1" : "0");

	$descripciones = limpiar("");
	$observaciones = limpiar($_POST['observaciones']=="" ? "" : $_POST['observaciones']);
	$fechaentrega = limpiar("0000-00-00 00:00:00");
	$statuspedido = limpiar("0");
	$tipoventa = limpiar("1");
	$codigo = limpiar($_SESSION["codigo"]);
	$mesero = limpiar("0");
	$docelectronico = limpiar("0");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################# REGISTRO DATOS DE VENTA #################################

	$this->dbh->beginTransaction();
	########################### SELECCIONO DETALLES DE LA COTIZACION ###########################
	$sql = "SELECT * FROM detallecotizaciones 
	WHERE codcotizacion = '".limpiar(decrypt($_POST['codcotizacion']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
    foreach ($this->dbh->query($sql) as $row2)
	{

    ##################### REGISTRO DETALLES EN VENTAS #######################
	$query = "INSERT INTO detalleventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
    $stmt = $this->dbh->prepare($query);
    $stmt->bindParam(1, $codventa);
	$stmt->bindParam(2, $idproducto);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $producto);
    $stmt->bindParam(5, $codcategoria);
    $stmt->bindParam(6, $cantidad);
    $stmt->bindParam(7, $preciocompra);
    $stmt->bindParam(8, $precioventa);
    $stmt->bindParam(9, $ivaproducto);
    $stmt->bindParam(10, $descproducto);
    $stmt->bindParam(11, $valortotal);
    $stmt->bindParam(12, $totaldescuentov);
    $stmt->bindParam(13, $subtotalimpuestos);
    $stmt->bindParam(14, $valorneto);
    $stmt->bindParam(15, $valorneto2);
    $stmt->bindParam(16, $detallesobservaciones);
    $stmt->bindParam(17, $tipo);
    $stmt->bindParam(18, $codsucursal);

	$idproducto = limpiar($row2['idproducto']);
	$codproducto = limpiar($row2['codproducto']);
	$producto = limpiar($row2['producto']);
	$codcategoria = limpiar($row2['codcategoria']);
	$cantidad = limpiar($row2['cantcotizacion']);
	$preciocompra = limpiar($row2['preciocompra']);
	$precioventa = limpiar($row2['precioventa']);
	$ivaproducto = limpiar($row2['ivaproducto']);
	$descproducto = limpiar($row2['descproducto']);
	$descuento = $row2['descproducto']/100;
	$valortotal = number_format($row2['valortotal'], 2, '.', '');
	$totaldescuentov = number_format($row2['totaldescuentov'], 2, '.', '');
	$subtotalimpuestos = limpiar($row2['subtotalimpuestos']);
	$valorneto = number_format($row2['valorneto'], 2, '.', '');
	$valorneto2 = number_format($row2['valorneto2'], 2, '.', '');
	$detallesobservaciones = limpiar($row2['detallesobservaciones']);
	$tipo = limpiar($row2['tipo']);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### REGISTRO DETALLES EN VENTAS #######################

	##################### REGISTRO DETALLES EN PEDIDOS #######################
	$query = "INSERT INTO detallepedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $numpedido);
	$stmt->bindParam(3, $numero);
	$stmt->bindParam(4, $codmesa);
	$stmt->bindParam(5, $idproducto);
	$stmt->bindParam(6, $codproducto);
	$stmt->bindParam(7, $producto);
	$stmt->bindParam(8, $codcategoria);
	$stmt->bindParam(9, $cantidad);
	$stmt->bindParam(10, $preciocompra);
	$stmt->bindParam(11, $precioventa);
	$stmt->bindParam(12, $ivaproducto);
	$stmt->bindParam(13, $descproducto);
	$stmt->bindParam(14, $valortotal);
	$stmt->bindParam(15, $totaldescuentov);
    $stmt->bindParam(16, $subtotalimpuestos);
	$stmt->bindParam(17, $valorneto);
	$stmt->bindParam(18, $valorneto2);
	$stmt->bindParam(19, $observacionespedido);
	$stmt->bindParam(20, $salsaspedido);
	$stmt->bindParam(21, $cocinero);
	$stmt->bindParam(22, $preparado);
	$stmt->bindParam(23, $tipodetalle);
	$stmt->bindParam(24, $detallepedido);
	$stmt->bindParam(25, $statusdetalle);
	$stmt->bindParam(26, $fechadetallepedido);
	$stmt->bindParam(27, $fechadetalleentrega);
	$stmt->bindParam(28, $bandera_pedido);
	$stmt->bindParam(29, $codsucursal);

	$codmesa = limpiar("0");
	$idproducto = limpiar($row2['idproducto']);
	$codproducto = limpiar($row2['codproducto']);
	$producto = limpiar($row2['producto']);
	$codcategoria = limpiar($row2['codcategoria']);
	$cantidad = limpiar($row2['cantcotizacion']);
	$preciocompra = limpiar($row2['preciocompra']);
	$precioventa = limpiar($row2['precioventa']);
	$ivaproducto = limpiar($row2['ivaproducto']);
	$descproducto = limpiar($row2['descproducto']);
	$valortotal = number_format($row2['valortotal'], 2, '.', '');
	$totaldescuentov = number_format($row2['totaldescuentov'], 2, '.', '');
	$subtotalimpuestos = limpiar($row2['subtotalimpuestos']);
	$valorneto = number_format($row2['valorneto'], 2, '.', '');
	$valorneto2 = number_format($row2['valorneto2'], 2, '.', '');
    $observacionespedido = limpiar($row2['detallesobservaciones'] == ", " ? "" : $row2['detallesobservaciones']);
    $salsaspedido = limpiar($row2['detallesalsas'] == ", " ? "" : $row2['detallesalsas']);
	$cocinero = limpiar('1');
	$preparado = limpiar($row2['preparado']);
	$tipodetalle = limpiar($row2['tipo']);
    $detallepedido = limpiar("1");
    $statusdetalle = limpiar("1");
	$fechadetallepedido = limpiar($fecha);
	$fechadetalleentrega = limpiar("0000-00-00 00:00:00");
	$bandera_pedido = limpiar("1");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### REGISTRO DETALLES EN PEDIDOS #######################

    if(limpiar($row2['tipo']) == 1){//SI EL DETALLE ESUN  PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################

	    ############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = '".limpiar($row2['codproducto'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		$controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codproducto = '".limpiar($row2['codproducto'])."'
			     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($row2['cantcotizacion'], 2, '.', '');
		$existencia = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
        $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);		
	    $stmt->bindParam(14, $codsucursal);	

		$codcliente = limpiar($_POST["codcliente"]);
		$codproducto = limpiar($row2['codproducto']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$ivaproducto = limpiar($row2['ivaproducto']);
		$descproducto = limpiar($row2['descproducto']);
		$precio = limpiar($row2['precioventa']);
		$documento = limpiar("PROCESO EN COTIZACION");
		$fechakardex = limpiar($fecha);
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################

	}// FIN SI CONTROL STOCK PRODUCTO

	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
	    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($row2['codproducto'],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
        	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
        	WHERE productosxingredientes.codproducto IN ('".limpiar($row2['codproducto'])."') 
        	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			    $codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		        if($controlingredientebd == 1){// SIN CONTROL STOCK INGREDIENTE

				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
				   $update = "UPDATE ingredientes set "
				   ." cantingrediente = ? "
				   ." WHERE "
				   ." codingrediente = ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codingredientebd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$row2['cantcotizacion'], 2, '.', '');
				   $cantidadracion = number_format($cantingredientebd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

				   ############## REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX ###################
				   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codventa);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codingrediente);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaingrediente);
				   $stmt->bindParam(10, $descingrediente);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codcliente = limpiar($_POST["codcliente"]);
				   $codingrediente = limpiar($codingredientebd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantingredientebd-$racion, 2, '.', '');
				   $ivaingrediente = limpiar($ivaingredientebd == "NO" ? "0.00" : $iva);
				   $descingrediente = limpiar($descingredientebd);
				   $precio = limpiar($precioventaingredientebd);
				   $documento = limpiar("PROCESO EN COTIZACION");
				   $fechakardex = limpiar($fecha);
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX ###################
			    
			    }//FIN DE CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################	

    } elseif(limpiar($row2['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################

	    ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE codcombo = '".limpiar($row2['codproducto'])."'
		AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codcombo = '".limpiar($row2['codproducto'])."'
			     AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($row2['cantcotizacion'], 2, '.', '');
		$existencia = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################
        $query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
        $stmt->bindParam(14, $codsucursal);		

		$codcliente = limpiar($_POST["codcliente"]);
		$codcombo = limpiar($row2['codproducto']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$ivacombo = limpiar($row2['ivaproducto']);
		$desccombo = limpiar($row2['descproducto']);
		$precio = limpiar($row2['precioventa']);
		$documento = limpiar("PROCESO EN COTIZACION");
		$fechakardex = limpiar($fecha);
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($row2['codproducto'],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.ivaproducto,
	    	productos.controlstockp
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	WHERE combosxproductos.codcombo IN ('".limpiar($row2['codproducto'])."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd = $row['cantidad'];
			   $codproductobd = $row['codproducto'];
			   $cantproductobd = $row['existencia'];
			   $precioventaproductobd = $row['precioventa'];
			   $ivaproductobd = $row['ivaproducto'];
			   $descproductobd = $row['descproducto'];
		       $controlproductobd = $row['controlstockp'];

		        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproductobd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$row2['cantcotizacion'], 2, '.', '');
				   $cantidadracion = number_format($cantproductobd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codventa);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaproducto);
				   $stmt->bindParam(10, $descproducto);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codcliente = limpiar($_POST["codcliente"]);
				   $codproducto = limpiar($codproductobd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantproductobd-$racion, 2, '.', '');
				   $ivaproducto = limpiar($ivaproductobd == "NO" ? "0.00" : $iva);
				   $descproducto = limpiar($descproductobd);
				   $precio = limpiar($precioventaproductobd);
				   $documento = limpiar("PROCESO EN COTIZACION");
				   $fechakardex = limpiar($fecha);
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }//FIN DE CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

	############################### PROCESO PARA VERIFICAR LOS COMBOS ###################################### 

    }  else { // SI EL DETALLE ES UN EXTRA

   	############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    	############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################
		$sql = "SELECT 
		cantingrediente, 
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($row2['codproducto'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

		if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

		    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
			$sql = " UPDATE ingredientes set "
				  ." cantingrediente = ? "
				  ." WHERE "
				  ." codingrediente = '".limpiar($row2['codproducto'])."'
	                 AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
				   ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$cantventa = number_format($row2['cantcotizacion'], 2, '.', '');
			$existencia = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

			############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
	        $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codventa);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codingrediente);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaingrediente);
			$stmt->bindParam(10, $descingrediente);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
	        $stmt->bindParam(14, $codsucursal);			

			$codcliente = limpiar($_POST["codcliente"]);
			$codingrediente = limpiar($row2['codproducto']);
			$movimiento = limpiar("SALIDAS");
			$entradas = limpiar("0.00");
			$salidas= number_format($cantventa, 2, '.', '');
			$devolucion = limpiar("0.00");
			$stockactual = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$ivaingrediente = limpiar($row2['ivaproducto']);
			$descingrediente = limpiar($row2['descproducto']);
			$precio = limpiar($row2['precioventa']);
			$documento = limpiar("PROCESO EN COTIZACION");
			$fechakardex = limpiar($fecha);
	        $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
			############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################

		}// FIN DE CONTROL STOCK INGREDIENTE
    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    }// FIN DE TIPO DETALLE

    }// FIN DE FOR SESION
    $this->dbh->commit();

	######################## ELIMINO COTIZACION ########################
	$sql = "DELETE FROM cotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codcotizacion);
	$stmt->bindParam(2,$codsucursal);
	$codcotizacion = limpiar(decrypt($_POST["codcotizacion"]));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	######################## ELIMINO COTIZACION ########################

	######################## ELIMINO DETALLES COTIZACION ########################
	$sql = "DELETE FROM detallecotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
    $stmt->bindParam(1,$codcotizacion);
	$stmt->bindParam(2,$codsucursal);
	$codcotizacion = limpiar(decrypt($_POST["codcotizacion"]));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	######################## ELIMINO DETALLES COTIZACION ########################

	################## OBTENGO LOS DATOS EN CAJA ##################
	$sql = "SELECT 
	efectivo, 
	cheque, 
	tcredito, 
	tdebito, 
	tprepago, 
	transferencia, 
	electronico,
	cupon, 
	otros,
	creditos,
	propinasefectivo,
	propinasotros,
	nroticket,
	nroboleta,
	nrofactura
	FROM arqueocaja WHERE codarqueo = '".limpiar($codarqueo)."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$efectivo = ($row['efectivo']== "" ? "0.00" : $row['efectivo']);
	$cheque = ($row['cheque']== "" ? "0.00" : $row['cheque']);
	$tcredito = ($row['tcredito']== "" ? "0.00" : $row['tcredito']);
	$tdebito = ($row['tdebito']== "" ? "0.00" : $row['tdebito']);
	$tprepago = ($row['tprepago']== "" ? "0.00" : $row['tprepago']);
	$transferencia = ($row['transferencia']== "" ? "0.00" : $row['transferencia']);
	$electronico = ($row['electronico']== "" ? "0.00" : $row['electronico']);
	$cupon = ($row['cupon']== "" ? "0.00" : $row['cupon']);
	$otros = ($row['otros']== "" ? "0.00" : $row['otros']);
	$credito = ($row['creditos']== "" ? "0.00" : $row['creditos']);
	$propinasefectivo = ($row['propinasefectivo']== "" ? "0.00" : $row['propinasefectivo']);
	$propinasotros = ($row['propinasotros']== "" ? "0.00" : $row['propinasotros']);
	$nroticket = $row['nroticket'];
	$nroboleta = $row['nroboleta'];
	$nrofactura = $row['nrofactura'];
	################## OBTENGO LOS DATOS EN CAJA ##################

	############## AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ###############
	if (limpiar($_POST["tipopago"]=="CONTADO")){

	if(isset($_POST['formapago2']) && $_POST['formapago2']!=""){

	########################## AGREGO EL MONTO EN CAJA #################################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);

	if($_POST["formapago"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtEfectivo = $efectivo;	
	}

	if($_POST["formapago"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCheque = $cheque;	
	}

	if($_POST["formapago"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTcredito = $tcredito;	
	}

	if($_POST["formapago"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTdebito = $tdebito;	
	}

	if($_POST["formapago"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTprepago = $tprepago;	
	}

	if($_POST["formapago"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTransferencia = $transferencia;	
	}

	if($_POST["formapago"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtElectronico = $electronico;	
	}

	if($_POST["formapago"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCupon = $cupon;	
	}

	if($_POST["formapago"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtOtros = $otros;	
	}
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	########################## AGREGO EL MONTO EN CAJA #################################

	} else { 

	########################## PROCESO LA 1ERA FORMA DE PAGO #################################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);
	
	$textdelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");
	$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
	$txtEfectivo = limpiar($_POST["formapago"] == "EFECTIVO" ? number_format($efectivo+$TotalPagar, 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["formapago"] == "CHEQUE" ? number_format($cheque+$TotalPagar, 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["formapago"] == "TARJETA DE CREDITO" ? number_format($tcredito+$TotalPagar, 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["formapago"] == "TARJETA DE DEBITO" ? number_format($tdebito+$TotalPagar, 2, '.', '') : $tdebito);
	$txtTprepago = limpiar($_POST["formapago"] == "TARJETA PREPAGO" ? number_format($tprepago+$TotalPagar, 2, '.', '') : $tprepago);
	$txtTransferencia = limpiar($_POST["formapago"] == "TRANSFERENCIA" ? number_format($transferencia+$TotalPagar, 2, '.', '') : $transferencia);
	$txtElectronico = limpiar($_POST["formapago"] == "DINERO ELECTRONICO" ? number_format($electronico+$TotalPagar, 2, '.', '') : $electronico);
	$txtCupon = limpiar($_POST["formapago"] == "CUPON" ? number_format($cupon+$TotalPagar, 2, '.', '') : $cupon);
	$txtOtros = limpiar($_POST["formapago"] == "OTROS" ? number_format($otros+$TotalPagar, 2, '.', '') : $otros);
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	########################## PROCESO LA 1ERA FORMA DE PAGO #################################
		}
	}
    ################ AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ##############

    ######### AGREGAMOS EL INGRESO Y ABONOS DE VENTAS A CREDITOS A CAJA ############
	if (limpiar($_POST["tipopago"]=="CREDITO")) {

	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." creditos = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtCredito);
	$stmt->bindParam(11, $NumTicket);
	$stmt->bindParam(12, $NumBoleta);
	$stmt->bindParam(13, $NumFactura);
	$stmt->bindParam(14, $codarqueo);

	$textdelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");
	$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
	$txtEfectivo = limpiar($_POST["medioabono"] == "EFECTIVO" ? number_format($efectivo+$_POST["montoabono"], 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["medioabono"] == "CHEQUE" ? number_format($cheque+$_POST["montoabono"], 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["medioabono"] == "TARJETA DE CREDITO" ? number_format($tcredito+$_POST["montoabono"], 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["medioabono"] == "TARJETA DE DEBITO" ? number_format($tdebito+$_POST["montoabono"], 2, '.', '') : $tdebito);
	$txtTprepago = limpiar($_POST["medioabono"] == "TARJETA PREPAGO" ? number_format($tprepago+$_POST["montoabono"], 2, '.', '') : $tprepago);
	$txtTransferencia = limpiar($_POST["medioabono"] == "TRANSFERENCIA" ? number_format($transferencia+$_POST["montoabono"], 2, '.', '') : $transferencia);
	$txtElectronico = limpiar($_POST["medioabono"] == "DINERO ELECTRONICO" ? number_format($electronico+$_POST["montoabono"], 2, '.', '') : $electronico);
	$txtCupon = limpiar($_POST["medioabono"] == "CUPON" ? number_format($cupon+$_POST["montoabono"], 2, '.', '') : $cupon);
	$txtOtros = limpiar($_POST["medioabono"] == "OTROS" ? number_format($otros+$_POST["montoabono"], 2, '.', '') : $otros);
	$txtCredito = number_format($credito+($TotalPagar-$_POST["montoabono"]), 2, '.', '');

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();

	$sql = "SELECT codcliente FROM creditosxclientes WHERE codcliente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcliente"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO creditosxclientes values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $montocredito);
		$stmt->bindParam(3, $codsucursal);

		$codcliente = limpiar($_POST["codcliente"]);
		$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
		$montocredito = number_format($TotalPagar-$_POST["montoabono"], 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	} else { 

		$sql = "UPDATE creditosxclientes set"
		." montocredito = ? "
		." WHERE "
		." codcliente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $montocredito);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codsucursal);

		$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
		$montocredito = number_format($montoactual+($TotalPagar-$_POST["montoabono"]), 2, '.', '');
		$codcliente = limpiar($_POST["codcliente"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	}

   if (limpiar($_POST["montoabono"]!="0.00" && $_POST["montoabono"]!="0" && $_POST["montoabono"]!="")) {

	$query = "INSERT INTO abonoscreditos values (null, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcaja);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codcliente);
	$stmt->bindParam(4, $montoabono);
	$stmt->bindParam(5, $formaabono);
	$stmt->bindParam(6, $fechaabono);
	$stmt->bindParam(7, $codsucursal);

	$codcliente = limpiar($_POST["codcliente"]);
	$montoabono = limpiar($_POST["montoabono"]);
	$formaabono = limpiar($_POST["medioabono"]);
	$fechaabono = limpiar(date("Y-m-d H:i:s"));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

   }

	} 
   ########## AGREGAMOS EL INGRESO Y ABONOS DE VENTAS A CREDITOS A CAJA ########

echo "<span class='fa fa-check-square-o'></span> LA COTIZACION HA SIDO PROCESADA COMO VENTA EXITOSAMENTE <a href='reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR DOCUMENTO</strong></font color></a>";

	echo "<script>window.open('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '_blank');</script>";
	exit;
}
###################### FUNCION PROCESAR COTIZACIONES A VENTAS #################################

###################### FUNCION BUSQUEDA COTIZACIONES POR FECHAS ####################
public function BuscarCotizacionesxFechas() 
{
	self::SetNames();
	$sql ="SELECT 
	cotizaciones.idcotizacion, 
	cotizaciones.codcotizacion,  
	cotizaciones.codcliente, 
	cotizaciones.subtotalivasi, 
	cotizaciones.subtotalivano, 
	cotizaciones.iva, 
	cotizaciones.totaliva, 
	cotizaciones.descontado,
	cotizaciones.descuento, 
	cotizaciones.totaldescuento,
	cotizaciones.totalpago, 
	cotizaciones.totalpago2, 
	cotizaciones.observaciones,
	cotizaciones.fechacotizacion,
	cotizaciones.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	provincias.provincia,
	departamentos.departamento,
	provincias2.provincia AS provincia2,
	departamentos2.departamento AS departamento2,
	usuarios.dni,
	usuarios.nombres,  
	SUM(detallecotizaciones.cantcotizacion) AS articulos
	FROM (cotizaciones LEFT JOIN detallecotizaciones ON detallecotizaciones.codcotizacion = cotizaciones.codcotizacion)
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal 
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON cotizaciones.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON clientes.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON clientes.id_departamento = departamentos2.id_departamento
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE cotizaciones.codsucursal = ? 
	AND DATE_FORMAT(cotizaciones.fechacotizacion,'%Y-%m-%d') BETWEEN ? AND ?
	GROUP BY detallecotizaciones.codcotizacion";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON COTIZACIONES PARA EL RANGO DE FECHA INGRESADO</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################### FUNCION BUSQUEDA COTIZACIONES POR FECHAS ###################

###################### FUNCION BUSCAR DETALLES COTIZACIONES POR FECHAS #########################
public function BuscarDetallesCotizacionesxFechas() 
{
	self::SetNames();
	$sql ="SELECT 
	detallecotizaciones.idproducto,
	detallecotizaciones.codproducto,
	detallecotizaciones.producto,
	detallecotizaciones.codcategoria,
	detallecotizaciones.descproducto,
	detallecotizaciones.ivaproducto,
	detallecotizaciones.preciocompra, 
	detallecotizaciones.precioventa, 
	detallecotizaciones.tipo, 
	productos.existencia,
	categorias.nomcategoria, 
	combos.existencia AS cantcombo,
	ingredientes.cantingrediente,
	medidas.nommedida,
	cotizaciones.iva,
	cotizaciones.fechacotizacion,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfsucursal,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.llevacontabilidad,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
    documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	provincias.provincia,
	departamentos.departamento,
	valor_cambio.montocambio,
	usuarios.dni,
	usuarios.nombres, 
	SUM(detallecotizaciones.cantcotizacion) as cantidad 
	FROM (cotizaciones INNER JOIN detallecotizaciones ON cotizaciones.codcotizacion = detallecotizaciones.codcotizacion) 
	LEFT JOIN productos ON detallecotizaciones.idproducto = productos.idproducto
	LEFT JOIN categorias ON detallecotizaciones.codcategoria = categorias.codcategoria  
	LEFT JOIN combos ON detallecotizaciones.idproducto = combos.idcombo
	LEFT JOIN ingredientes ON detallecotizaciones.idproducto = ingredientes.idingrediente
	LEFT JOIN medidas ON detallecotizaciones.codcategoria = medidas.codmedida
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE cotizaciones.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	AND DATE_FORMAT(cotizaciones.fechacotizacion,'%Y-%m-%d') BETWEEN ? AND ? 
	GROUP BY detallecotizaciones.codproducto, detallecotizaciones.precioventa, detallecotizaciones.ivaproducto, detallecotizaciones.descproducto, detallecotizaciones.tipo
	ORDER BY detallecotizaciones.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN DETALLES COTIZADOS PARA EL RANGO DE FECHA INGRESADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION BUSCAR DETALLES COTIZACIONES POR FECHAS ###############################

###################### FUNCION BUSCAR DETALLES COTIZACIONES POR VENDEDOR #########################
public function BuscarDetallesCotizacionesxVendedor() 
{
   self::SetNames();
	$sql ="SELECT 
	detallecotizaciones.idproducto,
	detallecotizaciones.codproducto,
	detallecotizaciones.producto,
	detallecotizaciones.codcategoria,
	detallecotizaciones.descproducto,
	detallecotizaciones.ivaproducto,
	detallecotizaciones.preciocompra, 
	detallecotizaciones.precioventa, 
	detallecotizaciones.tipo, 
	productos.existencia,
	categorias.nomcategoria, 
	combos.existencia AS cantcombo,
	ingredientes.cantingrediente,
	medidas.nommedida,
	cotizaciones.fechacotizacion,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.tlfsucursal,
	sucursales.direcsucursal,
	sucursales.correosucursal,
	sucursales.llevacontabilidad,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
    documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	provincias.provincia,
	departamentos.departamento,
	usuarios.dni,
	usuarios.nombres, 
	SUM(detallecotizaciones.cantcotizacion) as cantidad 
	FROM (cotizaciones INNER JOIN detallecotizaciones ON cotizaciones.codcotizacion = detallecotizaciones.codcotizacion) 
	LEFT JOIN productos ON detallecotizaciones.idproducto = productos.idproducto
	LEFT JOIN categorias ON detallecotizaciones.codcategoria = categorias.codcategoria  
	LEFT JOIN combos ON detallecotizaciones.idproducto = combos.idcombo
	LEFT JOIN ingredientes ON detallecotizaciones.idproducto = ingredientes.idingrediente
	LEFT JOIN medidas ON detallecotizaciones.codcategoria = medidas.codmedida
	LEFT JOIN sucursales ON cotizaciones.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN usuarios ON cotizaciones.codigo = usuarios.codigo
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
	WHERE cotizaciones.codigo = ? 
    AND DATE_FORMAT(cotizaciones.fechacotizacion,'%Y-%m-%d') BETWEEN ? AND ? 
	GROUP BY detallecotizaciones.codproducto, detallecotizaciones.precioventa, detallecotizaciones.ivaproducto, detallecotizaciones.descproducto, detallecotizaciones.tipo
	ORDER BY detallecotizaciones.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codigo']));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN DETALLES COTIZADOS PARA EL VENDEDOR Y RANGO DE FECHA INGRESADA</center>";
	echo "</div>";		
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSCAR DETALLES COTIZACIONES POR VENDEDOR #########################

########################### FIN DE CLASE COTIZACIONES ############################































################################ CLASE CAJAS DE VENTAS ################################

######################### FUNCION REGISTRAR CAJAS DE VENTAS #######################
public function RegistrarCajas()
{
	self::SetNames();
	if(empty($_POST["nrocaja"]) or empty($_POST["nomcaja"]) or empty($_POST["codigo"]))
	{
		echo "1";
		exit;
	}
		
		$sql = "SELECT nrocaja FROM cajas WHERE nrocaja = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["nrocaja"],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num > 0)
		{
		    echo "2";
		    exit;

		} else {
			
		$sql = "SELECT nomcaja FROM cajas WHERE nomcaja = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["nomcaja"],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num > 0)
		{
			echo "3";
			exit;

		} else {
			
		$sql = "SELECT codigo FROM cajas WHERE codigo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codigo"],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$query = "INSERT INTO cajas values (null, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $nrocaja);
			$stmt->bindParam(2, $nomcaja);
			$stmt->bindParam(3, $codigo);
			$stmt->bindParam(4, $codsucursal);

			$nrocaja = limpiar($_POST["nrocaja"]);
			$nomcaja = limpiar($_POST["nomcaja"]);
			$codigo = limpiar($_POST["codigo"]);
			$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();

			echo "<span class='fa fa-check-square-o'></span> LA CAJA PARA VENTA HA SIDO REGISTRADA EXITOSAMENTE";
			exit;

			} else {

			echo "4";
			exit;
		    }
		}
	}
}
######################### FUNCION REGISTRAR CAJAS DE VENTAS #########################

######################### FUNCION LISTAR CAJAS DE VENTAS ################################
public function ListarCajas()
{
	self::SetNames();
	
	if($_SESSION['acceso'] == "administradorS") {

	$sql = "SELECT * FROM cajas INNER JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
    WHERE cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";

		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} else if($_SESSION["acceso"] == "cajero") {

    $sql = "SELECT * FROM cajas INNER JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
    WHERE cajas.codigo = '".limpiar($_SESSION["codigo"])."'
    AND cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} else {

	$sql = "SELECT * FROM cajas INNER JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION LISTAR CAJAS DE VENTAS ################################

############################ FUNCION ID CAJAS DE VENTAS #################################
public function CajasPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM cajas 
	INNER JOIN usuarios ON usuarios.codigo = cajas.codigo
	INNER JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda 
	WHERE cajas.codcaja = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcaja"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID CAJAS DE VENTAS #################################

#################### FUNCION ACTUALIZAR CAJAS DE VENTAS ############################
public function ActualizarCajas()
{
	self::SetNames();
	if(empty($_POST["codcaja"]) or empty($_POST["nrocaja"]) or empty($_POST["nomcaja"]) or empty($_POST["codigo"]))
	{
		echo "1";
		exit;
	}
		$sql = "SELECT nrocaja FROM cajas WHERE codcaja != ? AND nrocaja = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codcaja"],$_POST["nrocaja"],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num > 0)
		{
		    echo "2";
		    exit;

		} else {
			
		$sql = "SELECT nomcaja FROM cajas WHERE codcaja != ? AND nomcaja = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codcaja"],$_POST["nomcaja"],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num > 0)
		{
			echo "3";
			exit;

		} else {
			
		$sql = "SELECT codigo FROM cajas WHERE codcaja != ? AND codigo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["codcaja"],$_POST["codigo"],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$sql = "UPDATE cajas set "
			." nrocaja = ?, "
			." nomcaja = ?, "
			." codigo = ?, "
			." codsucursal = ? "
			." WHERE "
			." codcaja = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $nrocaja);
			$stmt->bindParam(2, $nomcaja);
			$stmt->bindParam(3, $codigo);
			$stmt->bindParam(4, $codsucursal);
			$stmt->bindParam(5, $codcaja);

			$nrocaja = limpiar($_POST["nrocaja"]);
			$nomcaja = limpiar($_POST["nomcaja"]);
			$codigo = limpiar($_POST["codigo"]);
			$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$codcaja = limpiar($_POST["codcaja"]);
			$stmt->execute();

			echo "<span class='fa fa-check-square-o'></span> LA CAJA PARA VENTA HA SIDO ACTUALIZADA EXITOSAMENTE";
			exit;

			} else {

			echo "4";
			exit;
		    }
		}
	}
}
#################### FUNCION ACTUALIZAR CAJAS DE VENTAS ###########################

####################### FUNCION ELIMINAR CAJAS DE VENTAS ########################
public function EliminarCajas()
{
	self::SetNames();
		if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

		$sql = "SELECT codcaja FROM ventas WHERE codcaja = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["codcaja"])));
		$num = $stmt->rowCount();
		if($num == 0)
		{

			$sql = "DELETE FROM cajas WHERE codcaja = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1,$codcaja);
			$codcaja = decrypt($_GET["codcaja"]);
			$stmt->execute();

			echo "1";
			exit;

		} else {
		   
			echo "2";
			exit;
		  } 
			
		} else {
		
		echo "3";
		exit;
	 }	
}
####################### FUNCION ELIMINAR CAJAS DE VENTAS #######################

####################### FUNCION BUSCAR CAJAS POR SUCURSAL ###############################
public function BuscarCajasxSucursal() 
    {
	self::SetNames();
	$sql = " SELECT * FROM cajas 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	INNER JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal 
	WHERE sucursales.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION BUSCAR CAJAS POR SUCURSAL #######################

######################### FUNCION LISTAR CAJAS ABIERTAS ##########################
public function ListarCajasAbiertas()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT * FROM arqueocaja INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
    WHERE cajas.codsucursal = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	     if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	       }
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}

	} else if($_SESSION["acceso"] == "cajero") {

    $sql = "SELECT * FROM arqueocaja INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
    WHERE cajas.codigo = '".limpiar($_SESSION["codigo"])."'
    AND cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
    AND arqueocaja.statusarqueo = 1
    GROUP BY arqueocaja.codarqueo";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} else {

	$sql = "SELECT * FROM arqueocaja INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
    WHERE cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
    AND arqueocaja.statusarqueo = 1
    GROUP BY arqueocaja.codarqueo";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
   }
}
######################### FUNCION LISTAR CAJAS ABIERTAS ##########################

############################ FIN DE CLASE CAJAS DE VENTAS ##############################


























########################## CLASE ARQUEOS DE CAJA ###################################

########################## FUNCION PARA REGISTRAR ARQUEO DE CAJA ####################
public function RegistrarArqueoCaja()
{
	self::SetNames();
	if(empty($_POST["codcaja"]) or empty($_POST["montoinicial"]) or empty($_POST["fecharegistro"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT codcaja FROM arqueocaja WHERE codcaja = ? AND statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcaja"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO arqueocaja values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcaja);
		$stmt->bindParam(2, $montoinicial);
		$stmt->bindParam(3, $efectivo);
		$stmt->bindParam(4, $cheque);
		$stmt->bindParam(5, $tcredito);
		$stmt->bindParam(6, $tdebito);
		$stmt->bindParam(7, $tprepago);
		$stmt->bindParam(8, $transferencia);
		$stmt->bindParam(9, $electronico);
		$stmt->bindParam(10, $cupon);
		$stmt->bindParam(11, $otros);
		$stmt->bindParam(12, $creditos);
		$stmt->bindParam(13, $abonosefectivo);
		$stmt->bindParam(14, $abonosotros);
		$stmt->bindParam(15, $propinasefectivo);
		$stmt->bindParam(16, $propinasotros);
		$stmt->bindParam(17, $ingresosefectivo);
		$stmt->bindParam(18, $ingresosotros);
		$stmt->bindParam(19, $egresos);
		$stmt->bindParam(20, $egresonotas);
		$stmt->bindParam(21, $nroticket);
		$stmt->bindParam(22, $nroboleta);
		$stmt->bindParam(23, $nrofactura);
		$stmt->bindParam(24, $nronota);
		$stmt->bindParam(25, $dineroefectivo);
		$stmt->bindParam(26, $diferencia);
		$stmt->bindParam(27, $comentarios);
		$stmt->bindParam(28, $fechaapertura);
		$stmt->bindParam(29, $fechacierre);
		$stmt->bindParam(30, $statusarqueo);
		$stmt->bindParam(31, $codsucursal);

		$codcaja = limpiar($_POST["codcaja"]);
		$montoinicial = limpiar($_POST["montoinicial"]);
		$efectivo = limpiar("0.00");
		$cheque = limpiar("0.00");
		$tcredito = limpiar("0.00");
		$tdebito = limpiar("0.00");
		$tprepago = limpiar("0.00");
		$transferencia = limpiar("0.00");
		$electronico = limpiar("0.00");
		$cupon = limpiar("0.00");
		$otros = limpiar("0.00");
		$creditos = limpiar("0.00");
		$abonosefectivo = limpiar("0.00");
		$abonosotros = limpiar("0.00");
		$propinasefectivo = limpiar("0.00");
		$propinasotros = limpiar("0.00");
		$ingresosefectivo = limpiar("0.00");
		$ingresosotros = limpiar("0.00");
		$egresos = limpiar("0.00");
		$egresonotas = limpiar("0.00");
		$nroticket = limpiar("0");
		$nroboleta = limpiar("0");
		$nrofactura = limpiar("0");
		$nronota = limpiar("0");
		$dineroefectivo = limpiar("0.00");
		$diferencia = limpiar("0.00");
		$comentarios = limpiar('NINGUNO');
		$fechaapertura = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fecharegistro'])));
		$fechacierre = limpiar("0000-00-00 00:00:00");
		$statusarqueo = limpiar("1");
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL ARQUEO DE CAJA HA SIDO REALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
######################## FUNCION PARA REGISTRAR ARQUEO DE CAJA #######################

######################## FUNCION PARA LISTAR ARQUEO DE CAJA ########################
public function ListarArqueoCaja()
{
	self::SetNames();
	if($_SESSION['acceso'] == "administradorS") {

    $sql = "SELECT * FROM arqueocaja 
    INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda 
    WHERE cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
    ORDER BY arqueocaja.codarqueo DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else if($_SESSION["acceso"] == "cajero") {

    $sql = "SELECT * FROM arqueocaja 
    INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda 
    WHERE cajas.codigo = '".limpiar($_SESSION["codigo"])."'
    AND cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
    ORDER BY arqueocaja.codarqueo DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

	$sql = "SELECT * FROM arqueocaja 
    INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda 
	ORDER BY arqueocaja.codarqueo DESC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	}
}
######################## FUNCION PARA LISTAR ARQUEO DE CAJA #########################

########################## FUNCION ID ARQUEO DE CAJA #############################
public function ArqueoCajaPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM arqueocaja 
    INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento    
	WHERE arqueocaja.codarqueo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codarqueo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################## FUNCION ID ARQUEO DE CAJA #############################

##################### FUNCION VERIFICA ARQUEO DE CAJA POR USUARIO #######################
public function ArqueoCajaPorUsuario()
{
	self::SetNames();
	$sql = "SELECT * FROM arqueocaja 
    INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_SESSION["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION VERIFICA ARQUEO DE CAJA POR USUARIO ###################

######################### FUNCION PARA CERRAR ARQUEO DE CAJA #########################
public function CerrarArqueoCaja()
{
	self::SetNames();
	if(empty($_POST["codarqueo"]) or empty($_POST["dineroefectivo"]))
	{
		echo "1";
		exit;
	}

	if($_POST["dineroefectivo"] != 0.00 || $_POST["dineroefectivo"] != 0){

		$sql = "UPDATE arqueocaja SET "
		." dineroefectivo = ?, "
		." diferencia = ?, "
		." comentarios = ?, "
		." fechacierre = ?, "
		." statusarqueo = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $dineroefectivo);
		$stmt->bindParam(2, $diferencia);
		$stmt->bindParam(5, $statusarqueo);
		$stmt->bindParam(3, $comentarios);
		$stmt->bindParam(4, $fechacierre);
		$stmt->bindParam(6, $codarqueo);

		$dineroefectivo = limpiar($_POST["dineroefectivo"]);
		$diferencia = limpiar($_POST["diferencia"]);
		$comentarios = limpiar($_POST['comentarios']);
		$fechacierre = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fecharegistro'])));
		$statusarqueo = limpiar("0");
		$codarqueo = limpiar($_POST["codarqueo"]);
		$stmt->execute();
  
	    echo "<span class='fa fa-check-square-o'></span> EL CIERRE DE CAJA FUE REALIZADO EXITOSAMENTE <a href='reportepdf?codarqueo=".encrypt($codarqueo)."&tipo=".encrypt("TICKETCIERRE")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR TICKET</strong></font color></a></div>";

	    echo "<script>window.open('reportepdf?codarqueo=".encrypt($codarqueo)."&tipo=".encrypt("TICKETCIERRE")."', '_blank');</script>";
	    exit;
	
	} else {

		echo "2";
		exit;
	}
}
######################### FUNCION PARA CERRAR ARQUEO DE CAJA ######################

###################### FUNCION BUSCAR ARQUEOS DE CAJA POR FECHAS ######################
public function BuscarArqueosxFechas() 
	{
	self::SetNames();
	$sql = "SELECT * FROM arqueocaja 
    INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda 
	WHERE sucursales.codsucursal = ? 
	AND arqueocaja.codcaja = ? 
	AND DATE_FORMAT(arqueocaja.fechaapertura,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codcaja'])));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(4, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</div></center>";
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
    }
}
######################## FUNCION BUSCAR ARQUEOS DE CAJA POR FECHAS ####################

##################### FUNCION INFORME DE CAJAS POR FECHAS #######################
public function SumarVentasCajasxFechas()
{
	self::SetNames();
	$sql = "SELECT 
	SUM(totaliva) AS totaliva, 
	SUM(totalpago) AS totalventa, 
	SUM(totalpago2) AS totalcompra
	FROM ventas WHERE codcaja = ? 
	AND DATE_FORMAT(fechaventa,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codcaja'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}

public function SumarArqueosCajasxFechas()
{
	self::SetNames();
	$sql = "SELECT 
	SUM(ingresosefectivo+ingresosotros) AS totalingresos, 
	SUM(egresos+egresonotas) AS totalegresos, 
	SUM(abonosefectivo+abonosotros) AS totalabonos
	FROM arqueocaja WHERE codcaja = ? 
	AND DATE_FORMAT(fechaapertura,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codcaja'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION INFORME DE CAJAS POR FECHAS ###################


##################### FUNCION INFORME DE VENTAS POR FECHAS #######################
public function SumarVentasxFechas()
{
	self::SetNames();
	$sql = "SELECT 
	SUM(totaliva) AS totaliva, 
	SUM(totalpago) AS totalventa, 
	SUM(totalpago2) AS totalcompra
	FROM ventas WHERE codsucursal = ? 
	AND DATE_FORMAT(fechaventa,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}

public function SumarComprasxFechas()
{
	self::SetNames();
	$sql = "SELECT 
	SUM(totalivac) AS totalivacompra, 
	SUM(totalpagoc) AS totalcomprageneral 
	FROM compras WHERE codsucursal = ? 
	AND DATE_FORMAT(fechaemision,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}

public function SumarArqueosxFechas()
{
	self::SetNames();
	$sql = "SELECT 
	SUM(ingresosefectivo+ingresosotros) AS totalingresos, 
	SUM(egresos+egresonotas) AS totalegresos, 
	SUM(abonosefectivo+abonosotros) AS totalabonos
	FROM arqueocaja WHERE codsucursal = ? 
	AND DATE_FORMAT(fechaapertura,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}

public function SumarCarteraxFechas()
{
	self::SetNames();
	/*$sql = "SELECT
	(SELECT SUM(totalpago) FROM ventas WHERE tipopago = 'CREDITO') AS totaldebe,
	(SELECT SUM(montoabono) FROM abonoscreditos) AS totalabono";*/
	$sql = "SELECT 
	SUM(totalpago) AS totaldebe, 
	SUM(creditopagado) AS totalpagado 
	FROM ventas WHERE codsucursal = ? AND tipopago = 'CREDITO'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION INFORME DE VENTAS POR FECHAS ###################

############################# FIN DE CLASE ARQUEOS DE CAJA ###########################


























############################ CLASE MOVIMIENTOS EN CAJAS ##############################

###################### FUNCION PARA REGISTRAR MOVIMIENTO EN CAJA #######################
public function RegistrarMovimientos()
{
	self::SetNames();
	if(empty($_POST["tipomovimiento"]) or empty($_POST["montomovimiento"]) or empty($_POST["mediomovimiento"]) or empty($_POST["codcaja"]))
	{
		echo "1";
		exit;
	}
	elseif($_POST["montomovimiento"] == "" || $_POST["montomovimiento"] == 0 || $_POST["montomovimiento"] == 0.00)
	{
		echo "2";
		exit;
	}
	
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE arqueocaja.codcaja = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codcaja"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "4";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$arqueo = $row['codarqueo'];
		$inicial = $row['montoinicial'];
		$efectivo = $row['efectivo'];
		$abono = $row['abonosefectivo'];
		$propina = $row['propinasefectivo'];
		$ingreso = $row['ingresosefectivo'];
		$ingreso2 = $row['ingresosotros'];
		$egresos = $row['egresos'];
		$total = $inicial+$efectivo+$abono+$propina+$ingreso-$egresos;
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################

	//REALIZO LA CONDICION SI EL MOVIMIENTO ES UN INGRESO
	if($_POST["tipomovimiento"]=="INGRESO"){ 

		######################## ACTUALIZO DATOS EN ARQUEO ########################
		$sql = " UPDATE arqueocaja SET "
		." ingresosefectivo = ?, "
		." ingresosotros = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtEfectivo);
		$stmt->bindParam(2, $txtOtros);
		$stmt->bindParam(3, $codcaja);

		$txtEfectivo = limpiar($_POST["mediomovimiento"] == "EFECTIVO" ? number_format($ingreso+$_POST["montomovimiento"], 2, '.', '') : $ingreso);
	    $txtOtros = limpiar($_POST["mediomovimiento"] != "EFECTIVO" ? number_format($ingreso2+$_POST["montomovimiento"], 2, '.', '') : $ingreso2);
		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$stmt->execute();
		######################## ACTUALIZO DATOS EN ARQUEO ########################

		######################## REGISTRO EL MOVIMIENTOS EN CAJA ########################
		$query = "INSERT INTO movimientoscajas values (null, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcaja);
		$stmt->bindParam(2, $tipomovimiento);
		$stmt->bindParam(3, $descripcionmovimiento);
		$stmt->bindParam(4, $montomovimiento);
		$stmt->bindParam(5, $mediomovimiento);
		$stmt->bindParam(6, $fechamovimiento);
		$stmt->bindParam(7, $arqueo);

		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$tipomovimiento = limpiar($_POST["tipomovimiento"]);
		$descripcionmovimiento = limpiar($_POST["descripcionmovimiento"]);
		$montomovimiento = limpiar($_POST["montomovimiento"]);
		$mediomovimiento = limpiar($_POST["mediomovimiento"]);
		$fechamovimiento = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fecharegistro'])));
		$stmt->execute();
		######################## REGISTRO EL MOVIMIENTOS EN CAJA ########################

    //REALIZO LA CONDICION SI EL MOVIMIENTO ES UN EGRESO
	} else {

	    if($_POST["mediomovimiento"]!="EFECTIVO"){

			echo "5";
			exit;

        } else if($_POST["montomovimiento"]>$total){

			echo "6";
			exit;

        } else {

		######################## ACTUALIZO DATOS EN ARQUEO ########################
        $sql = "UPDATE arqueocaja SET "
		." egresos = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $egresos);
		$stmt->bindParam(2, $codcaja);

		$egresos = number_format($egresos+$_POST["montomovimiento"], 2, '.', '');
		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$stmt->execute();
		######################## ACTUALIZO DATOS EN ARQUEO ########################

		######################## REGISTRO EL MOVIMIENTOS EN CAJA ########################
		$query = "INSERT INTO movimientoscajas values (null, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcaja);
		$stmt->bindParam(2, $tipomovimiento);
		$stmt->bindParam(3, $descripcionmovimiento);
		$stmt->bindParam(4, $montomovimiento);
		$stmt->bindParam(5, $mediomovimiento);
		$stmt->bindParam(6, $fechamovimiento);
		$stmt->bindParam(7, $arqueo);

		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$tipomovimiento = limpiar($_POST["tipomovimiento"]);
		$descripcionmovimiento = limpiar($_POST["descripcionmovimiento"]);
		$montomovimiento = limpiar($_POST["montomovimiento"]);
		$mediomovimiento = limpiar($_POST["mediomovimiento"]);
		$fechamovimiento = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fecharegistro'])));
		$stmt->execute();
		######################## REGISTRO EL MOVIMIENTOS EN CAJA ########################

	     }
	}

	echo "<span class='fa fa-check-square-o'></span> EL MOVIMIENTO EN CAJA HA SIDO REGISTRADO EXITOSAMENTE";
	exit;	
}
##################### FUNCION PARA REGISTRAR MOVIMIENTO EN CAJA #######################

###################### FUNCION PARA LISTAR MOVIMIENTO EN CAJA #######################
public function ListarMovimientos()
{
	self::SetNames();
	
	if($_SESSION['acceso'] == "administradorS" || $_SESSION['acceso'] == "secretaria") {

    $sql = "SELECT * FROM movimientoscajas 
    LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo
    LEFT JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
    WHERE cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} else if($_SESSION["acceso"] == "cajero") {

    $sql = "SELECT * FROM movimientoscajas 
    LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo
    LEFT JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	WHERE usuarios.codigo = '".limpiar($_SESSION["codigo"])."'
    AND cajas.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} else {

	$sql = "SELECT * FROM movimientoscajas 
    LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo
    LEFT JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION PARA LISTAR MOVIMIENTO EN CAJA ######################

########################## FUNCION ID MOVIMIENTO EN CAJA #############################
public function MovimientosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM movimientoscajas 
    LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo
    LEFT JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	WHERE movimientoscajas.codmovimiento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmovimiento"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################## FUNCION ID MOVIMIENTO EN CAJA #############################

##################### FUNCION PARA ACTUALIZAR MOVIMIENTOS EN CAJA ##################
public function ActualizarMovimientos()
{
	self::SetNames();
	if(empty($_POST["codmovimiento"]) or empty($_POST["tipomovimiento"]) or empty($_POST["montomovimiento"]) or empty($_POST["mediomovimiento"]) or empty($_POST["codcaja"]))
	{
		echo "1";
		exit;
	}
	elseif($_POST["montomovimiento"] == "" || $_POST["montomovimiento"] == 0 || $_POST["montomovimiento"] == 0.00)
	{
		echo "2";
		exit;

	}
	elseif($_POST["tipomovimiento"] != $_POST["tipomovimientobd"] || $_POST["mediomovimiento"] != $_POST["mediomovimientobd"])
	{
		echo "3";
		exit;
	}

	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE arqueocaja.codarqueo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codarqueo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "4";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$arqueo = $row['codarqueo'];
		$inicial = $row['montoinicial'];
		$efectivo = $row['efectivo'];
		$abono = $row['abonosefectivo'];
		$propina = $row['propinasefectivo'];
		$ingreso = $row['ingresosefectivo'];
		$ingreso2 = $row['ingresosotros'];
		$egreso = $row['egresos'];
		$status = $row['statusarqueo'];
		$total = $inicial+$efectivo+$abono+$propina+$ingreso-$egreso;
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################
	
	//REALIZAMOS CALCULO DE CAMPOS
	$montomovimiento = limpiar($_POST["montomovimiento"]);
	$montomovimientobd = limpiar($_POST["montomovimientobd"]);
	$ingresobd = number_format($ingreso-$montomovimientobd, 2, '.', '');
	$ingresobd2 = number_format($ingreso2-$montomovimientobd, 2, '.', '');
	$totalmovimiento = number_format($montomovimiento-$montomovimientobd, 2, '.', '');

	if($status == 1) {

	if($_POST["tipomovimiento"]=="INGRESO"){ //REALIZO LA CONDICION SI EL MOVIMIENTO ES UN INGRESO

	$sql = "UPDATE arqueocaja SET "
		." ingresosefectivo = ?, "
		." ingresosotros = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtEfectivo);
		$stmt->bindParam(2, $txtOtros);
		$stmt->bindParam(3, $codcaja);
		
		$txtEfectivo = limpiar($_POST["mediomovimiento"] == "EFECTIVO" ? number_format($ingresobd+$montomovimiento, 2, '.', '') : $ingreso);
	    $txtOtros = limpiar($_POST["mediomovimiento"] != "EFECTIVO" ? number_format($ingresobd2+$montomovimiento, 2, '.', '') : $ingreso2);
		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$stmt->execute();

	    $sql = "UPDATE movimientoscajas SET"
		." codcaja = ?, "
		." tipomovimiento = ?, "
		." descripcionmovimiento = ?, "
		." montomovimiento = ?, "
		." mediomovimiento = ? "
		." WHERE "
		." codmovimiento = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codcaja);
		$stmt->bindParam(2, $tipomovimiento);
		$stmt->bindParam(3, $descripcionmovimiento);
		$stmt->bindParam(4, $montomovimiento);
		$stmt->bindParam(5, $mediomovimiento);
		$stmt->bindParam(6, $codmovimiento);

		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$tipomovimiento = limpiar($_POST["tipomovimiento"]);
		$descripcionmovimiento = limpiar($_POST["descripcionmovimiento"]);
		$montomovimiento = limpiar($_POST["montomovimiento"]);
		$mediomovimiento = limpiar($_POST["mediomovimiento"]);
		$codmovimiento = limpiar($_POST["codmovimiento"]);
		$stmt->execute();

	} else { //REALIZO LA CONDICION SI EL MOVIMIENTO ES UN EGRESO

	    if($_POST["mediomovimiento"]!="EFECTIVO"){

			echo "5";
			exit;

        } else if($totalmovimiento>$total){

			echo "6";
			exit;

        } else {

	$sql = "UPDATE arqueocaja SET"
		." egresos = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $egresos);
		$stmt->bindParam(2, $codcaja);

		$egresos = number_format($egreso+$totalmovimiento, 2, '.', '');
		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$stmt->execute();

		$sql = "UPDATE movimientoscajas SET"
		." codcaja = ?, "
		." tipomovimiento = ?, "
		." descripcionmovimiento = ?, "
		." montomovimiento = ?, "
		." mediomovimiento = ? "
		." WHERE "
		." codmovimiento = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codcaja);
		$stmt->bindParam(2, $tipomovimiento);
		$stmt->bindParam(3, $descripcionmovimiento);
		$stmt->bindParam(4, $montomovimiento);
		$stmt->bindParam(5, $mediomovimiento);
		$stmt->bindParam(6, $codmovimiento);

		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$tipomovimiento = limpiar($_POST["tipomovimiento"]);
		$descripcionmovimiento = limpiar($_POST["descripcionmovimiento"]);
		$montomovimiento = limpiar($_POST["montomovimiento"]);
		$mediomovimiento = limpiar($_POST["mediomovimiento"]);
		$codmovimiento = limpiar($_POST["codmovimiento"]);
		$stmt->execute();

	    }
	}	

	echo "<span class='fa fa-check-square-o'></span> EL MOVIMIENTO EN CAJA HA SIDO ACTUALIZADO EXITOSAMENTE";
    exit;

	} else {
		   
		echo "7";
		exit;
    }
} 
##################### FUNCION PARA ACTUALIZAR MOVIMIENTOS EN CAJA ####################	

###################### FUNCION PARA ELIMINAR MOVIMIENTOS EN CAJA ######################
public function EliminarMovimiento()
{
	if($_SESSION['acceso'] == "administradorS" || $_SESSION['acceso'] == "secretaria" || $_SESSION['acceso'] == "cajero") {

    #################### AGREGAMOS EL INGRESO A ARQUEO EN CAJA ####################
	$sql = "SELECT * FROM movimientoscajas INNER JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo WHERE movimientoscajas.codmovimiento = '".limpiar(decrypt($_GET["codmovimiento"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	//OBTENEMOS CAMPOS DE MOVIMIENTOS
	$codcaja = $row['codcaja'];
	$tipomovimiento = $row['tipomovimiento'];
	$descripcionmovimiento = $row['descripcionmovimiento'];
	$montomovimiento = $row['montomovimiento'];
	$mediomovimiento = $row['mediomovimiento'];
	$fechamovimiento = $row['fechamovimiento'];

	//OBTENEMOS CAMPOS DE ARQUEO
	$inicial = $row['montoinicial'];
	$efectivo = $row['efectivo'];
	$ingreso = $row['ingresosefectivo'];
	$ingreso2 = $row['ingresosotros'];
	$egreso = $row['egresos'];
	$status = $row['statusarqueo'];

    if($status == 1) {

        if($tipomovimiento=="INGRESO"){

		$sql = "UPDATE arqueocaja SET"
		." ingresosefectivo = ?, "
		." ingresosotros = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtEfectivo);
		$stmt->bindParam(2, $txtOtros);
		$stmt->bindParam(3, $codcaja);

	   $txtEfectivo = limpiar($mediomovimiento == "EFECTIVO" ? number_format($ingreso-$montomovimiento, 2, '.', '') : $ingreso);
	    $txtOtros = limpiar($mediomovimiento != "EFECTIVO" ? number_format($ingreso2-$montomovimiento, 2, '.', '') : $ingreso2);
		$stmt->execute();

       } else {

		$sql = "UPDATE arqueocaja SET "
		." egresos = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $egresos);
		$stmt->bindParam(2, $codcaja);

		$egresos = number_format($egreso-$montomovimiento, 2, '.', '');
		$stmt->execute();

      }

		$sql = "DELETE FROM movimientoscajas WHERE codmovimiento = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmovimiento);
		$codmovimiento = decrypt($_GET["codmovimiento"]);
		$stmt->execute();

		echo "1";
		exit;
		   
		 } else {
		   
			echo "2";
			exit;
		  }
			
	} else {
		
		echo "3";
		exit;
	 }	
}
###################### FUNCION PARA ELIMINAR MOVIMIENTOS EN CAJAS  ####################

################## FUNCION BUSCAR MOVIMIENTOS DE CAJA POR FECHAS #######################
public function BuscarMovimientosxFechas() 
	{
	self::SetNames();
	$sql = "SELECT * FROM movimientoscajas 
    LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo
    LEFT JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja
    LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
    LEFT JOIN sucursales ON cajas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	WHERE sucursales.codsucursal = ? 
	AND movimientoscajas.codcaja = ? 
	AND DATE_FORMAT(movimientoscajas.fechamovimiento,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codcaja'])));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(4, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<center><div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</div></center>";
	exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
    }
}
###################### FUNCION BUSCAR MOVIMIENTOS DE CAJA POR FECHAS ###################

######################### FIN DE CLASE MOVIMIENTOS EN CAJAS #############################























###################################### CLASE PEDIDOS ###################################

############################ FUNCION PARA REGISTRAR PEDIDOS ##############################
public function RegistrarPedido()
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA ANTERIOR #######################
	/*$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? 
	AND DATE_FORMAT(fechaapertura,'%Y-%m-%d') != '".date('Y-m-d')."'
	AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "1";
		exit;
	}*/
	####################### VERIFICO ARQUEO DE CAJA ANTERIOR #######################

	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "2";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueo = $row['codarqueo'];
		$codcaja = $row['codcaja'];
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################

	if(empty($_SESSION["CarritoPedido"]) or empty($_POST["txtTotal"]) or empty($_POST["txtImporte"]))
	{
		echo "3";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############
	$v = $_SESSION["CarritoPedido"];
	for($i=0;$i<count($v);$i++){

	if(limpiar($_POST["statuspedido"]) == 0){ // SI EL PEDIDO FUE ENTREGADO

		if(limpiar($v[$i]['tipo']) == 1){ // SI EL DETALLE ES PRODUCTO

		    $sql = "SELECT 
		    existencia,
		    controlstockp 
		    FROM productos 
		    WHERE codproducto = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
			$controlproductobd = $row['controlstockp'];
		    $cantidad = $v[$i]['cantidad'];

	        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

			    if ($cantidad > $existenciabd) 
			    { 
			        echo "4";
			        exit;
			    }
				    
			}// FIN CONTROL STOCK PRODUCTO

		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
		    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array(limpiar($v[$i]['txtCodigo']),decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
		    if($num>0) { 

		    	$sql = "SELECT 
		    	productosxingredientes.codproducto,
		    	productosxingredientes.codingrediente,
		    	productosxingredientes.cantracion,
		    	productosxingredientes.codsucursal,
		    	ingredientes.cantingrediente,
		    	ingredientes.controlstocki
		    	FROM productosxingredientes 
		    	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
		    	WHERE productosxingredientes.codproducto IN ('".limpiar($v[$i]['txtCodigo'])."') 
		    	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
		    	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				    $cantracionbd = $row['cantracion'];
				    $codingredientebd = $row['codingrediente'];
				    $cantingredientebd = $row['cantingrediente'];
			        $controlingredientebd = $row['controlstocki'];

			        $racion = number_format($cantracionbd*$v[$i]['cantidad'], 2, '.', '');

			        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

			        	if ($racion > $cantingredientebd) 
			        	{ 
			        		echo "5";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK INGREDIENTE
			    }
		    }//fin de consulta de ingredientes de productos	
		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS ################# 

	    } elseif(limpiar($v[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

	    	$sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE codcombo = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		       echo "6";
		       exit;
	        }

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($v[$i]['txtCodigo'],decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia,
	        	productos.controlstockp
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($v[$i]['txtCodigo'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				   $cantracionbd = $row['cantidad'];
				   $codproductobd = $row['codproducto'];
				   $cantproductobd = $row['existencia'];
			       $controlproductobd = $row['controlstockp'];

			        $racion = number_format($cantracionbd*$v[$i]['cantidad'], 2, '.', '');

			        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

			        	if ($racion > $cantproductobd) 
			        	{ 
			        		echo "7";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK PRODUCTO
			    }
		    }//fin de consulta de ingredientes de productos	
		   ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

	    } else {  // SI EL DETALLE ES UN EXTRA

	    	$sql = "SELECT 
		    cantingrediente,
		    controlstocki  
		    FROM ingredientes 
		    WHERE codingrediente = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['cantingrediente'];
			$controlingredientebd = $row['controlstocki'];
		    $cantidad = $v[$i]['cantidad'];

	        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

	        	if ($cantidad > $existenciabd) 
	        	{ 
	        		echo "8";
	        		exit;
	        	}
				    
			}// FIN CONTROL STOCK INGREDIENTE
	    }

	}// FIN DE PEDIDO ENTREGADO
	   
	}// FIN DE FOR
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############

	if(empty($_POST["tipodocumento"]) or empty($_POST["tipopago"]) or empty($_POST["nrodocumento"]))
	{
		echo "9";
		exit;
	}
	else if(limpiar($_POST["tipodocumento"]) == "FACTURA" && limpiar($_POST["nrodocumento"]) == "0"){ 

    	echo "10";
	    exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
    clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
    clientes.girocliente,
    clientes.emailcliente, 
    clientes.tipocliente,
    clientes.limitecredito,
    clientes.id_provincia,
    clientes.id_departamento,
    clientes.direccliente,
    provincias.provincia,
    departamentos.departamento,
    ROUND(SUM(if(pag.montocredito!='0',pag.montocredito,'0.00')), 2) montoactual,
    ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 2) creditodisponible
    FROM clientes 
    LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes
       WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.dnicliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente = ($row['codcliente'] == "" ? "0" : $row['codcliente']);
    $tipocliente = ($row['tipocliente'] == "" ? "0" : $row['tipocliente']);
    $dnicliente = ($row['dnicliente'] == "" ? "0" : $row['dnicliente']);
    $nomcliente = ($row['nomcliente'] == "" ? "0" : $row['nomcliente']);
    $girocliente = ($row['girocliente'] == "" ? "0" : $row['girocliente']);
    $emailcliente = $row['emailcliente'];
    $provincia = ($row['id_provincia'] == "" || $row['id_provincia'] == "0" ? "0" : $row['provincia']);
    $departamento = ($row['id_departamento'] == "" || $row['id_departamento'] == "0" ? "0" : $row['departamento']);
    $direccliente = ($row['direccliente'] == "" ? "0" : $row['direccliente']);
    $limitecredito = $row['limitecredito'];
    $montoactual = $row['montoactual'];
    $creditodisponible = $row['creditodisponible'];
    $medioabono = (empty($_POST["medioabono"]) ? "" : $_POST["medioabono"]);
    $montoabono = (empty($_POST["montoabono"]) ? "0.00" : $_POST["montoabono"]);
    $total = number_format($_POST["txtImporte"]-$montoabono, 2, '.', '');
    
	    if(limpiar($_POST["tipodocumento"] == "FACTURA" && $tipocliente == "NATURAL")){ 

    	    echo "11";
	        exit;

        } else if ($_POST["tipopago"] == "CREDITO") {

		$fechaactual = date("Y-m-d");
		$fechaentrega = date("Y-m-d",strtotime($_POST['fechaentrega']));

		if ($_POST["nrodocumento"] == '0') { 

	        echo "12";
	        exit;

        } else if (strtotime($fechaentrega) < strtotime($fechaactual)) {

			echo "13";
			exit;

		} else if ($montoabono != "0.00" && $medioabono == "") {
  
           echo "14";
	       exit;

		} else if ($limitecredito != "0.00" && $total > $creditodisponible) {
  
           echo "15";
	       exit;

		} else if($_POST["montoabono"] >= $_POST["txtTotal"]) { 
	
		   echo "16";
		   exit;
	    }
	}
	################### SELECCIONE LOS DATOS DEL CLIENTE ######################

	####################### OBTENGO DATOS DE SUCURSAL #######################
	$sql = " SELECT 
	codsucursal, 
	cuitsucursal, 
	nomsucursal, 
	codgiro, 
	girosucursal, 
	nroactividadsucursal,
	inicioticket,
	inicioboleta,
	iniciofactura 
	FROM sucursales 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$rucemisor = $row['cuitsucursal'];
    $razonsocial = $row['nomsucursal'];
    $actecoemisor = $row['codgiro'];
    $giroemisor = $row['girosucursal'];
    $nroactividad = $row['nroactividadsucursal'];
	$inicioticket = $row['inicioticket'];
	$inicioboleta = $row['inicioboleta'];
	$iniciofactura = $row['iniciofactura'];
	####################### OBTENGO DATOS DE SUCURSAL #######################

	##################### AGREGAMOS EL CODIGO DE PEDIDO #######################
	$sql = "SELECT 
	codpedido 
	FROM pedidos 
	ORDER BY idpedido 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$pedido=$row["codpedido"];
	}
	$codpedido = (empty($pedido) ? "1" : $pedido + 1);
	##################### AGREGAMOS EL CODIGO DE PEDIDO #######################

	##################### AGREGAMOS NUMERO DE PEDIDO #######################
	$sql = "SELECT 
	numpedido 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idnum=$row["numpedido"];
	}
	$numpedido = (empty($idnum) ? "1" : $idnum + 1);
	##################### AGREGAMOS NUMERO DE PEDIDO #######################

	##################### AGREGAMOS NUMERO DE CONTROL #######################
	$sql = "SELECT 
	numero 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idcontrol=$row["numero"];
	}
	$numero = (empty($idcontrol) ? "1" : $idcontrol + 1);
	##################### AGREGAMOS NUMERO DE CONTROL #######################

	##################### AGREGAMOS EL NUMERO DE VENTA #######################
	$sql = "SELECT 
	codventa 
	FROM ventas
	ORDER BY idventa 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$venta=$row["codventa"];
	}
	$codventa = (empty($venta) ? "1" : $venta + 1);
	##################### AGREGAMOS EL NUMERO DE VENTA #######################

	################ CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ################
	$sql = "SELECT 
	codfactura 
	FROM ventas 
	WHERE tipodocumento = '".limpiar($_POST['tipodocumento'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$factura=$row["codfactura"];
	}
	
	if($_POST['tipodocumento']=="TICKET") {

        $codfactura = (empty($factura) ? $inicioticket : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="BOLETA") {

        $codfactura = (empty($factura) ? $inicioboleta : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="FACTURA") {

		$codfactura = (empty($factura) ? $iniciofactura : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());
	}
    ################# CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ###############

    $fecha = date("Y-m-d H:i:s");

	################################# REGISTRO DATOS DE PEDIDO #################################
	$query = "INSERT INTO pedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $numpedido);
	$stmt->bindParam(3, $numero);
	$stmt->bindParam(4, $codmesa);
	$stmt->bindParam(5, $referencia);
	$stmt->bindParam(6, $codcliente);
	$stmt->bindParam(7, $subtotalivasi);
	$stmt->bindParam(8, $subtotalivano);
	$stmt->bindParam(9, $iva);
	$stmt->bindParam(10, $totaliva);
	$stmt->bindParam(11, $descontado);
	$stmt->bindParam(12, $descuento);
	$stmt->bindParam(13, $totaldescuento);
	$stmt->bindParam(14, $totalpago);
	$stmt->bindParam(15, $totalpago2);
	$stmt->bindParam(16, $descripciones);
	$stmt->bindParam(17, $tipopedido);
	$stmt->bindParam(18, $statuspedido);
	$stmt->bindParam(19, $repartidor);
	$stmt->bindParam(20, $fechapedido);
	$stmt->bindParam(21, $fechaentrega);
	$stmt->bindParam(22, $codigo);
	$stmt->bindParam(23, $mesero);
	$stmt->bindParam(24, $codsucursal);

	$codmesa = limpiar("0");
	$referencia = limpiar("0");
	$subtotalivasi = limpiar($_POST["txtsubtotal"]);
	$subtotalivano = limpiar($_POST["txtsubtotal2"]);
	$iva = limpiar($_POST["iva"]);
	$totaliva = limpiar($_POST["txtIva"]);
	$descontado = limpiar($_POST["txtdescontado"]);
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago = limpiar($_POST["txtTotal"]);
	$totalpago2 = limpiar($_POST["txtTotalCompra"]);
	$descripciones = limpiar($_POST['descripciones']=="" ? "" : $_POST['descripciones']);
    $tipopedido = limpiar("3");
    $statuspedido = limpiar("1");
	$repartidor = limpiar("0");
    $fechapedido = limpiar($fecha);
    $fechaentrega = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fechaentrega']." ".$_POST['horaentrega'])));
	$codigo = limpiar($_SESSION["codigo"]);
	$mesero = limpiar("0");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################# REGISTRO DATOS DE PEDIDO #################################

	################################# REGISTRO DATOS DE VENTA #################################
	$query = "INSERT INTO ventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codmesa);
	$stmt->bindParam(4, $tipodocumento);
	$stmt->bindParam(5, $codcaja);
	$stmt->bindParam(6, $codfactura);
	$stmt->bindParam(7, $codserie);
	$stmt->bindParam(8, $codautorizacion);
	$stmt->bindParam(9, $codcliente);
	$stmt->bindParam(10, $subtotalivasi);
	$stmt->bindParam(11, $subtotalivano);
	$stmt->bindParam(12, $iva);
	$stmt->bindParam(13, $totaliva);
	$stmt->bindParam(14, $descontado);
	$stmt->bindParam(15, $descuento);
	$stmt->bindParam(16, $totaldescuento);
	$stmt->bindParam(17, $totalpago);
	$stmt->bindParam(18, $totalpago2);
	$stmt->bindParam(19, $creditopagado);
	$stmt->bindParam(20, $montodelivery);
	$stmt->bindParam(21, $tipopago);
	$stmt->bindParam(22, $formapago);
	$stmt->bindParam(23, $montopagado);
	$stmt->bindParam(24, $formapago2);
	$stmt->bindParam(25, $montopagado2);
	$stmt->bindParam(26, $formapropina);
	$stmt->bindParam(27, $montopropina);
	$stmt->bindParam(28, $montodevuelto);
	$stmt->bindParam(29, $fechavencecredito);
	$stmt->bindParam(30, $fechapagado);
	$stmt->bindParam(31, $statusventa);
	$stmt->bindParam(32, $fechaventa);
	$stmt->bindParam(33, $delivery);
	$stmt->bindParam(34, $repartidor);
	$stmt->bindParam(35, $entregado);
	$stmt->bindParam(36, $descripciones);
	$stmt->bindParam(37, $observaciones);
	$stmt->bindParam(38, $fechaentrega);
	$stmt->bindParam(39, $statuspedido);
	$stmt->bindParam(40, $tipoventa);
	$stmt->bindParam(41, $codigo);
	$stmt->bindParam(42, $mesero);
	$stmt->bindParam(43, $docelectronico);
	$stmt->bindParam(44, $codsucursal);
    
	$codmesa = limpiar("0");
	$tipodocumento = limpiar($_POST["tipodocumento"]);
	$subtotalivasi = limpiar($_POST["txtsubtotal"]);
	$subtotalivano = limpiar($_POST["txtsubtotal2"]);
	$iva = limpiar($_POST["iva"]);
	$totaliva = limpiar($_POST["txtIva"]);
	$descontado = limpiar($_POST["txtdescontado"]);
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago = limpiar($_POST["txtTotal"]);
	$totalpago2 = limpiar($_POST["txtTotalCompra"]);
    $creditopagado = limpiar(isset($_POST['montoabono']) ? $_POST["montoabono"] : "0.00");
	$montodelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");
	
	$tipopago = limpiar($_POST["tipopago"]);
	$formapago = limpiar($_POST["tipopago"]=="CONTADO" ? $_POST["formapago"] : "CREDITO");
	$montopagado = limpiar(isset($_POST['montopagado']) ? $_POST["montopagado"] : "0.00");
	$formapago2 = limpiar(isset($_POST['montopagado2']) ? $_POST["formapago2"] : "0");
	$montopagado2 = limpiar(isset($_POST['montopagado2']) ? $_POST["montopagado2"] : "0.00");
	$formapropina = limpiar(isset($_POST['formapropina']) ? $_POST["formapropina"] : "0");
	$montopropina = limpiar(isset($_POST['montopropina']) ? $_POST["montopropina"] : "0.00");
	$montodevuelto = limpiar(isset($_POST['montodevuelto']) ? $_POST["montodevuelto"] : "0.00");
    $fechavencecredito = limpiar($_POST["tipopago"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
    $fechapagado = limpiar("0000-00-00");
    $statusventa = limpiar($_POST["tipopago"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
    $fechaventa = limpiar($fecha);
	$delivery = limpiar("0");
	$repartidor = limpiar("0");
	$entregado = limpiar("0");
	$descripciones = limpiar($_POST['descripciones']=="" ? "" : $_POST['descripciones']);
	$observaciones = limpiar($_POST['observaciones']=="" ? "" : $_POST['observaciones']);
    $fechaentrega = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fechaentrega']." ".$_POST['horaentrega'])));
	$statuspedido = limpiar($_POST["statuspedido"]);
    $tipoventa = limpiar("2");
	$codigo = limpiar($_SESSION["codigo"]);
	$mesero = limpiar("0");
	$docelectronico = limpiar("0");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################# REGISTRO DATOS DE VENTA #################################

	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoPedido"];
	for($i=0;$i<count($detalle);$i++){

	##################### REGISTRO DETALLES EN VENTAS #######################
	$query = "INSERT INTO detalleventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
    $stmt = $this->dbh->prepare($query);
    $stmt->bindParam(1, $codventa);
	$stmt->bindParam(2, $idproducto);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $producto);
    $stmt->bindParam(5, $codcategoria);
    $stmt->bindParam(6, $cantidad);
    $stmt->bindParam(7, $preciocompra);
    $stmt->bindParam(8, $precioventa);
    $stmt->bindParam(9, $ivaproducto);
    $stmt->bindParam(10, $descproducto);
    $stmt->bindParam(11, $valortotal);
    $stmt->bindParam(12, $totaldescuentov);
    $stmt->bindParam(13, $subtotalimpuestos);
    $stmt->bindParam(14, $valorneto);
    $stmt->bindParam(15, $valorneto2);
    $stmt->bindParam(16, $detallesobservaciones);
    $stmt->bindParam(17, $tipo);
    $stmt->bindParam(18, $codsucursal);
	
	$idproducto = limpiar($detalle[$i]['id']);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$producto = limpiar($detalle[$i]['producto']);
	$codcategoria = limpiar($detalle[$i]['codcategoria']);
	$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
	$preciocompra = limpiar($detalle[$i]['precio']);
	$precioventa = limpiar($detalle[$i]['precio2']);
	$precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$descuento = $detalle[$i]['descproducto']/100;
	$valortotal = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto = 1 + ($_POST["iva"]/100);
	$Discriminado = $precioconiva/$ValorImpuesto;
    $SubtotalDiscriminado = $precioconiva - $Discriminado;
    $BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto = number_format($valortotal-$totaldescuentov, 2, '.', '');
	$valorneto2 = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
    $detallesobservaciones = limpiar("");
	$tipo = limpiar($detalle[$i]['tipo']);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### REGISTRO DETALLES EN VENTAS #######################

	##################### REGISTRO DETALLES EN PEDIDOS #######################
	$query = "INSERT INTO detallepedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $numpedido);
	$stmt->bindParam(3, $numero);
	$stmt->bindParam(4, $codmesa);
	$stmt->bindParam(5, $idproducto);
	$stmt->bindParam(6, $codproducto);
	$stmt->bindParam(7, $producto);
	$stmt->bindParam(8, $codcategoria);
	$stmt->bindParam(9, $cantidad);
	$stmt->bindParam(10, $preciocompra);
	$stmt->bindParam(11, $precioventa);
	$stmt->bindParam(12, $ivaproducto);
	$stmt->bindParam(13, $descproducto);
	$stmt->bindParam(14, $valortotal);
	$stmt->bindParam(15, $totaldescuentov);
    $stmt->bindParam(16, $subtotalimpuestos);
	$stmt->bindParam(17, $valorneto);
	$stmt->bindParam(18, $valorneto2);
	$stmt->bindParam(19, $observacionespedido);
	$stmt->bindParam(20, $salsaspedido);
	$stmt->bindParam(21, $cocinero);
	$stmt->bindParam(22, $preparado);
	$stmt->bindParam(23, $tipodetalle);
	$stmt->bindParam(24, $detallepedido);
	$stmt->bindParam(25, $statusdetalle);
	$stmt->bindParam(26, $fechadetallepedido);
	$stmt->bindParam(27, $fechadetalleentrega);
	$stmt->bindParam(28, $bandera_pedido);
	$stmt->bindParam(29, $codsucursal);

	$codmesa = limpiar("0");
	$idproducto = limpiar($detalle[$i]['id']);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$producto = limpiar($detalle[$i]['producto']);
	$codcategoria = limpiar($detalle[$i]['codcategoria']);
	$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
	$preciocompra = limpiar($detalle[$i]['precio']);
	$precioventa = limpiar($detalle[$i]['precio2']);
	$precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$descuento = $detalle[$i]['descproducto']/100;
	$valortotal = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto = 1 + ($_POST["iva"]/100);
	$Discriminado = $precioconiva/$ValorImpuesto;
    $SubtotalDiscriminado = $precioconiva - $Discriminado;
    $BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto = number_format($valortotal-$totaldescuentov, 2, '.', '');
	$valorneto2 = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
    $observacionespedido = limpiar($detalle[$i]['observacion'] == ", " ? "" : $detalle[$i]['observacion']);
    $salsaspedido = limpiar($detalle[$i]['salsa'] == ", " ? "" : $detalle[$i]['salsa']);
	$cocinero = limpiar('1');
	$preparado = limpiar($detalle[$i]['preparado']);
	$tipodetalle = limpiar($detalle[$i]['tipo']);
    $detallepedido = limpiar("1");
    $statusdetalle = limpiar("1");
	$tipo = limpiar($detalle[$i]['tipo']);
	$fechadetallepedido = limpiar($fecha);
	$fechadetalleentrega = limpiar("0000-00-00 00:00:00");
	$bandera_pedido = limpiar("1");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### REGISTRO DETALLES EN PEDIDOS #######################

	if(limpiar($_POST["statuspedido"]) == 0){ // SI EL PEDIDO FUE ENTREGADO

	if(limpiar($detalle[$i]['tipo']) == 1){ // SI EL DETALLE ES PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		$controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
                 AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$existencia = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
        $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
        $stmt->bindParam(14, $codsucursal);			

		$codcliente = limpiar($_POST["codcliente"]);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$precio = limpiar($detalle[$i]['precio2']);
		$documento = limpiar("DETALLE EN PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
        $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
	
	}//FIN CONTROL STOCK PRODUCTO

	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
	    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($detalle[$i]['txtCodigo']),decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
	    if($num>0) {  

	    	$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
	    	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
	    	WHERE productosxingredientes.codproducto IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
	    	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	    	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			    $codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
				   $update = "UPDATE ingredientes set "
				   ." cantingrediente = ? "
				   ." WHERE "
				   ." codingrediente = ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codingredientebd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$detalle[$i]['cantidad'], 2, '.', '');
				   $cantidadracion = number_format($cantingredientebd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codventa);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codingrediente);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaingrediente);
				   $stmt->bindParam(10, $descingrediente);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codcliente = limpiar($_POST["codcliente"]);
				   $codingrediente = limpiar($codingredientebd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantingredientebd-$racion, 2, '.', '');
				   $ivaingrediente = limpiar($ivaingredientebd == "NO" ? "0.00" : $_POST["iva"]);
				   $descingrediente = limpiar($descingredientebd);
				   $precio = limpiar($precioventaingredientebd);
				   $documento = limpiar("DETALLE EN PEDIDO");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

	############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################	
    
    } elseif(limpiar($detalle[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

   	############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			  ." existencia = ? "
			  ." where "
			  ." codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	             AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$existencia = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################
	    $query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);			
	    $stmt->bindParam(14, $codsucursal);	

		$codcliente = limpiar($_POST["codcliente"]);
		$codcombo = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$ivacombo = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$desccombo = limpiar($detalle[$i]['descproducto']);
		$precio = limpiar($detalle[$i]['precio2']);
		$documento = limpiar("DETALLE EN PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($detalle[$i]['txtCodigo'],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.ivaproducto,
	    	productos.controlstockp
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	WHERE combosxproductos.codcombo IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd = $row['cantidad'];
			   $codproductobd = $row['codproducto'];
			   $cantproductobd = $row['existencia'];
			   $precioventaproductobd = $row['precioventa'];
			   $ivaproductobd = $row['ivaproducto'];
			   $descproductobd = $row['descproducto'];
		       $controlproductobd = $row['controlstockp'];

		        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproductobd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$detalle[$i]['cantidad'], 2, '.', '');
				   $cantidadracion = number_format($cantproductobd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codventa);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaproducto);
				   $stmt->bindParam(10, $descproducto);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codcliente = limpiar($_POST["codcliente"]);
				   $codproducto = limpiar($codproductobd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantproductobd-$racion, 2, '.', '');
				   $ivaproducto = limpiar($ivaproductobd == "NO" ? "0.00" : $_POST["iva"]);
				   $descproducto = limpiar($descproductobd);
				   $precio = limpiar($precioventaproductobd);
				   $documento = limpiar("DETALLE EN PEDIDO");
				   $fechakardex = limpiar($fecha);
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de ingredientes de productos	
	   ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################
    
    }  else { // SI EL DETALLE ES UN EXTRA

   	############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    	############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################
		$sql = "SELECT 
		cantingrediente, 
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

		if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

		    ##################### ACTUALIZO LA EXISTENCIA DEL INGREDIENTE DEL ALMACEN ####################
			$sql = " UPDATE ingredientes set "
				  ." cantingrediente = ? "
				  ." WHERE "
				  ." codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	                 AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
				   ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
			$existencia = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL INGREDIENTE DEL ALMACEN ####################

			############## REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX ###################
	        $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codventa);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codingrediente);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaingrediente);
			$stmt->bindParam(10, $descingrediente);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
	        $stmt->bindParam(14, $codsucursal);			

			$codcliente = limpiar($_POST["codcliente"]);
			$codingrediente = limpiar($detalle[$i]['txtCodigo']);
			$movimiento = limpiar("SALIDAS");
			$entradas = limpiar("0.00");
			$salidas= number_format($detalle[$i]['cantidad'], 2, '.', '');
			$devolucion = limpiar("0.00");
			$stockactual = number_format($existenciaingredientebd-$detalle[$i]['cantidad'], 2, '.', '');
			$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
			$descingrediente = limpiar($detalle[$i]['descproducto']);
			$precio = limpiar($detalle[$i]['precio2']);
			$documento = limpiar("DETALLE EN PEDIDO");
			$fechakardex = limpiar(date("Y-m-d"));
	        $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
			############## REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX ###################
		
		}// FIN CONTROL STOCK INGREDIENTE
    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    }// FIN DE TIPO DETALLE

    }// FIN DE PEDIDO ENTREGADO

    }// FIN DE FOR SESSION
		
	####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoPedido"]);
    $this->dbh->commit();

    ################## OBTENGO LOS DATOS EN CAJA ##################
	$sql = "SELECT 
	efectivo, 
	cheque, 
	tcredito, 
	tdebito, 
	tprepago, 
	transferencia, 
	electronico,
	cupon, 
	otros,
	creditos,
	propinasefectivo,
	propinasotros,
	nroticket,
	nroboleta,
	nrofactura
	FROM arqueocaja WHERE codarqueo = '".limpiar($codarqueo)."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$efectivo = ($row['efectivo']== "" ? "0.00" : $row['efectivo']);
	$cheque = ($row['cheque']== "" ? "0.00" : $row['cheque']);
	$tcredito = ($row['tcredito']== "" ? "0.00" : $row['tcredito']);
	$tdebito = ($row['tdebito']== "" ? "0.00" : $row['tdebito']);
	$tprepago = ($row['tprepago']== "" ? "0.00" : $row['tprepago']);
	$transferencia = ($row['transferencia']== "" ? "0.00" : $row['transferencia']);
	$electronico = ($row['electronico']== "" ? "0.00" : $row['electronico']);
	$cupon = ($row['cupon']== "" ? "0.00" : $row['cupon']);
	$otros = ($row['otros']== "" ? "0.00" : $row['otros']);
	$credito = ($row['creditos']== "" ? "0.00" : $row['creditos']);
	$propinasefectivo = ($row['propinasefectivo']== "" ? "0.00" : $row['propinasefectivo']);
	$propinasotros = ($row['propinasotros']== "" ? "0.00" : $row['propinasotros']);
	$nroticket = $row['nroticket'];
	$nroboleta = $row['nroboleta'];
	$nrofactura = $row['nrofactura'];
	################## OBTENGO LOS DATOS EN CAJA ##################

    ############## AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ###############
	if (limpiar($_POST["tipopago"]=="CONTADO")){
	
	if(isset($_POST['formapago2']) && $_POST['formapago2']!=""){

	########################## AGREGO EL MONTO EN CAJA #################################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ? AND statusarqueo = 1;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);

	if($_POST["formapago"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtEfectivo = $efectivo;	
	}

	if($_POST["formapago"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCheque = $cheque;	
	}

	if($_POST["formapago"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTcredito = $tcredito;	
	}

	if($_POST["formapago"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTdebito = $tdebito;	
	}

	if($_POST["formapago"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTprepago = $tprepago;	
	}

	if($_POST["formapago"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTransferencia = $transferencia;	
	}

	if($_POST["formapago"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtElectronico = $electronico;	
	}

	if($_POST["formapago"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCupon = $cupon;	
	}

	if($_POST["formapago"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtOtros = $otros;	
	}
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	########################## AGREGO EL MONTO EN CAJA #################################

	} else { 

	########################## AGREGO EL MONTO EN CAJA #################################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ? AND statusarqueo = 1;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);
	
	$textdelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");
	$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
	$txtEfectivo = limpiar($_POST["formapago"] == "EFECTIVO" ? number_format($efectivo+$TotalPagar, 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["formapago"] == "CHEQUE" ? number_format($cheque+$TotalPagar, 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["formapago"] == "TARJETA DE CREDITO" ? number_format($tcredito+$TotalPagar, 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["formapago"] == "TARJETA DE DEBITO" ? number_format($tdebito+$TotalPagar, 2, '.', '') : $tdebito);
	$txtTprepago = limpiar($_POST["formapago"] == "TARJETA PREPAGO" ? number_format($tprepago+$TotalPagar, 2, '.', '') : $tprepago);
	$txtTransferencia = limpiar($_POST["formapago"] == "TRANSFERENCIA" ? number_format($transferencia+$TotalPagar, 2, '.', '') : $transferencia);
	$txtElectronico = limpiar($_POST["formapago"] == "DINERO ELECTRONICO" ? number_format($electronico+$TotalPagar, 2, '.', '') : $electronico);
	$txtCupon = limpiar($_POST["formapago"] == "CUPON" ? number_format($cupon+$TotalPagar, 2, '.', '') : $cupon);
	$txtOtros = limpiar($_POST["formapago"] == "OTROS" ? number_format($otros+$TotalPagar, 2, '.', '') : $otros);
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	########################## AGREGO EL MONTO EN CAJA #################################
		}
	}
    ################ AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ##############


    ######### AGREGAMOS EL INGRESO Y ABONOS DE VENTAS A CREDITOS A CAJA ############
	if (limpiar($_POST["tipopago"]=="CREDITO")) {

	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." creditos = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ? AND statusarqueo = 1;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtCredito);
	$stmt->bindParam(11, $NumTicket);
	$stmt->bindParam(12, $NumBoleta);
	$stmt->bindParam(13, $NumFactura);
	$stmt->bindParam(14, $codarqueo);

	$textdelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");
	$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
	$txtEfectivo = limpiar($_POST["medioabono"] == "EFECTIVO" ? number_format($efectivo+$_POST["montoabono"], 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["medioabono"] == "CHEQUE" ? number_format($cheque+$_POST["montoabono"], 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["medioabono"] == "TARJETA DE CREDITO" ? number_format($tcredito+$_POST["montoabono"], 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["medioabono"] == "TARJETA DE DEBITO" ? number_format($tdebito+$_POST["montoabono"], 2, '.', '') : $tdebito);
	$txtTprepago = limpiar($_POST["medioabono"] == "TARJETA PREPAGO" ? number_format($tprepago+$_POST["montoabono"], 2, '.', '') : $tprepago);
	$txtTransferencia = limpiar($_POST["medioabono"] == "TRANSFERENCIA" ? number_format($transferencia+$_POST["montoabono"], 2, '.', '') : $transferencia);
	$txtElectronico = limpiar($_POST["medioabono"] == "DINERO ELECTRONICO" ? number_format($electronico+$_POST["montoabono"], 2, '.', '') : $electronico);
	$txtCupon = limpiar($_POST["medioabono"] == "CUPON" ? number_format($cupon+$_POST["montoabono"], 2, '.', '') : $cupon);
	$txtOtros = limpiar($_POST["medioabono"] == "OTROS" ? number_format($otros+$_POST["montoabono"], 2, '.', '') : $otros);
	$txtCredito = number_format($credito+($TotalPagar-$_POST["montoabono"]), 2, '.', '');

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();

	$sql = "SELECT codcliente FROM creditosxclientes WHERE codcliente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($codcliente,decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO creditosxclientes values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $montocredito);
		$stmt->bindParam(3, $codsucursal);

		$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
		$montocredito = number_format($TotalPagar-$_POST["montoabono"], 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	} else { 

		$sql = "UPDATE creditosxclientes set"
		." montocredito = ? "
		." WHERE "
		." codcliente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $montocredito);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codsucursal);

		$TotalPagar =  number_format($_POST["txtTotal"]+$textdelivery, 2, '.', '');
		$montocredito = number_format($montoactual+($TotalPagar-$_POST["montoabono"]), 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	}

   if (limpiar($_POST["montoabono"]!="0.00" && $_POST["montoabono"]!="0" && $_POST["montoabono"]!="")) {

	$query = "INSERT INTO abonoscreditos values (null, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcaja);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codcliente);
	$stmt->bindParam(4, $montoabono);
	$stmt->bindParam(5, $formaabono);
	$stmt->bindParam(6, $fechaabono);
    $stmt->bindParam(7, $codsucursal);

	$montoabono = limpiar($_POST["montoabono"]);
	$formaabono = limpiar($_POST["medioabono"]);
	$fechaabono = limpiar(date("Y-m-d H:i:s"));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

   }

	} 
   ########## AGREGAMOS EL INGRESO Y ABONOS DE VENTAS A CREDITOS A CAJA ########

   echo "<span class='fa fa-check-square-o'></span> EL PEDIDO HA SIDO REGISTRADO EXITOSAMENTE <a href='reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR ".$tipodocumento."</strong></font color></a></div>";

    echo "<script>window.open('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '_blank');</script>";
	exit;
}
######################### FUNCION PARA REGISTRAR PEDIDOS ############################

################################## FUNCION LISTAR PEDIDOS ################################
public function ListarPedidos()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorG") {

	$sql = "SELECT 
	ventas.idventa, 
	ventas.codventa, 
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado, 
	ventas.montodelivery,
	ventas.tipopago, 
	ventas.formapago, 
	ventas.formapago2,
	ventas.montopagado, 
	ventas.montopagado2,
	ventas.montopropina,
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
	ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa,
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
	ventas.observaciones,
	ventas.fechaentrega,
    ventas.statuspedido,
	ventas.tipoventa,
	ventas.docelectronico, 
	ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	SUM(detalleventas.cantventa) AS articulos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	AND ventas.tipoventa = 2 
	GROUP BY ventas.codventa";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

	} else if($_SESSION["acceso"] == "cajero") {

	$sql = "SELECT 
	ventas.idventa, 
	ventas.codventa, 
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado, 
	ventas.montodelivery,
	ventas.tipopago, 
	ventas.formapago, 
	ventas.formapago2,
	ventas.montopagado, 
	ventas.montopagado2,
	ventas.montopropina,
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
	ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa,
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
	ventas.observaciones,
	ventas.fechaentrega,
    ventas.statuspedido,
	ventas.tipoventa,
	ventas.docelectronico, 
	ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	SUM(detalleventas.cantventa) AS articulos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND ventas.codigo = '".limpiar($_SESSION["codigo"])."' 
	AND ventas.tipoventa = 2 
	GROUP BY ventas.codventa";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    } else {

    $sql = "SELECT 
	ventas.idventa, 
	ventas.codventa, 
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado, 
	ventas.montodelivery,
	ventas.tipopago, 
	ventas.formapago, 
	ventas.formapago2,
	ventas.montopagado, 
	ventas.montopagado2,
	ventas.montopropina,
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
	ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa,
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
	ventas.observaciones,
	ventas.fechaentrega,
    ventas.statuspedido,
	ventas.tipoventa,
	ventas.docelectronico, 
	ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_provincia,
	clientes.id_departamento,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
	documentos2.documento AS documento2, 
	documentos3.documento AS documento3,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	SUM(detalleventas.cantventa) AS articulos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = '".limpiar($_SESSION["codsucursal"])."'  
	AND ventas.tipoventa = 2 
	GROUP BY ventas.codventa";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
    }
}
################################## FUNCION LISTAR PEDIDOS ############################

############################# FUNCION ACTUALIZAR PEDIDOS #############################
public function ActualizarPedidos()
	{
	self::SetNames();
	if(empty($_POST["codpedido"]) or empty($_POST["codventa"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

    ############ CONSULTO TOTAL EN FACTURA ##############
	$sql = "SELECT 
	codcaja,
	totalpago,
	totalpago2,
	montodelivery 
	FROM ventas 
	WHERE codventa = '".limpiar($_POST["codventa"])."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cajabd = $row['codcaja'];
	$totalpagobd = $row['totalpago'];
	$totalpago2bd = $row['totalpago2'];
	$montodeliverybd = $row['montodelivery'];
	############ CONSULTO TOTAL EN FACTURA ##############

    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente, 
    clientes.emailcliente, 
    clientes.limitecredito,
    ROUND(SUM(if(pag.montocredito!='0',pag.montocredito,'0.00')), 2) montoactual,
    ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 2) creditodisponible
    FROM clientes 
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.codcliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['codcliente'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $nomcliente = $row['nomcliente'];
    $emailcliente = $row['emailcliente'];
    $limitecredito = $row['limitecredito'];
    $montoactual = $row['montoactual'];
    $creditodisponible = $row['creditodisponible'];
    $montoabono = (empty($_POST["abonototal"]) ? "0.00" : $_POST["abonototal"]);
    $total = number_format($_POST["txtTotal"], 2, '.', '');

	for($i=0;$i<count($_POST['coddetalleventa']);$i++){  //recorro el array
		if (!empty($_POST['coddetalleventa'][$i])) {

			if($_POST['cantventa'][$i]==0){

				echo "2";
				exit;

			}
		}
	}
	################### SELECCIONE LOS DATOS DEL CLIENTE ######################

	$this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetalleventa']);$i++){  //recorro el array
	if (!empty($_POST['coddetalleventa'][$i])) {

	    ############ OBTENGO DETALLES DE VENTAS ############
	    $sql = "SELECT 
	    cantventa 
	    FROM detalleventas 
	    WHERE coddetalleventa = '".limpiar($_POST['coddetalleventa'][$i])."' 
	    AND codventa = '".limpiar($_POST["codventa"])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidadbd = $row['cantventa'];
		############ OBTENGO DETALLES DE VENTAS ############

	if($cantidadbd != $_POST['cantventa'][$i]){

	    ############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############

	    if(limpiar($_POST['tipo'][$i]) == 1){ // SI EL DETALLE ES PRODUCTO

		    $sql = "SELECT 
		    existencia 
		    FROM productos 
		    WHERE codproducto = '".limpiar($_POST['codproducto'][$i])."' 
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$existenciaproductobd = $row['existencia'];
			$cantventa = number_format($_POST['cantventa'][$i], 2, '.', '');
			$cantidadventabd = number_format($_POST['cantidadventabd'][$i], 2, '.', '');
			$totalventa = $cantventa-$cantidadventabd;

	        if ($totalventa > $existenciaproductobd) 
	        { 
			    echo "3";
			    exit;
		    }

	    } elseif(limpiar($v[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

		    $sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE codcombo = '".limpiar($_POST['codproducto'][$i])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			    foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$existenciacombobd = $row['existencia'];
			$cantventa = $_POST["cantventa"][$i];
			$cantidadventabd = $_POST["cantidadventabd"][$i];
			$totalventa = $cantventa-$cantidadventabd;

	        if ($totalventa > $existenciacombobd) 
	        { 
			    echo "3";
			    exit;
		    }

	    } else {  // SI EL DETALLE ES UN EXTRA O INGREDIENTE

	    	$sql = "SELECT 
		    cantingrediente 
		    FROM ingredientes 
		    WHERE codingrediente = '".limpiar($_POST['codproducto'][$i])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }

			$existenciaingredientebd = $row['cantingrediente'];
			$cantventa = $_POST["cantventa"][$i];
			$cantidadventabd = $_POST["cantidadventabd"][$i];
			$totalventa = $cantventa-$cantidadventabd;

	        if ($totalventa > $existenciaingredientebd) 
	        { 
		       echo "3";
		       exit;
	        }
	    }
	    ############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############

	    ################ ACTUALIZO CANTIDAD EN DETALLES ################
	    $query = "UPDATE detalleventas set"
		." cantventa = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." coddetalleventa = ? AND codventa = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantventa);
		$stmt->bindParam(2, $valortotal);
		$stmt->bindParam(3, $totaldescuentov);
		$stmt->bindParam(4, $subtotalimpuestos);
		$stmt->bindParam(5, $valorneto);
		$stmt->bindParam(6, $valorneto2);
		$stmt->bindParam(7, $coddetalleventa);
		$stmt->bindParam(8, $codventa);
		$stmt->bindParam(9, $codsucursal);

		$cantventa = number_format($_POST['cantventa'][$i], 2, '.', '');
		$preciocompra = limpiar($_POST['preciocompra'][$i]);
		$precioventa = limpiar($_POST['precioventa'][$i]);
		$ivaproducto = limpiar($_POST['ivaproducto'][$i]);
		$descuento = $_POST['descproducto'][$i]/100;
		$valortotal = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuento = number_format($_POST['totaldescuentov'][$i], 2, '.', '');
		$subtotalimpuestos = number_format($_POST['subtotalimpuestos'][$i], 2, '.', '');
		$valorneto = number_format($_POST['valorneto'][$i], 2, '.', '');
		$valorneto2 = number_format($_POST['valorneto2'][$i], 2, '.', '');
		$coddetalleventa = limpiar($_POST['coddetalleventa'][$i]);
		$codventa = limpiar($_POST["codventa"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################ ACTUALIZO CANTIDAD EN DETALLES ################

	if(limpiar($_POST['tipo'][$i]) == 1){ // SI EL DETALLE ES PRODUCTO

   ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################

		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = '".limpiar($_POST["codproducto"][$i])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		$controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO
	
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codproducto = '".limpiar($_POST["codproducto"][$i])."'
			     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$existencia = number_format($existenciaproductobd-$totalventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############# ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###################
		$sql3 = " UPDATE kardex_productos set "
		      ." salidas = ?, "
		      ." stockactual = ? "
			  ." WHERE "
			  ." codproceso = '".limpiar($_POST["codventa"])."'
			     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
			     AND codproducto = '".limpiar($_POST["codproducto"][$i])."';
			   ";
		$stmt = $this->dbh->prepare($sql3);
		$stmt->bindParam(1, $salidas);
		$stmt->bindParam(2, $existencia);
		
		$salidas = number_format($_POST['cantventa'][$i], 2, '.', '');
		$existencia = number_format($existenciaproductobd-$totalventa, 2, '.', '');
		$stmt->execute();
		############# ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###################
	
	}//FIN CONTROL STOCK PRODUCTO

	    ############## VERIFICO SSI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
	    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($_POST["codproducto"][$i]),decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
        	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
        	WHERE productosxingredientes.codproducto IN ('".$_POST["codproducto"][$i]."')
        	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $codingredientebd = $row['codingrediente'];
			   $cantracionbd = $row['cantracion'];
			   $cantingredientebd = $row['cantingrediente'];
			   $precioventaingredientebd = $row['precioventa'];
			   $ivaingredientebd = $row['ivaingrediente'];
			   $descingredientebd = $row['descingrediente'];
		       $controlingredientebd = $row['controlstocki'];

		    if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
			   $update = "UPDATE ingredientes set "
			   ." cantingrediente = ? "
			   ." WHERE "
			   ." codingrediente = ? AND codsucursal = ?;
			   ";
			   $stmt = $this->dbh->prepare($update);
			   $stmt->bindParam(1, $cantidadracion);
			   $stmt->bindParam(2, $codingredientebd);

			   $racion = number_format($cantracionbd*$totalventa, 2, '.', '');
			   $cantidadracion = number_format($cantingredientebd-$racion, 2, '.', '');
               $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			   $stmt->execute();
			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

			   ############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
			   $sql = "SELECT 
			   salidas 
			   FROM kardex_ingredientes 
			   WHERE codproceso = '".limpiar($_POST['codventa'])."' 
			   AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			   AND codingrediente = '".limpiar($codingredientebd)."'";
			   foreach ($this->dbh->query($sql) as $row)
			   {
			   	$this->p[] = $row;
			   }
			   $salidakardex = $row['salidas'];
		       ############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

			   ########## ACTUALIZAMOS LOS DATOS DEL INGREDIENTE EN KARDEX ###################
			   $sql3 = " UPDATE kardex_ingredientes set "
			   ." salidas = ?, "
			   ." stockactual = ? "
			   ." WHERE "
			   ." codproceso = '".limpiar($_POST["codventa"])."' 
			      AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			      AND codingrediente = '".limpiar($codingredientebd)."';
			   ";
			   $stmt = $this->dbh->prepare($sql3);
			   $stmt->bindParam(1, $salidas);
			   $stmt->bindParam(2, $stockactual);

			   $racion = number_format($cantracionbd*$totalventa, 2, '.', '');
			   $salidas = number_format($salidakardex+$racion, 2, '.', '');
			   
			   $substock = number_format($cantracionbd*$totalventa, 2, '.', '');
			   $stockactual = number_format($cantingredientebd-$substock, 2, '.', '');
			   $stmt->execute();
			   
			   }//FIN CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		

	} elseif(limpiar($detalle[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

	############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################
	
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE codcombo = '".limpiar($_POST["codproducto"][$i])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			  ." existencia = ? "
			  ." where "
			  ." codcombo = '".limpiar($_POST["codproducto"][$i])."'
			     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$existencia = number_format($existenciacombobd-$totalventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############# ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###################
		$sql3 = " UPDATE kardex_combos set "
		      ." salidas = ?, "
		      ." stockactual = ? "
			  ." WHERE "
			  ." codproceso = '".limpiar($_POST["codventa"])."'
			     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			     AND codcombo = '".limpiar($_POST["codproducto"][$i])."';
			   ";
		$stmt = $this->dbh->prepare($sql3);
		$stmt->bindParam(1, $salidas);
		$stmt->bindParam(2, $existencia);
		
		$salidas = number_format($_POST['cantventa'][$i], 2, '.', '');
		$existencia = number_format($existenciacombobd-$totalventa, 2, '.', '');
		$stmt->execute();

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################

	}  else { // SI EL DETALLE ES UN EXTRA O INGREDIENTE

   	############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    	############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################
		$sql = "SELECT 
		cantingrediente, 
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($_POST["codproducto"][$i])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

	if($controlingredientebd == 1){//SI CONTROL STOCK INGREDIENTE
	
		##################### ACTUALIZO LA EXISTENCIA DEL INGREDIENTE ####################
		$sql = " UPDATE ingredientes set "
			  ." cantingrediente = ? "
			  ." WHERE "
			  ." codproducto = '".limpiar($_POST["codproducto"][$i])."'
			     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$existencia = number_format($existenciaingredientebd-$totalventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL INGREDIENTE ####################

		############# ACTUALIZAMOS LOS DATOS DEL INGREDIENTE EN KARDEX ###################
		$sql3 = " UPDATE kardex_ingredientes set "
		      ." salidas = ?, "
		      ." stockactual = ? "
			  ." WHERE "
			  ." codproceso = '".limpiar($_POST["codventa"])."'
			     AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
			     AND codproducto = '".limpiar($_POST["codproducto"][$i])."';
			   ";
		$stmt = $this->dbh->prepare($sql3);
		$stmt->bindParam(1, $salidas);
		$stmt->bindParam(2, $existencia);
		
		$salidas = number_format($_POST['cantventa'][$i], 2, '.', '');
		$existencia = number_format($existenciaingredientebd-$totalventa, 2, '.', '');
		$stmt->execute();
		############# ACTUALIZAMOS LOS DATOS DEL INGREDIENTE EN KARDEX ###################
	
	}//FIN CONTROL STOCK INGREDIENTE

    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    }// FIN DE TIPO DETALLE


		} else {

           echo "";

	       }
        } 
    }    
    $this->dbh->commit();

    ############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############
    $sql = " UPDATE ventas SET "
    ." codcliente = ?, "
    ." subtotalivasi = ?, "
    ." subtotalivano = ?, "
    ." totaliva = ?, "
	." descontado = ?, "
    ." descuento = ?, "
    ." totaldescuento = ?, "
    ." totalpago = ?, "
	." totalpago2 = ?, "
	." montodevuelto = ?, "
	." repartidor = ?, "
	." entregado = ? "
    ." WHERE "
    ." codventa = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql);
    $stmt->bindParam(1, $codcliente);
    $stmt->bindParam(2, $subtotalivasi);
    $stmt->bindParam(3, $subtotalivano);
    $stmt->bindParam(4, $totaliva);
	$stmt->bindParam(5, $descontado);
    $stmt->bindParam(6, $descuento);
    $stmt->bindParam(7, $totaldescuento);
    $stmt->bindParam(8, $totalpago);
    $stmt->bindParam(9, $totalpago2);
	$stmt->bindParam(10, $montodevuelto);
	$stmt->bindParam(11, $repartidor);
	$stmt->bindParam(12, $entregado);
    $stmt->bindParam(13, $codventa);
    $stmt->bindParam(14, $codsucursal);

    $codcliente = limpiar($_POST["codcliente"]);
	$subtotalivasi = number_format($_POST["txtsubtotal"], 2, '.', '');
	$subtotalivano = number_format($_POST["txtsubtotal2"], 2, '.', '');
	$totaliva = number_format($_POST["txtIva"], 2, '.', '');
	$descontado = number_format($_POST["txtdescontado"], 2, '.', '');
	$descuento = limpiar($_POST["descuento"]);
    $totaldescuento = number_format($_POST["txtDescuento"], 2, '.', '');
    $totalpago = number_format($_POST["txtTotal"], 2, '.', '');
    $totalpago2 = number_format($_POST["txtTotalCompra"], 2, '.', '');
    $txttotal = number_format($_POST["txtTotal"]+$montodeliverybd, 2, '.', '');
	$montodevuelto = number_format($totalpago > $_POST["pagado"] ? "0.00" : $_POST["pagado"]-$txttotal, 2, '.', '');
    $repartidor = limpiar($_POST["repartidor"] == "" ? "0" : decrypt($_POST["repartidor"]));
	$entregado = limpiar($_POST["repartidor"] == "" ? "0" : "1");
    $codventa = limpiar($_POST["codventa"]);
    $tipodocumento = limpiar($_POST["tipodocumento"]);
    $tipopago = limpiar($_POST["tipopago"]);
    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
    $stmt->execute();
    ############ ACTUALIZO LOS TOTALES EN LA VENTA ##############

    ################## OBTENGO LOS DATOS EN CAJA ##################
	$sql = "SELECT 
	efectivo, 
	cheque, 
	tcredito, 
	tdebito, 
	tprepago, 
	transferencia, 
	electronico,
	cupon, 
	otros,
	creditos,
	propinasefectivo,
	propinasotros,
	nroticket,
	nroboleta,
	nrofactura
	FROM arqueocaja WHERE codcaja = '".limpiar($cajabd)."' AND statusarqueo = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$efectivo = ($row['efectivo']== "" ? "0.00" : $row['efectivo']);
	$cheque = ($row['cheque']== "" ? "0.00" : $row['cheque']);
	$tcredito = ($row['tcredito']== "" ? "0.00" : $row['tcredito']);
	$tdebito = ($row['tdebito']== "" ? "0.00" : $row['tdebito']);
	$tprepago = ($row['tprepago']== "" ? "0.00" : $row['tprepago']);
	$transferencia = ($row['transferencia']== "" ? "0.00" : $row['transferencia']);
	$electronico = ($row['electronico']== "" ? "0.00" : $row['electronico']);
	$cupon = ($row['cupon']== "" ? "0.00" : $row['cupon']);
	$otros = ($row['otros']== "" ? "0.00" : $row['otros']);
	$credito = ($row['creditos']== "" ? "0.00" : $row['creditos']);
	$propinasefectivo = ($row['propinasefectivo']== "" ? "0.00" : $row['propinasefectivo']);
	$propinasotros = ($row['propinasotros']== "" ? "0.00" : $row['propinasotros']);
	$nroticket = $row['nroticket'];
	$nroboleta = $row['nroboleta'];
	$nrofactura = $row['nrofactura'];
	################## OBTENGO LOS DATOS EN CAJA ##################

    ################ AGREGAMOS O QUITAMOS LA DIFERENCIA EN CAJA ####################
	if (limpiar($_POST["tipopago"]=="CONTADO") && $totalpagobd != $totalpago){

		if ($totalpagobd > $totalpago){
	
	    ########################## PROCESO LA 1ERA FORMA DE PAGO #################################
		$sql = "UPDATE arqueocaja set "
		." efectivo = ?, "
		." cheque = ?, "
		." tcredito = ?, "
		." tdebito = ?, "
		." tprepago = ?, "
		." transferencia = ?, "
		." electronico = ?, "
		." cupon = ?, "
		." otros = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtEfectivo);
		$stmt->bindParam(2, $txtCheque);
		$stmt->bindParam(3, $txtTcredito);
		$stmt->bindParam(4, $txtTdebito);
		$stmt->bindParam(5, $txtTprepago);
		$stmt->bindParam(6, $txtTransferencia);
		$stmt->bindParam(7, $txtElectronico);
		$stmt->bindParam(8, $txtCupon);
		$stmt->bindParam(9, $txtOtros);
		$stmt->bindParam(10, $caja);

		$txtEfectivo = limpiar($_POST["formapago"] == "EFECTIVO" ? number_format($efectivo-($totalpagobd-$totalpago), 2, '.', '') : $efectivo);
		$txtCheque = limpiar($_POST["formapago"] == "CHEQUE" ? number_format($cheque-($totalpagobd-$totalpago), 2, '.', '') : $cheque);
		$txtTcredito = limpiar($_POST["formapago"] == "TARJETA DE CREDITO" ? number_format($tcredito-($totalpagobd-$totalpago), 2, '.', '') : $tcredito);
		$txtTdebito = limpiar($_POST["formapago"] == "TARJETA DE DEBITO" ? number_format($tdebito-($totalpagobd-$totalpago), 2, '.', '') : $tdebito);
		$txtTprepago = limpiar($_POST["formapago"] == "TARJETA PREPAGO" ? number_format($tprepago-($totalpagobd-$totalpago), 2, '.', '') : $tprepago);
		$txtTransferencia = limpiar($_POST["formapago"] == "TRANSFERENCIA" ? number_format($transferencia-($totalpagobd-$totalpago), 2, '.', '') : $transferencia);
		$txtElectronico = limpiar($_POST["formapago"] == "DINERO ELECTRONICO" ? number_format($electronico-($totalpagobd-$totalpago), 2, '.', '') : $electronico);
		$txtCupon = limpiar($_POST["formapago"] == "CUPON" ? number_format($cupon-($totalpagobd-$totalpago), 2, '.', '') : $cupon);
		$txtOtros = limpiar($_POST["formapago"] == "OTROS" ? number_format($otros-($totalpagobd-$totalpago), 2, '.', '') : $otros);
		$codcaja = limpiar($_POST["codcaja"]);
		$stmt->execute();
	    ########################## PROCESO LA 1ERA FORMA DE PAGO #################################


	if($_POST['formapago2'] != "0"){
	########################## PROCESO LA 2DA FORMA DE PAGO #################################
		
	########################## PROCESO LA 2DA FORMA DE PAGO #################################
	}
		} else {

	    ########################## PROCESO LA 1ERA FORMA DE PAGO #################################
		$sql = "UPDATE arqueocaja set "
		." efectivo = ?, "
		." cheque = ?, "
		." tcredito = ?, "
		." tdebito = ?, "
		." tprepago = ?, "
		." transferencia = ?, "
		." electronico = ?, "
		." cupon = ?, "
		." otros = ? "
		." WHERE "
		." codcaja = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtEfectivo);
		$stmt->bindParam(2, $txtCheque);
		$stmt->bindParam(3, $txtTcredito);
		$stmt->bindParam(4, $txtTdebito);
		$stmt->bindParam(5, $txtTprepago);
		$stmt->bindParam(6, $txtTransferencia);
		$stmt->bindParam(7, $txtElectronico);
		$stmt->bindParam(8, $txtCupon);
		$stmt->bindParam(9, $txtOtros);
		$stmt->bindParam(10, $caja);

		$txtEfectivo = limpiar($_POST["formapago"] == "EFECTIVO" ? number_format($efectivo+($totalpago-$totalpagobd), 2, '.', '') : $efectivo);
		$txtCheque = limpiar($_POST["formapago"] == "CHEQUE" ? number_format($cheque+($totalpago-$totalpagobd), 2, '.', '') : $cheque);
		$txtTcredito = limpiar($_POST["formapago"] == "TARJETA DE CREDITO" ? number_format($tcredito+($totalpago-$totalpagobd), 2, '.', '') : $tcredito);
		$txtTdebito = limpiar($_POST["formapago"] == "TARJETA DE DEBITO" ? number_format($tdebito+($totalpago-$totalpagobd), 2, '.', '') : $tdebito);
		$txtTprepago = limpiar($_POST["formapago"] == "TARJETA PREPAGO" ? number_format($tprepago+($totalpago-$totalpagobd), 2, '.', '') : $tprepago);
		$txtTransferencia = limpiar($_POST["formapago"] == "TRANSFERENCIA" ? number_format($transferencia+($totalpago-$totalpagobd), 2, '.', '') : $transferencia);
		$txtElectronico = limpiar($_POST["formapago"] == "DINERO ELECTRONICO" ? number_format($electronico+($totalpago-$totalpagobd), 2, '.', '') : $electronico);
		$txtCupon = limpiar($_POST["formapago"] == "CUPON" ? number_format($cupon+($totalpago-$totalpagobd), 2, '.', '') : $cupon);
		$txtOtros = limpiar($_POST["formapago"] == "OTROS" ? number_format($otros+($totalpago-$totalpagobd), 2, '.', '') : $otros);
		$codcaja = limpiar($_POST["codcaja"]);
		$stmt->execute();	
	    ########################## PROCESO LA 1ERA FORMA DE PAGO #################################

	if($_POST['formapago2'] != "0"){
	########################## PROCESO LA 2DA FORMA DE PAGO #################################
		
	########################## PROCESO LA 2DA FORMA DE PAGO #################################
	}
	    }
	}
    ############### AGREGAMOS O QUITAMOS LA DIFERENCIA EN CAJA ####################

    ############## AGREGAMOS O QUITAMOS LA DIFERENCIA EN CAJA ##################
	if (limpiar($_POST["tipopago"]=="CREDITO") && $totalpagobd != $totalpago) {

		$sql = " UPDATE arqueocaja SET "
		   ." creditos = ? "
		   ." WHERE "
		   ." codcaja = ? and statusarqueo = 1;
		    ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $TxtTotal);
		$stmt->bindParam(2, $caja);

		$TxtTotal = number_format(($totalpagobd>$totalpago ? $credito-($totalpagobd-$totalpago) : $credito+($totalpago-$totalpagobd)), 2, '.', '');
		$codcaja = limpiar($_POST["codcaja"]);
		$stmt->execute();	

		$sql = "UPDATE creditosxclientes set"
		." montocredito = ? "
		." WHERE "
		." codcliente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $montocredito);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codsucursal);

        $montocredito = number_format(($totalpagobd>$totalpago ? $montoactual-($totalpagobd-$totalpago) : $montoactual+($totalpago-$totalpagobd)), 2, '.', '');
		$codcliente = limpiar($_POST["codcliente"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute(); 
	}
    ############## AGREGAMOS O QUITAMOS LA DIFERENCIA EN CAJA ##################

    echo "<span class='fa fa-check-square-o'></span> EL PEDIDO DE PRODUCTOS HA SIDO ACTUALIZADO EXITOSAMENTE <a href='reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>window.open('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '_blank');</script>";
	exit;
}
############################ FUNCION ACTUALIZAR PEDIDOS ###########################

####################### FUNCION REGISTRAR PAGOS A PEDIDOS #############################
public function RegistrarPagoPedidos()
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
		exit;
		
	} else {
			
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
        $codarqueo = $row['codarqueo'];
        $codcaja = $row['codcaja'];
        $abonoefectivo = ($row['abonosefectivo']== "" ? "0.00" : $row['abonosefectivo']);
        $abonootros = ($row['abonosotros']== "" ? "0.00" : $row['abonosotros']);
	}
	####################### VERIFICO ARQUEO DE CAJA #######################

    if(empty($_POST["codcliente"]) or empty($_POST["codventa"]) or empty($_POST["montoabono"]))
	{
		echo "2";
		exit;
	} 
	else if($_POST["montoabono"] > $_POST["totaldebe"])
	{
		echo "3";
		exit;
	}

	################### VERIFICO MONTO DE CREDITO DEL CLIENTE ######################
	$sql = "SELECT montocredito 
	FROM creditosxclientes 
	WHERE codcliente = '".limpiar(decrypt($_POST['codcliente']))."'
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
    $monto = (empty($row['montocredito']) ? "0.00" : $row['montocredito']);
    ################### VERIFICO MONTO DE CREDITO DEL CLIENTE ######################

	################### INGRESOS EL ABONO DEL CREDITO ######################
	$query = "INSERT INTO abonoscreditos values (null, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcaja);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codcliente);
	$stmt->bindParam(4, $montoabono);
	$stmt->bindParam(5, $formaabono);
	$stmt->bindParam(6, $fechaabono);
	$stmt->bindParam(7, $codsucursal);

	$codventa = limpiar(decrypt($_POST["codventa"]));
	$codcliente = limpiar(decrypt($_POST["codcliente"]));
	$montoabono = limpiar($_POST["montoabono"]);
	$formaabono = limpiar($_POST["formaabono"]);
	$fechaabono = limpiar(date("Y-m-d H:i:s"));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################### INGRESOS EL ABONO DEL CREDITO ######################

	############# ACTUALIZAMNOS DATOS DE CAJA ##############
	$sql = "UPDATE arqueocaja set "
	." abonosefectivo = ?, "
	." abonosotros = ? "
	." WHERE "
	." codarqueo = ? AND statusarqueo = 1;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtOtros);
	$stmt->bindParam(3, $codarqueo);

    $txtEfectivo = limpiar($_POST["formaabono"] == "EFECTIVO" ? number_format($abonoefectivo+$_POST["montoabono"], 2, '.', '') : $abonoefectivo);
    $txtOtros = limpiar($_POST["formaabono"] != "EFECTIVO" ? number_format($abonootros+$_POST["montoabono"], 2, '.', '') : $abonootros);
	$stmt->execute(); 
	############# ACTUALIZAMNOS DATOS DE CAJA ##############

    ############## ACTUALIZAMOS EL MONTO DE CREDITO ##################
	$sql = "UPDATE creditosxclientes set"
	." montocredito = ? "
	." WHERE "
	." codcliente = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $montocredito);
	$stmt->bindParam(2, $codcliente);
	$stmt->bindParam(3, $codsucursal);

    $montocredito = number_format($monto - $_POST["montoabono"], 2, '.', '');
	$codcliente = limpiar(decrypt($_POST["codcliente"]));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute(); 
	############## ACTUALIZAMOS EL MONTO DE CREDITO ##################

	############## ACTUALIZAMOS EL STATUS DE LA FACTURA ##################
	if($_POST["montoabono"] == $_POST["totaldebe"]) {

		$sql = "UPDATE ventas set "
		." creditopagado = ?, "
		." statusventa = ?, "
		." fechapagado = ? "
		." WHERE "
		." codventa = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $creditopagado);
		$stmt->bindParam(2, $statusventa);
		$stmt->bindParam(3, $fechapagado);
		$stmt->bindParam(4, $codventa);
		$stmt->bindParam(5, $codsucursal);

		$creditopagado = number_format($_POST["totalabono"] + $_POST["montoabono"], 2, '.', '');
		$statusventa = limpiar("PAGADA");
		$fechapagado = limpiar(date("Y-m-d"));
		$codventa = limpiar(decrypt($_POST["codventa"]));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	
	} else {

		$sql = "UPDATE ventas set "
		." creditopagado = ? "
		." WHERE "
		." codventa = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $creditopagado);
		$stmt->bindParam(2, $codventa);
		$stmt->bindParam(3, $codsucursal);

		$creditopagado = number_format($_POST["totalabono"] + $_POST["montoabono"], 2, '.', '');
		$codventa = limpiar(decrypt($_POST["codventa"]));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	}
    ############## ACTUALIZAMOS EL STATUS DE LA FACTURA ##################
		
    echo "<span class='fa fa-check-square-o'></span> EL ABONO AL CR&Eacute;DITO DE VENTA HA SIDO REGISTRADO EXITOSAMENTE <a href='reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETCREDITO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR DOCUMENTO</strong></font color></a></div>";

    echo "<script>window.open('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETCREDITO")."', '_blank');</script>";
	exit;
}
##################### FUNCION REGISTRAR PAGOS A PEDIDOS ###########################

############################ FUNCION PARA ENTREGAR PEDIDOS ############################
public function EntregarPedido()
{
	if ($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"]=="secretaria" || $_SESSION["acceso"]=="cajero") {
	
	self::SetNames();

	$this->dbh->beginTransaction();
	################### SELECCIONO DETALLES DE LA VENTA ######################
	$sql = "SELECT * FROM detalleventas 
	WHERE codventa = '".limpiar(decrypt($_GET['codventa']))."' 
	AND codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
    foreach ($this->dbh->query($sql) as $row2)
	{

		if(limpiar($row2['tipo']) == 1){//SI EL DETALLE ESUN  PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################

	    ############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = '".limpiar($row2['codproducto'])."'
		AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		$controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codproducto = '".limpiar($row2['codproducto'])."'
			     AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($row2['cantventa'], 2, '.', '');
		$existencia = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
        $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);		
	    $stmt->bindParam(14, $codsucursal);	

		$codventa = limpiar(decrypt($_GET["codventa"]));
		$codcliente = limpiar(decrypt($_GET["codcliente"]));
		$codproducto = limpiar($row2['codproducto']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$precio = limpiar($row2['precioventa']);
		$ivaproducto = limpiar($row2['ivaproducto']);
		$descproducto = limpiar($row2['descproducto']);
		$documento = limpiar("DETALLE EN PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################

	}// FIN SI CONTROL STOCK PRODUCTO

	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
	    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($row2['codproducto'],decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
        	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
        	WHERE productosxingredientes.codproducto IN ('".limpiar($row2['codproducto'])."') 
        	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			    $codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		        if($controlingredientebd == 1){// SIN CONTROL STOCK INGREDIENTE

				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
				   $update = "UPDATE ingredientes set "
				   ." cantingrediente = ? "
				   ." WHERE "
				   ." codingrediente = ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codingredientebd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$row2['cantventa'], 2, '.', '');
				   $cantidadracion = number_format($cantingredientebd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

				   ############## REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX ###################
				   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codventa);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codingrediente);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaingrediente);
				   $stmt->bindParam(10, $descingrediente);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codventa = limpiar(decrypt($_GET["codventa"]));
				   $codcliente = limpiar(decrypt($_GET["codcliente"]));
				   $codingrediente = limpiar($codingredientebd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantingredientebd-$racion, 2, '.', '');
				   $precio = limpiar($precioventaingredientebd);
				   $ivaingrediente = limpiar($ivaingredientebd);
				   $descingrediente = limpiar($descingredientebd);
				   $documento = limpiar("DETALLE EN PEDIDO");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE INGREDIENTE EN KARDEX ###################
			    
			    }//FIN DE CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################	

    } elseif(limpiar($row2['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################

	    ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE codcombo = '".limpiar($row2['codproducto'])."'
		AND codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codcombo = '".limpiar($row2['codproducto'])."'
			     AND codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($row2['cantventa'], 2, '.', '');
		$existencia = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################
        $query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
        $stmt->bindParam(14, $codsucursal);		

		$codventa = limpiar(decrypt($_GET["codventa"]));
		$codcliente = limpiar(decrypt($_GET["codcliente"]));
		$codcombo = limpiar($row2['codproducto']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$precio = limpiar($row2['precioventa']);
		$ivacombo = limpiar($row2['ivaproducto']);
		$desccombo = limpiar($row2['descproducto']);
		$documento = limpiar("DETALLE EN PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($row2['codproducto'],decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.controlstockp,
	    	impuestos.valorimpuesto
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	LEFT JOIN impuestos ON impuestos.codimpuesto = productos.ivaproducto
        	WHERE combosxproductos.codcombo IN ('".limpiar($row2['codproducto'])."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd = $row['cantidad'];
			   $codproductobd = $row['codproducto'];
			   $cantproductobd = $row['existencia'];
			   $precioventaproductobd = $row['precioventa'];
			   $ivaproductobd = $row['valorimpuesto'];
			   $descproductobd = $row['descproducto'];
		       $controlproductobd = $row['controlstockp'];

		        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproductobd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$row2['cantventa'], 2, '.', '');
				   $cantidadracion = number_format($cantproductobd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codventa);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaingrediente);
				   $stmt->bindParam(10, $descingrediente);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codventa = limpiar(decrypt($_GET["codventa"]));
		           $codcliente = limpiar(decrypt($_GET["codcliente"]));
				   $codproducto = limpiar($codproductobd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantproductobd-$racion, 2, '.', '');
				   $precio = limpiar($precioventaproductobd);
				   $ivaingrediente = limpiar($ivaproductobd);
				   $descingrediente = limpiar($descproductobd);
				   $documento = limpiar("DETALLE EN PEDIDO");
		           $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }//FIN DE CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

	############################### PROCESO PARA VERIFICAR LOS COMBOS ###################################### 

    }  else { // SI EL DETALLE ES UN EXTRA

   	############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    	############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################
		$sql = "SELECT 
		cantingrediente, 
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($row2['codproducto'])."'
	    AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

		if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

		    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
			$sql = " UPDATE ingredientes set "
				  ." cantingrediente = ? "
				  ." WHERE "
				  ." codingrediente = '".limpiar($row2['codproducto'])."'
	                 AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."';
				   ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$cantventa = number_format($row2['cantventa'], 2, '.', '');
			$existencia = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

			############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
	        $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codventa);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codingrediente);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaingrediente);
			$stmt->bindParam(10, $descingrediente);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
	        $stmt->bindParam(14, $codsucursal);			

			$codventa = limpiar(decrypt($_GET["codventa"]));
		    $codcliente = limpiar(decrypt($_GET["codcliente"]));
			$codingrediente = limpiar($row2['codproducto']);
			$movimiento = limpiar("SALIDAS");
			$entradas = limpiar("0.00");
			$salidas= number_format($cantventa, 2, '.', '');
			$devolucion = limpiar("0.00");
			$stockactual = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$precio = limpiar($row2['precioventa']);
			$ivaingrediente = limpiar($row2['ivaproducto']);
			$descingrediente = limpiar($row2['descproducto']);
			$documento = limpiar("DETALLE EN PEDIDO");
		    $fechakardex = limpiar(date("Y-m-d"));
		    $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			$stmt->execute();
			############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################

		}// FIN DE CONTROL STOCK INGREDIENTE
    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    }// FIN DE TIPO DETALLE

	}// FIN DE FOR SESION
	################### SELECCIONO DETALLES DE LA VENTA ######################
    $this->dbh->commit();

	################### ACTUALIZO LA VENTA ######################
	$sql = " UPDATE ventas SET"
		  ." statuspedido = ? "
		  ." WHERE "
		  ." codventa = ? AND codsucursal = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statuspedido);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codsucursal);

	$statuspedido = limpiar("0");
	$codventa = limpiar(decrypt($_GET["codventa"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	################### ACTUALIZO LA VENTA ######################

	   echo "1";
	   exit;
	   
	} else {
	   
		echo "2";
		exit;
	}
}
########################## FUNCION PARA ENTREGAR PEDIDOS ###############################

########################## FUNCION LISTAR PEDIDOS DIARIAS ################################
public function ListarPedidosDiarias()
{
	self::SetNames();

	if ($_SESSION['acceso'] == "administradorS" || $_SESSION['acceso'] == "secretaria") {

	$sql = "SELECT 
	ventas.idventa, 
	ventas.codventa,
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado,
	ventas.montodelivery, 
	ventas.tipopago, 
	ventas.formapago, 
	ventas.montopagado,
	ventas.formapago2, 
	ventas.montopagado2,
	ventas.formapropina,
	ventas.montopropina, 
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
    ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa, 
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
    ventas.observaciones,
    ventas.fechaentrega,
    ventas.statuspedido, 
    ventas.tipoventa, 
    ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,  
	clientes.girocliente,
	clientes.tlfcliente, 
	clientes.id_provincia, 
	clientes.id_departamento, 
	clientes.direccliente, 
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
    documentos2.documento AS documento2, 
    documentos3.documento AS documento3,
	provincias.provincia,
    departamentos.departamento,
    provincias2.provincia AS provincia2,
    departamentos2.departamento AS departamento2,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	usuarios.comision,
	SUM(detalleventas.cantventa) as articulos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON clientes.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON clientes.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = '".limpiar($_SESSION["codsucursal"])."' 
	AND DATE_FORMAT(ventas.fechaventa,'%d-%m-%Y') = '".date("d-m-Y")."' 
	AND ventas.tipoventa = 2 
	GROUP BY detalleventas.codventa";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	    return $this->p;
		$this->dbh=null;

	} else { 

    $sql = "SELECT 
	ventas.idventa, 
	ventas.codventa,
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado,
	ventas.montodelivery, 
	ventas.tipopago, 
	ventas.formapago, 
	ventas.montopagado,
	ventas.formapago2, 
	ventas.montopagado2,
	ventas.formapropina,
	ventas.montopropina, 
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
    ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa, 
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
    ventas.observaciones, 
    ventas.fechaentrega,
    ventas.statuspedido, 
    ventas.tipoventa,
    ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,  
	clientes.girocliente,
	clientes.tlfcliente, 
	clientes.id_provincia, 
	clientes.id_departamento, 
	clientes.direccliente, 
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
    documentos2.documento AS documento2, 
    documentos3.documento AS documento3,
	provincias.provincia,
    departamentos.departamento,
    provincias2.provincia AS provincia2,
    departamentos2.departamento AS departamento2,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	usuarios.comision,
	SUM(detalleventas.cantventa) as articulos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON clientes.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON clientes.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codigo = '".limpiar($_SESSION["codigo"])."' 
	AND DATE_FORMAT(ventas.fechaventa,'%d-%m-%Y') = '".date("d-m-Y")."' 
	AND ventas.tipoventa = 2
	GROUP BY detalleventas.codventa";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	    return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION LISTAR PEDIDOS DIARIAS ############################

###################### FUNCION BUSQUEDA PEDIDOS POR CAJAS ###########################
public function BuscarPedidosxCajas() 
{
	self::SetNames();
	$sql ="SELECT 
	ventas.idventa, 
	ventas.codventa,
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado,
	ventas.montodelivery, 
	ventas.tipopago, 
	ventas.formapago, 
	ventas.montopagado,
	ventas.formapago2, 
	ventas.montopagado2,
	ventas.formapropina,
	ventas.montopropina, 
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
    ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa, 
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
    ventas.observaciones, 
    ventas.fechaentrega, 
    ventas.statuspedido,
    ventas.tipoventa,
    ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,  
	clientes.girocliente,
	clientes.tlfcliente, 
	clientes.id_provincia, 
	clientes.id_departamento, 
	clientes.direccliente, 
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
    documentos2.documento AS documento2, 
    documentos3.documento AS documento3,
	provincias.provincia,
    departamentos.departamento,
    provincias2.provincia AS provincia2,
    departamentos2.departamento AS departamento2,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	usuarios.comision,
	SUM(detalleventas.cantventa) as articulos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON clientes.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON clientes.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = ?
	AND ventas.codcaja = ? 
	AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ? 
	AND ventas.tipoventa = 2 
	GROUP BY detalleventas.codventa";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codcaja'])));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(4, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA PEDIDOS POR CAJAS ###########################


###################### FUNCION BUSQUEDA PEDIDOS POR FECHAS ###########################
public function BuscarPedidosxFechas() 
{
	self::SetNames();
	$sql ="SELECT 
	ventas.idventa, 
	ventas.codventa,
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado,
	ventas.montodelivery, 
	ventas.tipopago, 
	ventas.formapago, 
	ventas.montopagado,
	ventas.formapago2, 
	ventas.montopagado2,
	ventas.formapropina,
	ventas.montopropina, 
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
    ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa, 
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
    ventas.observaciones, 
    ventas.fechaentrega,
    ventas.statuspedido, 
    ventas.tipoventa,
    ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,  
	clientes.girocliente,
	clientes.tlfcliente, 
	clientes.id_provincia, 
	clientes.id_departamento, 
	clientes.direccliente, 
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
    documentos2.documento AS documento2, 
    documentos3.documento AS documento3,
	provincias.provincia,
    departamentos.departamento,
    provincias2.provincia AS provincia2,
    departamentos2.departamento AS departamento2,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	usuarios.comision,
	SUM(detalleventas.cantventa) as articulos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON clientes.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON clientes.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = ?
	AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ? 
	AND ventas.tipoventa = 2 
	GROUP BY detalleventas.codventa";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA PEDIDOS POR FECHAS ###########################

###################### FUNCION BUSQUEDA PEDIDOS POR FECHAS DE ENTREGA ###########################
public function BuscarPedidosxFechasEntrega() 
{
	self::SetNames();
	$sql ="SELECT 
	ventas.idventa, 
	ventas.codventa,
	ventas.codmesa,
	ventas.tipodocumento, 
	ventas.codfactura, 
	ventas.codserie, 
	ventas.codautorizacion, 
	ventas.codcaja, 
	ventas.codcliente, 
	ventas.subtotalivasi, 
	ventas.subtotalivano, 
	ventas.iva, 
	ventas.totaliva,
	ventas.descontado, 
	ventas.descuento, 
	ventas.totaldescuento, 
	ventas.totalpago, 
	ventas.totalpago2,
	ventas.creditopagado,
	ventas.montodelivery, 
	ventas.tipopago, 
	ventas.formapago, 
	ventas.montopagado,
	ventas.formapago2, 
	ventas.montopagado2,
	ventas.formapropina,
	ventas.montopropina, 
	ventas.montodevuelto, 
	ventas.fechavencecredito, 
    ventas.fechapagado,
	ventas.statusventa, 
	ventas.fechaventa, 
	ventas.delivery,
	ventas.repartidor,
	ventas.entregado,
    ventas.descripciones,
    ventas.observaciones, 
    ventas.fechaentrega, 
    ventas.statuspedido,
    ventas.tipoventa,
    ventas.codsucursal, 
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,  
	clientes.girocliente,
	clientes.tlfcliente, 
	clientes.id_provincia, 
	clientes.id_departamento, 
	clientes.direccliente, 
	clientes.emailcliente,
	clientes.limitecredito,
	documentos.documento,
    documentos2.documento AS documento2, 
    documentos3.documento AS documento3,
	provincias.provincia,
    departamentos.departamento,
    provincias2.provincia AS provincia2,
    departamentos2.departamento AS departamento2,
	cajas.nrocaja,
	cajas.nomcaja,
	usuarios.dni,
	usuarios.nombres,
	usuarios.comision,
	SUM(detalleventas.cantventa) as articulos, 
	GROUP_CONCAT(detalleventas.cantventa, ' | ', substr(detalleventas.producto, 1,21) , ' | ', ROUND(detalleventas.valorneto, 2) SEPARATOR '<br>') AS detalles_productos 
	FROM (ventas LEFT JOIN detalleventas ON detalleventas.codventa = ventas.codventa)
	LEFT JOIN mesas ON ventas.codmesa = mesas.codmesa 
	LEFT JOIN cajas ON ventas.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo 
	LEFT JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN provincias ON sucursales.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON sucursales.id_departamento = departamentos.id_departamento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente
	LEFT JOIN documentos AS documentos3 ON clientes.documcliente = documentos3.coddocumento
	LEFT JOIN provincias AS provincias2 ON clientes.id_provincia = provincias2.id_provincia 
	LEFT JOIN departamentos AS departamentos2 ON clientes.id_departamento = departamentos2.id_departamento
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = ?
	AND DATE_FORMAT(ventas.fechaentrega,'%Y-%m-%d') BETWEEN ? AND ? 
	AND ventas.tipoventa = 2 
	GROUP BY detalleventas.codventa";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codsucursal'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA PEDIDOS POR FECHAS DE ENTREGA ###########################

###################################### CLASE PEDIDOS ###################################



































###################################### CLASE VENTAS ###################################

##################################################################################################################
#                                                                                                                #
#                                   FUNCIONES PARA PEDIDOS DE PRODUCTOS EN MESA                                  #
#                                                                                                                #
##################################################################################################################

####################### FUNCION VERIFICAR PEDIDOS EN MESAS #######################
public function VerificaMesa()
{ 
	self::SetNames();
	$imp = new Login();
	$imp = $imp->ImpuestosPorId();
	$impuesto = (empty($imp) ? "Impuesto" : $imp[0]['nomimpuesto']);
	$valor = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
	//$impuesto = ($imp == '' ? "Impuesto" : $imp[0]['nomimpuesto']);
	//$valor = ($imp == '' ? "0.00" : $imp[0]['valorimpuesto']);

	$simbolo = ($_SESSION["acceso"] == "administradorG" ? "" : "<strong>".$_SESSION["simbolo"]."</strong>");

	if ($_SESSION["acceso"] == "cajero") {

	 	$sql = "SELECT * FROM arqueocaja 
	 	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	 	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	 	WHERE usuarios.codigo = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_SESSION["codigo"]));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<div class='alert alert-danger'>";
            echo "<center><span class='fa fa-info-circle'></span> POR FAVOR DEBE DE REALIZAR EL ARQUEO DE CAJA ASIGNADA PARA PROCESAR VENTAS <a href='arqueos'><label> REALIZAR ARQUEO</a></label></div></center>";
			exit;
	    }
	}

	$sql = "SELECT
	clientes.documcliente,
	clientes.dnicliente, 
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente, 
	pedidos.codpedido,
	/*pedidos.numpedido, 
    pedidos.numero,*/
    pedidos.codmesa,
    pedidos.referencia,
    pedidos.codcliente,
    pedidos.subtotalivasi, 
    pedidos.subtotalivano, 
    pedidos.iva, 
    pedidos.totaliva, 
	pedidos.descontado,
    pedidos.descuento, 
    pedidos.totaldescuento, 
    pedidos.totalpago, 
    pedidos.totalpago2,
    pedidos.codigo,
    pedidos.descripciones, 
    pedidos.codsucursal, 
    detallepedidos.coddetallepedido, 
    detallepedidos.codproducto, 
    detallepedidos.producto, 
    detallepedidos.ivaproducto, 
    detallepedidos.cantventa, 
    detallepedidos.descproducto, 
    detallepedidos.valortotal, 
    detallepedidos.totaldescuentov, 
    detallepedidos.valorneto,  
    detallepedidos.valorneto2, 
    detallepedidos.observacionespedido,
    detallepedidos.preparado,
    detallepedidos.tipodetalle,
    detallepedidos.detallepedido,
    detallepedidos.statusdetalle,
    salas.nomsala, 
    mesas.codmesa, 
    mesas.nommesa,
    mesas.statusmesa, 
    usuarios.nombres 
    FROM mesas LEFT JOIN pedidos ON mesas.codmesa = pedidos.codmesa 
    LEFT JOIN detallepedidos ON detallepedidos.codpedido = pedidos.codpedido
    LEFT JOIN clientes ON pedidos.codcliente = clientes.codcliente 
    LEFT JOIN salas ON salas.codsala = mesas.codsala  
    LEFT JOIN usuarios ON pedidos.codigo = usuarios.codigo 
    WHERE pedidos.codmesa = ? 
    AND pedidos.statuspedido = 1
    AND mesas.statusmesa = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmesa"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	?>

	<?php
    $mesa = new Login();
    $mesa = $mesa->MesasPorId();
    ?> 

    <input type="hidden" name="proceso" id="proceso" value="nuevopedido"/>
    <input type="hidden" name="mesa" id="mesa" value="<?php echo encrypt($mesa[0]['codmesa']); ?>">
    <input type="hidden" name="sucursal" id="sucursal" value="<?php echo encrypt($_SESSION['codsucursal']); ?>">
    <input type="hidden" name="codmesa" id="codmesa" value="<?php echo $mesa[0]['codmesa']; ?>">
    <input type="hidden" name="nombremesa" id="nombremesa" value="<?php echo $mesa[0]['nommesa']; ?>">
    <input type="hidden" name="codsucursal" id="codsucursal" value="<?php echo encrypt($_SESSION['codsucursal']); ?>">
    <input type="hidden" name="idproducto" id="idproducto">
    <input type="hidden" name="codproducto" id="codproducto">
    <input type="hidden" name="producto" id="producto">
    <input type="hidden" name="codcategoria" id="codcategoria">
    <input type="hidden" name="categorias" id="categorias">
    <input type="hidden" name="precioventa" id="precioventa">
    <input type="hidden" name="preciocompra" id="preciocompra"> 
    <input type="hidden" name="precioconiva" id="precioconiva">
    <input type="hidden" name="observacion" id="observacion">
    <input type="hidden" name="salsa" id="salsa">
    <input type="hidden" name="ivaproducto" id="ivaproducto">
    <input type="hidden" name="descproducto" id="descproducto">
    <input type="hidden" name="preparado" id="preparado">
    <input type="hidden" name="tipo" id="tipo">
    <input type="hidden" name="cantidad" id="cantidad" value="1">
    <input type="hidden" name="existencia" id="existencia">

    <div class="row">
        <div class="col-md-12">
            <label class="control-label">Búsqueda de Cliente: </label>
            <div class="input-group mb-3 has-feedback">
                <div class="input-group-append">
                <button type="button" class="btn btn-success waves-effect waves-light" data-placement="left" title="Nuevo Cliente" data-original-title="" data-href="#" data-toggle="modal" data-target="#myModalCliente" data-backdrop="static" data-keyboard="false"><i class="fa fa-user-plus"></i></button>
                </div>
                <input type="hidden" name="codcliente" id="codcliente" value="0">
                <input type="hidden" name="nrodocumento" id="nrodocumento" value="0">
                <input style="color:#000;font-weight:bold;" type="text" class="form-control" name="busqueda" id="busqueda" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Criterio para la Búsqueda del Cliente" value="CONSUMIDOR FINAL" autocomplete="off"/>
            </div>
        </div>
    </div>
      
    <div id="favoritos" style="display:none !important;"></div>

    <div class="table-responsive m-t-5 scroll-mesa">
    	<table id="carrito" class="table table-hover" style="margin-bottom: -20px !important; margin-top: 0px !important;" id="nvo-ped-det">
    		<thead>
    		</thead>
    		<tbody>
    			<tr class="warning-element" style="border-left: 2px solid #ffb22b !important; background: #fefde3;">
    				<td class="text-center" colspan=5><h4>NO HAY DETALLES AGREGADOS<h4></td>
    				</tr>
    			</tbody>
    		</table> 
    	</div>

    	<hr>

        <div class="row">
            <div class="col-md-12"> 
                <div class="form-group has-feedback2"> 
                    <label class="control-label">Observaciones: </label> 
                    <textarea class="form-control" type="text" name="descripciones" id="descripciones" onKeyUp="this.value=this.value.toUpperCase();" autocomplete="off" placeholder="Ingrese Observaciones" rows="2"></textarea>
                    <i class="fa fa-comment-o form-control-feedback2"></i> 
                </div> 
            </div>
        </div>

    	<div class="table-responsive">
    		<table id="carritototal" width="100%">
    			<tr>
                   <td><h5 class="text-left"><label>TOTAL DE ITEMS:</label></h5></td>
                   <td><h5 class="text-right"><label id="lblitems" name="lblitems">0.00</label></h5></td>
                </tr>
                <tr>
    				<td><h5 class="text-left"><label>TOTAL A CONFIRMAR:</label></h5></td>
    				<td><h5 class="text-right"><?php echo $simbolo; ?><label id="lbltotal" name="lbltotal">0.00</label></h5></td>
    				<input type="hidden" name="txtsubtotal" id="txtsubtotal" value="0.00"/>
    				<input type="hidden" name="txtsubtotal2" id="txtsubtotal2" value="0.00"/>
    				<input type="hidden" name="iva" id="iva" value="<?php echo $valor == '' ? "0.00" : number_format($valor, 2, '.', ''); ?>">
    				<input type="hidden" name="txtIva" id="txtIva" value="0.00"/>
                    <input type="hidden" name="txtdescontado" id="txtdescontado" value="0.00"/>
    				<input type="hidden" name="descuento" id="descuento" value="<?php echo number_format($_SESSION['descsucursal'], 2, '.', ''); ?>">
    				<input type="hidden" name="txtDescuento" id="txtDescuento" value="0.00"/>
    				<input type="hidden" name="txtTotal" id="txtTotal" value="0.00"/>
    				<input type="hidden" name="txtTotalCompra" id="txtTotalCompra" value="0.00"/>
    			</tr>
    		</table>
    	</div>

    	<div class="row">
    		<div class="col-md-4">
    			<button type="button" class="btn btn-info btn-lg btn-block waves-effect waves-light" onClick="RecargaPedidos('<?php echo encrypt("MESAS"); ?>');" data-placement="left" title="Ver Pedidos" data-original-title="" data-href="#" data-toggle="modal" data-target="#myModalPedidos" data-backdrop="static" data-keyboard="false"><i class="fa fa-cutlery"></i> Ver Cocina</button>
    		</div>

    		<div class="col-md-4">
    			<button type="button" class="btn btn-dark btn-lg btn-block" id="vaciar"><span class="fa fa-trash-o"></span> Limpiar</button>
    		</div>

    		<div class="col-md-4">
    			<span id="submit_guardar"><button type="submit" name="btn-submit" id="btn-submit" class="btn btn-warning btn-lg btn-block waves-effect waves-light" ><span class="fa fa-save"></span> Confirmar</button></span>
    		</div>
    	</div>

		<?php  
		exit;
		} else {
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
####################### FUNCION VERIFICAR PEDIDOS EN MESA #######################

############################ FUNCION NUEVO PEDIDO EN MESA ##############################
public function NuevoPedido()
	{
	self::SetNames();
	if(empty($_SESSION["CarritoVenta"]) or empty($_POST["txtTotal"]))
	{
		echo "1";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############
	$v = $_SESSION["CarritoVenta"];
	for($i=0;$i<count($v);$i++){

		if(limpiar($v[$i]['tipo']) == 1){ // SI EL DETALLE ES UN PRODUCTO

		     $sql = "SELECT 
		    existencia,
		    controlstockp  
		    FROM productos 
		    WHERE codproducto = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
			$controlproductobd = $row['controlstockp'];
		    $cantidad = $v[$i]['cantidad'];

	        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

			    if ($cantidad > $existenciabd) 
			    { 
			        echo "2";
			        exit;
			    }
				    
			}// FIN CONTROL STOCK PRODUCTO

		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
		    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array(limpiar($v[$i]['txtCodigo']),decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
		    if($num>0) { 

		    	$sql = "SELECT 
		    	productosxingredientes.codproducto,
		    	productosxingredientes.codingrediente,
		    	productosxingredientes.cantracion,
		    	productosxingredientes.codsucursal,
		    	ingredientes.cantingrediente,
		    	ingredientes.controlstocki
		    	FROM productosxingredientes 
		    	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
		    	WHERE productosxingredientes.codproducto IN ('".limpiar($v[$i]['txtCodigo'])."') 
		    	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
		    	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				    $cantracionbd = $row['cantracion'];
				    $codingredientebd = $row['codingrediente'];
				    $cantingredientebd = $row['cantingrediente'];
			        $controlingredientebd = $row['controlstocki'];

			        $racion = number_format($cantracionbd*$v[$i]['cantidad'], 2, '.', '');

			        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

			        	if ($racion > $cantingredientebd) 
			        	{ 
			        		echo "3";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK INGREDIENTE
			    }
		    }//fin de consulta de ingredientes de productos	
		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS ################# 

	    } elseif(limpiar($v[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO 

		    $sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE codcombo = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		       echo "4";
		       exit;
	        }

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($v[$i]['txtCodigo'],decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia,
	        	productos.controlstockp
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($v[$i]['txtCodigo'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				   $cantracionbd = $row['cantidad'];
				   $codproductobd = $row['codproducto'];
				   $cantproductobd = $row['existencia'];
			       $controlproductobd = $row['controlstockp'];

			        $racion = number_format($cantracionbd*$v[$i]['cantidad'], 2, '.', '');

			        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

			        	if ($racion > $cantproductobd) 
			        	{ 
			        		echo "5";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK PRODUCTO
			    }
		    }//fin de consulta de ingredientes de productos	
		   ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

	    } else {  // SI EL DETALLE ES UN EXTRA

	    	$sql = "SELECT 
		    cantingrediente,
		    controlstocki  
		    FROM ingredientes 
		    WHERE codingrediente = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['cantingrediente'];
			$controlingredientebd = $row['controlstocki'];
		    $cantidad = $v[$i]['cantidad'];

	        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

	        	if ($cantidad > $existenciabd) 
	        	{ 
	        		echo "6";
	        		exit;
	        	}
				    
			}// FIN CONTROL STOCK INGREDIENTE
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############

	##################### AGREGAMOS CODIGO DE PEDIDO #######################
	$sql = "SELECT 
	codpedido 
	FROM pedidos 
	ORDER BY idpedido 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$pedido=$row["codpedido"];
	}
	$codpedido = (empty($pedido) ? "1" : $pedido + 1);
	##################### AGREGAMOS CODIGO DE PEDIDO #######################

	##################### AGREGAMOS NUMERO DE PEDIDO #######################
	$sql = "SELECT 
	numpedido 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idnum=$row["numpedido"];
	}
	$numpedido = (empty($idnum) ? "1" : $idnum + 1);
	##################### AGREGAMOS NUMERO DE PEDIDO #######################

	##################### AGREGAMOS NUMERO DE CONTROL #######################
	$sql = "SELECT 
	numero 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idcontrol=$row["numero"];
	}
	$numero = (empty($idcontrol) ? "1" : $idcontrol + 1);
	##################### AGREGAMOS NUMERO DE CONTROL #######################

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
    clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
    clientes.girocliente,
    clientes.emailcliente, 
    clientes.tipocliente,
    clientes.limitecredito,
    clientes.id_provincia,
    clientes.id_departamento,
    clientes.direccliente,
    provincias.provincia,
    departamentos.departamento,
    ROUND(SUM(if(pag.montocredito!='0',pag.montocredito,'0.00')), 2) montoactual,
    ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 2) creditodisponible
    FROM clientes 
    LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes
       WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.dnicliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente = ($row['codcliente'] == "" ? "0" : $row['codcliente']);
    $tipocliente = ($row['tipocliente'] == "" ? "0" : $row['tipocliente']);
    $dnicliente = ($row['dnicliente'] == "" ? "0" : $row['dnicliente']);
    $nomcliente = ($row['nomcliente'] == "" ? "0" : $row['nomcliente']);
    $girocliente = ($row['girocliente'] == "" ? "0" : $row['girocliente']);
    $emailcliente = $row['emailcliente'];
    $provincia = ($row['id_provincia'] == "" || $row['id_provincia'] == "0" ? "0" : $row['provincia']);
    $departamento = ($row['id_departamento'] == "" || $row['id_departamento'] == "0" ? "0" : $row['departamento']);
    $direccliente = ($row['direccliente'] == "" ? "0" : $row['direccliente']);
    $limitecredito = $row['limitecredito'];
    $montoactual = $row['montoactual'];
    $creditodisponible = $row['creditodisponible'];
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    $fecha = date("Y-m-d H:i:s");

	##################### REGISTRO DE PEDIDO #######################
	$query = "INSERT INTO pedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $numpedido);
	$stmt->bindParam(3, $numero);
	$stmt->bindParam(4, $codmesa);
	$stmt->bindParam(5, $referencia);
	$stmt->bindParam(6, $codcliente);
	$stmt->bindParam(7, $subtotalivasi);
	$stmt->bindParam(8, $subtotalivano);
	$stmt->bindParam(9, $iva);
	$stmt->bindParam(10, $totaliva);
	$stmt->bindParam(11, $descontado);
	$stmt->bindParam(12, $descuento);
	$stmt->bindParam(13, $totaldescuento);
	$stmt->bindParam(14, $totalpago);
	$stmt->bindParam(15, $totalpago2);
	$stmt->bindParam(16, $descripciones);
	$stmt->bindParam(17, $tipopedido);
	$stmt->bindParam(18, $statuspedido);
	$stmt->bindParam(19, $repartidor);
	$stmt->bindParam(20, $fechapedido);
	$stmt->bindParam(21, $fechaentrega);
	$stmt->bindParam(22, $codigo);
	$stmt->bindParam(23, $mesero);
	$stmt->bindParam(24, $codsucursal);

	$codmesa = limpiar($_POST["codmesa"]);
	$referencia = limpiar("0");
	$subtotalivasi = limpiar($_POST["txtsubtotal"]);
	$subtotalivano = limpiar($_POST["txtsubtotal2"]);
	$iva = limpiar($_POST["iva"]);
	$totaliva = limpiar($_POST["txtIva"]);
	$descontado = limpiar($_POST["txtdescontado"]);
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago = limpiar($_POST["txtTotal"]);
	$totalpago2 = limpiar($_POST["txtTotalCompra"]);
	$descripciones = limpiar($_POST['descripciones']=="" ? "" : $_POST['descripciones']);
    $tipopedido = limpiar("1");
    $statuspedido = limpiar("1");
	$repartidor = limpiar("0");
    $fechapedido = limpiar($fecha);
    $fechaentrega = limpiar("0000-00-00 00:00:00");
	$codigo = limpiar($_SESSION["codigo"]);
	$mesero = limpiar($_SESSION["codigo"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### REGISTRO DE PEDIDO #######################

	#################### ACTUALIZAMOS EL STATUS DE MESA ####################
	$sql = "UPDATE mesas set "
	." statusmesa = ? "
	." WHERE "
	." codmesa = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statusmesa);
	$stmt->bindParam(2, $codmesa);

	$statusmesa = limpiar('1');
	$codmesa = limpiar($_POST["codmesa"]);
	$stmt->execute();
   #################### ACTUALIZAMOS EL STATUS DE MESA ####################

	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoVenta"];
	for($i=0;$i<count($detalle);$i++){

	##################### REGISTRO DETALLES EN PEDIDOS #######################
	$query = "INSERT INTO detallepedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $numpedido);
	$stmt->bindParam(3, $numero);
	$stmt->bindParam(4, $codmesa);
	$stmt->bindParam(5, $idproducto);
	$stmt->bindParam(6, $codproducto);
	$stmt->bindParam(7, $producto);
	$stmt->bindParam(8, $codcategoria);
	$stmt->bindParam(9, $cantidad);
	$stmt->bindParam(10, $preciocompra);
	$stmt->bindParam(11, $precioventa);
	$stmt->bindParam(12, $ivaproducto);
	$stmt->bindParam(13, $descproducto);
	$stmt->bindParam(14, $valortotal);
	$stmt->bindParam(15, $totaldescuentov);
	$stmt->bindParam(16, $subtotalimpuestos);
	$stmt->bindParam(17, $valorneto);
	$stmt->bindParam(18, $valorneto2);
	$stmt->bindParam(19, $observacionespedido);
	$stmt->bindParam(20, $salsaspedido);
	$stmt->bindParam(21, $cocinero);
	$stmt->bindParam(22, $preparado);
	$stmt->bindParam(23, $tipodetalle);
	$stmt->bindParam(24, $detallepedido);
	$stmt->bindParam(25, $statusdetalle);
	$stmt->bindParam(26, $fechadetallepedido);
	$stmt->bindParam(27, $fechadetalleentrega);
	$stmt->bindParam(28, $bandera_pedido);
	$stmt->bindParam(29, $codsucursal);

	$codmesa = limpiar($_POST["codmesa"]);
	$idproducto = limpiar($detalle[$i]['id']);
	$codproducto = limpiar($detalle[$i]['txtCodigo']);
	$producto = limpiar($detalle[$i]['producto']);
	$codcategoria = limpiar($detalle[$i]['codcategoria']);
	$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
	$preciocompra = limpiar($detalle[$i]['precio']);
	$precioventa = limpiar($detalle[$i]['precio2']);
	$precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto = limpiar($detalle[$i]['descproducto']);
	$descuento = $detalle[$i]['descproducto']/100;
	$valortotal = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto = 1 + ($_POST["iva"]/100);
	$Discriminado = $precioconiva/$ValorImpuesto;
    $SubtotalDiscriminado = $precioconiva - $Discriminado;
    $BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto = number_format($valortotal-$totaldescuentov, 2, '.', '');
	$valorneto2 = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
    $observacionespedido = limpiar($detalle[$i]['observacion'] == ", " ? "" : $detalle[$i]['observacion']);
    $salsaspedido = limpiar($detalle[$i]['salsa'] == ", " ? "" : $detalle[$i]['salsa']);
	$cocinero = limpiar('1');
	$preparado = limpiar($detalle[$i]['preparado']);
	$tipodetalle = limpiar($detalle[$i]['tipo']);
    $detallepedido = limpiar("1");
    $statusdetalle = limpiar("1");
	$fechadetallepedido = limpiar($fecha);
	$fechadetalleentrega = limpiar("0000-00-00 00:00:00");
	$bandera_pedido = limpiar("1");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### REGISTRO DETALLES EN PEDIDOS #######################

    if(limpiar($detalle[$i]['tipo']) == 1){  // SI EL DETALLE ES UN PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		
	
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		$controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
	             AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$existencia = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$stmt->execute();
	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
        $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);		
	    $stmt->bindParam(14, $codsucursal);		

		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$precio = limpiar($detalle[$i]['precio2']);
		$documento = limpiar("PEDIDO EN MESA");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################

	} // FIN DE CONTROL STOCK PRODUCTO

	    ############## VERIFICO SSI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
	    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($detalle[$i]['txtCodigo']),decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
        	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
        	WHERE productosxingredientes.codproducto IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
        	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			    $codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		       if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
				   $update = "UPDATE ingredientes set "
				   ." cantingrediente = ? "
				   ." WHERE "
				   ." codingrediente = ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codingredientebd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$detalle[$i]['cantidad'], 2, '.', '');
				   $cantidadracion = number_format($cantingredientebd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codpedido);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codingrediente);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaingrediente);
				   $stmt->bindParam(10, $descingrediente);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codingrediente = limpiar($codingredientebd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantingredientebd-$racion, 2, '.', '');
			       $ivaingrediente = limpiar($ivaingredientebd == "NO" ? "0.00" : $_POST["iva"]);
				   $descingrediente = limpiar($descingredientebd);
				   $precio = limpiar($precioventaingredientebd);
				   $documento = limpiar("PEDIDO EN MESA");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		

   } elseif(limpiar($detalle[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

   	############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			  ." existencia = ? "
			  ." where "
			  ." codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	             AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$existencia = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################
	    $query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);			
	    $stmt->bindParam(14, $codsucursal);	

		$codcombo = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$ivacombo = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$desccombo = limpiar($detalle[$i]['descproducto']);
		$precio = limpiar($detalle[$i]['precio2']);
		$documento = limpiar("PEDIDO EN MESA");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($detalle[$i]['txtCodigo'],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.ivaproducto,
	    	productos.controlstockp
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	WHERE combosxproductos.codcombo IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd = $row['cantidad'];
			   $codproductobd = $row['codproducto'];
			   $cantproductobd = $row['existencia'];
			   $precioventaproductobd = $row['precioventa'];
			   $ivaproductobd = $row['ivaproducto'];
			   $descproductobd = $row['descproducto'];
		       $controlproductobd = $row['controlstockp'];

		        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproductobd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$detalle[$i]['cantidad'], 2, '.', '');
				   $cantidadracion = number_format($cantproductobd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codpedido);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaingrediente);
				   $stmt->bindParam(10, $descingrediente);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codproducto = limpiar($codproductobd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantproductobd-$racion, 2, '.', '');
				   $precio = limpiar($precioventaproductobd);
				   $ivaingrediente = limpiar($ivaproductobd);
				   $descingrediente = limpiar($descproductobd);
				   $documento = limpiar("PEDIDO EN MESA");
				   $fechakardex = limpiar($fecha);
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN DE CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTOS RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################
    
    }  else { // SI EL DETALLE ES UN EXTRA

   	############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    	############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################
		$sql = "SELECT 
		cantingrediente, 
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

		if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

		    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
			$sql = " UPDATE ingredientes set "
				  ." cantingrediente = ? "
				  ." WHERE "
				  ." codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	                 AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
				   ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
			$existencia = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

			############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
	        $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpedido);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codingrediente);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaingrediente);
			$stmt->bindParam(10, $descingrediente);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
	        $stmt->bindParam(14, $codsucursal);			

			$codingrediente = limpiar($detalle[$i]['txtCodigo']);
			$movimiento = limpiar("SALIDAS");
			$entradas = limpiar("0.00");
			$salidas= number_format($cantventa, 2, '.', '');
			$devolucion = limpiar("0.00");
			$stockactual = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
		    $ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
			$descingrediente = limpiar($detalle[$i]['descproducto']);
			$precio = limpiar($detalle[$i]['precio2']);
			$documento = limpiar("PEDIDO EN MESA");
			$fechakardex = limpiar(date("Y-m-d"));
	        $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
			############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
		
		}// FIN DE CONTROL STOCK INGREDIENTE
    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    }// FIN DE TIPO DETALLE

    }// FIN DE FOR SESSION
		
	####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoVenta"]);
    $this->dbh->commit();

    echo "<span class='fa fa-check-square-o'></span> EL PEDIDO DE LA ".limpiar($_POST["nombremesa"]).", FUE REGISTRADO EXITOSAMENTE</div>";

    echo "<script>window.open('reportepdf?codpedido=".encrypt($codpedido)."&numpedido=".encrypt($numpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("GENERAL")."', '_blank');</script>";
	exit; 
}
######################### FUNCION NUEVO PEDIDO EN MESA ############################

############################ FUNCION AGREGAR PEDIDO EN MESA ##############################
public function AgregaPedido()
	{
	self::SetNames();
	if(empty($_POST["codsucursal"]) or empty($_POST["txtTotal"]) or empty($_SESSION["CarritoVenta"]))
	{
		echo "1";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############
	$v = $_SESSION["CarritoVenta"];
	for($i=0;$i<count($v);$i++){

		if(limpiar($v[$i]['tipo']) == 1){ // SI EL DETALLE ES PRODUCTO

		    $sql = "SELECT 
		    existencia,
		    controlstockp 
		    FROM productos 
		    WHERE codproducto = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
			$controlproductobd = $row['controlstockp'];
		    $cantidad = $v[$i]['cantidad'];

	        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

			    if ($cantidad > $existenciabd) 
			    { 
			        echo "2";
			        exit;
			    }
				    
			}// FIN CONTROL STOCK PRODUCTO

		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
		    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array(limpiar($v[$i]['txtCodigo']),decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
		    if($num>0) { 

		    	$sql = "SELECT 
		    	productosxingredientes.codproducto,
		    	productosxingredientes.codingrediente,
		    	productosxingredientes.cantracion,
		    	productosxingredientes.codsucursal,
		    	ingredientes.cantingrediente,
		    	ingredientes.controlstocki
		    	FROM productosxingredientes 
		    	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
		    	WHERE productosxingredientes.codproducto IN ('".limpiar($v[$i]['txtCodigo'])."') 
		    	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
		    	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				    $cantracionbd = $row['cantracion'];
				    $codingredientebd = $row['codingrediente'];
				    $cantingredientebd = $row['cantingrediente'];
			        $controlingredientebd = $row['controlstocki'];

			        $racion = number_format($cantracionbd*$v[$i]['cantidad'], 2, '.', '');

			        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

			        	if ($racion > $cantingredientebd) 
			        	{ 
			        		echo "3";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK INGREDIENTE
			    }
		    }//fin de consulta de ingredientes de productos	
		    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

	    } elseif(limpiar($v[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

	    	$sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE codcombo = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		       echo "4";
		       exit;
	        }

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($v[$i]['txtCodigo'],decrypt($_POST["codsucursal"])));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia,
	        	productos.controlstockp
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($v[$i]['txtCodigo'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				   $cantracionbd = $row['cantidad'];
				   $codproductobd = $row['codproducto'];
				   $cantproductobd = $row['existencia'];
			       $controlproductobd = $row['controlstockp'];

			        $racion = number_format($cantracionbd*$v[$i]['cantidad'], 2, '.', '');

			        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

			        	if ($racion > $cantproductobd) 
			        	{ 
			        		echo "5";
			        		exit;
			        	}
				    
				    }// FIN CONTROL STOCK PRODUCTO
			    }
		    }//fin de consulta de ingredientes de productos	
		   ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

	    } else {  // SI EL DETALLE ES UN EXTRA

	    	$sql = "SELECT 
		    cantingrediente,
		    controlstocki  
		    FROM ingredientes 
		    WHERE codingrediente = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			$this->p[] = $row;
		    }
		
		    $existenciabd = $row['cantingrediente'];
			$controlingredientebd = $row['controlstocki'];
		    $cantidad = $v[$i]['cantidad'];

	        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

	        	if ($cantidad > $existenciabd) 
	        	{ 
	        		echo "6";
	        		exit;
	        	}
				    
			}// FIN CONTROL STOCK INGREDIENTE
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA ############

	##################### AGREGAMOS NUMERO DE PEDIDO #######################
	$sql = "SELECT 
	numpedido 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idnum=$row["numpedido"];
	}
	$numpedido = (empty($idnum) ? "1" : $idnum + 1);
	##################### AGREGAMOS NUMERO DE PEDIDO #######################

	##################### AGREGAMOS NUMERO DE CONTROL #######################
	$sql = "SELECT 
	numero 
	FROM detallepedidos WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	ORDER BY coddetallepedido 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$idcontrol=$row["numero"];
	}
	$numero = (empty($idcontrol) ? "1" : $idcontrol + 1);
	##################### AGREGAMOS NUMERO DE CONTROL #######################

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
    clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
    clientes.girocliente,
    clientes.emailcliente, 
    clientes.tipocliente,
    clientes.limitecredito,
    clientes.id_provincia,
    clientes.id_departamento,
    clientes.direccliente,
    provincias.provincia,
    departamentos.departamento,
    ROUND(SUM(if(pag.montocredito!='0',pag.montocredito,'0.00')), 2) montoactual,
    ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 2) creditodisponible
    FROM clientes 
    LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes
       WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.dnicliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente = ($row['codcliente'] == "" ? "0" : $row['codcliente']);
    $tipocliente = ($row['tipocliente'] == "" ? "0" : $row['tipocliente']);
    $dnicliente = ($row['dnicliente'] == "" ? "0" : $row['dnicliente']);
    $nomcliente = ($row['nomcliente'] == "" ? "0" : $row['nomcliente']);
    $girocliente = ($row['girocliente'] == "" ? "0" : $row['girocliente']);
    $emailcliente = $row['emailcliente'];
    $provincia = ($row['id_provincia'] == "" || $row['id_provincia'] == "0" ? "0" : $row['provincia']);
    $departamento = ($row['id_departamento'] == "" || $row['id_departamento'] == "0" ? "0" : $row['departamento']);
    $direccliente = ($row['direccliente'] == "" ? "0" : $row['direccliente']);
    $limitecredito = $row['limitecredito'];
    $montoactual = $row['montoactual'];
    $creditodisponible = $row['creditodisponible'];
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

	$fecha = date("Y-m-d H:i:s");

	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoVenta"];
	for($i=0;$i<count($detalle);$i++){

		##################### REGISTRO DETALLES EN PEDIDOS #######################
		$query = "INSERT INTO detallepedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $numpedido);
		$stmt->bindParam(3, $numero);
		$stmt->bindParam(4, $codmesa);
		$stmt->bindParam(5, $idproducto);
		$stmt->bindParam(6, $codproducto);
		$stmt->bindParam(7, $producto);
		$stmt->bindParam(8, $codcategoria);
		$stmt->bindParam(9, $cantidad);
		$stmt->bindParam(10, $preciocompra);
		$stmt->bindParam(11, $precioventa);
		$stmt->bindParam(12, $ivaproducto);
		$stmt->bindParam(13, $descproducto);
		$stmt->bindParam(14, $valortotal);
		$stmt->bindParam(15, $totaldescuentov);
		$stmt->bindParam(16, $subtotalimpuestos);
		$stmt->bindParam(17, $valorneto);
		$stmt->bindParam(18, $valorneto2);
		$stmt->bindParam(19, $observacionespedido);
		$stmt->bindParam(20, $salsaspedido);
		$stmt->bindParam(21, $cocinero);
		$stmt->bindParam(22, $preparado);
		$stmt->bindParam(23, $tipodetalle);
		$stmt->bindParam(24, $detallepedido);
		$stmt->bindParam(25, $statusdetalle);
		$stmt->bindParam(26, $fechadetallepedido);
		$stmt->bindParam(27, $fechadetalleentrega);
		$stmt->bindParam(28, $bandera_pedido);
		$stmt->bindParam(29, $codsucursal);

		$codpedido = limpiar(decrypt($_POST["codpedido"]));
		//$numero = limpiar(decrypt($_POST["numero"]));
		$codmesa = limpiar(decrypt($_POST["codmesa"]));
		$idproducto = limpiar($detalle[$i]['id']);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$producto = limpiar($detalle[$i]['producto']);
		$codcategoria = limpiar($detalle[$i]['codcategoria']);
		$cantidad = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$preciocompra = limpiar($detalle[$i]['precio']);
		$precioventa = limpiar($detalle[$i]['precio2']);
		$precioconiva = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$descuento = $detalle[$i]['descproducto']/100;
		$valortotal = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto = 1 + ($_POST["iva"]/100);
		$Discriminado = $precioconiva/$ValorImpuesto;
	    $SubtotalDiscriminado = $precioconiva - $Discriminado;
	    $BaseDiscriminado = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto = number_format($valortotal-$totaldescuentov, 2, '.', '');
		$valorneto2 = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');

	    $observacionespedido = limpiar($detalle[$i]['observacion'] == ", " ? "" : $detalle[$i]['observacion']);
	    $salsaspedido = limpiar($detalle[$i]['salsa'] == ", " ? "" : $detalle[$i]['salsa']);
		$cocinero = limpiar('1');
		$preparado = limpiar($detalle[$i]['preparado']);
		$tipodetalle = limpiar($detalle[$i]['tipo']);
	    $detallepedido = limpiar("1");
	    $statusdetalle = limpiar("1");
		$fechadetallepedido = limpiar($fecha);
		$fechadetalleentrega = limpiar("0000-00-00 00:00:00");
		$bandera_pedido = limpiar("1");
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	    ##################### REGISTRO DETALLES EN PEDIDOS #######################

	if(limpiar($detalle[$i]['tipo']) == 1){ // SI EL DETALLE ES UN PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
		$controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
			  ." existencia = ? "
			  ." WHERE "
			  ." codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
	             AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$existencia = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
        $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);		
	    $stmt->bindParam(14, $codsucursal);		

		$codpedido = limpiar(decrypt($_POST["codpedido"]));
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciaproductobd-$cantventa, 2, '.', '');
		$ivaproducto = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto = limpiar($detalle[$i]['descproducto']);
		$precio = limpiar($detalle[$i]['precio2']);
		$documento = limpiar("PEDIDO EN MESA");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################

	}// FIN CONTROL STOCK PRODUCTO

	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
	    $sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($detalle[$i]['txtCodigo']),decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
	    if($num>0) {  

	    	$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
	    	LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
	    	WHERE productosxingredientes.codproducto IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
	    	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	    	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			    $codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		        if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
				   $update = "UPDATE ingredientes set "
				   ." cantingrediente = ? "
				   ." WHERE "
				   ." codingrediente = ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codingredientebd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$detalle[$i]['cantidad'], 2, '.', '');
				   $cantidadracion = number_format($cantingredientebd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codpedido);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codingrediente);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaingrediente);
				   $stmt->bindParam(10, $descingrediente);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codpedido = limpiar(decrypt($_POST["codpedido"]));
				   $codingrediente = limpiar($codingredientebd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantingredientebd-$racion, 2, '.', '');
			       $ivaingrediente = limpiar($ivaingredientebd == "NO" ? "0.00" : $_POST["iva"]);
				   $descingrediente = limpiar($descingredientebd);
				   $precio = limpiar($precioventaingredientebd);
				   $documento = limpiar("PEDIDO EN MESA");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################	

    } elseif(limpiar($detalle[$i]['tipo']) == 2){ // SI EL DETALLE ES UN COMBO

   	############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			  ." existencia = ? "
			  ." where "
			  ." codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	             AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
		$existencia = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################
	    $query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);			
	    $stmt->bindParam(14, $codsucursal);	

		$codpedido = limpiar(decrypt($_POST["codpedido"]));
		$codcombo = limpiar($detalle[$i]['txtCodigo']);
		$movimiento = limpiar("SALIDAS");
		$entradas = limpiar("0.00");
		$salidas= number_format($cantventa, 2, '.', '');
		$devolucion = limpiar("0.00");
		$stockactual = number_format($existenciacombobd-$cantventa, 2, '.', '');
		$ivacombo = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$desccombo = limpiar($detalle[$i]['descproducto']);
		$precio = limpiar($detalle[$i]['precio2']);
		$documento = limpiar("PEDIDO EN MESA");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX ###################

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($detalle[$i]['txtCodigo'],decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.ivaproducto,
	    	productos.controlstockp
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	WHERE combosxproductos.codcombo IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd = $row['cantidad'];
			   $codproductobd = $row['codproducto'];
			   $cantproductobd = $row['existencia'];
			   $precioventaproductobd = $row['precioventa'];
			   $ivaproductobd = $row['ivaproducto'];
			   $descproductobd = $row['descproducto'];
		       $controlproductobd = $row['controlstockp'];

		        if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproductobd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd*$detalle[$i]['cantidad'], 2, '.', '');
				   $cantidadracion = number_format($cantproductobd-$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codpedido);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaproducto);
				   $stmt->bindParam(10, $descproducto);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codpedido = limpiar(decrypt($_POST["codpedido"]));
				   $codproducto = limpiar($codproductobd);
				   $movimiento = limpiar("SALIDAS");
				   $entradas = limpiar("0.00");
				   $salidas= number_format($racion, 2, '.', '');
				   $devolucion = limpiar("0.00");
				   $stockactual = number_format($cantproductobd-$racion, 2, '.', '');
			       $ivaproducto = limpiar($ivaproductobd == "NO" ? "0.00" : $_POST["iva"]);
				   $descproducto = limpiar($descproductobd);
				   $precio = limpiar($precioventaproductobd);
				   $documento = limpiar("PEDIDO EN MESA");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de productos de combos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################
    
    }  else { // SI EL DETALLE ES UN EXTRA

    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

    	############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################
		$sql = "SELECT 
		cantingrediente, 
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

		if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

		    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
			$sql = " UPDATE ingredientes set "
				  ." cantingrediente = ? "
				  ." WHERE "
				  ." codingrediente = '".limpiar($detalle[$i]['txtCodigo'])."'
	                 AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
				   ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$cantventa = number_format($detalle[$i]['cantidad'], 2, '.', '');
			$existencia = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

			############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
	        $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpedido);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codingrediente);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaingrediente);
			$stmt->bindParam(10, $descingrediente);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
	        $stmt->bindParam(14, $codsucursal);			

			$codpedido = limpiar(decrypt($_POST["codpedido"]));
			$codingrediente = limpiar($detalle[$i]['txtCodigo']);
			$movimiento = limpiar("SALIDAS");
			$entradas = limpiar("0.00");
			$salidas= number_format($cantventa, 2, '.', '');
			$devolucion = limpiar("0.00");
			$stockactual = number_format($existenciaingredientebd-$cantventa, 2, '.', '');
			$ivaingrediente = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
			$descingrediente = limpiar($detalle[$i]['descproducto']);
			$precio = limpiar($detalle[$i]['precio2']);
			$documento = limpiar("PEDIDO EN MESA");
			$fechakardex = limpiar(date("Y-m-d"));
	        $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
		
		}// FIN CONTROL STOCK INGREDIENTE
    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

        }// FIN DE TIPO DETALLE

    }// FIN DE FOR SESSION
		
	####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoVenta"]);
    $this->dbh->commit();

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
    $sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00'";
    foreach ($this->dbh->query($sql3) as $row3)
    {
    	$this->p[] = $row3;
    }
	$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	$subtotalimpuestos = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
    $subtotalivasi = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
    $subtotalivasi2 = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
    $sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00'";
    foreach ($this->dbh->query($sql4) as $row4)
    {
    	$this->p[] = $row4;
    }
	$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
    $subtotalivano = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
    $subtotalivano2 = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ############ ACTUALIZO LOS TOTALES EN LA VENTA ##############
    $sql = " UPDATE pedidos SET "
    ." codcliente = ?, "
    ." subtotalivasi = ?, "
    ." subtotalivano = ?, "
    ." totaliva = ?, "
	." descontado = ?, "
    ." descuento = ?, "
    ." totaldescuento = ?, "
    ." totalpago = ?, "
    ." totalpago2 = ?, "
    ." descripciones = ? "
    ." WHERE "
    ." codpedido = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql);
    $stmt->bindParam(1, $codcliente);
    $stmt->bindParam(2, $subtotalivasi);
    $stmt->bindParam(3, $subtotalivano);
    $stmt->bindParam(4, $totaliva);
	$stmt->bindParam(5, $descontado);
    $stmt->bindParam(6, $descuento);
    $stmt->bindParam(7, $totaldescuento);
    $stmt->bindParam(8, $totalpago);
    $stmt->bindParam(9, $totalpago2);
    $stmt->bindParam(10, $descripciones);
    $stmt->bindParam(11, $codpedido);
	$stmt->bindParam(12, $codsucursal);	

    $iva = $_POST["iva"]/100;
	$totaliva = number_format($subtotalimpuestos, 2, '.', '');
	$descontado = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
    $descuento = limpiar($_POST["descuento"]);
    $txtDescuento = $_POST["descuento"]/100;
    $total = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
    $totaldescuento = number_format($total*$txtDescuento, 2, '.', '');
    $totalpago = number_format($total-$totaldescuento, 2, '.', '');
    $totalpago2 = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
	$descripciones = limpiar($_POST['descripciones']=="" ? "" : $_POST['descripciones']);
    $codpedido = limpiar(decrypt($_POST["codpedido"]));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
    $stmt->execute();
    ############ ACTUALIZO LOS TOTALES EN LA VENTA ##############

    echo "<span class='fa fa-check-square-o'></span> EL PEDIDO FUE AGREGADO A LA ".limpiar($_POST["nombremesa"])." EXITOSAMENTE </div>";

    echo "<script>window.open('reportepdf?codpedido=".encrypt($codpedido)."&numpedido=".encrypt($numpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("GENERAL")."', '_blank');</script>";
	exit;
}
######################### FUNCION AGREGAR PEDIDO EN MESA ############################

####################### FUNCION DETALLES PEDIDOS EN MESAS #######################
public function VerDetallesPedidosModal()
{ 
	self::SetNames();
	$sql = "SELECT
	pedidos.codpedido,
    pedidos.codmesa,
    pedidos.referencia, 
    pedidos.codcliente,
    pedidos.codigo,
    pedidos.descripciones, 
    pedidos.codsucursal, 
    detallepedidos.coddetallepedido, 
    detallepedidos.codproducto, 
    detallepedidos.producto, 
    detallepedidos.ivaproducto, 
    detallepedidos.cantventa, 
    detallepedidos.descproducto, 
    detallepedidos.valortotal, 
    detallepedidos.totaldescuentov, 
    detallepedidos.valorneto, 
    detallepedidos.valorneto2,  
    detallepedidos.observacionespedido,
    detallepedidos.preparado,
    detallepedidos.tipodetalle,
    detallepedidos.detallepedido
    FROM pedidos INNER JOIN detallepedidos ON pedidos.codpedido = detallepedidos.codpedido 
    WHERE pedidos.codmesa = ?
    AND pedidos.codsucursal = ?
    AND pedidos.statuspedido = 1
    AND detallepedidos.bandera_pedido = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmesa"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	    echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO HAY DETALLES AGREGADOS</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
####################### FUNCION DETALLES PEDIDOS EN MESA #######################

######################## FUNCION ELIMINAR DETALLES DE PEDIDOS #######################
public function EliminarDetallesPedido()
{
    self::SetNames();

	############ CONSULTO LOS TOTALES DE PEDIDO ##############
    $sql2 = "SELECT iva, descuento FROM pedidos WHERE codpedido = ? AND codsucursal = ?";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->execute(array(decrypt($_GET["codpedido"]),decrypt($_GET["codsucursal"])));
    $num = $stmt->rowCount();

    if($row = $stmt->fetch(PDO::FETCH_ASSOC))
    {
    	$paea[] = $row;
    }
    $iva = $paea[0]["iva"]/100;
    $ivg = $paea[0]["iva"];
    $descuento = $paea[0]["descuento"]/100;
	############ CONSULTO LOS TOTALES DE PEDIDO ##############

	$sql = "SELECT * FROM detallepedidos WHERE codpedido = ? AND codsucursal = ? AND bandera_pedido = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpedido"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{
	    ############## OBTENGO LOS DATOS DEL PEDIDO A ELIMINAR #################
		$sql = "SELECT
		idproducto,
		codproducto, 
		cantventa, 
		preciocompra, 
		precioventa, 
		ivaproducto, 
		descproducto,
		tipodetalle  
		FROM detallepedidos 
		WHERE coddetallepedido = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["coddetallepedido"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$idproductobd = $row['idproducto'];
		$codproductobd = $row['codproducto'];
		$cantidadbd = $row['cantventa'];
		$preciocomprabd = $row['preciocompra'];
		$precioventabd = $row['precioventa'];
	    $precioconiva = ($row['ivaproducto'] == "0.00" ? "0.00" : $row['precioventa']);
		$ivaproductobd = $row['ivaproducto'];
		$descproductobd = $row['descproducto'];
		$tipodetallebd = $row['tipodetalle'];
		############## OBTENGO LOS DATOS DEL PEDIDO A ELIMINAR #################

    if(limpiar($tipodetallebd) == 1){ // SI EL DETALLE ES PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql2 = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
	    $controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK PRODUCTO

		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$existencia = number_format($existenciaproductobd+$cantidadbd, 2, '.', '');
		$codproducto = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ######## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ###########
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);	

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$codproducto = limpiar($codproductobd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciaproductobd+$cantidadbd, 2, '.', '');
		$ivaproducto = limpiar($ivaproductobd);
		$descproducto = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		######## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ###########

	}// FIN CONTROL STOCK PRODUCTO

	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
		$sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
		if($num>0) {  

			$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
			LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
			WHERE productosxingredientes.codproducto IN ('".limpiar($codproductobd)."') 
        	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
			foreach ($this->dbh->query($sql) as $row)
			{ 
				$this->p[] = $row;

				$codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		    if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
			   $update = "UPDATE ingredientes set "
			   ." cantingrediente = ? "
			   ." WHERE "
			   ." codingrediente = ? AND codsucursal = ?;
			   ";
			   $stmt = $this->dbh->prepare($update);
			   $stmt->bindParam(1, $cantidadracion);
			   $stmt->bindParam(2, $codingredientebd);
               $stmt->bindParam(3, $codsucursal);

			   $racion = number_format($cantracionbd*$cantidadbd, 2, '.', '');
			   $cantidadracion = number_format($cantingredientebd+$racion, 2, '.', '');
	           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			   $stmt->execute();
			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

			   ############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
			   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			   $stmt = $this->dbh->prepare($query);
			   $stmt->bindParam(1, $codpedido);
			   $stmt->bindParam(2, $codcliente);
			   $stmt->bindParam(3, $codingrediente);
			   $stmt->bindParam(4, $movimiento);
			   $stmt->bindParam(5, $entradas);
			   $stmt->bindParam(6, $salidas);
			   $stmt->bindParam(7, $devolucion);
			   $stmt->bindParam(8, $stockactual);
			   $stmt->bindParam(9, $ivaingrediente);
			   $stmt->bindParam(10, $descingrediente);
			   $stmt->bindParam(11, $precio);
			   $stmt->bindParam(12, $documento);
			   $stmt->bindParam(13, $fechakardex);
               $stmt->bindParam(14, $codsucursal);		

			   $codpedido = limpiar(decrypt($_GET["codpedido"]));
			   $codcliente = limpiar("0");
			   $codingrediente = limpiar($codingredientebd);
			   $movimiento = limpiar("DEVOLUCION");
			   $entradas = limpiar("0.00");
			   $salidas= limpiar("0");
			   $devolucion = number_format($racion, 2, '.', '');
			   $stockactual = number_format($cantingredientebd+$racion, 2, '.', '');
			   $ivaingrediente = limpiar($ivaingredientebd == "NO" ? "0.00" : $ivg);
			   $descingrediente = limpiar($descingredientebd);
			   $precio = limpiar($precioventaingredientebd);
			   $documento = limpiar("DEVOLUCION DE PEDIDO");
			   $fechakardex = limpiar(date("Y-m-d"));
	           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			   $stmt->execute();
			   
			   }// FIN CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################	

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################

	} elseif(limpiar($tipodetallebd) == 2){ // SI EL DETALLE ES UN COMBO

	############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql2 = "SELECT existencia FROM combos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

		########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############
		$sql = "UPDATE combos SET "
		." existencia = ? "
		." WHERE "
		." codcombo = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codcombo);
		$stmt->bindParam(3, $codsucursal);	

		$existencia = number_format($existenciacombobd+$cantidadbd, 2, '.', '');
		$codcombo = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############

	    ######## REGISTRAMOS LOS DATOS DEL COMBO ELIMINADO EN KARDEX ###########
		$query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);		

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$codcombo = limpiar($codproductobd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciacombobd+$cantidadbd, 2, '.', '');
		$ivacombo = limpiar($ivaproductobd);
		$desccombo = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		######## REGISTRAMOS LOS DATOS DEL COMBO ELIMINADO EN KARDEX ###########

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.ivaproducto,
	    	productos.controlstockp
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	WHERE combosxproductos.codcombo IN ('".limpiar($codproductobd)."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd2 = $row['cantidad'];
			   $codproductobd2 = $row['codproducto'];
			   $cantproductobd2 = $row['existencia'];
			   $precioventaproductobd2 = $row['precioventa'];
			   $ivaproductobd2 = $row['ivaproducto'];
			   $descproductobd2 = $row['descproducto'];
		       $controlproductobd2 = $row['controlstockp'];

		        if($controlproductobd2 == 1){// SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproductobd2);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd2*$cantidadbd, 2, '.', '');
				   $cantidadracion = number_format($cantproductobd2+$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codpedido);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaproducto);
				   $stmt->bindParam(10, $descproducto);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codpedido = limpiar(decrypt($_GET["codpedido"]));
			       $codcliente = limpiar("0");
				   $codproducto = limpiar($codproductobd2);
				   $movimiento = limpiar("DEVOLUCION");
			       $entradas = limpiar("0.00");
			       $salidas= limpiar("0");
			       $devolucion = number_format($racion, 2, '.', '');
				   $stockactual = number_format($cantproductobd2+$racion, 2, '.', '');
				   $ivaproducto = limpiar($ivaproductobd2 == "NO" ? "0.00" : $ivg);
				   $descproducto = limpiar($descproductobd2);
				   $precio = limpiar($precioventaproductobd2);
				   $documento = limpiar("DEVOLUCION DE PEDIDO");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################

	} else { // SI EL DETALLE ES UN EXTRA

    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################		

		############## VERIFICO LA EXISTENCIA DEL INGREDIENTES EN ALMACEN #################
		$sql2 = "SELECT 
		cantingrediente,
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

	if($controlingredientebd == 1){// SI CONTROL STOCK INGTREDIENTE

		########### ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql = "UPDATE ingredientes SET "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codingrediente);
		$stmt->bindParam(3, $codsucursal);	

		$existencia = number_format($existenciaingredientebd+$cantidadbd, 2, '.', '');
		$codingrediente = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	    ############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codingrediente);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);		

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$codingrediente = limpiar($codproductobd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciaingredientebd+$cantidadbd, 2, '.', '');
		$ivaingrediente = limpiar($ivaproductobd);
		$descingrediente = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
	
	}// FIN CONTROL STOCK INGREDIENTE

    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

	}// FIN DE TIPO DETALLE	

		############ ELIMINO DETALLE DE PEDIDO ############
	    $sql = "DELETE FROM detallepedidos 
		WHERE coddetallepedido = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddetallepedido);

		$coddetallepedido = limpiar(decrypt($_GET["coddetallepedido"]));
		$stmt->execute();
		############ ELIMINO DETALLE DE PEDIDO ############

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
		$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_GET["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
		foreach ($this->dbh->query($sql3) as $row3)
		{
			$this->p[] = $row3;
		}
	    $subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	    $subtotalimpuestos = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
		$subtotalivasi = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
		$subtotalivasi2 = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
		$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_GET["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
		foreach ($this->dbh->query($sql4) as $row4)
		{
			$this->p[] = $row4;
		}
	    $subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
		$subtotalivano = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
		$subtotalivano2 = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

        ############ ACTUALIZO LOS TOTALES EN EL PEDIDO ##############
        $sql = " UPDATE pedidos SET "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
	    ." descontado = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." totalpago2= ? "
		." WHERE "
		." codpedido = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $subtotalivasi);
		$stmt->bindParam(2, $subtotalivano);
		$stmt->bindParam(3, $totaliva);
	    $stmt->bindParam(4, $descontado);
		$stmt->bindParam(5, $totaldescuento);
		$stmt->bindParam(6, $totalpago);
		$stmt->bindParam(7, $totalpago2);
		$stmt->bindParam(8, $codpedido);
		$stmt->bindParam(9, $codsucursal);

		$totaliva= number_format($subtotalimpuestos, 2, '.', '');
	    $descontado = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
		$total= number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
		$totaldescuento= number_format($total*$descuento, 2, '.', '');
		$totalpago= number_format($total-$totaldescuento, 2, '.', '');
		$totalpago2 = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN EL PEDIDO ##############
		
		echo "1";
		exit;

		} else {

		############## OBTENGO LOS DATOS DEL PEDIDO A ELIMINAR #################
		$sql = "SELECT
		idproducto,
		codproducto, 
		cantventa, 
		preciocompra, 
		precioventa, 
		ivaproducto, 
		descproducto,
		tipodetalle  
		FROM detallepedidos 
		WHERE coddetallepedido = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["coddetallepedido"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$idproductobd = $row['idproducto'];
		$codproductobd = $row['codproducto'];
		$cantidadbd = $row['cantventa'];
		$preciocomprabd = $row['preciocompra'];
		$precioventabd = $row['precioventa'];
	    $precioconiva = ($row['ivaproducto'] == "0.00" ? "0.00" : $row['precioventa']);
		$ivaproductobd = $row['ivaproducto'];
		$descproductobd = $row['descproducto'];
		$tipodetallebd = $row['tipodetalle'];
		############## OBTENGO LOS DATOS DEL PEDIDO A ELIMINAR #################

    if(limpiar($tipodetallebd) == 1){ // SI EL DETALLE ES PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql2 = "SELECT 
		existencia, 
		controlstockp 
		FROM productos 
		WHERE codproducto = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
	    $controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){// SI CONTROL STOCK DE PRODUCTO

		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$existencia = number_format($existenciaproductobd+$cantidadbd, 2, '.', '');
		$codproducto = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ######## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ###########
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);	

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$codproducto = limpiar($codproductobd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciaproductobd+$cantidadbd, 2, '.', '');
		$ivaproducto = limpiar($ivaproductobd);
		$descproducto = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		######## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ###########

	}// FIN DE CONTROL STOCK DE PRODUCTO	
	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
		$sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
		if($num>0) {  

			$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
			LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
			WHERE productosxingredientes.codproducto IN ('".limpiar(decrypt($_GET["codproducto"]))."') 
        	AND productosxingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
			foreach ($this->dbh->query($sql) as $row)
			{ 
				$this->p[] = $row;

				$codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		    if($controlingredientebd == 1){//SI CONTROL STOCK INGREDIENTE

			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
			   $update = "UPDATE ingredientes set "
			   ." cantingrediente = ? "
			   ." WHERE "
			   ." codingrediente = ? AND codsucursal = ?;
			   ";
			   $stmt = $this->dbh->prepare($update);
			   $stmt->bindParam(1, $cantidadracion);
			   $stmt->bindParam(2, $codingredientebd);
               $stmt->bindParam(3, $codsucursal);

			   $racion = number_format($cantracionbd*$cantidadbd, 2, '.', '');
			   $cantidadracion = number_format($cantingredientebd+$racion, 2, '.', '');
	           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			   $stmt->execute();
			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

			   ############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
			   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			   $stmt = $this->dbh->prepare($query);
			   $stmt->bindParam(1, $codpedido);
			   $stmt->bindParam(2, $codcliente);
			   $stmt->bindParam(3, $codingrediente);
			   $stmt->bindParam(4, $movimiento);
			   $stmt->bindParam(5, $entradas);
			   $stmt->bindParam(6, $salidas);
			   $stmt->bindParam(7, $devolucion);
			   $stmt->bindParam(8, $stockactual);
			   $stmt->bindParam(9, $ivaingrediente);
			   $stmt->bindParam(10, $descingrediente);
			   $stmt->bindParam(11, $precio);
			   $stmt->bindParam(12, $documento);
			   $stmt->bindParam(13, $fechakardex);
               $stmt->bindParam(14, $codsucursal);		

			   $codpedido = limpiar(decrypt($_GET["codpedido"]));
			   $codcliente = limpiar("0");
			   $codingrediente = limpiar($codingredientebd);
			   $movimiento = limpiar("DEVOLUCION");
			   $entradas = limpiar("0.00");
			   $salidas= limpiar("0");
			   $devolucion = number_format($racion, 2, '.', '');
			   $stockactual = number_format($cantingredientebd+$racion, 2, '.', '');
			   $ivaingrediente = limpiar($ivaingredientebd == "NO" ? "0.00" : $ivg);
			   $descingrediente = limpiar($descingredientebd);
			   $precio = limpiar($precioventaingredientebd);
			   $documento = limpiar("DEVOLUCION DE PEDIDO");
			   $fechakardex = limpiar(date("Y-m-d"));
	           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			   $stmt->execute();
			   
			   }//FIN DE CONTROL STOCK INGREDIENTE
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################	

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################

	} elseif(limpiar($tipodetallebd) == 2){ // SI EL DETALLE ES UN COMBO

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql2 = "SELECT existencia FROM combos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

		########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############
		$sql = "UPDATE combos SET "
		." existencia = ? "
		." WHERE "
		." codcombo = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codcombo);
		$stmt->bindParam(3, $codsucursal);	

		$existencia = number_format($existenciacombobd+$cantidadbd, 2, '.', '');
		$codcombo = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############

	    ######## REGISTRAMOS LOS DATOS DEL COMBO ELIMINADO EN KARDEX ###########
		$query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);		

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$codcombo = limpiar($codproductobd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciacombobd+$cantidadbd, 2, '.', '');
		$ivacombo = limpiar($ivaproductobd);
		$desccombo = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		######## REGISTRAMOS LOS DATOS DEL COMBO ELIMINADO EN KARDEX ###########

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.ivaproducto,
	    	productos.controlstockp
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	WHERE combosxproductos.codcombo IN ('".limpiar(decrypt($_GET["codproducto"]))."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd2 = $row['cantidad'];
			   $codproductobd2 = $row['codproducto'];
			   $cantproductobd2 = $row['existencia'];
			   $precioventaproductobd2 = $row['precioventa'];
			   $ivaproductobd2 = $row['ivaproducto'];
			   $descproductobd2 = $row['descproducto'];
		       $controlproductobd2 = $row['controlstockp'];

		        if($controlproductobd2 == 1){// SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproductobd);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd2*$cantidadbd, 2, '.', '');
				   $cantidadracion = number_format($cantproductobd2+$racion, 2, '.', '');
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codpedido);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaproducto);
				   $stmt->bindParam(10, $descproducto);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codpedido = limpiar(decrypt($_GET["codpedido"]));
			       $codcliente = limpiar("0");
				   $codproducto = limpiar($codproductobd2);
				   $movimiento = limpiar("DEVOLUCION");
			       $entradas = limpiar("0.00");
			       $salidas= limpiar("0");
			       $devolucion = number_format($racion, 2, '.', '');
				   $stockactual = number_format($cantproductobd2+$racion, 2, '.', '');
				   $ivaproducto = limpiar($ivaproductobd2 == "NO" ? "0.00" : $ivg);
				   $descproducto = limpiar($descproductobd2);
				   $precio = limpiar($precioventaproductobd2);
				   $documento = limpiar("DEVOLUCION DE PEDIDO");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }// FIN CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################

	} else { // SI EL DETALLE ES UN EXTRA O INGREDIENTE

    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################		

		############## VERIFICO LA EXISTENCIA DEL INGREDIENTES EN ALMACEN #################
		$sql2 = "SELECT 
		cantingrediente,
		controlstocki 
		FROM ingredientes 
		WHERE codingrediente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

	if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

		########### ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############
		$sql = "UPDATE ingredientes SET "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codingrediente);
		$stmt->bindParam(3, $codsucursal);	

		$existencia = number_format($existenciaingredientebd+$cantidadbd, 2, '.', '');
		$codingrediente = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	    ############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codingrediente);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);		

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$codingrediente = limpiar($codproductobd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciaingredientebd+$cantidadbd, 2, '.', '');
		$ivaingrediente = limpiar($ivaproductobd);
		$descingrediente = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
	
	}// FIN CONTROL STOCK INGREDIENTE

    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

	}// FIN DE TIPO DETALLE		

		#################### ELIMINAMOS EL PEDIDO ####################
		$sql = "DELETE FROM pedidos WHERE codpedido = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpedido);
		$stmt->bindParam(2,$codsucursal);

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		#################### ELIMINAMOS EL PEDIDO ####################

		#################### ELIMINAMOS EL PEDIDO EN DETALLES PEDIDOS ####################
		$sql = "DELETE FROM detallepedidos 
		WHERE codpedido = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpedido);
		$stmt->bindParam(2,$codsucursal);

		$codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		#################### ELIMINAMOS EL PEDIDO EN DETALLES PEDIDOS ####################

		#################### ACTUALIZAMOS EL STATUS DE MESA ####################
    	$sql = "UPDATE mesas set "
    	." statusmesa = ? "
    	." WHERE "
    	." codmesa = ?;
    	";
    	$stmt = $this->dbh->prepare($sql);
    	$stmt->bindParam(1, $statusmesa);
    	$stmt->bindParam(2, $codmesa);

    	$statusmesa = limpiar('0');
    	$codmesa = decrypt($_GET["codmesa"]);
    	$stmt->execute();
        #################### ACTUALIZAMOS EL STATUS DE MESA ####################

		echo "1";
		exit;
	}	
}
##################### FUNCION ELIMINAR DETALLES DE PEDIDOS ###############################

############################ FUNCION CANCELAR PEDIDOS #############################
public function CancelarPedido()
	{
	self::SetNames();

	############ CONSULTO LOS TOTALES DE PEDIDO ##############
    $sql2 = "SELECT iva, descuento FROM pedidos WHERE codpedido = ? AND codsucursal = ?";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->execute(array(decrypt($_GET["codpedido"]),decrypt($_GET["codsucursal"])));
    $num = $stmt->rowCount();

    if($row = $stmt->fetch(PDO::FETCH_ASSOC))
    {
    	$paea[] = $row;
    }
    $iva = $paea[0]["iva"]/100;
    $ivg = $paea[0]["iva"];
    $descuento = $paea[0]["descuento"]/100;
	############ CONSULTO LOS TOTALES DE PEDIDO ##############

	#################### SELECCIONO LOS PRODUCTOS EN DETALLES VENTAS ####################
	$sql = "SELECT * FROM detallepedidos 
	WHERE codmesa = '".limpiar(decrypt($_GET["codmesa"]))."'
	AND statusdetalle = 1";

    foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;

	$idproductobd = $row['idproducto'];
	$codproductobd = $row['codproducto'];
	$cantidadbd = $row['cantventa'];
	$precioventabd = $row['precioventa'];
	$ivaproductobd = $row['ivaproducto'];
	$descproductobd = $row['descproducto'];
	$tipodetallebd = $row['tipodetalle'];
	#################### SELECCIONO LOS PRODUCTOS EN DETALLES VENTAS ####################

    if(limpiar($tipodetallebd) == 1){//SI EL DETALLE ES PRODUCTO

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################
		$sql2 = "SELECT 
		existencia, 
		controlstockp 
		FROM productos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaproductobd = $row['existencia'];
	    $controlproductobd = $row['controlstockp'];
		############## VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN #################

	if($controlproductobd == 1){//SI CONTROL STOCK PRODUCTO	

		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN ###############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproductobd);
		$stmt->bindParam(3, $codsucursal);

		$existencia = number_format($existenciaproductobd+$cantidadbd);
        $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ########
		$query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);	

	    $codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$codproducto = limpiar($codproductobd);
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciaproductobd+$cantidadbd, 2, '.', '');
		$ivaproducto = limpiar($ivaproductobd);
		$descproducto = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
        $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ########
	
	}//FIN CONTROL STOCK PRODUCTO

		############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################
		$sql = "SELECT * FROM productosxingredientes WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($codproductobd),decrypt($_GET['codsucursal'])));
		$num = $stmt->rowCount();
		if($num>0) {  

			$sql = "SELECT 
	    	productosxingredientes.codproducto,
	    	productosxingredientes.codingrediente,
	    	productosxingredientes.cantracion,
	    	productosxingredientes.codsucursal,
	    	ingredientes.cantingrediente,
	    	ingredientes.precioventa,
	    	ingredientes.ivaingrediente,
	    	ingredientes.descingrediente,
	    	ingredientes.controlstocki
	    	FROM productosxingredientes 
			LEFT JOIN ingredientes ON productosxingredientes.codingrediente = ingredientes.codingrediente 
			WHERE productosxingredientes.codproducto IN ('".limpiar($codproductobd)."') 
	        AND productosxingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND ingredientes.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
			foreach ($this->dbh->query($sql) as $row)
			{ 
				$this->p[] = $row;

				$codingredientebd = $row['codingrediente'];
			    $cantracionbd = $row['cantracion'];
			    $cantingredientebd = $row['cantingrediente'];
			    $precioventaingredientebd = $row['precioventa'];
			    $ivaingredientebd = $row['ivaingrediente'];
			    $descingredientebd = $row['descingrediente'];
		        $controlingredientebd = $row['controlstocki'];

		    if($controlingredientebd == 1){// SI CONTROL STOCK INGREDIENTE

			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################
			   $update = "UPDATE ingredientes set "
			   ." cantingrediente = ? "
			   ." WHERE "
			   ." codingrediente = ? AND codsucursal = ?;
			   ";
			   $stmt = $this->dbh->prepare($update);
			   $stmt->bindParam(1, $cantidadracion);
			   $stmt->bindParam(2, $codingredientebd);	
			   $stmt->bindParam(3, $codsucursal);

			   $racion = number_format($cantracionbd*$cantidadbd, 2, '.', '');
			   $cantidadracion = number_format($cantingredientebd+$racion, 2, '.', '');
		       $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			   $stmt->execute();
			   ############## ACTUALIZO LOS DATOS DEL INGREDIENTE #################

			   ############## REGISTRAMOS LOS DATOS DE INGREDIENTES EN KARDEX ###################
			   $query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			   $stmt = $this->dbh->prepare($query);
			   $stmt->bindParam(1, $codpedido);
			   $stmt->bindParam(2, $codcliente);
			   $stmt->bindParam(3, $codingrediente);
			   $stmt->bindParam(4, $movimiento);
			   $stmt->bindParam(5, $entradas);
			   $stmt->bindParam(6, $salidas);
			   $stmt->bindParam(7, $devolucion);
			   $stmt->bindParam(8, $stockactual);
			   $stmt->bindParam(9, $ivaingrediente);
			   $stmt->bindParam(10, $descingrediente);
			   $stmt->bindParam(11, $precio);
			   $stmt->bindParam(12, $documento);
			   $stmt->bindParam(13, $fechakardex);	
			   $stmt->bindParam(14, $codsucursal);	

			   $codpedido = limpiar(decrypt($_GET["codpedido"]));
			   $codcliente = limpiar("0");
			   $codingrediente = limpiar($codingredientebd);
			   $movimiento = limpiar("DEVOLUCION");
			   $entradas = limpiar("0.00");
			   $salidas= limpiar("0");
			   $devolucion = number_format($racion, 2, '.', '');
			   $stockactual = number_format($cantidadracion, 2, '.', '');
			   $ivaingrediente = limpiar($ivaingredientebd == "NO" ? "0.00" : $ivg);
			   $descingrediente = limpiar($descingredientebd);
			   $precio = limpiar($precioventaingredientebd);
			   $documento = limpiar("DEVOLUCION DE PEDIDO");
			   $fechakardex = limpiar(date("Y-m-d"));
		       $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			   $stmt->execute();
			
			   }// FIN CONTROL STOCK INGREDIENTE
			}
		}//fin de consulta de ingredientes de productos	
		############## VERIFICO SI EL PRODUCTO TIENE INGREDIENTES RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS PRODUCTOS ######################################

	} elseif(limpiar($tipodetallebd) == 2){ // SI EL DETALLE ES COMBO

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################		

		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql2 = "SELECT existencia FROM combos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################	

		########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN ###############
		$sql = "UPDATE combos SET "
		." existencia = ? "
		." WHERE "
		." codcombo = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codcombo);	
		$stmt->bindParam(3, $codsucursal);

		$existencia = number_format($existenciacombobd+$cantidadbd, 2, '.', '');
		$codcombo = limpiar($codproductobd);
	    $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL COMBO ELIMINADO EN KARDEX ########
		$query = "INSERT INTO kardex_combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproductobd);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);		

	    $codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciacombobd+$cantidadbd, 2, '.', '');
		$ivacombo = limpiar($ivaproductobd);
		$desccombo = limpiar($descproductobd);
		$precio = limpiar($precioventabd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
	    $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL COMBO ELIMINADO EN KARDEX ########

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($codproductobd),decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
        if($num>0) {  

        	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.existencia,
	    	productos.precioventa,
	    	productos.descproducto,
	    	productos.ivaproducto,
	    	productos.controlstockp
	    	FROM combosxproductos 
        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
        	WHERE combosxproductos.codcombo IN ('".limpiar($codproductobd)."') 
        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
        	foreach ($this->dbh->query($sql) as $row)
		    { 
			   $this->p[] = $row;

			   $cantracionbd2 = $row['cantidad'];
			   $codproductobd2 = $row['codproducto'];
			   $cantproductobd2 = $row['existencia'];
			   $precioventaproductobd2 = $row['precioventa'];
			   $ivaproductobd2 = $row['ivaproducto'];
			   $descproductobd2 = $row['descproducto'];
		       $controlproductobd2 = $row['controlstockp'];

		        if($controlproductobd == 1){//SI CONTROL STOCK PRODUCTO

				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				   $update = "UPDATE productos set "
				   ." existencia = ? "
				   ." WHERE "
				   ." codproducto= ? AND codsucursal = ?;
				   ";
				   $stmt = $this->dbh->prepare($update);
				   $stmt->bindParam(1, $cantidadracion);
				   $stmt->bindParam(2, $codproducto);
	               $stmt->bindParam(3, $codsucursal);

				   $racion = number_format($cantracionbd2*$cantidadbd, 2, '.', '');
				   $cantidadracion = number_format($cantproductobd2+$racion, 2, '.', '');
		           $codproducto = limpiar($codproductobd2);
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				   $query = "INSERT INTO kardex_productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
				   $stmt = $this->dbh->prepare($query);
				   $stmt->bindParam(1, $codpedido);
				   $stmt->bindParam(2, $codcliente);
				   $stmt->bindParam(3, $codproducto);
				   $stmt->bindParam(4, $movimiento);
				   $stmt->bindParam(5, $entradas);
				   $stmt->bindParam(6, $salidas);
				   $stmt->bindParam(7, $devolucion);
				   $stmt->bindParam(8, $stockactual);
				   $stmt->bindParam(9, $ivaproducto);
				   $stmt->bindParam(10, $descproducto);
				   $stmt->bindParam(11, $precio);
				   $stmt->bindParam(12, $documento);
				   $stmt->bindParam(13, $fechakardex);
	               $stmt->bindParam(14, $codsucursal);		

				   $codpedido = limpiar(decrypt($_GET["codpedido"]));
			       $codcliente = limpiar("0");
				   $codproducto = limpiar($codproductobd2);
				   $movimiento = limpiar("DEVOLUCION");
			       $entradas = limpiar("0.00");
			       $salidas= limpiar("0");
			       $devolucion = number_format($racion, 2, '.', '');
				   $stockactual = number_format($cantproductobd2+$racion, 2, '.', '');
				   $ivaproducto = limpiar($ivaproductobd2 == "NO" ? "0.00" : $ivg);
				   $descproducto = limpiar($descproductobd2);
				   $precio = limpiar($precioventaproductobd2);
				   $documento = limpiar("DEVOLUCION DE PEDIDO");
				   $fechakardex = limpiar(date("Y-m-d"));
		           $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
				   $stmt->execute();
				   ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    
			    }//FIN CONTROL STOCK PRODUCTO
		    }
	    }//fin de consulta de ingredientes de productos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

    ############################### PROCESO PARA VERIFICAR LOS COMBOS ######################################

	} else {//SI EL DETALLE ES EXTRA

    ############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################		

		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################
		$sql2 = "SELECT 
		cantingrediente, 
		controlstocki 
		FROM ingredientes WHERE codingrediente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciaingredientebd = $row['cantingrediente'];
		$controlingredientebd = $row['controlstocki'];
		############## VERIFICO LA EXISTENCIA DEL INGREDIENTE EN ALMACEN #################

	if($controlingredientebd == 1){	// SI CONTROL STOCK INGREDIENTE

		########### ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN ###############
		$sql = "UPDATE ingredientes SET "
		." cantingrediente = ? "
		." WHERE "
		." codingrediente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproductobd);
		$stmt->bindParam(3, $codsucursal);

		$existencia = number_format($existenciaingredientebd+$cantidadbd, 2, '.', '');
        $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE INGREDIENTE EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ########
		$query = "INSERT INTO kardex_ingredientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproductobd);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaingrediente);
		$stmt->bindParam(10, $descingrediente);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $codsucursal);	

	    $codpedido = limpiar(decrypt($_GET["codpedido"]));
		$codcliente = limpiar("0");
		$movimiento = limpiar("DEVOLUCION");
		$entradas= limpiar("0.00");
		$salidas = limpiar("0.00");
		$devolucion = number_format($cantidadbd, 2, '.', '');
		$stockactual = number_format($existenciaproductobd+$cantidadbd, 2, '.', '');
		$precio = limpiar($precioventabd);
		$ivaingrediente = limpiar($ivaproductobd);
		$descingrediente = limpiar($descproductobd);
		$documento = limpiar("DEVOLUCION DE PEDIDO");
		$fechakardex = limpiar(date("Y-m-d"));
        $codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL INGREDIENTE ELIMINADO EN KARDEX ########
	
	}//FIN CONTROL STOCK INGREDIENTE
	############################### PROCESO PARA VERIFICAR LOS EXTRAS ######################################

	}// FIN DE TIPO DETALLE

    }// FIN DE FOR SESSION	

		
    #################### ELIMINAMOS EL PEDIDO ####################
	$sql = "DELETE FROM ventas WHERE codpedido = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codpedido);
	$stmt->bindParam(2,$codsucursal);

	$codpedido = limpiar(decrypt($_GET["codpedido"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
    #################### ELIMINAMOS EL PEDIDO ####################

    #################### ELIMINAMOS EN DETALLES PEDIDOS ####################
	$sql = "DELETE FROM detallepedidos WHERE codpedido = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codpedido);
	$stmt->bindParam(2,$codsucursal);

	$codpedido = limpiar(decrypt($_GET["codpedido"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
    #################### ELIMINAMOS EN DETALLES PEDIDOS ####################

    #################### ACTUALIZAMOS EL STATUS DE MESA ####################
	$sql = "UPDATE mesas set "
	." statusmesa = ? "
	." WHERE "
	." codmesa = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statusmesa);
	$stmt->bindParam(2, $codmesa);

	$statusmesa = limpiar('0');
	$codmesa = limpiar(decrypt($_GET["codmesa"]));
	$stmt->execute();
    #################### ACTUALIZAMOS EL STATUS DE MESA ####################
		
    echo "1";
    exit;
}
########################### FUNCION CANCELAR PEDIDOS ###########################

####################### FUNCION VERIFICAR PEDIDOS EN MESA PARA COBRO #######################
public function BusquedaPedidosMesa()
{ 
	self::SetNames();
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND usuarios.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"],$_SESSION["codsucursal"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<center><span class='fa fa-info-circle'></span> POR FAVOR DEBE DE REALIZAR EL ARQUEO DE CAJA ASIGNADA PARA PROCESAR VENTAS <a href='arqueos'><label> REALIZAR ARQUEO</a></label></div></center>";
		exit;

	}
	
	$sql = "SELECT
	clientes.documcliente,
	clientes.dnicliente, 
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente, 
    pedidos.idpedido, 
	pedidos.codpedido,
	pedidos.numero, 
	pedidos.codmesa,
    pedidos.referencia, 
	pedidos.codcliente, 
	pedidos.subtotalivasi, 
	pedidos.subtotalivano, 
	pedidos.iva, 
	pedidos.totaliva,
	pedidos.descontado, 
	pedidos.descuento, 
	pedidos.totaldescuento, 
	pedidos.totalpago, 
	pedidos.totalpago2,
    pedidos.descripciones,
    pedidos.tipopedido,
	pedidos.statuspedido,
	pedidos.repartidor,
	pedidos.fechapedido,
	pedidos.fechaentrega,
	pedidos.codigo,
	pedidos.codsucursal,
    salas.nomsala, 
    mesas.codmesa, 
    mesas.nommesa,
    mesas.statusmesa, 
    usuarios.nombres,
	SUM(detallepedidos.cantventa) AS articulos, 
	GROUP_CONCAT(detallepedidos.cantventa, ' | ', substr(detallepedidos.producto, 1,21) , ' | ', ROUND(detallepedidos.valorneto, 2) SEPARATOR '<br>') AS detalles  
    FROM mesas INNER JOIN pedidos ON mesas.codmesa = pedidos.codmesa
	LEFT JOIN detallepedidos ON detallepedidos.codpedido = pedidos.codpedido
    LEFT JOIN salas ON salas.codsala = mesas.codsala  
    LEFT JOIN clientes ON pedidos.codcliente = clientes.codcliente 
    LEFT JOIN documentos ON clientes.documcliente = documentos.coddocumento 
    LEFT JOIN usuarios ON pedidos.codigo = usuarios.codigo 
    WHERE pedidos.codmesa = ? 
    AND pedidos.codsucursal = ? 
    AND pedidos.statuspedido = 1
    AND detallepedidos.statusdetalle = 1
    GROUP BY detallepedidos.codpedido";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmesa"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo '<center class="alert-link" >SELECCIONE MESA PARA CONTINUAR <i class="font-20 fa fa-arrow-right"></i></center>';
    echo '<h6 class="text-dark text-center">Para ingresar o visualizar pedidos</h6>';
    exit;

	} 
	else 
	{
	    while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
####################### FUNCION VERIFICAR PEDIDOS EN MESA PARA COBRO #######################

############################ FUNCION COBRAR MESA ##############################
public function CobrarMesa()
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA ANTERIOR #######################
	/*$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? 
	AND DATE_FORMAT(fechaapertura,'%Y-%m-%d') != '".date('Y-m-d')."'
	AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "1";
		exit;
	}*/
	####################### VERIFICO ARQUEO DE CAJA ANTERIOR #######################

	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "2";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueo = $row['codarqueo'];
		$codcaja = $row['codcaja'];
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################

    if(empty($_POST["tipodocumento"]) or empty($_POST["tipopago"]))
	{
		echo "3";
		exit;
	}
	elseif(empty($_POST["txtTotalPago"]) && empty($_POST["txtImporte"]))
	{
		echo "4";
		exit;
			
	}
	elseif(isset($_POST['formapago2']) && $_POST["formapago2"] != ""){

		
	}
	else if(limpiar($_POST["tipodocumento"]) == "FACTURA" && limpiar($_POST["nrodocumento"]) == "0"){ 

        echo "5";
		exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
    clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
    clientes.girocliente,
    clientes.emailcliente, 
    clientes.tipocliente,
    clientes.limitecredito,
    clientes.id_provincia,
    clientes.id_departamento,
    clientes.direccliente,
    provincias.provincia,
    departamentos.departamento,
    ROUND(SUM(if(pag.montocredito!='0',pag.montocredito,'0.00')), 2) montoactual,
    ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 2) creditodisponible
    FROM clientes 
    LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes
       WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.dnicliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente = ($row['codcliente'] == "" ? "0" : $row['codcliente']);
    $tipocliente = ($row['tipocliente'] == "" ? "0" : $row['tipocliente']);
    $dnicliente = ($row['dnicliente'] == "" ? "0" : $row['dnicliente']);
    $nomcliente = ($row['nomcliente'] == "" ? "0" : $row['nomcliente']);
    $girocliente = ($row['girocliente'] == "" ? "0" : $row['girocliente']);
    $emailcliente = $row['emailcliente'];
    $provincia = ($row['id_provincia'] == "" || $row['id_provincia'] == "0" ? "0" : $row['provincia']);
    $departamento = ($row['id_departamento'] == "" || $row['id_departamento'] == "0" ? "0" : $row['departamento']);
    $direccliente = ($row['direccliente'] == "" ? "0" : $row['direccliente']);
    $limitecredito = $row['limitecredito'];
    $montoactual = $row['montoactual'];
    $creditodisponible = $row['creditodisponible'];
    $medioabono = (empty($_POST["medioabono"]) ? "" : $_POST["medioabono"]);
    $montoabono = (empty($_POST["montoabono"]) ? "0.00" : $_POST["montoabono"]);
    $total = number_format($_POST["txtImporte"]-$montoabono, 2, '.', '');
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################
	
	/*if(limpiar($_POST["tipodocumento"] == "FACTURA" && $tipocliente == "NATURAL")){ 

    	    echo "6";
	        exit;

    } else */if ($_POST["tipopago"] == "CREDITO") {

		$fechaactual = date("Y-m-d");
		$fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));

		if ($_POST["codcliente"] == '0') { 

	        echo "7";
	        exit;

        } else if (strtotime($fechavence) < strtotime($fechaactual)) {

			echo "8";
			exit;

		} else if ($montoabono != "0.00" && $medioabono == "") {
  
           echo "9";
	       exit;

		} else if ($limitecredito != "0.00" && $total > $creditodisponible) {
  
           echo "10";
	       exit;

		} else if($_POST["montoabono"] >= $_POST["txtTotalPago"]) { 
	
		   echo "11";
		   exit;

	    }
	}
	################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ####################### OBTENGO DATOS DE SUCURSAL #######################
	$sql = " SELECT 
	codsucursal, 
	cuitsucursal,
	nomsucursal, 
	codgiro, 
	girosucursal, 
	nroactividadsucursal,
	inicioticket,
	inicioboleta,
	iniciofactura 
	FROM sucursales 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$rucemisor = $row['cuitsucursal'];
    $razonsocial = $row['nomsucursal'];
    $actecoemisor = $row['codgiro'];
    $giroemisor = $row['girosucursal'];
    $nroactividad = $row['nroactividadsucursal'];
	$inicioticket = $row['inicioticket'];
	$inicioboleta = $row['inicioboleta'];
	$iniciofactura = $row['iniciofactura'];
	####################### OBTENGO DATOS DE SUCURSAL #######################

	##################### AGREGAMOS EL NUMERO DE VENTA #######################
	$sql = "SELECT 
	codventa 
	FROM ventas ORDER BY idventa 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$venta=$row["codventa"];
	}
	$codventa = (empty($venta) ? "1" : $venta + 1);
	##################### AGREGAMOS EL NUMERO DE VENTA #######################

	################ CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ################
	$sql = "SELECT 
	codfactura 
	FROM ventas 
	WHERE tipodocumento = '".limpiar($_POST['tipodocumento'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$factura=$row["codfactura"];

	}
	
	if($_POST['tipodocumento']=="TICKET") {

        $codfactura = (empty($factura) ? $inicioticket : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="BOLETA") {

        $codfactura = (empty($factura) ? $inicioboleta : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="FACTURA") {

		$codfactura = (empty($factura) ? $iniciofactura : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());
	}
    ################# CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ###############

    ################### OBTENGO DATOS DE PEDIDO ######################
    $sql = "SELECT * FROM pedidos WHERE codpedido = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST['codpedido']),decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    ################### OBTENGO DATOS DE PEDIDO ######################

	$fecha = date("Y-m-d H:i:s");

	################################# REGISTRO DATOS DE VENTA #################################
    $query = "INSERT INTO ventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codmesa);
	$stmt->bindParam(4, $tipodocumento);
	$stmt->bindParam(5, $codcaja);
	$stmt->bindParam(6, $codfactura);
	$stmt->bindParam(7, $codserie);
	$stmt->bindParam(8, $codautorizacion);
	$stmt->bindParam(9, $codcliente);
	$stmt->bindParam(10, $subtotalivasi);
	$stmt->bindParam(11, $subtotalivano);
	$stmt->bindParam(12, $iva);
	$stmt->bindParam(13, $totaliva);
	$stmt->bindParam(14, $descontado);
	$stmt->bindParam(15, $descuento);
	$stmt->bindParam(16, $totaldescuento);
	$stmt->bindParam(17, $totalpago);
	$stmt->bindParam(18, $totalpago2);
	$stmt->bindParam(19, $creditopagado);
	$stmt->bindParam(20, $montodelivery);
	$stmt->bindParam(21, $tipopago);
	$stmt->bindParam(22, $formapago);
	$stmt->bindParam(23, $montopagado);
	$stmt->bindParam(24, $formapago2);
	$stmt->bindParam(25, $montopagado2);
	$stmt->bindParam(26, $formapropina);
	$stmt->bindParam(27, $montopropina);
	$stmt->bindParam(28, $montodevuelto);
	$stmt->bindParam(29, $fechavencecredito);
	$stmt->bindParam(30, $fechapagado);
	$stmt->bindParam(31, $statusventa);
	$stmt->bindParam(32, $fechaventa);
	$stmt->bindParam(33, $delivery);
	$stmt->bindParam(34, $repartidor);
	$stmt->bindParam(35, $entregado);
	$stmt->bindParam(36, $descripciones);
	$stmt->bindParam(37, $observaciones);
	$stmt->bindParam(38, $fechaentrega);
	$stmt->bindParam(39, $statuspedido);
	$stmt->bindParam(40, $tipoventa);
	$stmt->bindParam(41, $codigo);
	$stmt->bindParam(42, $mesero);
	$stmt->bindParam(43, $docelectronico);
	$stmt->bindParam(44, $codsucursal);

	$codpedido = limpiar("0");
	$codmesa = limpiar(decrypt($_POST["codmesa"]));
	$tipodocumento = limpiar($_POST["tipodocumento"]);
	$subtotalivasi = limpiar($row["subtotalivasi"]);
	$subtotalivano = limpiar($row["subtotalivano"]);
	$iva = limpiar($row["iva"]);
	$totaliva = limpiar($row["totaliva"]);
	$descontado = limpiar($row["descontado"]);
	$descuento = limpiar($row["descuento"]);
	$totaldescuento = limpiar($row["totaldescuento"]);
	$totalpago = limpiar($row["totalpago"]);
	$totalpago2 = limpiar($row["totalpago2"]);
    $creditopagado = limpiar(isset($_POST['montoabono']) ? $_POST["montoabono"] : "0.00");
	$montodelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");

	$tipopago = limpiar($_POST["tipopago"]);
	$formapago = limpiar($_POST["tipopago"]=="CONTADO" ? $_POST["formapago"] : "CREDITO");
	$montopagado = limpiar(isset($_POST['montopagado']) ? $_POST["montopagado"] : "0.00");
	$formapago2 = limpiar(isset($_POST['montopagado2']) ? $_POST["formapago2"] : "0");
	$montopagado2 = limpiar(isset($_POST['montopagado2']) ? $_POST["montopagado2"] : "0.00");
	$formapropina = limpiar(isset($_POST['formapropina']) ? $_POST["formapropina"] : "0");
	$montopropina = limpiar(isset($_POST['montopropina']) ? $_POST["montopropina"] : "0.00");
	$montodevuelto = limpiar(isset($_POST['montodevuelto']) ? $_POST["montodevuelto"] : "0.00");

    $fechavencecredito = limpiar($_POST["tipopago"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
    $fechapagado = limpiar("0000-00-00");
    $statusventa = limpiar($_POST["tipopago"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
    $fechaventa = limpiar($fecha);
	$delivery = limpiar("0");
	$repartidor = limpiar("0");
	$entregado = limpiar("0");
	$descripciones = limpiar("");
	$observaciones = limpiar($_POST['observaciones']=="" ? "" : $_POST['observaciones']);
	$fechaentrega = limpiar("0000-00-00 00:00:00");
	$statuspedido = limpiar("0"); 
	$tipoventa = limpiar("1");
	$codigo = limpiar($_SESSION["codigo"]);
	$mesero = limpiar(decrypt($_POST["mesero"]));
	$docelectronico = limpiar("0");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################# REGISTRO DATOS DE VENTA #################################

	$this->dbh->beginTransaction();
	################### OBTENGO DETALLES DE PEDIDOS ######################
	$sql = "SELECT
	detallepedidos.coddetallepedido,
	detallepedidos.codpedido,
	detallepedidos.idproducto,
	detallepedidos.codproducto,
	detallepedidos.producto,
	detallepedidos.codcategoria,
	detallepedidos.preciocompra,
	detallepedidos.precioventa,
	detallepedidos.ivaproducto,
	detallepedidos.descproducto,
	detallepedidos.valortotal, 
	detallepedidos.totaldescuentov,
	detallepedidos.subtotalimpuestos,
	detallepedidos.valorneto,
	detallepedidos.valorneto2,
	detallepedidos.observacionespedido,
	detallepedidos.tipodetalle,
	SUM(cantventa) AS cantidad
	FROM detallepedidos 
	WHERE codpedido = '".limpiar(decrypt($_POST['codpedido']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'
	GROUP BY codpedido, codproducto";
    foreach ($this->dbh->query($sql) as $row2)
	{
		################### REGISTRO DETALLES DE VENTA ######################
		$query = "INSERT INTO detalleventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	    $stmt = $this->dbh->prepare($query);
	    $stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $codcategoria);
	    $stmt->bindParam(6, $cantidad);
	    $stmt->bindParam(7, $preciocompra);
	    $stmt->bindParam(8, $precioventa);
	    $stmt->bindParam(9, $ivaproducto);
	    $stmt->bindParam(10, $descproducto);
	    $stmt->bindParam(11, $valortotal);
	    $stmt->bindParam(12, $totaldescuentov);
	    $stmt->bindParam(13, $subtotalimpuestos);
	    $stmt->bindParam(14, $valorneto);
	    $stmt->bindParam(15, $valorneto2);
	    $stmt->bindParam(16, $detallesobservaciones);
	    $stmt->bindParam(17, $tipo);
	    $stmt->bindParam(18, $codsucursal);

		$idproducto = limpiar($row2['idproducto']);
		$codproducto = limpiar($row2['codproducto']);
		$producto = limpiar($row2['producto']);
		$codcategoria = limpiar($row2['codcategoria']);
		$cantidad = number_format($row2['cantidad'], 2, '.', '');
		$preciocompra = number_format($row2['preciocompra'], 2, '.', '');
		$precioventa = number_format($row2['precioventa'], 2, '.', '');
		$ivaproducto = number_format($row2['ivaproducto'], 2, '.', '');
		$descproducto = number_format($row2['descproducto'], 2, '.', '');
		$valortotal = number_format($row2['valortotal'], 2, '.', '');
		$totaldescuentov = number_format($row2['valortotal'], 2, '.', '');
		$subtotalimpuestos = number_format($row2['subtotalimpuestos'], 2, '.', '');
		$valorneto = number_format($row2['valorneto'], 2, '.', '');
		$valorneto2 = number_format($row2['valorneto2'], 2, '.', '');
		$detallesobservaciones = limpiar($row2['observacionespedido']);
		$tipo = limpiar($row2['tipodetalle']);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### REGISTRO DETALLES DE VENTA ######################

	}// FIN DE FOR SESSION
	################### OBTENGO DETALLES DE PEDIDOS ######################
    $this->dbh->commit();

	##################### ACTUALIZO PEDIDO ####################
	$sql = " UPDATE pedidos set "
    ." statuspedido = ? "
    ." WHERE "
	." codpedido = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statuspedido);
	$stmt->bindParam(2, $codpedido);
	$stmt->bindParam(3, $codsucursal);

	$statuspedido = limpiar("0");
	$codpedido = limpiar(decrypt($_POST["codpedido"]));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### ACTUALIZO PEDIDO ####################

	##################### ACTUALIZO DETALLES PEDIDO ####################
	$sql = " UPDATE detallepedidos set "
    ." statusdetalle = ? "
    ." WHERE "
	." codpedido = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statusdetalle);
	$stmt->bindParam(2, $codpedido);
	$stmt->bindParam(3, $codsucursal);

	$statusdetalle = limpiar("0");
	$codpedido = limpiar(decrypt($_POST["codpedido"]));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	##################### ACTUALIZO DETALLES PEDIDO ####################

	#################### ACTUALIZO EL STATUS DE MESA ####################
	$sql = "UPDATE mesas set "
	." statusmesa = ? "
	." WHERE "
	." codmesa = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $statusmesa);
	$stmt->bindParam(2, $codmesa);

	$statusmesa = limpiar('0');
	$codmesa = limpiar(decrypt($_POST["codmesa"]));
	$stmt->execute();
    #################### ACTUALIZO EL STATUS DE MESA ####################

	################## OBTENGO LOS DATOS EN CAJA ##################
	$sql = "SELECT 
	efectivo, 
	cheque, 
	tcredito, 
	tdebito, 
	tprepago, 
	transferencia, 
	electronico,
	cupon, 
	otros,
	creditos,
	propinasefectivo,
	propinasotros,
	nroticket,
	nroboleta,
	nrofactura
	FROM arqueocaja WHERE codarqueo = '".limpiar($codarqueo)."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$efectivo = ($row['efectivo']== "" ? "0.00" : $row['efectivo']);
	$cheque = ($row['cheque']== "" ? "0.00" : $row['cheque']);
	$tcredito = ($row['tcredito']== "" ? "0.00" : $row['tcredito']);
	$tdebito = ($row['tdebito']== "" ? "0.00" : $row['tdebito']);
	$tprepago = ($row['tprepago']== "" ? "0.00" : $row['tprepago']);
	$transferencia = ($row['transferencia']== "" ? "0.00" : $row['transferencia']);
	$electronico = ($row['electronico']== "" ? "0.00" : $row['electronico']);
	$cupon = ($row['cupon']== "" ? "0.00" : $row['cupon']);
	$otros = ($row['otros']== "" ? "0.00" : $row['otros']);
	$credito = ($row['creditos']== "" ? "0.00" : $row['creditos']);
	$propinasefectivo = ($row['propinasefectivo']== "" ? "0.00" : $row['propinasefectivo']);
	$propinasotros = ($row['propinasotros']== "" ? "0.00" : $row['propinasotros']);
	$nroticket = $row['nroticket'];
	$nroboleta = $row['nroboleta'];
	$nrofactura = $row['nrofactura'];
	################## OBTENGO LOS DATOS EN CAJA ##################

    ############## AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ###############
	if (limpiar($_POST["tipopago"]=="CONTADO")){

	if(isset($_POST['formapago2']) && $_POST['formapago2']!=""){

    ################ AGREGO EL MONTO EN CAJA ################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);

	if($_POST["formapago"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtEfectivo = $efectivo;	
	}

	if($_POST["formapago"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCheque = $cheque;	
	}

	if($_POST["formapago"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTcredito = $tcredito;	
	}

	if($_POST["formapago"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTdebito = $tdebito;	
	}

	if($_POST["formapago"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTprepago = $tprepago;	
	}

	if($_POST["formapago"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTransferencia = $transferencia;	
	}

	if($_POST["formapago"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtElectronico = $electronico;	
	}

	if($_POST["formapago"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCupon = $cupon;	
	}

	if($_POST["formapago"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtOtros = $otros;	
	}
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	################ AGREGO EL MONTO EN CAJA ################

	} else { 

	################ AGREGO EL MONTO EN CAJA ################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);

	$txtEfectivo = limpiar($_POST["formapago"] == "EFECTIVO" ? number_format($efectivo+$_POST["txtTotalPago"], 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["formapago"] == "CHEQUE" ? number_format($cheque+$_POST["txtTotalPago"], 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["formapago"] == "TARJETA DE CREDITO" ? number_format($tcredito+$_POST["txtTotalPago"], 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["formapago"] == "TARJETA DE DEBITO" ? number_format($tdebito+$_POST["txtTotalPago"], 2, '.', '') : $tdebito);
	$txtTprepago = limpiar($_POST["formapago"] == "TARJETA PREPAGO" ? number_format($tprepago+$_POST["txtTotalPago"], 2, '.', '') : $tprepago);
	$txtTransferencia = limpiar($_POST["formapago"] == "TRANSFERENCIA" ? number_format($transferencia+$_POST["txtTotalPago"], 2, '.', '') : $transferencia);
	$txtElectronico = limpiar($_POST["formapago"] == "DINERO ELECTRONICO" ? number_format($electronico+$_POST["txtTotalPago"], 2, '.', '') : $electronico);
	$txtCupon = limpiar($_POST["formapago"] == "CUPON" ? number_format($cupon+$_POST["txtTotalPago"], 2, '.', '') : $cupon);
	$txtOtros = limpiar($_POST["formapago"] == "OTROS" ? number_format($otros+$_POST["txtTotalPago"], 2, '.', '') : $otros);
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	################ AGREGO EL MONTO EN CAJA ################
		}
	}
    ################ AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ##############


    ######### AGREGAMOS EL INGRESO Y ABONOS DE VENTAS A CREDITOS A CAJA ############
	if (limpiar($_POST["tipopago"]=="CREDITO")) {

	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." creditos = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtCredito);
	$stmt->bindParam(11, $NumTicket);
	$stmt->bindParam(12, $NumBoleta);
	$stmt->bindParam(13, $NumFactura);
	$stmt->bindParam(14, $codarqueo);

	$txtEfectivo = limpiar($_POST["medioabono"] == "EFECTIVO" ? number_format($efectivo+$_POST["montoabono"], 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["medioabono"] == "CHEQUE" ? number_format($cheque+$_POST["montoabono"], 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["medioabono"] == "TARJETA DE CREDITO" ? number_format($tcredito+$_POST["montoabono"], 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["medioabono"] == "TARJETA DE DEBITO" ? number_format($tdebito+$_POST["montoabono"], 2, '.', '') : $tdebito);
	$txtTprepago = limpiar($_POST["medioabono"] == "TARJETA PREPAGO" ? number_format($tprepago+$_POST["montoabono"], 2, '.', '') : $tprepago);
	$txtTransferencia = limpiar($_POST["medioabono"] == "TRANSFERENCIA" ? number_format($transferencia+$_POST["montoabono"], 2, '.', '') : $transferencia);
	$txtElectronico = limpiar($_POST["medioabono"] == "DINERO ELECTRONICO" ? number_format($electronico+$_POST["montoabono"], 2, '.', '') : $electronico);
	$txtCupon = limpiar($_POST["medioabono"] == "CUPON" ? number_format($cupon+$_POST["montoabono"], 2, '.', '') : $cupon);
	$txtOtros = limpiar($_POST["medioabono"] == "OTROS" ? number_format($otros+$_POST["montoabono"], 2, '.', '') : $otros);
	$txtCredito = number_format($credito+($_POST["txtTotalPago"]-$_POST["montoabono"]), 2, '.', '');

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	################ AGREGO EL MONTO #1 EN CAJA ################

	$sql = "SELECT codcliente FROM creditosxclientes WHERE codcliente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($codcliente,decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO creditosxclientes values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $montocredito);
		$stmt->bindParam(3, $codsucursal);

		$montocredito = number_format($_POST["txtTotalPago"]-$_POST["montoabono"], 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	} else { 

		$sql = "UPDATE creditosxclientes set"
		." montocredito = ? "
		." WHERE "
		." codcliente = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $montocredito);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codsucursal);

		$montocredito = number_format($montoactual+($_POST["txtTotalPago"]-$_POST["montoabono"]), 2, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	}

	   if (limpiar($_POST["montoabono"]!="0.00" && $_POST["montoabono"]!="0" && $_POST["montoabono"]!="")) {

		$query = "INSERT INTO abonoscreditos values (null, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcaja);
		$stmt->bindParam(2, $codventa);
		$stmt->bindParam(3, $codcliente);
		$stmt->bindParam(4, $montoabono);
		$stmt->bindParam(5, $formaabono);
		$stmt->bindParam(6, $fechaabono);
	    $stmt->bindParam(7, $codsucursal);

		$montoabono = limpiar($_POST["montoabono"]);
		$formaabono = limpiar($_POST["medioabono"]);
		$fechaabono = limpiar(date("Y-m-d H:i:s"));
	    $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	
	   }
	} 
    ########## AGREGAMOS EL INGRESO Y ABONOS DE VENTAS A CREDITOS A CAJA ########

    echo "<span class='fa fa-check-square-o'></span> LA MESA HA SIDO COBRADA EN CAJA EXITOSAMENTE <a href='reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR ".$tipodocumento."</strong></font color></a></div>";

    echo "<script>window.open('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '_blank');</script>";
	exit;
}
############################ FUNCION COBRAR MESA ############################

############################ FUNCION COBRAR CUENTA SEPARADA ##############################
public function CobrarCuentaSeparada()
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA ANTERIOR #######################
	/*$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? 
	AND DATE_FORMAT(fechaapertura,'%Y-%m-%d') != '".date('Y-m-d')."'
	AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "1";
		exit;
	}*/
	####################### VERIFICO ARQUEO DE CAJA ANTERIOR #######################

	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "2";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueo = $row['codarqueo'];
		$codcaja = $row['codcaja'];
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################

	################ VERIFICO QUE CANTIDAD PAGADA NO SEA MAYOR QUE VENDIDA ################
	$this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['pagado']);$i++){
        if (!empty($_POST['pagado'][$i])) {

        	if($_POST['pagado'][$i] > $_POST['cantidad'][$i]){

        		echo "3";
        		exit;
        	}

        }//fin de if
	}//fin de for
    $this->dbh->commit();
    ################ VERIFICO QUE CANTIDAD PAGADA NO SEA MAYOR QUE VENDIDA ################

    if(empty($_POST["tipodocumento"]) or empty($_POST["tipopago"]))
	{
		echo "4";
		exit;
	}
	elseif(empty($_POST["txtTotalPago"]) && empty($_POST["txtImporte"]))
	{
		echo "5";
		exit;
			
	}
	elseif(isset($_POST['formapago2']) && $_POST["formapago2"] != ""){

		
	}
	else if(limpiar($_POST["tipodocumento"]) == "FACTURA" && limpiar($_POST["nrodocumento"]) == "0"){ 

        echo "6";
		exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
    clientes.dnicliente,
    CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
    clientes.girocliente,
    clientes.emailcliente, 
    clientes.tipocliente,
    clientes.limitecredito,
    clientes.id_provincia,
    clientes.id_departamento,
    clientes.direccliente,
    provincias.provincia,
    departamentos.departamento,
    ROUND(SUM(if(pag.montocredito!='0',pag.montocredito,'0.00')), 2) montoactual,
    ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 2) creditodisponible
    FROM clientes 
    LEFT JOIN provincias ON clientes.id_provincia = provincias.id_provincia 
	LEFT JOIN departamentos ON clientes.id_departamento = departamentos.id_departamento
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes
       WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.dnicliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente = ($row['codcliente'] == "" ? "0" : $row['codcliente']);
    $tipocliente = ($row['tipocliente'] == "" ? "0" : $row['tipocliente']);
    $dnicliente = ($row['dnicliente'] == "" ? "0" : $row['dnicliente']);
    $nomcliente = ($row['nomcliente'] == "" ? "0" : $row['nomcliente']);
    $girocliente = ($row['girocliente'] == "" ? "0" : $row['girocliente']);
    $emailcliente = $row['emailcliente'];
    $provincia = ($row['id_provincia'] == "" || $row['id_provincia'] == "0" ? "0" : $row['provincia']);
    $departamento = ($row['id_departamento'] == "" || $row['id_departamento'] == "0" ? "0" : $row['departamento']);
    $direccliente = ($row['direccliente'] == "" ? "0" : $row['direccliente']);
    $limitecredito = $row['limitecredito'];
    $montoactual = $row['montoactual'];
    $creditodisponible = $row['creditodisponible'];
    $medioabono = (empty($_POST["medioabono"]) ? "" : $_POST["medioabono"]);
    $montoabono = (empty($_POST["montoabono"]) ? "0.00" : $_POST["montoabono"]);
    $total = number_format($_POST["txtImporte"]-$montoabono, 2, '.', '');
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################
	
	/*if(limpiar($_POST["tipodocumento"] == "FACTURA" && $tipocliente == "NATURAL")){ 

    	    echo "7";
	        exit;

    } else */if ($_POST["tipopago"] == "CREDITO") {

		$fechaactual = date("Y-m-d");
		$fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));

		if ($_POST["codcliente"] == '0') { 

	        echo "8";
	        exit;

        } else if (strtotime($fechavence) < strtotime($fechaactual)) {

			echo "9";
			exit;

		} else if ($montoabono != "0.00" && $medioabono == "") {
  
           echo "10";
	       exit;

		} else if ($limitecredito != "0.00" && $total > $creditodisponible) {
  
           echo "11";
	       exit;

		} else if($_POST["montoabono"] >= $_POST["txtTotalPago"]) { 
	
		   echo "12";
		   exit;

	    }
	}
	################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ####################### OBTENGO DATOS DE SUCURSAL #######################
	$sql = " SELECT 
	codsucursal, 
	cuitsucursal,
	nomsucursal, 
	codgiro, 
	girosucursal, 
	nroactividadsucursal,
	inicioticket,
	inicioboleta,
	iniciofactura 
	FROM sucursales 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$rucemisor = $row['cuitsucursal'];
    $razonsocial = $row['nomsucursal'];
    $actecoemisor = $row['codgiro'];
    $giroemisor = $row['girosucursal'];
    $nroactividad = $row['nroactividadsucursal'];
	$inicioticket = $row['inicioticket'];
	$inicioboleta = $row['inicioboleta'];
	$iniciofactura = $row['iniciofactura'];
	####################### OBTENGO DATOS DE SUCURSAL #######################

	##################### AGREGAMOS EL NUMERO DE VENTA #######################
	$sql = "SELECT 
	codventa 
	FROM ventas ORDER BY idventa 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$venta=$row["codventa"];
	}
	$codventa = (empty($venta) ? "1" : $venta + 1);
	##################### AGREGAMOS EL NUMERO DE VENTA #######################

	################ CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ################
	$sql = "SELECT 
	codfactura 
	FROM ventas 
	WHERE tipodocumento = '".limpiar($_POST['tipodocumento'])."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$factura=$row["codfactura"];

	}
	
	if($_POST['tipodocumento']=="TICKET") {

        $codfactura = (empty($factura) ? $inicioticket : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="BOLETA") {

        $codfactura = (empty($factura) ? $inicioboleta : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($_POST['tipodocumento']=="FACTURA") {

		$codfactura = (empty($factura) ? $iniciofactura : $factura + 1);
		$codserie = limpiar(GenerateRandomStringg());
		$codautorizacion = limpiar(GenerateRandomStringg());
	}
    ################# CREO LOS CODIGO VENTA-SERIE-AUTORIZACION ###############

	$fecha = date("Y-m-d H:i:s");

	################################# REGISTRO DATOS DE VENTA #################################
    $query = "INSERT INTO ventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $codventa);
	$stmt->bindParam(3, $codmesa);
	$stmt->bindParam(4, $tipodocumento);
	$stmt->bindParam(5, $codcaja);
	$stmt->bindParam(6, $codfactura);
	$stmt->bindParam(7, $codserie);
	$stmt->bindParam(8, $codautorizacion);
	$stmt->bindParam(9, $codcliente);
	$stmt->bindParam(10, $subtotalivasi);
	$stmt->bindParam(11, $subtotalivano);
	$stmt->bindParam(12, $iva);
	$stmt->bindParam(13, $totaliva);
	$stmt->bindParam(14, $descontado);
	$stmt->bindParam(15, $descuento);
	$stmt->bindParam(16, $totaldescuento);
	$stmt->bindParam(17, $totalpago);
	$stmt->bindParam(18, $totalpago2);
	$stmt->bindParam(19, $creditopagado);
	$stmt->bindParam(20, $montodelivery);
	$stmt->bindParam(21, $tipopago);
	$stmt->bindParam(22, $formapago);
	$stmt->bindParam(23, $montopagado);
	$stmt->bindParam(24, $formapago2);
	$stmt->bindParam(25, $montopagado2);
	$stmt->bindParam(26, $formapropina);
	$stmt->bindParam(27, $montopropina);
	$stmt->bindParam(28, $montodevuelto);
	$stmt->bindParam(29, $fechavencecredito);
	$stmt->bindParam(30, $fechapagado);
	$stmt->bindParam(31, $statusventa);
	$stmt->bindParam(32, $fechaventa);
	$stmt->bindParam(33, $delivery);
	$stmt->bindParam(34, $repartidor);
	$stmt->bindParam(35, $entregado);
	$stmt->bindParam(36, $descripciones);
	$stmt->bindParam(37, $observaciones);
	$stmt->bindParam(38, $fechaentrega);
	$stmt->bindParam(39, $statuspedido);
	$stmt->bindParam(40, $tipoventa);
	$stmt->bindParam(41, $codigo);
	$stmt->bindParam(42, $mesero);
	$stmt->bindParam(43, $docelectronico);
	$stmt->bindParam(44, $codsucursal);

	$codpedido = limpiar("0");
	$codmesa = limpiar(decrypt($_POST["codmesa"]));
	$tipodocumento = limpiar($_POST["tipodocumento"]);
	$subtotalivasi = limpiar($_POST["subtotalivasi"]);
	$subtotalivano = limpiar($_POST["subtotalivano"]);
	$iva = limpiar($_POST["iva"]);
	$totaliva = limpiar($_POST["txtIva"]);
	$descontado = limpiar($_POST["txtdescontado"]);
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago = limpiar($_POST["txtTotalPago"]);
	$totalpago2 = limpiar($_POST["txtTotalCompra"]);

    $creditopagado = limpiar(isset($_POST['montoabono']) ? $_POST["montoabono"] : "0.00");
	$montodelivery = limpiar(isset($_POST['montodelivery']) ? $_POST["montodelivery"] : "0.00");

	$tipopago = limpiar($_POST["tipopago"]);
	$formapago = limpiar($_POST["tipopago"]=="CONTADO" ? $_POST["formapago"] : "CREDITO");
	$montopagado = limpiar(isset($_POST['montopagado']) ? $_POST["montopagado"] : "0.00");
	$formapago2 = limpiar(isset($_POST['montopagado2']) ? $_POST["formapago2"] : "0");
	$montopagado2 = limpiar(isset($_POST['montopagado2']) ? $_POST["montopagado2"] : "0.00");
	$formapropina = limpiar(isset($_POST['formapropina']) ? $_POST["formapropina"] : "0");
	$montopropina = limpiar(isset($_POST['montopropina']) ? $_POST["montopropina"] : "0.00");
	$montodevuelto = limpiar(isset($_POST['montodevuelto']) ? $_POST["montodevuelto"] : "0.00");

    $fechavencecredito = limpiar($_POST["tipopago"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
    $fechapagado = limpiar("0000-00-00");
    $statusventa = limpiar($_POST["tipopago"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
    $fechaventa = limpiar($fecha);
	$delivery = limpiar("0");
	$repartidor = limpiar("0");
	$entregado = limpiar("0");
	$descripciones = limpiar("");
	$observaciones = limpiar($_POST['observaciones']=="" ? "" : $_POST['observaciones']);
	$fechaentrega = limpiar("0000-00-00 00:00:00");
	$statuspedido = limpiar("0"); 
	$tipoventa = limpiar("1");
	$codigo = limpiar($_SESSION["codigo"]);
	$mesero = limpiar(decrypt($_POST["mesero"]));
	$docelectronico = limpiar("0");
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################# REGISTRO DATOS DE VENTA #################################

	$this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['pagado']);$i++){
        //if (!empty($_POST['pagado'][$i]) && $_POST['pagado'][$i] != "" && $_POST['pagado'][$i] != "0" && $_POST['pagado'][$i] != "0.00") {
        if (!empty($_POST['pagado'][$i])) {

		################### REGISTRO DETALLES DE VENTA ######################
		$query = "INSERT INTO detalleventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	    $stmt = $this->dbh->prepare($query);
	    $stmt->bindParam(1, $codventa);
		$stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $codcategoria);
	    $stmt->bindParam(6, $cantidad);
	    $stmt->bindParam(7, $preciocompra);
	    $stmt->bindParam(8, $precioventa);
	    $stmt->bindParam(9, $ivaproducto);
	    $stmt->bindParam(10, $descproducto);
	    $stmt->bindParam(11, $valortotal);
	    $stmt->bindParam(12, $totaldescuentov);
	    $stmt->bindParam(13, $subtotalimpuestos);
	    $stmt->bindParam(14, $valorneto);
	    $stmt->bindParam(15, $valorneto2);
	    $stmt->bindParam(16, $detallesobservaciones);
	    $stmt->bindParam(17, $tipo);
	    $stmt->bindParam(18, $codsucursal);

		$idproducto = limpiar($_POST['idproducto'][$i]);
		$codproducto = limpiar($_POST['codproducto'][$i]);
		$producto = limpiar($_POST['producto'][$i]);
		$codcategoria = limpiar($_POST['codcategoria'][$i]);
		$cantidad = number_format($_POST['pagado'][$i], 2, '.', '');
		$preciocompra = number_format($_POST['preciocompra'][$i], 2, '.', '');
		$precioventa = number_format($_POST['precioventa'][$i], 2, '.', '');
		$precioconiva = number_format($_POST['precioconiva'][$i], 2, '.', '');
		$ivaproducto = limpiar($_POST['ivaproducto'][$i]);
		$descproducto = number_format($_POST['descproducto'][$i], 2, '.', '');
		$valortotal = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuentov = number_format($_POST['totaldescuentov'][$i], 2, '.', '');
		$subtotalimpuestos = number_format($_POST['subtotalimpuestos'][$i], 2, '.', '');
		$valorneto = number_format($_POST['valorneto'][$i], 2, '.', '');
		$valorneto2 = number_format($_POST['valorneto2'][$i], 2, '.', '');
		$detallesobservaciones = limpiar($_POST["observacionespedido"][$i]);
		$tipo = limpiar($_POST["tipodetalle"][$i]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### REGISTRO DETALLES DE VENTA ######################

		################### VERIFICO DETALLES DE PEDIDOS ######################
		$cantidad_vendida = number_format($_POST['cantidad'][$i], 2, '.', '');
		$cantidad_pagada = number_format($_POST['pagado'][$i], 2, '.', '');

		if($cantidad_vendida == $cantidad_pagada){

			################### ACTUALIZO DETALLES DE PEDIDO ######################
			$sql = " UPDATE detallepedidos set "
			   ." statusdetalle = ? "
			   ." WHERE "
			   ." coddetallepedido = '".limpiar(decrypt($_POST['coddetallepedido'][$i]))."';
			   ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $statusdetalle);
			
			$statusdetalle = limpiar("0");
			$cantidad_pagada = number_format($_POST['pagado'][$i], 2, '.', '');
			$stmt->execute();
			################### ACTUALIZO DETALLES DE PEDIDO ######################

	    } else {

			################### ACTUALIZO DETALLES DE PEDIDO ######################
			$sql = " UPDATE detallepedidos set "
			   ." cantventa = ? "
			   ." WHERE "
			   ." coddetallepedido = '".limpiar(decrypt($_POST['coddetallepedido'][$i]))."';
			   ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $cantidad_total);
			
			$cantidad_total = number_format($cantidad_vendida-$cantidad_pagada, 2, '.', '');
			$stmt->execute();
			################### ACTUALIZO DETALLES DE PEDIDO ######################
	    }
	    ################### VERIFICO DETALLES DE PEDIDOS ######################

	    }//fin de if
	}//fin de for
    $this->dbh->commit();

    ################### VERIFICO STATUS DE PEDIDO ######################
    $sql = "SELECT * FROM detallepedidos WHERE codpedido = ? AND codsucursal = ? AND statusdetalle = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codpedido"]),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		################### ACTUALIZO PEDIDO ######################
		$sql = " UPDATE pedidos set "
		   ." statuspedido = ? "
		   ." WHERE "
		   ." codpedido = '".limpiar(decrypt($_POST['codpedido']))."';
		   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $statuspedido);
		
		$statuspedido = limpiar("0");
		$stmt->execute();
		################### ACTUALIZO PEDIDO ######################

		#################### ACTUALIZO EL STATUS DE MESA ####################
		$sql = "UPDATE mesas set "
		." statusmesa = ? "
		." WHERE "
		." codmesa = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $statusmesa);
		$stmt->bindParam(2, $codmesa);

		$statusmesa = limpiar('0');
		$codmesa = limpiar(decrypt($_POST["codmesa"]));
		$stmt->execute();
	    #################### ACTUALIZO EL STATUS DE MESA ####################

	} else {

		############ CONSULTO LOS TOTALES DE VENTAS ##############
		$sql2 = "SELECT iva, descuento FROM pedidos WHERE codpedido = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array(decrypt($_POST["codpedido"]),decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$paea[] = $row;
		}
		$iva = $paea[0]["iva"]/100;
		$descuento = $paea[0]["descuento"]/100;
		############ CONSULTO LOS TOTALES DE VENTAS ##############

		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
		$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00' AND statusdetalle = 1";
		foreach ($this->dbh->query($sql3) as $row3)
		{
			$this->p[] = $row3;
		}
	    $subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	    $subtotalimpuestos = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
		$subtotalivasi = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
		$subtotalivasi2 = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
		$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00' AND statusdetalle = 1";
		foreach ($this->dbh->query($sql4) as $row4)
		{
			$this->p[] = $row4;
		}
	    $subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
		$subtotalivano = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
		$subtotalivano2 = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

		############ ACTUALIZO LOS TOTALES EN EL PEDIDO ##############
        $sql = " UPDATE pedidos SET "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
	    ." descontado = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." totalpago2= ? "
		." WHERE "
		." codpedido = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $subtotalivasi);
		$stmt->bindParam(2, $subtotalivano);
		$stmt->bindParam(3, $totaliva);
	    $stmt->bindParam(4, $descontado);
		$stmt->bindParam(5, $totaldescuento);
		$stmt->bindParam(6, $totalpago);
		$stmt->bindParam(7, $totalpago2);
		$stmt->bindParam(8, $codpedido);
		$stmt->bindParam(9, $codsucursal);

		$totaliva= number_format($subtotalimpuestos, 2, '.', '');
	    $descontado = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
		$total= number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
		$totaldescuento= number_format($total*$descuento, 2, '.', '');
		$totalpago= number_format($total-$totaldescuento, 2, '.', '');
		$totalpago2 = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
		$codpedido = limpiar(decrypt($_POST["codpedido"]));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN EL PEDIDO ##############

	}
	################### VERIFICO STATUS DE PEDIDO ######################

	################## OBTENGO LOS DATOS EN CAJA ##################
	$sql = "SELECT 
	efectivo, 
	cheque, 
	tcredito, 
	tdebito, 
	tprepago, 
	transferencia, 
	electronico,
	cupon, 
	otros,
	creditos,
	propinasefectivo,
	propinasotros,
	nroticket,
	nroboleta,
	nrofactura
	FROM arqueocaja WHERE codarqueo = '".limpiar($codarqueo)."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$efectivo = ($row['efectivo']== "" ? "0.00" : $row['efectivo']);
	$cheque = ($row['cheque']== "" ? "0.00" : $row['cheque']);
	$tcredito = ($row['tcredito']== "" ? "0.00" : $row['tcredito']);
	$tdebito = ($row['tdebito']== "" ? "0.00" : $row['tdebito']);
	$tprepago = ($row['tprepago']== "" ? "0.00" : $row['tprepago']);
	$transferencia = ($row['transferencia']== "" ? "0.00" : $row['transferencia']);
	$electronico = ($row['electronico']== "" ? "0.00" : $row['electronico']);
	$cupon = ($row['cupon']== "" ? "0.00" : $row['cupon']);
	$otros = ($row['otros']== "" ? "0.00" : $row['otros']);
	$credito = ($row['creditos']== "" ? "0.00" : $row['creditos']);
	$propinasefectivo = ($row['propinasefectivo']== "" ? "0.00" : $row['propinasefectivo']);
	$propinasotros = ($row['propinasotros']== "" ? "0.00" : $row['propinasotros']);
	$nroticket = $row['nroticket'];
	$nroboleta = $row['nroboleta'];
	$nrofactura = $row['nrofactura'];
	################## OBTENGO LOS DATOS EN CAJA ##################

    ############## AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ###############
	if (limpiar($_POST["tipopago"]=="CONTADO")){

	if(isset($_POST['formapago2']) && $_POST['formapago2']!=""){

    ################ AGREGO EL MONTO EN CAJA ################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);

	if($_POST["formapago"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "EFECTIVO"){
	$txtEfectivo = number_format($efectivo + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtEfectivo = $efectivo;	
	}

	if($_POST["formapago"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CHEQUE"){
	$txtCheque = number_format($cheque + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCheque = $cheque;	
	}

	if($_POST["formapago"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE CREDITO"){
	$txtTcredito = number_format($tcredito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTcredito = $tcredito;	
	}

	if($_POST["formapago"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA DE DEBITO"){
	$txtTdebito = number_format($tdebito + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTdebito = $tdebito;	
	}

	if($_POST["formapago"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TARJETA PREPAGO"){
	$txtTprepago = number_format($tprepago + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTprepago = $tprepago;	
	}

	if($_POST["formapago"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "TRANSFERENCIA"){
	$txtTransferencia = number_format($transferencia + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtTransferencia = $transferencia;	
	}

	if($_POST["formapago"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "DINERO ELECTRONICO"){
	$txtElectronico = number_format($electronico + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtElectronico = $electronico;	
	}

	if($_POST["formapago"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "CUPON"){
	$txtCupon = number_format($cupon + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtCupon = $cupon;	
	}

	if($_POST["formapago"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado"], 2, '.', '');
	} else if($_POST["formapago2"] == "OTROS"){
	$txtOtros = number_format($otros + $_POST["montopagado2"], 2, '.', '');
	} else {
	$txtOtros = $otros;	
	}
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	################ AGREGO EL MONTO EN CAJA ################

	} else { 

	################ AGREGO EL MONTO EN CAJA ################
	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." propinasefectivo = ?, "
	." propinasotros = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtPropinaEfectivo);
	$stmt->bindParam(11, $txtPropinaOtros);
	$stmt->bindParam(12, $NumTicket);
	$stmt->bindParam(13, $NumBoleta);
	$stmt->bindParam(14, $NumFactura);
	$stmt->bindParam(15, $codarqueo);

	$txtEfectivo = limpiar($_POST["formapago"] == "EFECTIVO" ? number_format($efectivo+$_POST["txtTotalPago"], 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["formapago"] == "CHEQUE" ? number_format($cheque+$_POST["txtTotalPago"], 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["formapago"] == "TARJETA DE CREDITO" ? number_format($tcredito+$_POST["txtTotalPago"], 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["formapago"] == "TARJETA DE DEBITO" ? number_format($tdebito+$_POST["txtTotalPago"], 2, '.', '') : $tdebito);
	$txtTprepago = limpiar($_POST["formapago"] == "TARJETA PREPAGO" ? number_format($tprepago+$_POST["txtTotalPago"], 2, '.', '') : $tprepago);
	$txtTransferencia = limpiar($_POST["formapago"] == "TRANSFERENCIA" ? number_format($transferencia+$_POST["txtTotalPago"], 2, '.', '') : $transferencia);
	$txtElectronico = limpiar($_POST["formapago"] == "DINERO ELECTRONICO" ? number_format($electronico+$_POST["txtTotalPago"], 2, '.', '') : $electronico);
	$txtCupon = limpiar($_POST["formapago"] == "CUPON" ? number_format($cupon+$_POST["txtTotalPago"], 2, '.', '') : $cupon);
	$txtOtros = limpiar($_POST["formapago"] == "OTROS" ? number_format($otros+$_POST["txtTotalPago"], 2, '.', '') : $otros);
	
	$txtPropinaEfectivo = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] == "EFECTIVO" ? number_format($propinasefectivo+$_POST["montopropina"], 2, '.', '') : $propinasefectivo);
	$txtPropinaOtros = limpiar(isset($_POST['montopropina']) && $_POST["formapropina"] != "EFECTIVO" ? number_format($propinasotros+$_POST["montopropina"], 2, '.', '') : $propinasotros);

	$NumTicket = limpiar($_POST["tipodocumento"] == "TICKET" ? $nroticket+1 : $nroticket);
	$NumBoleta = limpiar($_POST["tipodocumento"] == "BOLETA" ? $nroboleta+1 : $nroboleta);
	$NumFactura = limpiar($_POST["tipodocumento"] == "FACTURA" ? $nrofactura+1 : $nrofactura);
	$stmt->execute();
	################ AGREGO EL MONTO EN CAJA ################
		}
	}
    ################ AGREGAMOS EL INGRESO DE VENTAS PAGADAS A CAJA ##############


    ######### AGREGAMOS EL INGRESO Y ABONOS DE VENTAS A CREDITOS A CAJA ############
	if (limpiar($_POST["tipopago"]=="CREDITO")) {

	$sql = "UPDATE arqueocaja set "
	." efectivo = ?, "
	." cheque = ?, "
	." tcredito = ?, "
	." tdebito = ?, "
	." tprepago = ?, "
	." transferencia = ?, "
	." electronico = ?, "
	." cupon = ?, "
	." otros = ?, "
	." creditos = ?, "
	." nroticket = ?, "
	." nroboleta = ?, "
	." nrofactura = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtEfectivo);
	$stmt->bindParam(2, $txtCheque);
	$stmt->bindParam(3, $txtTcredito);
	$stmt->bindParam(4, $txtTdebito);
	$stmt->bindParam(5, $txtTprepago);
	$stmt->bindParam(6, $txtTransferencia);
	$stmt->bindParam(7, $txtElectronico);
	$stmt->bindParam(8, $txtCupon);
	$stmt->bindParam(9, $txtOtros);
	$stmt->bindParam(10, $txtCredito);
	$stmt->bindParam(11, $NumTicket);
	$stmt->bindParam(12, $NumBoleta);
	$stmt->bindParam(13, $NumFactura);
	$stmt->bindParam(14, $codarqueo);

	$txtEfectivo = limpiar($_POST["medioabono"] == "EFECTIVO" ? number_format($efectivo+$_POST["montoabono"], 2, '.', '') : $efectivo);
	$txtCheque = limpiar($_POST["medioabono"] == "CHEQUE" ? number_format($cheque+$_POST["montoabono"], 2, '.', '') : $cheque);
	$txtTcredito = limpiar($_POST["medioabono"] == "TARJETA DE CREDITO" ? number_format($tcredito+$_POST["montoabono"], 2, '.', '') : $tcredito);
	$txtTdebito = limpiar($_POST["medioabono"] == "TARJETA DE DEBITO" ? number_format($tdebito+$_POST["montoabono"], 2, '.', '') : 